/* Copyright (C) 2001  Marko Mlinar
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */
package org.opencores.structure;

/** Class that actually does nothing. It is inserted to break cycles
  * to simplify processing.
  * @see Node */
public class NodeCycleBreak extends Node {
	/** Input port. */
	public static final int IN = 0;
	/** Output port. */
	public static final int OUT = 1;
	
	public String toString() {		
		return "NCB "+super.toString();
	}
	
	/** creates new (unlinked) node with same parameters.
	  * @return duplicated node */
	public Object clone() {
		NodeCycleBreak n = new NodeCycleBreak();
		n.duplicate(this);
		return n;
	}
	
	/** duplicates parameters from n to this
	  * @param n node to copy data from */
	public void duplicate(NodeCycleBreak n) {
		duplicate((Node)n);
	}
	
	/** Constructs new <i>NodeCycleBreak</i>.
	  * @see NodeCycleBreak */
	public NodeCycleBreak() {
		super(2);
		dir[OUT] = OUTPUT;
	}
}
