/* Copyright (C) 2001  Marko Mlinar
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */
package org.opencores.structure;

import org.opencores.Conf;

/** Node class that implements full adder
  * Ports:
  * 0: A (in)
  * 1: B (in)
  * 2: C (in)
  * 3: S (out)
  * 4: COUT (out)
  */
public class NodeAdd extends Node {
	/** number of inputs, they must be listed first in ports */
	public static final int NINPUTS = 3;
	/** index of carry input port */
	public static final int CARRY_IN_PORT = 2;
	/** index of carry ouput port */
	public static final int CARRY_OUT_PORT = 4;
	/** adder this one receives carry */
	public NodeAdd prev = null;
	/** adder this one passes carry */
	public NodeAdd next = null;
	/** first adder of the group */
	public NodeAdd group = null;

  /** constructs new adder */
	public NodeAdd() {
		super(5);
		dir[3] = dir[4] = OUTPUT;
	}
	
	public String toString() {		
		return "ADD_ABC "+super.toString();
	}
	
	/** creates new (unlinked) node with same parameters.
	  * @return duplicated node */
	public Object clone() {
		NodeAdd n = new NodeAdd();
		n.duplicate(this);
		return n;
	}
	
	/** duplicates parameters from n to this
	  * @param n node to copy data from */
	public void duplicate(NodeAdd n) {
		duplicate((Node)n);
	}
}
