/* Copyright (C) 2001  Marko Mlinar
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */
package org.opencores.structure;

import java.util.Vector;
import org.opencores.Conf;

/** Global net, that is accessible from everywhere (e.g. GND, VCC, CLK).
  * This net is not placed nor routed in standard P&R process. */
public class NetGlobal extends Net { 
	/** GND generator node type */
	public static final int GND = 0;
	/** VCC generator node type */
	public static final int VCC = 1;
	/** CLK signal type */
	public static final int GCLK0 = 2;
	/** CLK signal type */
	public static final int GCLK1 = 3;
	/** async RST signal type */
	public static final int GRST = 4;
	/** async SET signal type */
	public static final int GSET = 5;
	/** PIO_CLK signal */
	public static final int PIO_CLK = 6;
	/** number of global net types */
	public static final int NUM_GLOBAL = 7;
	
  /** NodeGlobal names */
	public static final String typeName[] = {
	"GND","VCC","GCLK0","GCLK1","GRST","GSET","PIO_CLK"};
	
	/** this instance type */
	public int type;
	
	/** Construct new special node.
	  * @param type node type (use NetGlobal.*) */
	public NetGlobal(int type) {			
		super();
		this.type = type;
		name = typeName[type];		
	}

	public String toString() {
		String s = super.toString();
		return typeName[type]+" "+s;
	}		
}
