/* Copyright (C) 2001  Marko Mlinar
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */
package org.opencores.structure;

import java.util.Vector;
import org.opencores.Conf;

/** simple net type class (has only one output and many inputs),
  * suitable for P&R process */
public class Net { 
	/** net name */
  public String name;	
  /** all inputs net is connected to */  
	public Vector inputs = new Vector();
	/** node (only one), that outputs data */
	public Node output;
	/** net link - for graph duplication, etc. */
	public Net link = null;
	/** net cost */
	public float cost = 0;
	
	public String toString() {
		String s = "Net "+name+", nodes("+(inputs.size()+1)+") *";
		if(output != null) s = s + output.name; else s = s + "null";
		
		for(int i = 0; i < inputs.size(); i++) {
			if(inputs.elementAt(i) != null) 
				s = s + ", " + ((Node)inputs.elementAt(i)).name;			
			else s = s + ", null";
		}
		return s + Conf.NL;
	}
}
