/* Copyright (C) 2001  Marko Mlinar
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */
package org.opencores.structure;

/** Class representing Nodes, that can be indexed. From index we can
  * calculate actual position. All mapped elements should extend this node. */
public abstract class IndexedNode extends NodeRoutable {	
	/** node index */
	public int idx = 0;
	
	/** Costructs new node.
	  * @param width node width */
	public IndexedNode(int width) {
		super(width);
	}
	
	/** Returns its x position.
	  * @return x position */
	public abstract int posX();
	
	/** Returns its y position.
	  * @return y position */
	public abstract int posY();
}
