/* Copyright (C) 2001  Marko Mlinar
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */
package org.opencores.placement;

import org.opencores.structure.*;
import org.opencores.Conf;

/** Class, which does some tests in order to improve architecture. */
public class Statistics {
	/** distance count */
	public int distCnt[] = new int[Conf.X+Conf.Y];
	
	public Statistics(Graph g) {
		for(int i = 0; i < distCnt.length; i++) distCnt[i] = 0;
		for(int i = 0; i < g.nets.size(); i++) {
			Net nt = (Net) g.nets.elementAt(i);			
			MST(nt);
		}
	}
	
	/** Returns manhattan distance of vector (dx, dy).
		* @param dx vector x component
		* @param dy vector y component
		* @return distance */	
	private static final int manhattan(int dx, int dy) {
		return Math.abs(dx) + Math.abs(dy);
	}
	
	/** Calculates minimum spanning tree size.	  
	  * @param net to compute MST on */	  
	private void MST(Net nt) {	  
		/* find all nodes on the net and put it into mst */
		Node mst[]; 
		int dist [];	// current shortest distance to given node
		int size = nt.inputs.size();	
		if(nt.output != null) {		
			if(nt.inputs.size() == 1)	{// handle simple nets faster
				Node a = (Node) nt.inputs.firstElement(); 
				distCnt[manhattan(nt.output.x - a.x, nt.output.y - a.y)]++;
				return;
			}
			mst = new Node[++size];
			mst[size-1] = nt.output;
		} else mst = new Node[size];
		dist = new int[size];
		for(int i = 0; i < nt.inputs.size(); i++) //copy inputs
			mst[i] = (Node)nt.inputs.elementAt(i);			
		
		
		int idx = 0;
		for(int i = 0; i < size; i++) {
			dist[i] = Integer.MAX_VALUE;
			//Conf.log.print("("+mst[i].x+","+mst[i].y+"),");
		}
		
		idx = 0;
		dist[idx] = 0;
		// calculate cost using Prim's algorithm
		for(int i = 0; i < size; i++) {			
			int min = Integer.MAX_VALUE;	// find closest available	nodes
			int bestj = 0;
			int x = mst[idx].x;
			int y = mst[idx].y;
			mst[idx] = null;
			for(int j = 1; j < size; j++) if(mst[j] != null) {
				dist[j] = Math.min(dist[j], manhattan(x - mst[j].x, y - mst[j].y));
				if(min > dist[j]) {
					min = dist[j];
					bestj = j;
				}
			}
			
			distCnt[dist[idx]]++;
			idx = bestj;
		}				
	}
}
