/* Copyright (C) 2001  Marko Mlinar
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */
package org.opencores.mapping;

import java.util.Vector;
import org.opencores.structure.*;
import org.opencores.Conf;

/** Consist of mapping fuctions for mapping into GPC */
public class IOCMap {
	/** Groups LUTs and FFs into GPCs. Do roommate joining first.
	  * @param g graph to work on */
	public static void group(Graph g) {		
	  /* We have to use candidate list here, since we are later deleting
	   * and building in same list */
		Vector IOCs = new Vector(Conf.NUM_IOC);	// build candidate list
		for(int i = 0; i < g.nodes.size(); i++) {		
			Node n = (Node) g.nodes.elementAt(i);
			if(n instanceof NodePort) IOCs.add(n);
		}
		for(int i = 0; i < IOCs.size(); i++) { // replace all ports with IOCs
			NodePort a = (NodePort) IOCs.elementAt(i);			
			NodeIOC ioc = new NodeIOC(a, g.global[NetGlobal.GND]);			
			a.unlinkNets();
			ioc.linkNets();
			/* update graph nodes */
			g.nodes.remove(a);			
			g.nodes.add(ioc);
		}
	}
}
