/* Copyright (C) 2001  Marko Mlinar
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */
package org.opencores.mapping;

import java.util.Vector;
import org.opencores.structure.*;

/** Consist of mapping fuctions for mapping into GPC */
public class GPCMap {
	/** Groups LUTs and FFs into GPCs. Do roommate joining first.
	  * @param g graph to work on */
	public static void group(Graph g) {		
	  /* We have to use candidate list here, since we are later deleting
	   * and building in same list */
		Vector LUTs = new Vector(g.nodes.size()/2);	// build candidate list
		for(int i = 0; i < g.nodes.size(); i++) {		
			Node n = (Node) g.nodes.elementAt(i);
			if(n instanceof NodeLUT) LUTs.add(n);
		}
		for(int i = 0; i < LUTs.size(); i++) { 
			NodeLUT a = (NodeLUT) LUTs.elementAt(i);			
			NodeFF ra;

			/* search for FF */
			Net nt = a.ports[a.OUT];
			if((nt.inputs.size() == 1)&&(nt.inputs.firstElement() instanceof NodeFF)) {
				NodeFF ff = (NodeFF)nt.inputs.firstElement();
				if(ff.ports[ff.DATA] == nt) {
					ra = ff;
					g.nets.remove(nt); // this net will be joined, delete
				}	else ra = null;
			} else ra = null;				
				
			/* create joined node */
			NodeGPC gpc = new NodeGPC(a, ra, true, g.global[NetGlobal.GND]);
			/* update graph nodes */
			g.nodes.remove(a);
			g.nodes.remove(ra);
			g.nodes.add(gpc);
		}
	}
}
