/* Copyright (C) 2001  Marko Mlinar
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */
package org.opencores.mapping;

import org.opencores.structure.*;

/** This class contains routines specific for flip-flop mapping. */
public class FlipFlopMap {
	/** Function inserts new LUT, so that each FF has its direct and only
	  * predecessor LUT */
	public static void addLUTs(Graph g) {
		for(int i = 0; i < g.nodes.size(); i++) {
			Node n = (Node) g.nodes.elementAt(i);
			if(n instanceof NodeFF) {
				NodeFF ff = (NodeFF)n;
				Net nt = ff.ports[ff.DATA];
				/* FF should have only one parent - LUT */
				if((nt.inputs.size() != 1)||(!(nt.output instanceof NodeLUT))) {
					/* insert new LUT */
					NodeLUT l = new NodePrim(NodePrim.BUF);
					l.name = ff.name+"_LUT";
					nt.inputs.removeElement(ff); // unlink ff.data
					l.ports[0] = ff.ports[ff.DATA];	// link nt->l
					nt.inputs.add(l);
					Net inside = new Net();		// link l->inside
					inside.name = ff.name+"_inside";
					l.ports[1] = inside;
					l.fx = ff.fx; l.fy = ff.fy;
					inside.output = l;
					ff.ports[ff.DATA] = inside;	// link inside->ff.data
					inside.inputs.add(ff);
					g.nodes.add(l);			// add lut to graph
					g.nets.add(inside);	// add inside net to graph
				}
			}
		}
	}
}
