/* Copyright (C) 2001  Marko Mlinar
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */
package org.opencores.graphics;

import java.awt.*;
import java.awt.event.*;
import java.util.Vector;

/** Class, which stores data for drawing LineCharts.  
  * Values should be positive only.
  * @see LineChart */
public class LineChartData {	
  /** current data */
	private Vector data = new Vector();
	/** current max value */
	private double maxy = 1.f;
	/** graph colors */
	private Color color;
	
	/** constructs new LineChartData, with line color <i>color</i> */
	public LineChartData(Color color) {				
		this.color = color;
	}
	
	/** Repaints chart line.
	  * @param g graphics to draw on
	  * @param top offset on top
	  * @param left offset on left
	  * @param height window height */
	public void paint(Graphics g, int top, int height, int left) {
		g.setColor(color);
		if(data.isEmpty()) return; // nothing to do		
		double py = ((Double)data.firstElement()).doubleValue()/maxy;
		for(int i = 1; i < data.size(); i++) {
			double ny = ((Double)data.elementAt(i)).doubleValue()/maxy;
			g.drawLine(i-1 + left, (int)((1-py) * height)+top,
								 i + left, (int)((1-ny) * height)+top);
			py = ny;
		}
	}
	
	/** Clears all currently stored data. */
	public void resetData() {
		data = new Vector();
		maxy = Double.MIN_VALUE;
	}
	
	/** Adds new value to graph to display it.
	  * @param y value */
	public void addData(double y) {
		if(y > maxy) maxy = y;
		data.addElement(new Double(y));
	}
}
