/* Copyright (C) 2001  Marko Mlinar
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */
package org.opencores.graphics;

import java.awt.*;
import java.awt.event.*;
import java.util.Vector;

/** Component used for drawing LineCharts.
  * Values should be positive only.
  * @see LineChartData */
public class LineChart extends Frame {		
	/** Border, data is not drawn to. */
	private static final int TOP = 30;
	/** Border, data is not drawn to. */
	private static final int BOTTOM = 5;
	/** Border, data is not drawn to. */
	private static final int LEFT = 3;
	/** Border, data is not drawn to. */
	private static final int RIGHT = 3;
  /** current data */
	private Vector lcd = new Vector();	
	/** window height */
	private int height;
	
	/** constructs new LineChart, with <i>x</i> visible columns and
	  * height <i>y</i>. */
	public LineChart(int x, int y) {
		setSize(x, y);		
	}	
	
	public void setSize(int x, int y) {		
		height = y;
		for(int i = 0; i < lcd.size(); i++) {
			LineChartData lc = (LineChartData)lcd.elementAt(i);
			lcd.setSize(y);
		}
		super.setSize(x, y);
		repaint();
	}
	
	/** repaints frame */
	public void paint(Graphics g) {		
		int h = height - TOP - BOTTOM;		
		for(int i = 0; i < lcd.size(); i++) {
			LineChartData lc = (LineChartData)lcd.elementAt(i);
			lc.paint(g, TOP, h, LEFT);
		}
	}	
	
	/** Clears all currently stored lines. */
	public void resetChartLine() {
		lcd = new Vector();		
	}
	
	/** Adds new graph line.
	  * @param lcd line chart data
	  * @see LineChartData */
	public void addData(LineChartData lcd) {		
		this.lcd.addElement(lcd);
	}
}
