/* Copyright (C) 2001  Marko Mlinar
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */
  
package org.opencores.edifp;

/** Lex passes this class. */
class Symbol {
	/** Object Symbol is connected to. */
	Object o = null;
	/** Symbol identifier.
	  * @see sym */
	int s;

  /** Constructs new symbol.
    * @param s id */
	Symbol(int s) {
		this.s = s;
	}

	/** Constructs new symbol.
    * @param s id
    * @param o object */
	Symbol(int s, Object o) {
		this.s = s;
		this.o = o;
	}

	/** @return symbol String representation */
	public String toString() {
		if(o!=null) return "#"+s+"("+o+")";
		else return "#"+s;
	}
}
