/* Copyright (C) 2001  Marko Mlinar
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */
package org.opencores.edifp;
			 
import java.util.Vector;					   

/** port type class, used for EDIF parser purposes */
public class Port {
	/** input type wire */
	public final static int INPUT = 1;	
	/** output type wire */
	public final static int OUTPUT = 2; 
	/** input/output type wire */
	public final static int INOUT = 3;  
	
	/** names for port directions */
	public final static String IONames[]={
		"null","INPUT","OUTPUT","INOUT"
	};
	
	/** port name */
	String name;									
	/** port direction (relative to instance) */
	int direction;
	/** width of port (array length) */								
	int width;										
	/** net, port is connected to */	
	ENet net;											
	
	/** inverts direction
	  * @param direction direction to invert
	  * @return inverted direction (e.g. INPUT|->OUTPUT) */
	public final static int invertDirection(int direction) {
		switch(direction) {
			case INPUT:return OUTPUT;
			case OUTPUT:return INPUT;
			case INOUT:return INOUT;
		}
		return 0;// invalid direction
	}
}
