/* Copyright (C) 2001  Marko Mlinar
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */
package org.opencores.edifp;

/** stack frame for one EDIF layer */
class PathScope {
  /** path */
	Edif edif;
	/** path */
	Library lib;
	/** path */
	Cell cell;
	/** path */
	Instance inst;
	/** path */
	Port port;
	/** path, port index */
	int port_i;	
	/** path */
	ENet net;	

	/** copies values from existing sf */ 
	void copyFrom(PathScope sf) {
		edif=sf.edif;
		lib=sf.lib;
		cell=sf.cell;
		inst=sf.inst;
		port=sf.port;
		net=sf.net;
	}
}
