/* Copyright (C) 2001  Marko Mlinar
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */
package org.opencores.edifp;


class Lex {
	private final int YY_BUFFER_SIZE = 512;
	private final int YY_F = -1;
	private final int YY_NO_STATE = -1;
	private final int YY_NOT_ACCEPT = 0;
	private final int YY_START = 1;
	private final int YY_END = 2;
	private final int YY_NO_ANCHOR = 4;
	private final int YY_BOL = 128;
	private final int YY_EOF = 129;
	public final int YYEOF = -1;
 
	public int line=1;
	private java.io.BufferedReader yy_reader;
	private int yy_buffer_index;
	private int yy_buffer_read;
	private int yy_buffer_start;
	private int yy_buffer_end;
	private char yy_buffer[];
	private boolean yy_at_bol;
	private int yy_lexical_state;

	Lex (java.io.Reader reader) {
		this ();
		if (null == reader) {
			throw (new Error("Error: Bad input stream initializer."));
		}
		yy_reader = new java.io.BufferedReader(reader);
	}

	Lex (java.io.InputStream instream) {
		this ();
		if (null == instream) {
			throw (new Error("Error: Bad input stream initializer."));
		}
		yy_reader = new java.io.BufferedReader(new java.io.InputStreamReader(instream));
	}

	private Lex () {
		yy_buffer = new char[YY_BUFFER_SIZE];
		yy_buffer_read = 0;
		yy_buffer_index = 0;
		yy_buffer_start = 0;
		yy_buffer_end = 0;
		yy_at_bol = true;
		yy_lexical_state = YYINITIAL;
	}

	private boolean yy_eof_done = false;
	private final int YYINITIAL = 0;
	private final int yy_state_dtrans[] = {
		0
	};
	private void yybegin (int state) {
		yy_lexical_state = state;
	}
	private int yy_advance ()
		throws java.io.IOException {
		int next_read;
		int i;
		int j;

		if (yy_buffer_index < yy_buffer_read) {
			return yy_buffer[yy_buffer_index++];
		}

		if (0 != yy_buffer_start) {
			i = yy_buffer_start;
			j = 0;
			while (i < yy_buffer_read) {
				yy_buffer[j] = yy_buffer[i];
				++i;
				++j;
			}
			yy_buffer_end = yy_buffer_end - yy_buffer_start;
			yy_buffer_start = 0;
			yy_buffer_read = j;
			yy_buffer_index = j;
			next_read = yy_reader.read(yy_buffer,
					yy_buffer_read,
					yy_buffer.length - yy_buffer_read);
			if (-1 == next_read) {
				return YY_EOF;
			}
			yy_buffer_read = yy_buffer_read + next_read;
		}

		while (yy_buffer_index >= yy_buffer_read) {
			if (yy_buffer_index >= yy_buffer.length) {
				yy_buffer = yy_double(yy_buffer);
			}
			next_read = yy_reader.read(yy_buffer,
					yy_buffer_read,
					yy_buffer.length - yy_buffer_read);
			if (-1 == next_read) {
				return YY_EOF;
			}
			yy_buffer_read = yy_buffer_read + next_read;
		}
		return yy_buffer[yy_buffer_index++];
	}
	private void yy_move_end () {
		if (yy_buffer_end > yy_buffer_start &&
		    '\n' == yy_buffer[yy_buffer_end-1])
			yy_buffer_end--;
		if (yy_buffer_end > yy_buffer_start &&
		    '\r' == yy_buffer[yy_buffer_end-1])
			yy_buffer_end--;
	}
	private boolean yy_last_was_cr=false;
	private void yy_mark_start () {
		yy_buffer_start = yy_buffer_index;
	}
	private void yy_mark_end () {
		yy_buffer_end = yy_buffer_index;
	}
	private void yy_to_mark () {
		yy_buffer_index = yy_buffer_end;
		yy_at_bol = (yy_buffer_end > yy_buffer_start) &&
		            ('\r' == yy_buffer[yy_buffer_end-1] ||
		             '\n' == yy_buffer[yy_buffer_end-1] ||
		             2028/*LS*/ == yy_buffer[yy_buffer_end-1] ||
		             2029/*PS*/ == yy_buffer[yy_buffer_end-1]);
	}
	private java.lang.String yytext () {
		return (new java.lang.String(yy_buffer,
			yy_buffer_start,
			yy_buffer_end - yy_buffer_start));
	}
	private int yylength () {
		return yy_buffer_end - yy_buffer_start;
	}
	private char[] yy_double (char buf[]) {
		int i;
		char newbuf[];
		newbuf = new char[2*buf.length];
		for (i = 0; i < buf.length; ++i) {
			newbuf[i] = buf[i];
		}
		return newbuf;
	}
	private final int YY_E_INTERNAL = 0;
	private final int YY_E_MATCH = 1;
	private java.lang.String yy_error_string[] = {
		"Error: Internal error.\n",
		"Error: Unmatched input.\n"
	};
	private void yy_error (int code,boolean fatal) {
		java.lang.System.out.print(yy_error_string[code]);
		java.lang.System.out.flush();
		if (fatal) {
			throw new Error("Fatal Error.\n");
		}
	}
	private int[][] unpackFromString(int size1, int size2, String st) {
		int colonIndex = -1;
		String lengthString;
		int sequenceLength = 0;
		int sequenceInteger = 0;

		int commaIndex;
		String workString;

		int res[][] = new int[size1][size2];
		for (int i= 0; i < size1; i++) {
			for (int j= 0; j < size2; j++) {
				if (sequenceLength != 0) {
					res[i][j] = sequenceInteger;
					sequenceLength--;
					continue;
				}
				commaIndex = st.indexOf(',');
				workString = (commaIndex==-1) ? st :
					st.substring(0, commaIndex);
				st = st.substring(commaIndex+1);
				colonIndex = workString.indexOf(':');
				if (colonIndex == -1) {
					res[i][j]=Integer.parseInt(workString);
					continue;
				}
				lengthString =
					workString.substring(colonIndex+1);
				sequenceLength=Integer.parseInt(lengthString);
				workString=workString.substring(0,colonIndex);
				sequenceInteger=Integer.parseInt(workString);
				res[i][j] = sequenceInteger;
				sequenceLength--;
			}
		}
		return res;
	}
	private int yy_acpt[] = {
		/* 0 */ YY_NOT_ACCEPT,
		/* 1 */ YY_NO_ANCHOR,
		/* 2 */ YY_NO_ANCHOR,
		/* 3 */ YY_NO_ANCHOR,
		/* 4 */ YY_NO_ANCHOR,
		/* 5 */ YY_NO_ANCHOR,
		/* 6 */ YY_NO_ANCHOR,
		/* 7 */ YY_NO_ANCHOR,
		/* 8 */ YY_NO_ANCHOR,
		/* 9 */ YY_NO_ANCHOR,
		/* 10 */ YY_NO_ANCHOR,
		/* 11 */ YY_NO_ANCHOR,
		/* 12 */ YY_NO_ANCHOR,
		/* 13 */ YY_NO_ANCHOR,
		/* 14 */ YY_NO_ANCHOR,
		/* 15 */ YY_NO_ANCHOR,
		/* 16 */ YY_NO_ANCHOR,
		/* 17 */ YY_NO_ANCHOR,
		/* 18 */ YY_NO_ANCHOR,
		/* 19 */ YY_NO_ANCHOR,
		/* 20 */ YY_NO_ANCHOR,
		/* 21 */ YY_NO_ANCHOR,
		/* 22 */ YY_NO_ANCHOR,
		/* 23 */ YY_NO_ANCHOR,
		/* 24 */ YY_NO_ANCHOR,
		/* 25 */ YY_NO_ANCHOR,
		/* 26 */ YY_NO_ANCHOR,
		/* 27 */ YY_NO_ANCHOR,
		/* 28 */ YY_NO_ANCHOR,
		/* 29 */ YY_NO_ANCHOR,
		/* 30 */ YY_NO_ANCHOR,
		/* 31 */ YY_NO_ANCHOR,
		/* 32 */ YY_NO_ANCHOR,
		/* 33 */ YY_NO_ANCHOR,
		/* 34 */ YY_NO_ANCHOR,
		/* 35 */ YY_NO_ANCHOR,
		/* 36 */ YY_NO_ANCHOR,
		/* 37 */ YY_NO_ANCHOR,
		/* 38 */ YY_NOT_ACCEPT,
		/* 39 */ YY_NO_ANCHOR,
		/* 40 */ YY_NO_ANCHOR,
		/* 41 */ YY_NO_ANCHOR,
		/* 42 */ YY_NO_ANCHOR,
		/* 43 */ YY_NO_ANCHOR,
		/* 44 */ YY_NO_ANCHOR,
		/* 45 */ YY_NO_ANCHOR,
		/* 46 */ YY_NO_ANCHOR,
		/* 47 */ YY_NO_ANCHOR,
		/* 48 */ YY_NO_ANCHOR,
		/* 49 */ YY_NO_ANCHOR,
		/* 50 */ YY_NO_ANCHOR,
		/* 51 */ YY_NO_ANCHOR,
		/* 52 */ YY_NO_ANCHOR,
		/* 53 */ YY_NO_ANCHOR,
		/* 54 */ YY_NO_ANCHOR,
		/* 55 */ YY_NO_ANCHOR,
		/* 56 */ YY_NO_ANCHOR,
		/* 57 */ YY_NO_ANCHOR,
		/* 58 */ YY_NO_ANCHOR,
		/* 59 */ YY_NO_ANCHOR,
		/* 60 */ YY_NO_ANCHOR,
		/* 61 */ YY_NO_ANCHOR,
		/* 62 */ YY_NO_ANCHOR,
		/* 63 */ YY_NO_ANCHOR,
		/* 64 */ YY_NO_ANCHOR,
		/* 65 */ YY_NO_ANCHOR,
		/* 66 */ YY_NO_ANCHOR,
		/* 67 */ YY_NO_ANCHOR,
		/* 68 */ YY_NO_ANCHOR,
		/* 69 */ YY_NO_ANCHOR,
		/* 70 */ YY_NO_ANCHOR,
		/* 71 */ YY_NO_ANCHOR,
		/* 72 */ YY_NO_ANCHOR,
		/* 73 */ YY_NO_ANCHOR,
		/* 74 */ YY_NO_ANCHOR,
		/* 75 */ YY_NO_ANCHOR,
		/* 76 */ YY_NO_ANCHOR,
		/* 77 */ YY_NO_ANCHOR,
		/* 78 */ YY_NO_ANCHOR,
		/* 79 */ YY_NO_ANCHOR,
		/* 80 */ YY_NO_ANCHOR,
		/* 81 */ YY_NO_ANCHOR,
		/* 82 */ YY_NO_ANCHOR,
		/* 83 */ YY_NO_ANCHOR,
		/* 84 */ YY_NO_ANCHOR,
		/* 85 */ YY_NO_ANCHOR,
		/* 86 */ YY_NO_ANCHOR,
		/* 87 */ YY_NO_ANCHOR,
		/* 88 */ YY_NO_ANCHOR,
		/* 89 */ YY_NO_ANCHOR,
		/* 90 */ YY_NO_ANCHOR,
		/* 91 */ YY_NO_ANCHOR,
		/* 92 */ YY_NO_ANCHOR,
		/* 93 */ YY_NO_ANCHOR,
		/* 94 */ YY_NO_ANCHOR,
		/* 95 */ YY_NO_ANCHOR,
		/* 96 */ YY_NO_ANCHOR,
		/* 97 */ YY_NO_ANCHOR,
		/* 98 */ YY_NO_ANCHOR,
		/* 99 */ YY_NO_ANCHOR,
		/* 100 */ YY_NO_ANCHOR,
		/* 101 */ YY_NO_ANCHOR,
		/* 102 */ YY_NO_ANCHOR,
		/* 103 */ YY_NO_ANCHOR,
		/* 104 */ YY_NO_ANCHOR,
		/* 105 */ YY_NO_ANCHOR,
		/* 106 */ YY_NO_ANCHOR,
		/* 107 */ YY_NO_ANCHOR,
		/* 108 */ YY_NO_ANCHOR,
		/* 109 */ YY_NO_ANCHOR,
		/* 110 */ YY_NO_ANCHOR,
		/* 111 */ YY_NO_ANCHOR,
		/* 112 */ YY_NO_ANCHOR,
		/* 113 */ YY_NO_ANCHOR,
		/* 114 */ YY_NO_ANCHOR,
		/* 115 */ YY_NO_ANCHOR,
		/* 116 */ YY_NO_ANCHOR,
		/* 117 */ YY_NO_ANCHOR,
		/* 118 */ YY_NO_ANCHOR,
		/* 119 */ YY_NO_ANCHOR,
		/* 120 */ YY_NO_ANCHOR,
		/* 121 */ YY_NO_ANCHOR,
		/* 122 */ YY_NO_ANCHOR,
		/* 123 */ YY_NO_ANCHOR,
		/* 124 */ YY_NO_ANCHOR,
		/* 125 */ YY_NO_ANCHOR,
		/* 126 */ YY_NO_ANCHOR,
		/* 127 */ YY_NO_ANCHOR,
		/* 128 */ YY_NO_ANCHOR,
		/* 129 */ YY_NO_ANCHOR,
		/* 130 */ YY_NO_ANCHOR,
		/* 131 */ YY_NO_ANCHOR,
		/* 132 */ YY_NO_ANCHOR,
		/* 133 */ YY_NO_ANCHOR,
		/* 134 */ YY_NO_ANCHOR,
		/* 135 */ YY_NO_ANCHOR,
		/* 136 */ YY_NO_ANCHOR,
		/* 137 */ YY_NO_ANCHOR,
		/* 138 */ YY_NO_ANCHOR,
		/* 139 */ YY_NO_ANCHOR,
		/* 140 */ YY_NO_ANCHOR,
		/* 141 */ YY_NO_ANCHOR,
		/* 142 */ YY_NO_ANCHOR,
		/* 143 */ YY_NO_ANCHOR,
		/* 144 */ YY_NO_ANCHOR,
		/* 145 */ YY_NO_ANCHOR,
		/* 146 */ YY_NO_ANCHOR,
		/* 147 */ YY_NO_ANCHOR,
		/* 148 */ YY_NO_ANCHOR,
		/* 149 */ YY_NO_ANCHOR,
		/* 150 */ YY_NO_ANCHOR,
		/* 151 */ YY_NO_ANCHOR,
		/* 152 */ YY_NO_ANCHOR,
		/* 153 */ YY_NO_ANCHOR
	};
	private int yy_cmap[] = unpackFromString(1,130,
"26:9,31,30,26,31:2,26:18,31,26,25,26:5,1,2,26:3,27,26:2,28:10,26:7,14,13,16" +
",4,3,6,23,29,5,22,29,12,21,11,10,19,29,8,9,18,17,7,20,24,15,29,26:4,29,26,1" +
"4,13,16,4,3,6,23,29,5,22,29,12,21,11,10,19,29,8,9,18,17,7,20,24,15,29,26:5," +
"0:2")[0];

	private int yy_rmap[] = unpackFromString(1,154,
"0,1:3,2,3,4,1:3,5,6,7,8,9,10:10,11,10:3,12,10:8,3,13,1,14,4,15,16,17,18,19," +
"20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44," +
"45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69," +
"70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94," +
"95,96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114," +
"10,115,116,117,118,119,120,121,122,123,124")[0];

	private int yy_nxt[][] = unpackFromString(125,32,
"1,2,3,4,126,139,143,144,145,143,146,69,147,143,148,143,149,143:2,150,143,15" +
"1,152,143:2,5,40,42,6,143,7,8,-1:35,143,70,143:19,71,-1:3,143:2,-1:3,38:24," +
"9,38:4,-1,38,-1:28,6,-1:6,143:9,97,143:12,-1:3,143:2,-1:5,143:4,141,143:17," +
"-1:3,143:2,-1:5,143:5,105,143:9,106,143:6,-1:3,143:2,-1:5,143:5,109,143:16," +
"-1:3,143:2,-1:5,143:5,111,143:16,-1:3,143:2,-1:5,143:22,-1:3,143:2,-1:5,143" +
":5,123,143:16,-1:3,143:2,-1:5,143:5,125,143:16,-1:3,143:2,-1:5,143:15,10,14" +
"3:6,-1:3,143:2,-1:5,143:3,11,143:18,-1:3,143:2,-1:5,143:17,12,143:4,-1:3,14" +
"3:2,-1:5,143:9,13,143:12,-1:3,143:2,-1:5,143:15,14,143:6,-1:3,143:2,-1:5,14" +
"3:15,15,143:6,-1:3,143:2,-1:5,143:15,16,143:6,-1:3,143:2,-1:5,143:12,17,143" +
":9,-1:3,143:2,-1:5,143:8,18,143:13,-1:3,143:2,-1:5,19,143:21,-1:3,143:2,-1:" +
"5,143:15,20,143:6,-1:3,143:2,-1:5,143:5,21,143:16,-1:3,143:2,-1:5,143,22,14" +
"3:20,-1:3,143:2,-1:5,143:3,23,143:18,-1:3,143:2,-1:5,143:15,24,143:6,-1:3,1" +
"43:2,-1:5,143:12,25,143:9,-1:3,143:2,-1:5,143:3,26,143:18,-1:3,143:2,-1:5,1" +
"43:3,27,143:18,-1:3,143:2,-1:5,143:9,28,143:12,-1:3,143:2,-1:5,29,143:21,-1" +
":3,143:2,-1:5,30,143:21,-1:3,143:2,-1:5,143:6,31,143:15,-1:3,143:2,-1:5,143" +
":12,32,143:9,-1:3,143:2,-1:5,143:8,33,143:13,-1:3,143:2,-1:5,34,143:21,-1:3" +
",143:2,-1:5,143:3,35,143:18,-1:3,143:2,-1:5,143:8,36,143:13,-1:3,143:2,-1:5" +
",143:3,37,143:18,-1:3,143:2,-1:5,39,143:21,-1:3,143:2,-1:5,143:2,41,143:19," +
"-1:3,143:2,-1:5,143:15,83,143:6,-1:3,143:2,-1:5,143:6,130,143:15,-1:3,143:2" +
",-1:5,143:5,131,143:16,-1:3,143:2,-1:5,143:6,84,85,143:7,153,86,143:5,-1:3," +
"143:2,-1:5,43,143:21,-1:3,143:2,-1:5,143:8,87,143:13,-1:3,143:2,-1:5,143:10" +
",89,143:11,-1:3,143:2,-1:5,143:9,44,143:12,-1:3,143:2,-1:5,143:7,134,143:14" +
",-1:3,143:2,-1:5,143:5,45,143:16,-1:3,143:2,-1:5,143:18,91,143:3,-1:3,143:2" +
",-1:5,143:2,92,143:19,-1:3,143:2,-1:5,135,143:21,-1:3,143:2,-1:5,143:15,133" +
",143:6,-1:3,143:2,-1:5,143:14,46,143:7,-1:3,143:2,-1:5,143:14,47,143:7,-1:3" +
",143:2,-1:5,143:11,95,143:10,-1:3,143:2,-1:5,143:16,96,143:5,-1:3,143:2,-1:" +
"5,143:5,98,143:16,-1:3,143:2,-1:5,143:11,48,143:10,-1:3,143:2,-1:5,143:10,1" +
"00,143:11,-1:3,143:2,-1:5,143:8,101,143:13,-1:3,143:2,-1:5,143:20,49,143,-1" +
":3,143:2,-1:5,143:13,103,143:8,-1:3,143:2,-1:5,143:18,50,143:3,-1:3,143:2,-" +
"1:5,143:14,51,143:7,-1:3,143:2,-1:5,143:2,107,143:19,-1:3,143:2,-1:5,143:11" +
",108,143:10,-1:3,143:2,-1:5,142,143:21,-1:3,143:2,-1:5,52,143:21,-1:3,143:2" +
",-1:5,53,143:21,-1:3,143:2,-1:5,143:8,112,143:13,-1:3,143:2,-1:5,143:15,113" +
",143:6,-1:3,143:2,-1:5,143:3,115,143:18,-1:3,143:2,-1:5,54,143:21,-1:3,143:" +
"2,-1:5,143:12,116,143:9,-1:3,143:2,-1:5,143:6,55,143:15,-1:3,143:2,-1:5,143" +
":5,56,143:16,-1:3,143:2,-1:5,57,143:21,-1:3,143:2,-1:5,143:5,118,143:16,-1:" +
"3,143:2,-1:5,58,143:21,-1:3,143:2,-1:5,143:11,59,143:10,-1:3,143:2,-1:5,143" +
":2,120,143:19,-1:3,143:2,-1:5,143:13,60,143:8,-1:3,143:2,-1:5,143:11,121,14" +
"3:10,-1:3,143:2,-1:5,143:16,61,143:5,-1:3,143:2,-1:5,143:15,62,143:6,-1:3,1" +
"43:2,-1:5,143:15,63,143:6,-1:3,143:2,-1:5,143:6,122,143:15,-1:3,143:2,-1:5," +
"143:7,64,143:14,-1:3,143:2,-1:5,143:13,65,143:8,-1:3,143:2,-1:5,143:2,124,1" +
"43:19,-1:3,143:2,-1:5,66,143:21,-1:3,143:2,-1:5,143:7,67,143:14,-1:3,143:2," +
"-1:5,68,143:21,-1:3,143:2,-1:5,72,143,73,143:19,-1:3,143:2,-1:5,143:15,88,1" +
"43:6,-1:3,143:2,-1:5,143:5,90,143:16,-1:3,143:2,-1:5,143:8,132,143:13,-1:3," +
"143:2,-1:5,143:2,93,143:19,-1:3,143:2,-1:5,94,143:21,-1:3,143:2,-1:5,143:15" +
",99,143:6,-1:3,143:2,-1:5,143:11,137,143:10,-1:3,143:2,-1:5,143:16,136,143:" +
"5,-1:3,143:2,-1:5,143:5,102,143:16,-1:3,143:2,-1:5,110,143:21,-1:3,143:2,-1" +
":5,143:8,114,143:13,-1:3,143:2,-1:5,143:5,119,143:16,-1:3,143:2,-1:5,143:8," +
"74,143:13,-1:3,143:2,-1:5,143:5,104,143:16,-1:3,143:2,-1:5,138,143:21,-1:3," +
"143:2,-1:5,143:8,117,143:13,-1:3,143:2,-1:5,143:2,75,143:19,-1:3,143:2,-1:5" +
",76,143:21,-1:3,143:2,-1:5,143:14,127,143:7,-1:3,143:2,-1:5,143:2,77,143:19" +
",-1:3,143:2,-1:5,143:5,128,143:16,-1:3,143:2,-1:5,78,143:6,129,143:14,-1:3," +
"143:2,-1:5,143:5,79,143,80,143:14,-1:3,143:2,-1:5,81,143:21,-1:3,143:2,-1:5" +
",143:7,82,143:14,-1:3,143:2,-1:5,140,143:21,-1:3,143:2,-1:2");

	public Symbol getToken ()
		throws java.io.IOException {
		int yy_lookahead;
		int yy_anchor = YY_NO_ANCHOR;
		int yy_state = yy_state_dtrans[yy_lexical_state];
		int yy_next_state = YY_NO_STATE;
		int yy_last_accept_state = YY_NO_STATE;
		boolean yy_initial = true;
		int yy_this_accept;

		yy_mark_start();
		yy_this_accept = yy_acpt[yy_state];
		if (YY_NOT_ACCEPT != yy_this_accept) {
			yy_last_accept_state = yy_state;
			yy_mark_end();
		}
		while (true) {
			if (yy_initial && yy_at_bol) yy_lookahead = YY_BOL;
			else yy_lookahead = yy_advance();
			yy_next_state = YY_F;
			yy_next_state = yy_nxt[yy_rmap[yy_state]][yy_cmap[yy_lookahead]];
			if (YY_EOF == yy_lookahead && true == yy_initial) {
 
	return (new Symbol(sym.EOF)); 
			}
			if (YY_F != yy_next_state) {
				yy_state = yy_next_state;
				yy_initial = false;
				yy_this_accept = yy_acpt[yy_state];
				if (YY_NOT_ACCEPT != yy_this_accept) {
					yy_last_accept_state = yy_state;
					yy_mark_end();
				}
			}
			else {
				if (YY_NO_STATE == yy_last_accept_state) {
					throw (new Error("Lexical Error: Unmatched Input."));
				}
				else {
					yy_anchor = yy_acpt[yy_last_accept_state];
					if (0 != (YY_END & yy_anchor)) {
						yy_move_end();
					}
					yy_to_mark();
					switch (yy_last_accept_state) {
					case 1:
						
					case -2:
						break;
					case 2:
						{ return new Symbol(sym.LPAREN); }
					case -3:
						break;
					case 3:
						{ return new Symbol(sym.RPAREN); }
					case -4:
						break;
					case 4:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -5:
						break;
					case 5:
						{ System.err.println("Illegal character: "+yytext()); }
					case -6:
						break;
					case 6:
						{ return new Symbol(sym.NUMBER, new Integer(yytext())); }
					case -7:
						break;
					case 7:
						{ line++; }
					case -8:
						break;
					case 8:
						{ /* ignore white space. */ }
					case -9:
						break;
					case 9:
						{ return new Symbol(sym.STRING,new String(yytext().substring(1,yytext().length()-1))); }
					case -10:
						break;
					case 10:
						{ return new Symbol(sym.NET); }
					case -11:
						break;
					case 11:
						{ return new Symbol(sym.EDIF); }
					case -12:
						break;
					case 12:
						{ return new Symbol(sym.VIEW); }
					case -13:
						break;
					case 13:
						{ return new Symbol(sym.CELL); }
					case -14:
						break;
					case 14:
						{ return new Symbol(sym.PORT); }
					case -15:
						break;
					case 15:
						{ return new Symbol(sym.INOUT); }
					case -16:
						break;
					case 16:
						{ return new Symbol(sym.INPUT); }
					case -17:
						break;
					case 17:
						{ return new Symbol(sym.ARRAY); }
					case -18:
						break;
					case 18:
						{ return new Symbol(sym.DESIGN); }
					case -19:
						break;
					case 19:
						{ return new Symbol(sym.RENAME); }
					case -20:
						break;
					case 20:
						{ return new Symbol(sym.OUTPUT); }
					case -21:
						break;
					case 21:
						{ return new Symbol(sym.MEMBER); }
					case -22:
						break;
					case 22:
						{ return new Symbol(sym.JOINED); }
					case -23:
						break;
					case 23:
						{ return new Symbol(sym.VIEWREF); }
					case -24:
						break;
					case 24:
						{ return new Symbol(sym.NETLIST); }
					case -25:
						break;
					case 25:
						{ return new Symbol(sym.LIBRARY); }
					case -26:
						break;
					case 26:
						{ return new Symbol(sym.CELLREF); }
					case -27:
						break;
					case 27:
						{ return new Symbol(sym.PORTREF); }
					case -28:
						break;
					case 28:
						{ return new Symbol(sym.EXTERNAL); }
					case -29:
						break;
					case 29:
						{ return new Symbol(sym.INSTANCE); }
					case -30:
						break;
					case 30:
						{ return new Symbol(sym.VIEWTYPE); }
					case -31:
						break;
					case 31:
						{ return new Symbol(sym.CONTENTS); }
					case -32:
						break;
					case 32:
						{ return new Symbol(sym.PROPERTY); }
					case -33:
						break;
					case 33:
						{ return new Symbol(sym.DIRECTION); }
					case -34:
						break;
					case 34:
						{ return new Symbol(sym.INTERFACE); }
					case -35:
						break;
					case 35:
						{ return new Symbol(sym.LIBRARYREF); }
					case -36:
						break;
					case 36:
						{ return new Symbol(sym.EDIFV); }
					case -37:
						break;
					case 37:
						{ return new Symbol(sym.INSTANCEREF); }
					case -38:
						break;
					case 39:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -39:
						break;
					case 40:
						{ System.err.println("Illegal character: "+yytext()); }
					case -40:
						break;
					case 41:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -41:
						break;
					case 42:
						{ System.err.println("Illegal character: "+yytext()); }
					case -42:
						break;
					case 43:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -43:
						break;
					case 44:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -44:
						break;
					case 45:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -45:
						break;
					case 46:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -46:
						break;
					case 47:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -47:
						break;
					case 48:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -48:
						break;
					case 49:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -49:
						break;
					case 50:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -50:
						break;
					case 51:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -51:
						break;
					case 52:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -52:
						break;
					case 53:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -53:
						break;
					case 54:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -54:
						break;
					case 55:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -55:
						break;
					case 56:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -56:
						break;
					case 57:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -57:
						break;
					case 58:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -58:
						break;
					case 59:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -59:
						break;
					case 60:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -60:
						break;
					case 61:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -61:
						break;
					case 62:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -62:
						break;
					case 63:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -63:
						break;
					case 64:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -64:
						break;
					case 65:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -65:
						break;
					case 66:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -66:
						break;
					case 67:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -67:
						break;
					case 68:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -68:
						break;
					case 69:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -69:
						break;
					case 70:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -70:
						break;
					case 71:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -71:
						break;
					case 72:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -72:
						break;
					case 73:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -73:
						break;
					case 74:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -74:
						break;
					case 75:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -75:
						break;
					case 76:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -76:
						break;
					case 77:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -77:
						break;
					case 78:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -78:
						break;
					case 79:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -79:
						break;
					case 80:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -80:
						break;
					case 81:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -81:
						break;
					case 82:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -82:
						break;
					case 83:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -83:
						break;
					case 84:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -84:
						break;
					case 85:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -85:
						break;
					case 86:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -86:
						break;
					case 87:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -87:
						break;
					case 88:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -88:
						break;
					case 89:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -89:
						break;
					case 90:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -90:
						break;
					case 91:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -91:
						break;
					case 92:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -92:
						break;
					case 93:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -93:
						break;
					case 94:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -94:
						break;
					case 95:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -95:
						break;
					case 96:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -96:
						break;
					case 97:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -97:
						break;
					case 98:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -98:
						break;
					case 99:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -99:
						break;
					case 100:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -100:
						break;
					case 101:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -101:
						break;
					case 102:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -102:
						break;
					case 103:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -103:
						break;
					case 104:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -104:
						break;
					case 105:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -105:
						break;
					case 106:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -106:
						break;
					case 107:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -107:
						break;
					case 108:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -108:
						break;
					case 109:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -109:
						break;
					case 110:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -110:
						break;
					case 111:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -111:
						break;
					case 112:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -112:
						break;
					case 113:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -113:
						break;
					case 114:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -114:
						break;
					case 115:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -115:
						break;
					case 116:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -116:
						break;
					case 117:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -117:
						break;
					case 118:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -118:
						break;
					case 119:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -119:
						break;
					case 120:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -120:
						break;
					case 121:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -121:
						break;
					case 122:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -122:
						break;
					case 123:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -123:
						break;
					case 124:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -124:
						break;
					case 125:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -125:
						break;
					case 126:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -126:
						break;
					case 127:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -127:
						break;
					case 128:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -128:
						break;
					case 129:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -129:
						break;
					case 130:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -130:
						break;
					case 131:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -131:
						break;
					case 132:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -132:
						break;
					case 133:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -133:
						break;
					case 134:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -134:
						break;
					case 135:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -135:
						break;
					case 136:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -136:
						break;
					case 137:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -137:
						break;
					case 138:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -138:
						break;
					case 139:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -139:
						break;
					case 140:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -140:
						break;
					case 141:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -141:
						break;
					case 142:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -142:
						break;
					case 143:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -143:
						break;
					case 144:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -144:
						break;
					case 145:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -145:
						break;
					case 146:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -146:
						break;
					case 147:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -147:
						break;
					case 148:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -148:
						break;
					case 149:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -149:
						break;
					case 150:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -150:
						break;
					case 151:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -151:
						break;
					case 152:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -152:
						break;
					case 153:
						{ return new Symbol(sym.ID, new String(yytext())); }
					case -153:
						break;
					default:
						yy_error(YY_E_INTERNAL,false);
					case -1:
					}
					yy_initial = true;
					yy_state = yy_state_dtrans[yy_lexical_state];
					yy_next_state = YY_NO_STATE;
					yy_last_accept_state = YY_NO_STATE;
					yy_mark_start();
					yy_this_accept = yy_acpt[yy_state];
					if (YY_NOT_ACCEPT != yy_this_accept) {
						yy_last_accept_state = yy_state;
						yy_mark_end();
					}
				}
			}
		}
	}
}
