/* Copyright (C) 2001  Marko Mlinar
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */
package org.opencores.edifp;

import java.util.Vector;
import java.io.PrintWriter;
import org.opencores.structure.*;
import org.opencores.Conf;

/** Class that converts EDIF structure to more compact one. */
class Convert {
	private boolean debug  = false;
	Graph graph = new Graph(); /** converted graph */
	
	/** converts EDIF structure to more compact one
	  * @param e EDIF structure
	  * result is placed into public variable graph
	  * @see graph */
	Convert(Edif e) {			
		debug = Conf.debug;
		graph.name = e.design.name;
		Cell c = e.design;
		PrintWriter log = Conf.log;
		
		for(int i = 0;i < c.ports.size();i++) { /* copy design ports into */
			Port p = ((Port)c.ports.elementAt(i));/* NodePorts */
			NodePort np = new NodePort(p.direction);			
			np.name = p.name;
			graph.nodes.addElement(np);			
		}
		
		for(int i = 0; i < c.inst.size();i++) {	/* copy instances  into */																						
			Instance in = ((Instance)c.inst.elementAt(i)); /* Node... */
			Node n = null;
			int found=-1;
			if(in.cell.name.equalsIgnoreCase("OFDX")) {
				n = new NodeFF();
				found = 0;
			}
			if(found < 0) {
				for(int j=0;j<NodePrim.names.length;j++) {
					if(in.cell.name.equalsIgnoreCase(NodePrim.names[j])) {					
						found = j;
						break;
					}
				}			
				if(found >= 0) {
					n = new NodePrim(found);										
				} else {
					//throw new Error					
					log.println("Unsupported primitive: "+in.cell.name+".");					
				}
			}
			if(found >= 0) {				
				in.link = graph.nodes.size();
				graph.nodes.addElement(n);
				n.name = in.name;
			} else in.link = -1;			
		}
		
		/* copy nets and link them to right port on instance */
		for(int i = 0; i < c.nets.size();i++) {			
		  ENet n = ((ENet)c.nets.elementAt(i));		  
		  if(debug) log.println(n.name);
			Net nn = new Net();
			nn.name = n.name;
			for(int j = 0; j < n.inst.size();j++) {
				Instance in = (Instance)n.inst.elementAt(j);				
				int idx = ((Integer)n.ports_i.elementAt(j)).intValue(); // port array index
				int in_link;
				int pidx;
				if(in != null) {
					log.println("  "+in.name);
					if(in.link < 0) continue;		// unsupported node, do not connect
					in_link = in.link;					
					int k=0;
					pidx = idx;
					while(n.ports.elementAt(j) != in.cell.ports.elementAt(k)) {
						if(debug) log.println("    "+k);
						pidx += ((Port)in.cell.ports.elementAt(k)).width;
						k++;
					}
				} else {
					if(debug) log.println("  design");
					int k=0;					
					while(n.ports.elementAt(j) != e.design.ports.elementAt(k)) {
						if(debug) log.println("    "+k);
						idx += ((Port)e.design.ports.elementAt(k)).width;
						k++;
					}
					in_link = idx;					// design node has Nodeports, so break them
					pidx = 0;							 // PortNode's port index is thus zero
				}
																								
				
				// get correct node, net is connected to
				Node gn = (Node)graph.nodes.elementAt(in_link);
				if(gn == null) continue;	// unsupported node, do not connect
				if(debug) log.println("    -"+gn.name+" "+in_link+" "+pidx);
				if(gn.ports[pidx] != null) {
					log.flush();
					throw new Error("Only one net per port permitted.");
				}

				gn.ports[pidx] = nn;		// connect them bidirectional
				if(gn.dir[pidx] == gn.INPUT) {
					nn.inputs.addElement(gn);
				} else {
					if(nn.output != null) throw new Error("Only one net per port permitted!");
					nn.output = gn;
				}				
			}
			graph.nets.addElement(nn);	// add net to global graph net list			
		}
	}
}
