/*
 * Decompiled with CFR 0.152.
 */
package org.opencores.verilogp;

import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;

class VTokenizer
extends StreamTokenizer {
    public int nbits = 0;
    static final int EOF = -1;
    static final int NUMBER = -2;
    static final int LPAREN = 40;
    static final int RPAREN = 41;
    static final int COMMA = 44;
    static final int COLON = 58;
    static final int DOT = 46;
    static final int SEMI = 59;
    static final int LBRACKET = 91;
    static final int RBRACKET = 93;
    static final int NOT = 126;
    static final int AND = 38;
    static final int OR = 124;
    static final int XOR = 94;
    static final int EQUAL = 61;
    static final int BSLASH = 92;
    static final int LCBRACKET = 123;
    static final int RCBRACKET = 125;

    VTokenizer(Reader reader) {
        super(reader);
        this.slashSlashComments(true);
        this.slashStarComments(true);
        this.setTable();
        this.wordChars(128, 255);
    }

    public int nextToken() throws IOException {
        int n = super.nextToken();
        if (n == 92) {
            this.wordChars(33, 127);
            n = super.nextToken();
            this.setTable();
        } else {
            if (n == -3 && (Character.isDigit(this.sval.charAt(0)) || this.sval.charAt(0) == '\'')) {
                this.nval = this.parseNumber(this.sval);
                return -2;
            }
            if (n == 45) {
                int n2 = this.nextToken();
                if (n2 == -2) {
                    this.nval = -this.nval;
                    return -2;
                }
                this.pushBack();
            }
        }
        return n;
    }

    private int parseNumber(String string) {
        int n = 0;
        int n2 = string.length();
        while (n < n2 && Character.isDigit(string.charAt(n))) {
            ++n;
        }
        int n3 = Integer.parseInt(string.substring(0, n));
        if (string.length() == n) {
            int n4 = n3;
            this.nbits = 0;
            while (n4 != 0) {
                n4 >>= 1;
                ++this.nbits;
            }
            this.nbits = Math.max(this.nbits, 1);
            return n3;
        }
        if (string.charAt(n) != '\'') {
            throw new Error("\"'\" expected");
        }
        char c = string.charAt(n + 1);
        string = string.substring(n + 2).toUpperCase();
        n2 = string.length();
        int n5 = 0;
        if (n2 > n3) {
            throw new Error("Number too large.");
        }
        this.nbits = n3;
        switch (c) {
            case 'b': {
                int n6 = 0;
                while (n6 < n2) {
                    switch (string.charAt(n6)) {
                        case '0': {
                            n5 *= 2;
                            break;
                        }
                        case '1': {
                            n5 = n5 * 2 + 1;
                            break;
                        }
                        default: {
                            throw new Error("Invalid binary number");
                        }
                    }
                    ++n6;
                }
                break;
            }
            case 'd': {
                int n7 = 0;
                while (n7 < n2) {
                    if (!Character.isDigit(string.charAt(n7))) {
                        throw new Error("Invalid decimal number");
                    }
                    n5 = n5 * 10 + string.charAt(n7) - 48;
                    ++n7;
                }
                break;
            }
            case 'o': {
                int n8 = 0;
                while (n8 < n2) {
                    if (string.charAt(n8) < '0' || string.charAt(n8) > '9') {
                        throw new Error("Invalid octal number");
                    }
                    n5 = n5 * 8 + string.charAt(n8) - 48;
                    ++n8;
                }
                break;
            }
            case 'h': {
                int n9 = 0;
                while (n9 < n2) {
                    if (Character.isDigit(string.charAt(n9))) {
                        n5 = n5 * 16 + string.charAt(n9) - 48;
                    } else if (string.charAt(n9) >= 'A' && string.charAt(n9) <= 'F') {
                        n5 = n5 * 16 + string.charAt(n9) - 65 + 10;
                    } else {
                        throw new Error("Invalid hex number");
                    }
                    ++n9;
                }
                break;
            }
            default: {
                throw new Error("Invalid number format.");
            }
        }
        return n5;
    }

    private void setTable() {
        this.whitespaceChars(0, 32);
        this.ordinaryChars(33, 64);
        this.wordChars(65, 90);
        this.ordinaryChars(91, 97);
        this.wordChars(97, 122);
        this.ordinaryChars(123, 127);
        this.wordChars(95, 95);
        this.wordChars(48, 57);
        this.wordChars(39, 39);
        this.ordinaryChar(46);
        this.quoteChar(34);
    }
}

