/*
 * Decompiled with CFR 0.152.
 */
package org.opencores.verilogp;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Stack;
import org.opencores.Conf;
import org.opencores.structure.Graph;
import org.opencores.structure.Net;
import org.opencores.structure.Node;
import org.opencores.structure.NodeFF;
import org.opencores.structure.NodePort;
import org.opencores.structure.NodePrim;
import org.opencores.verilogp.Dictionary;
import org.opencores.verilogp.GTech;
import org.opencores.verilogp.Range;
import org.opencores.verilogp.VTokenizer;

public class Parser {
    private Graph g = new Graph();
    private VTokenizer st;
    private Dictionary d = new Dictionary();
    private String filename;
    private int expr_mark = 0;
    private int msb;
    private int lsb;

    public Parser(String string) throws IOException {
        this.filename = string;
        this.st = new VTokenizer(new BufferedReader(new FileReader(String.valueOf(Conf.sdir) + string)));
        this.parse();
    }

    private void assimilate(Net net, Net net2) {
        if (net.output instanceof NodePort && net.output != null) {
            int n = 0;
            while (n < net.inputs.size()) {
                Node node = (Node)net.inputs.elementAt(n);
                int n2 = 0;
                while (n2 < node.width) {
                    if (node.ports[n2] == net) {
                        node.ports[n2] = net2;
                    }
                    ++n2;
                }
                net2.inputs.addElement(node);
                ++n;
            }
        } else {
            Node node = net.output;
            if (node == null) {
                throw new Error(String.valueOf(this.errorPrefix()) + "Net " + net.name + " should have defined output.");
            }
            int n = 0;
            while (n < node.width) {
                if (node.ports[n] == net) {
                    node.ports[n] = net2;
                }
                ++n;
            }
            net2.output = node;
            int n3 = 0;
            while (n3 < net.inputs.size()) {
                Node node2 = (Node)net.inputs.elementAt(n3);
                if (!(node2 instanceof NodePort) && node2 != null) {
                    int n4 = 0;
                    while (n4 < node2.width) {
                        if (node2.ports[n4] == net) {
                            node2.ports[n4] = net2;
                        }
                        ++n4;
                    }
                    net2.inputs.addElement(node2);
                }
                ++n3;
            }
        }
    }

    private String errorPrefix() {
        return String.valueOf(this.filename) + "(" + this.st.lineno() + "): ";
    }

    public Graph getGraph() {
        return this.g;
    }

    private void module() throws IOException {
        Object object;
        int n;
        String string;
        this.readKeyword(0);
        this.g.name = string = this.readNewWord();
        if (this.st.nextToken() == 40) {
            do {
                String string2 = this.readNewWord();
                object = new Range();
                ((Range)object).name = string2;
                this.d.add(string2, object);
            } while ((n = this.st.nextToken()) == 44);
            if (n != 41) {
                throw new Error(String.valueOf(this.errorPrefix()) + "Expected )");
            }
        } else {
            this.st.pushBack();
        }
        this.readSym(59);
        n = 0;
        while (n != 1) {
            n = this.readKeyword();
            switch (n) {
                case 3: {
                    this.readIN_OUT(1);
                    break;
                }
                case 4: {
                    this.readIN_OUT(2);
                    break;
                }
                case 2: {
                    this.readWIRE();
                    break;
                }
                case 5: {
                    this.readASSIGN();
                    break;
                }
                case -1: {
                    this.readModule(this.st.sval);
                    break;
                }
                default: {
                    if (n >= 10 && n < 100) {
                        object = null;
                        switch (n) {
                            case 10: {
                                object = new NodePrim(2);
                                break;
                            }
                            case 11: {
                                object = new NodePrim(3);
                                break;
                            }
                            case 12: {
                                object = new NodePrim(1);
                                break;
                            }
                            case 13: {
                                object = new NodePrim(0);
                                break;
                            }
                            case 17: {
                                object = new NodePrim(4);
                                break;
                            }
                            case 22: {
                                object = new NodePrim(7);
                                break;
                            }
                            case 16: {
                                object = new NodePrim(6);
                                break;
                            }
                            case 21: {
                                object = new NodePrim(8);
                                break;
                            }
                            case 14: 
                            case 20: {
                                object = new NodeFF();
                                break;
                            }
                            default: {
                                throw new Error(String.valueOf(this.errorPrefix()) + "Unsupported primitive '" + this.st.sval + "'.");
                            }
                        }
                        n -= 10;
                        ((Node)object).name = this.readNewWord();
                        this.g.nodes.addElement(object);
                        this.readSym(40);
                        int n2 = 44;
                        do {
                            if (n2 != 44) {
                                throw new Error(String.valueOf(this.errorPrefix()) + "Syntax.");
                            }
                            this.readSym(46);
                            n2 = this.st.nextToken();
                            String string3 = this.st.sval;
                            int n3 = -1;
                            int n4 = 1;
                            while (n4 < GTech.prim[n].length) {
                                if (string3.equals(GTech.prim[n][n4])) {
                                    n3 = n4 - 1;
                                }
                                ++n4;
                            }
                            if (n3 < 0) {
                                throw new Error(String.valueOf(this.errorPrefix()) + "Invalid parameter.");
                            }
                            this.readSym(40);
                            Object object2 = this.readParam();
                            if (n3 < ((Node)object).width) {
                                ((Node)object).ports[n3] = (Net)object2;
                                if (((Node)object).dir[n3] == 1) {
                                    ((Net)object2).inputs.addElement(object);
                                } else {
                                    ((Net)object2).output = object;
                                }
                            } else if (Conf.verbose) {
                                Conf.log.println(String.valueOf(this.errorPrefix()) + "Ignoring parameter " + GTech.prim[n][n3 + 1]);
                            }
                            this.readSym(41);
                        } while ((n2 = this.st.nextToken()) != 41);
                    } else {
                        throw new Error(String.valueOf(this.errorPrefix()) + "Keyword expected.");
                    }
                    this.readSym(59);
                }
                case 1: 
            }
        }
        if (this.st.nextToken() != -1) {
            throw new Error(String.valueOf(this.errorPrefix()) + "Only one module per file allowed.");
        }
    }

    private void parse() throws IOException {
        this.module();
    }

    private void readASSIGN() throws IOException {
        this.readRange();
        int n = 44;
        do {
            Net net;
            if (n != 44) {
                throw new Error(String.valueOf(this.errorPrefix()) + "Syntax");
            }
            Object object = this.readParamSimple();
            if (!(object instanceof Net)) {
                throw new Error(String.valueOf(this.errorPrefix()) + "Net expected.");
            }
            this.readSym(61);
            if (this.msb == this.lsb) {
                Net net2 = (Net)object;
                net = this.readExpr();
                Node node = net2.output = net.output;
                int n2 = 0;
                while (n2 < node.width) {
                    if (node.ports[n2] == net) {
                        node.ports[n2] = net2;
                    }
                    ++n2;
                }
            } else {
                throw new Error(String.valueOf(this.errorPrefix()) + "Array assignment not supported");
            }
            this.g.nets.remove(net);
        } while ((n = this.st.nextToken()) != 59);
    }

    private Net readExpr() throws IOException {
        Net net = this.readTerminal();
        int n = this.st.nextToken();
        if (net == null) {
            throw new Error(String.valueOf(this.errorPrefix()) + "Syntax");
        }
        switch (n) {
            default: 
        }
        this.st.pushBack();
        return net;
    }

    private Net readFinal() throws IOException {
        int n = this.st.nextToken();
        switch (n) {
            case 126: {
                NodePrim nodePrim = new NodePrim(0);
                Net net = new Net();
                Net net2 = this.readFinal();
                nodePrim.name = "a" + this.st.lineno() + "_" + this.expr_mark;
                net.name = "na" + this.st.lineno() + "_" + this.expr_mark++;
                this.g.nodes.add(nodePrim);
                this.g.nets.add(net);
                nodePrim.ports[0] = net2;
                net2.inputs.add(nodePrim);
                nodePrim.ports[1] = net;
                net.output = nodePrim;
                return net;
            }
            case -3: {
                this.st.pushBack();
                Object object = this.readParamSimple();
                if (object instanceof Range) {
                    throw new Error(String.valueOf(this.errorPrefix()) + "Arrays not supported in assign statement.");
                }
                if (!(object instanceof Net)) {
                    throw new Error(String.valueOf(this.errorPrefix()) + "Wire expected.");
                }
                return (Net)object;
            }
            case 40: {
                Net net = this.readExpr();
                this.readSym(41);
                return net;
            }
        }
        throw new Error(String.valueOf(this.errorPrefix()) + "Syntax.");
    }

    private void readIN_OUT(int n) throws IOException {
        this.readRange();
        int n2 = 44;
        do {
            if (n2 != 44) {
                throw new Error(String.valueOf(this.errorPrefix()) + "Syntax");
            }
            Object object = this.readWord();
            if (object == null) {
                object = new Range();
                ((Range)object).name = this.st.toString();
            } else if (!(object instanceof Range)) {
                throw new Error(String.valueOf(this.errorPrefix()) + "Nondefined, but declared port expected.");
            }
            Range range = (Range)object;
            if (this.msb == this.lsb) {
                NodePort nodePort = new NodePort(n);
                this.g.nodes.addElement(nodePort);
                nodePort.name = range.name;
                Net net = new Net();
                if (nodePort.dir[0] == 1) {
                    net.inputs.addElement(nodePort);
                } else {
                    net.output = nodePort;
                }
                nodePort.ports[0] = net;
                net.name = nodePort.name;
                this.g.nets.addElement(net);
                this.d.add(net.name, net);
                continue;
            }
            int n3 = 1;
            if (this.msb > this.lsb) {
                n3 = -1;
            }
            range.msb = this.msb;
            range.lsb = this.lsb;
            range.inc = n3;
            range.array = new Object[(this.lsb - this.msb) * n3 + 1];
            int n4 = this.msb;
            while (n4 != this.lsb + n3) {
                NodePort nodePort = new NodePort(n);
                this.g.nodes.addElement(nodePort);
                nodePort.name = String.valueOf(range.name) + " " + n4;
                Net net = new Net();
                if (nodePort.dir[0] == 1) {
                    net.inputs.addElement(nodePort);
                } else {
                    net.output = nodePort;
                }
                nodePort.ports[0] = net;
                net.name = nodePort.name;
                this.g.nets.addElement(net);
                range.array[(n4 - this.msb) * n3] = net;
                n4 += n3;
            }
        } while ((n2 = this.st.nextToken()) != 59);
    }

    private int readKeyword() throws IOException {
        int n = this.st.nextToken();
        boolean bl = false;
        if (n != -3) {
            return -1;
        }
        Object object = this.d.get(this.st.sval);
        if (!(object instanceof Integer)) {
            return -1;
        }
        return (Integer)object;
    }

    private void readKeyword(int n) throws IOException {
        int n2 = this.st.nextToken();
        if (n2 != -3 || (Integer)this.d.get(this.st.sval) != n) {
            throw new Error(String.valueOf(this.errorPrefix()) + "keyword '" + this.d.keywords[n] + "' expected.");
        }
    }

    private void readModule(String string) throws IOException {
        Object object;
        Object object2;
        Object object3;
        String string2 = this.readNewWord();
        System.out.println("Including '" + string2 + "'.");
        if (Conf.debug) {
            Conf.log.println("Including '" + string2 + "'.");
        }
        Parser parser = new Parser(String.valueOf(string) + ".v");
        this.readSym(40);
        int n = 44;
        while (n == 44) {
            Range range = null;
            object3 = null;
            this.readSym(46);
            n = this.st.nextToken();
            if (n != -3) {
                throw new Error(String.valueOf(this.errorPrefix()) + "Syntax.");
            }
            object2 = parser.d.get(this.st.sval);
            if (object2 == null) {
                throw new Error(String.valueOf(this.errorPrefix()) + "Parameter name not found.");
            }
            if (object2 instanceof Range) {
                range = (Range)object2;
            } else if (object2 instanceof Net) {
                object3 = (Net)object2;
            } else {
                throw new Error(String.valueOf(this.errorPrefix()) + "Parameter name not found.");
            }
            this.readSym(40);
            object2 = this.readParam();
            if (object2 instanceof Net) {
                if (object3 == null) {
                    throw new Error(String.valueOf(this.errorPrefix()) + "Single wire expected.");
                }
                this.assimilate((Net)object3, (Net)object2);
            } else {
                object = (Range)object2;
                if (range == null || range.array.length != ((Range)object).array.length) {
                    throw new Error(String.valueOf(this.errorPrefix()) + "Array of same size expected.");
                }
                int n2 = 0;
                while (n2 < range.array.length) {
                    this.assimilate((Net)range.array[n2], (Net)((Range)object).array[n2]);
                    ++n2;
                }
            }
            this.readSym(41);
            n = this.st.nextToken();
        }
        int n3 = 0;
        while (n3 < parser.g.nodes.size()) {
            object3 = (Node)parser.g.nodes.elementAt(n3);
            if (object3 instanceof NodePort) {
                ((Net)object2).link = object2 = ((Node)object3).ports[0];
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 < parser.g.nodes.size()) {
            object2 = (Node)parser.g.nodes.elementAt(n4);
            if (!(object2 instanceof NodePort)) {
                this.g.nodes.addElement(object2);
                int n5 = 0;
                while (n5 < ((Node)object2).width) {
                    if (((Node)object2).ports[n5].link != null) {
                        if (((Node)object2).dir[n5] == 2) {
                            ((Node)object2).ports[n5] = null;
                        } else {
                            Net net = new Net();
                            NodePrim nodePrim = new NodePrim(6);
                            net.name = nodePrim.name = ((Node)object2).ports[n5].name;
                            ((Node)object2).ports[n5] = nodePrim.ports[0] = net;
                            net.inputs.addElement(object2);
                            net.output = nodePrim;
                            this.g.nodes.addElement(net.output);
                            this.g.nets.addElement(net);
                        }
                    }
                    ++n5;
                }
            }
            ++n4;
        }
        int n6 = 0;
        while (n6 < parser.g.nets.size()) {
            object = (Net)parser.g.nets.elementAt(n6);
            if (((Net)object).link == null) {
                this.g.nets.addElement(object);
            }
            ++n6;
        }
        if (n != 41) {
            throw new Error(String.valueOf(this.errorPrefix()) + "Syntax.");
        }
        this.readSym(59);
    }

    private String readNewWord() throws IOException {
        int n = this.st.nextToken();
        if (n != -3) {
            throw new Error(String.valueOf(this.errorPrefix()) + "Word expected, found token#" + n + ".");
        }
        if (this.d.get(this.st.sval) != null) {
            throw new Error(String.valueOf(this.errorPrefix()) + "Invalid identifier");
        }
        return this.st.sval;
    }

    private int readNumber() throws IOException {
        this.readSym(-2);
        Double d = new Double(this.st.nval);
        return d.intValue();
    }

    private Object readParam() throws IOException {
        int n = this.st.nextToken();
        Stack<Object> stack = new Stack<Object>();
        if (n == 123) {
            Object object;
            n = 44;
            int n2 = 0;
            do {
                if (n != 44) {
                    throw new Error(String.valueOf(this.errorPrefix()) + "Syntax.");
                }
                object = this.readParamSimple();
                stack.push(object);
                if (object instanceof Net) {
                    ++n2;
                    continue;
                }
                n2 += ((Range)object).array.length;
            } while ((n = this.st.nextToken()) != 125);
            if (n2 == 1) {
                return stack.elementAt(0);
            }
            object = new Range();
            ((Range)object).msb = 0;
            ((Range)object).lsb = n2 - 1;
            ((Range)object).inc = 1;
            ((Range)object).array = new Object[n2];
            n2 = 0;
            int n3 = 0;
            while (n3 < stack.size()) {
                if (stack.elementAt(n3) instanceof Net) {
                    ((Range)object).array[n2++] = stack.elementAt(n3);
                } else {
                    Range range = (Range)stack.elementAt(n3);
                    int n4 = 0;
                    while (n4 < range.array.length) {
                        ((Range)object).array[n3] = range.array[n4];
                        ++n4;
                    }
                }
                ++n3;
            }
            return object;
        }
        this.st.pushBack();
        return this.readParamSimple();
    }

    private Object readParamSimple() throws IOException {
        Object object = this.readWord();
        if (object instanceof Range) {
            Range range = (Range)object;
            int n = this.st.nextToken();
            if (n == 91) {
                int n2 = this.readNumber();
                n = this.st.nextToken();
                if (n == 93) {
                    if (range.array[n2 = (n2 - range.msb) * range.inc] instanceof Net) {
                        return range.array[n2];
                    }
                    throw new Error(String.valueOf(this.errorPrefix()) + "Wire expected.");
                }
                if (n == 58) {
                    int n3 = this.readNumber();
                    Range range2 = new Range();
                    range2.msb = n2;
                    range2.lsb = n3;
                    range2.inc = n2 > n3 ? -1 : 1;
                    range2.array = new Object[(range2.lsb - range2.msb) * range2.inc + 1];
                    int n4 = 0;
                    while (n4 < range2.array.length) {
                        range2.array[n4] = range.array[(n4 - range.msb) * range.inc];
                        ++n4;
                    }
                    return range2;
                }
                throw new Error(String.valueOf(this.errorPrefix()) + "Syntax.");
            }
            this.st.pushBack();
            return range;
        }
        if (object instanceof Net) {
            return object;
        }
        throw new Error(String.valueOf(this.errorPrefix()) + "Wire expected.");
    }

    private void readRange() throws IOException {
        int n = this.st.nextToken();
        if (n == 91) {
            this.msb = this.readNumber();
            this.readSym(58);
            this.lsb = this.readNumber();
            this.readSym(93);
        } else {
            this.lsb = 0;
            this.msb = 0;
            this.st.pushBack();
        }
    }

    private void readSym(int n) throws IOException {
        int n2 = this.st.nextToken();
        if (n2 != n) {
            throw new Error(String.valueOf(this.errorPrefix()) + "Symbol expected.");
        }
    }

    private Net readTerminal() throws IOException {
        Net net = this.readFinal();
        block3: while (true) {
            int n = this.st.nextToken();
            switch (n) {
                case 38: {
                    NodePrim nodePrim = new NodePrim(2);
                    Net net2 = new Net();
                    Net net3 = this.readFinal();
                    nodePrim.name = "a" + this.st.lineno() + "_" + this.expr_mark;
                    net2.name = "na" + this.st.lineno() + "_" + this.expr_mark++;
                    this.g.nodes.add(nodePrim);
                    this.g.nets.add(net2);
                    nodePrim.ports[0] = net;
                    net.inputs.add(nodePrim);
                    nodePrim.ports[1] = net3;
                    net3.inputs.add(nodePrim);
                    nodePrim.ports[2] = net2;
                    net2.output = nodePrim;
                    net = net2;
                    continue block3;
                }
            }
            break;
        }
        this.st.pushBack();
        return net;
    }

    private void readWIRE() throws IOException {
        this.readRange();
        int n = 44;
        do {
            if (n != 44) {
                throw new Error(String.valueOf(this.errorPrefix()) + "Syntax");
            }
            String string = this.readNewWord();
            Range range = new Range();
            int n2 = 1;
            if (this.msb == this.lsb) {
                Net net = new Net();
                this.g.nets.addElement(net);
                net.name = string;
                n = this.st.nextToken();
                this.d.add(string, net);
                continue;
            }
            range.name = string;
            if (this.msb > this.lsb) {
                n2 = -1;
            }
            range.msb = this.msb;
            range.lsb = this.lsb;
            range.inc = n2;
            range.array = new Object[(this.msb - this.lsb) * n2];
            int n3 = this.msb;
            while (n3 != this.lsb + n2) {
                Net net = new Net();
                this.g.nets.addElement(net);
                net.name = String.valueOf(range.name) + " " + n3;
                range.array[(n3 - this.msb) * n2] = net;
                n3 += n2;
            }
            n = this.st.nextToken();
        } while (n != 59);
    }

    private Object readWord() throws IOException {
        Object object;
        int n = this.st.nextToken();
        if (n != -3) {
            if (n == -2) {
                if (this.st.nbits == 1) {
                    return this.g.global[(int)this.st.nval & 1];
                }
                object = new Range();
                ((Range)object).array = new Object[this.st.nbits];
                ((Range)object).lsb = 0;
                ((Range)object).msb = this.st.nbits;
                ((Range)object).inc = 1;
                int n2 = this.st.nbits - 1;
                while (n2 >= 0) {
                    ((Range)object).array[n2] = this.g.global[(int)this.st.nval & 1];
                    this.st.nval = (int)this.st.nval >> 1;
                    --n2;
                }
            } else {
                throw new Error(String.valueOf(this.errorPrefix()) + "Word expected, found token#" + n + ".");
            }
        }
        if ((object = this.d.get(this.st.sval)) instanceof Integer) {
            throw new Error(String.valueOf(this.errorPrefix()) + "ID expected, keyword found.");
        }
        return object;
    }
}

