/*
 * Decompiled with CFR 0.152.
 */
package org.opencores.util;

import java.util.NoSuchElementException;
import java.util.Vector;

public class Heap
extends Vector {
    public Heap() {
    }

    public Heap(Comparable[] comparableArray) {
        super(comparableArray.length);
        this.setSize(comparableArray.length);
        int n = 0;
        while (n < comparableArray.length) {
            this.setElementAt(comparableArray[n], n);
            ++n;
        }
        this.repair();
    }

    public synchronized void add(Comparable comparable) {
        int n = this.size();
        this.setSize(this.size() + 1);
        while (n > 0 && ((Comparable)this.elementAt(Heap.parent(n))).compareTo(comparable) > 0) {
            this.setElementAt(this.elementAt(Heap.parent(n)), n);
            n = Heap.parent(n);
        }
        this.setElementAt(comparable, n);
    }

    private final synchronized void exchange(int n, int n2) {
        Object e = this.elementAt(n2);
        this.setElementAt(this.elementAt(n), n2);
        this.setElementAt(e, n);
    }

    private static final int left(int n) {
        return (n + 1 << 1) - 1;
    }

    private static final int parent(int n) {
        return (n + 1 >> 1) - 1;
    }

    public synchronized Comparable remove() throws NoSuchElementException {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        Object e = this.elementAt(0);
        this.setElementAt(this.lastElement(), 0);
        this.removeElementAt(this.size() - 1);
        this.sift(0);
        return (Comparable)e;
    }

    public synchronized boolean remove(Comparable comparable) throws NoSuchElementException {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        int n = this.indexOf(comparable);
        if (n < 0) {
            return false;
        }
        this.setElementAt(this.lastElement(), n);
        this.removeElementAt(this.size() - 1);
        this.sift(n);
        return true;
    }

    public void repair() {
        int n = (int)Math.floor(this.size() / 2) - 1;
        while (n >= 0) {
            this.sift(n);
            --n;
        }
    }

    private static final int right(int n) {
        return n + 1 << 1;
    }

    private final synchronized void sift(int n) {
        int n2 = Heap.left(n);
        int n3 = Heap.right(n);
        int n4 = n2 < this.size() && ((Comparable)this.elementAt(n2)).compareTo(this.elementAt(n)) < 0 ? n2 : n;
        if (n3 < this.size() && ((Comparable)this.elementAt(n3)).compareTo(this.elementAt(n4)) < 0) {
            n4 = n3;
        }
        if (n4 != n) {
            this.exchange(n, n4);
            this.sift(n4);
        }
    }
}

