/*
 * Decompiled with CFR 0.152.
 */
package org.opencores.structure;

import java.io.IOException;
import org.opencores.structure.Net;
import org.opencores.structure.Node;
import org.opencores.util.BitStreamWriter;

public class NodeRoutable
extends Node {
    public static final int NINPUTS_ROUTABLE = 8;
    public static final int[][] neighCoor;
    private static final float[] costs;
    public float cost;
    public NodeRoutable[] neigh = new NodeRoutable[8];
    public int portsUnassigned;
    public Net[] segments = new Net[8];
    public int nSegments = 0;

    static {
        int[][] nArrayArray = new int[8][];
        int[] nArray = new int[2];
        nArray[0] = 1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[2];
        nArray2[0] = -1;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[2];
        nArray3[1] = 1;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[2];
        nArray4[1] = -1;
        nArrayArray[3] = nArray4;
        nArrayArray[4] = new int[]{3, -1};
        nArrayArray[5] = new int[]{-3, 1};
        nArrayArray[6] = new int[]{2, 3};
        nArrayArray[7] = new int[]{-2, -3};
        neighCoor = nArrayArray;
        costs = new float[]{1.1f, 1.1f, 1.1f, 1.1f, 1.4f, 1.4f, 1.5f, 1.5f};
    }

    public NodeRoutable(int n) {
        super(n);
    }

    public NodeRoutable(int n, int n2) {
        super(0);
        this.x = n;
        this.y = n2;
        this.name = "#";
    }

    public float calcCost(int n) {
        return costs[n];
    }

    public boolean isConnectable(int n, int n2) {
        return false;
    }

    protected int lessLoadedNeighbour() {
        return 0;
    }

    public static final int opposite(int n) {
        return n ^ 1;
    }

    public void writeBitstream(BitStreamWriter bitStreamWriter) throws IOException {
        if (this.x > 0 && this.x < 25 && this.y > 0 && this.y < 25) {
            bitStreamWriter.write(0, 16);
            bitStreamWriter.write(0, 16);
            bitStreamWriter.write(2, 2);
            bitStreamWriter.write(3, 2);
            bitStreamWriter.write(1, 2);
            bitStreamWriter.write(3, 2);
            bitStreamWriter.write(0, 2);
            bitStreamWriter.write(3, 2);
            bitStreamWriter.write(3, 2);
            bitStreamWriter.write(3, 2);
        } else {
            bitStreamWriter.write(3, 3);
            bitStreamWriter.write(3, 3);
            bitStreamWriter.write(this.lessLoadedNeighbour(), 3);
        }
        int n = 7;
        while (n >= 0) {
            NodeRoutable nodeRoutable = this.neigh[n];
            if (this.segments[n] == null) {
                bitStreamWriter.write(this.lessLoadedNeighbour(), 3);
            } else {
                int n2 = -1;
                int n3 = 0;
                while (n3 < 8) {
                    Net net = nodeRoutable.segments[NodeRoutable.opposite(n3)];
                    if (this.segments[n] == net) {
                        n2 = n3;
                        break;
                    }
                    ++n3;
                }
                if (n2 < 0) {
                    throw new Error("Cannot find net source");
                }
                bitStreamWriter.write(n2, 3);
            }
            --n;
        }
    }
}

