/*
 * Decompiled with CFR 0.152.
 */
package org.opencores.structure;

import org.opencores.structure.Net;
import org.opencores.structure.Node;

public class NodeLUT
extends Node {
    public int OUT;
    public byte[] func;

    public NodeLUT(int n) {
        super(n);
        this.OUT = n - 1;
        this.dir[this.OUT] = 2;
        this.func = new byte[this.size()];
    }

    public NodeLUT(NodeLUT nodeLUT, NodeLUT nodeLUT2, boolean bl) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int[] nArray = new int[nodeLUT.width - 1];
        int[] nArray2 = new int[nodeLUT2.width - 1];
        int[] nArray3 = new int[nodeLUT.width - 1];
        int[] nArray4 = new int[nodeLUT2.width - 1];
        Net net = nodeLUT.ports[nodeLUT.width - 1];
        int n9 = 0;
        while (n9 < nodeLUT.width - 1) {
            nArray[n7++] = n9;
            nArray3[n9] = n6++;
            ++n9;
        }
        boolean bl2 = false;
        int n10 = 0;
        while (n10 < nodeLUT2.width - 1) {
            if (nodeLUT2.ports[n10] != net) {
                n5 = -1;
                n4 = 0;
                while (n4 < n7) {
                    if (nodeLUT.ports[nArray[n4]] == nodeLUT2.ports[n10]) {
                        n5 = n4;
                        break;
                    }
                    ++n4;
                }
                if (n5 < 0) {
                    nArray2[n8++] = n10;
                    nArray4[n10] = n6++;
                } else {
                    nArray4[n10] = n5;
                }
            } else {
                nArray4[n10] = -1;
                bl2 = true;
            }
            ++n10;
        }
        if (!bl2) {
            throw new Error(String.valueOf(nodeLUT.name) + " is not parent of " + nodeLUT2.name + "!");
        }
        this.setWidth(n6 + 1);
        this.OUT = n6;
        this.func = new byte[this.size()];
        n5 = 0;
        while (n5 < this.size()) {
            this.func[n5] = 0;
            ++n5;
        }
        n4 = 0;
        while (n4 < 1 << n6) {
            n3 = 0;
            n2 = nodeLUT.calc(n4 & (1 << n7) - 1);
            n = 0;
            while (n < nodeLUT2.width - 1) {
                n3 <<= 1;
                n3 = nArray4[n] >= 0 ? (n3 |= n4 >> nArray4[n] & 1) : (n3 |= n2);
                ++n;
            }
            int n11 = nodeLUT2.calc(n3);
            if ((n11 | 1) != 1) {
                throw new Error("Value not 0 or 1!");
            }
            int n12 = n4 >> 3;
            this.func[n12] = (byte)(this.func[n12] | (byte)(n11 << (n4 & 7)));
            ++n4;
        }
        this.dir[n6] = 2;
        this.ports[n6] = nodeLUT2.ports[nodeLUT2.width - 1];
        n3 = 0;
        n2 = 0;
        while (n2 < n7) {
            this.ports[n3++] = nodeLUT.ports[nArray[n2]];
            ++n2;
        }
        n = 0;
        while (n < n8) {
            this.ports[n3++] = nodeLUT2.ports[nArray2[n]];
            ++n;
        }
        this.name = new String(String.valueOf(nodeLUT.name) + "+" + nodeLUT2.name);
        if (bl) {
            nodeLUT.unlinkNets();
            nodeLUT2.unlinkNets();
            this.linkNets();
        }
        this.fx = (nodeLUT.fx + nodeLUT2.fx) / 2.0f;
        this.fy = (nodeLUT.fy + nodeLUT2.fy) / 2.0f;
    }

    public static final int NumJoinInputs(NodeLUT nodeLUT, NodeLUT nodeLUT2) {
        int n = nodeLUT.width - 1;
        Net net = nodeLUT.ports[nodeLUT.width - 1];
        int n2 = 0;
        while (n2 < nodeLUT2.width - 1) {
            if (nodeLUT2.ports[n2] != net) {
                int n3 = -1;
                int n4 = 0;
                while (n4 < nodeLUT.width - 1) {
                    if (nodeLUT.ports[n4] == nodeLUT2.ports[n2]) {
                        n3 = n4;
                        break;
                    }
                    ++n4;
                }
                if (n3 < 0) {
                    ++n;
                }
            }
            ++n2;
        }
        return n;
    }

    public static final int NumJoinInputsEx(NodeLUT nodeLUT, NodeLUT nodeLUT2) {
        if (NodeLUT.isAChild(nodeLUT, nodeLUT2)) {
            return NodeLUT.NumJoinInputs(nodeLUT2, nodeLUT);
        }
        return NodeLUT.NumJoinInputs(nodeLUT, nodeLUT2);
    }

    public final int calc(int n) {
        return this.func[n >> 3] >> (n & 7) & 1;
    }

    public Object clone() {
        NodeLUT nodeLUT = new NodeLUT(this.width);
        nodeLUT.duplicate(this);
        return nodeLUT;
    }

    public void duplicate(NodeLUT nodeLUT) {
        this.duplicate((Node)nodeLUT);
        int n = 0;
        while (n < this.func.length) {
            this.func[n] = nodeLUT.func[n];
            ++n;
        }
    }

    public static final boolean isAChild(NodeLUT nodeLUT, NodeLUT nodeLUT2) {
        if (nodeLUT == null || nodeLUT2 == null) {
            return false;
        }
        Net net = nodeLUT.ports[nodeLUT.width - 1];
        Net net2 = nodeLUT2.ports[nodeLUT2.width - 1];
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        while (n < nodeLUT2.width - 1) {
            if (nodeLUT2.ports[n] == net) {
                bl2 = true;
                break;
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < nodeLUT.width - 1) {
            if (nodeLUT.ports[n2] == net2) {
                bl = true;
                break;
            }
            ++n2;
        }
        if (bl && bl2) {
            return nodeLUT.hashCode() < nodeLUT2.hashCode();
        }
        return bl;
    }

    public void permutateInputs(int[] nArray) throws Exception {
        byte[] byArray = new byte[this.func.length];
        if (nArray.length != this.width - 1) {
            throw new Exception("Invalid permutation");
        }
        int n = 0;
        while (n < 1 << this.width - 1) {
            int n2 = 0;
            int n3 = 0;
            while (n3 < nArray.length) {
                n2 |= (n >> n3 & 1) << nArray[n3];
                ++n3;
            }
            byArray[n2 / 8] = (byte)(this.calc(n2) << (n2 & 7));
            ++n;
        }
        this.func = byArray;
    }

    public void permutateInputsInv(int[] nArray) throws Exception {
        byte[] byArray = new byte[this.func.length];
        if (nArray.length != this.width - 1) {
            throw new Exception("Invalid permutation");
        }
        int n = 0;
        while (n < 1 << this.width - 1) {
            int n2 = 0;
            int n3 = 0;
            while (n3 < nArray.length) {
                n2 |= (n >> n3 & 1) << nArray[n3];
                ++n3;
            }
            byArray[n2 >> 3] = (byte)(this.calc(n2) << (n2 & 7));
            ++n;
        }
        this.func = byArray;
    }

    private int size() {
        return Math.max((1 << this.width - 1) / 8, 1);
    }

    public String toString() {
        String string = "LUT" + (this.width - 1) + super.toString() + "  ";
        int n = this.size() - 1;
        while (n >= 0) {
            string = String.valueOf(string) + Integer.toHexString(this.func[n] & 0xFF).toUpperCase();
            --n;
        }
        return String.valueOf(string) + "\r\n";
    }
}

