/*
 * Decompiled with CFR 0.152.
 */
package org.opencores.structure;

import java.io.IOException;
import org.opencores.structure.IndexedNode;
import org.opencores.structure.Net;
import org.opencores.structure.NetGlobal;
import org.opencores.structure.Node;
import org.opencores.structure.NodePort;
import org.opencores.structure.NodeRoutable;
import org.opencores.util.BitStreamWriter;

public class NodeIOC
extends IndexedNode {
    public int typeI = 3;
    public int typeO = 3;

    public NodeIOC() {
        super(2);
        this.dir[0] = 1;
        this.dir[1] = 2;
    }

    public NodeIOC(NodePort nodePort, NetGlobal netGlobal) {
        super(2);
        this.dir[0] = 1;
        this.dir[1] = 2;
        this.name = nodePort.name;
        this.x = nodePort.x;
        this.y = nodePort.y;
        this.fx = nodePort.fx;
        this.fy = nodePort.fy;
        if (nodePort.dir[0] == 1) {
            this.ports[0] = nodePort.ports[0];
        } else {
            this.ports[0] = netGlobal;
            this.ports[1] = nodePort.ports[0];
        }
    }

    public Object clone() {
        NodeIOC nodeIOC = new NodeIOC();
        nodeIOC.duplicate(this);
        return nodeIOC;
    }

    public void duplicate(NodeIOC nodeIOC) {
        this.duplicate((Node)nodeIOC);
    }

    public static int indexOf(int n, int n2) {
        if (n2 == -1) {
            return n;
        }
        if (n2 == 24) {
            return n + 24;
        }
        if (n == -1) {
            return n2 + 48;
        }
        return n2 + 48 + 24;
    }

    public boolean isConnectable(int n, int n2) {
        return true;
    }

    public int posX() {
        return NodeIOC.posX(this.idx);
    }

    public static int posX(int n) {
        if (n < 48) {
            if (n >= 24) {
                return n - 24;
            }
            return n;
        }
        if ((n -= 48) >= 24) {
            return 24;
        }
        return -1;
    }

    public int posY() {
        return NodeIOC.posY(this.idx);
    }

    public static int posY(int n) {
        if (n < 48) {
            if (n >= 24) {
                return 24;
            }
            return -1;
        }
        if ((n -= 48) >= 24) {
            return n - 24;
        }
        return n;
    }

    public String toString() {
        return "IOC " + super.toString();
    }

    public void writeBitstream(BitStreamWriter bitStreamWriter) throws IOException {
        bitStreamWriter.write(this.typeO, 3);
        bitStreamWriter.write(this.typeI, 3);
        int n = -1;
        int n2 = 0;
        while (n2 < 8) {
            if (this.segments[n2] == this.ports[0]) {
                n = n2;
                break;
            }
            ++n2;
        }
        if (n < 0) {
            throw new Error("Cannot find IOC's " + this.name + " input.");
        }
        bitStreamWriter.write(n, 3);
        int n3 = 7;
        while (n3 >= 0) {
            NodeRoutable nodeRoutable = this.neigh[n3];
            if (nodeRoutable == null) {
                bitStreamWriter.write(this.lessLoadedNeighbour(), 3);
            } else {
                Net net = nodeRoutable.segments[NodeRoutable.opposite(n3)];
                if (net == null) {
                    bitStreamWriter.write(this.lessLoadedNeighbour(), 3);
                } else {
                    n = -1;
                    int n4 = 0;
                    while (n4 < 8) {
                        if (this.segments[n4] == net) {
                            n = n4;
                            break;
                        }
                        ++n4;
                    }
                    if (n < 0) {
                        throw new Error("Cannot find net source");
                    }
                    bitStreamWriter.write(n, 3);
                }
            }
            --n3;
        }
    }
}

