/*
 * Decompiled with CFR 0.152.
 */
package org.opencores.structure;

import java.io.IOException;
import org.opencores.structure.IndexedNode;
import org.opencores.structure.Net;
import org.opencores.structure.NetGlobal;
import org.opencores.structure.NodeFF;
import org.opencores.structure.NodeLUT;
import org.opencores.structure.NodeRoutable;
import org.opencores.util.BitStreamWriter;

public class NodeGPC
extends IndexedNode {
    public static final int NINPUTS_LUT = 5;
    public static final int CLK = 5;
    public static final int SET = 6;
    public static final int RST = 7;
    public static final int OUT = 8;
    public NodeLUT a;
    public NodeFF ra;
    private static final int[] INPUT_CONF;

    static {
        int[] nArray = new int[256];
        nArray[0] = -1;
        nArray[1] = -1;
        nArray[2] = -1;
        nArray[3] = -1;
        nArray[4] = -1;
        nArray[5] = -1;
        nArray[6] = -1;
        nArray[7] = -1;
        nArray[8] = -1;
        nArray[10] = 273;
        nArray[11] = 1;
        nArray[12] = 546;
        nArray[13] = 2;
        nArray[14] = 274;
        nArray[15] = 18;
        nArray[16] = -1;
        nArray[17] = 68;
        nArray[18] = 341;
        nArray[19] = 69;
        nArray[20] = 614;
        nArray[21] = 70;
        nArray[22] = 342;
        nArray[23] = 86;
        nArray[24] = -1;
        nArray[25] = 4;
        nArray[26] = 277;
        nArray[27] = 5;
        nArray[28] = 550;
        nArray[29] = 6;
        nArray[30] = 278;
        nArray[31] = 22;
        nArray[32] = -1;
        nArray[33] = 136;
        nArray[34] = 409;
        nArray[35] = 137;
        nArray[36] = 682;
        nArray[37] = 138;
        nArray[38] = 410;
        nArray[39] = 154;
        nArray[40] = -1;
        nArray[41] = 8;
        nArray[42] = 281;
        nArray[43] = 9;
        nArray[44] = 554;
        nArray[45] = 10;
        nArray[46] = 282;
        nArray[47] = 26;
        nArray[48] = -1;
        nArray[49] = 72;
        nArray[50] = 345;
        nArray[51] = 73;
        nArray[52] = 618;
        nArray[53] = 74;
        nArray[54] = 346;
        nArray[55] = 90;
        nArray[56] = 819;
        nArray[57] = 56;
        nArray[58] = 313;
        nArray[59] = 57;
        nArray[60] = 570;
        nArray[61] = 58;
        nArray[62] = 314;
        nArray[63] = -1;
        nArray[64] = -1;
        nArray[65] = -1;
        nArray[66] = -1;
        nArray[67] = -1;
        nArray[68] = -1;
        nArray[69] = -1;
        nArray[70] = -1;
        nArray[71] = -1;
        nArray[72] = -1;
        nArray[73] = 12;
        nArray[74] = 285;
        nArray[75] = 13;
        nArray[76] = 558;
        nArray[77] = 14;
        nArray[78] = 286;
        nArray[79] = 30;
        nArray[80] = -1;
        nArray[81] = 76;
        nArray[82] = 349;
        nArray[83] = 77;
        nArray[84] = 622;
        nArray[85] = 78;
        nArray[86] = 350;
        nArray[87] = 94;
        nArray[88] = -1;
        nArray[89] = 60;
        nArray[90] = 317;
        nArray[91] = 61;
        nArray[92] = 574;
        nArray[93] = 62;
        nArray[94] = 318;
        nArray[95] = -1;
        nArray[96] = -1;
        nArray[97] = 140;
        nArray[98] = 413;
        nArray[99] = 141;
        nArray[100] = 686;
        nArray[101] = 142;
        nArray[102] = 414;
        nArray[103] = 158;
        nArray[104] = -1;
        nArray[105] = 143;
        nArray[106] = 415;
        nArray[107] = 159;
        nArray[108] = 687;
        nArray[109] = 175;
        nArray[110] = 431;
        nArray[111] = -1;
        nArray[112] = -1;
        nArray[113] = 188;
        nArray[114] = 445;
        nArray[115] = 189;
        nArray[116] = 702;
        nArray[117] = 190;
        nArray[118] = 446;
        nArray[119] = -1;
        nArray[120] = 831;
        nArray[121] = 191;
        nArray[122] = 447;
        nArray[123] = -1;
        nArray[124] = 703;
        nArray[125] = -1;
        nArray[126] = -1;
        nArray[127] = -1;
        nArray[128] = -1;
        nArray[129] = -1;
        nArray[130] = -1;
        nArray[131] = -1;
        nArray[132] = -1;
        nArray[133] = -1;
        nArray[134] = -1;
        nArray[135] = -1;
        nArray[136] = -1;
        nArray[137] = 192;
        nArray[138] = 465;
        nArray[139] = 193;
        nArray[140] = 738;
        nArray[141] = 194;
        nArray[142] = 466;
        nArray[143] = 210;
        nArray[144] = -1;
        nArray[145] = 196;
        nArray[146] = 469;
        nArray[147] = 197;
        nArray[148] = 742;
        nArray[149] = 198;
        nArray[150] = 470;
        nArray[151] = 214;
        nArray[152] = -1;
        nArray[153] = 199;
        nArray[154] = 471;
        nArray[155] = 215;
        nArray[156] = 743;
        nArray[157] = 231;
        nArray[158] = 487;
        nArray[159] = -1;
        nArray[160] = -1;
        nArray[161] = 200;
        nArray[162] = 473;
        nArray[163] = 201;
        nArray[164] = 746;
        nArray[165] = 202;
        nArray[166] = 474;
        nArray[167] = 218;
        nArray[168] = -1;
        nArray[169] = 203;
        nArray[170] = 475;
        nArray[171] = 219;
        nArray[172] = 747;
        nArray[173] = 235;
        nArray[174] = 491;
        nArray[175] = -1;
        nArray[176] = -1;
        nArray[177] = 248;
        nArray[178] = 505;
        nArray[179] = 249;
        nArray[180] = 762;
        nArray[181] = 250;
        nArray[182] = 506;
        nArray[183] = -1;
        nArray[184] = 1011;
        nArray[185] = 251;
        nArray[186] = 507;
        nArray[187] = -1;
        nArray[188] = 763;
        nArray[189] = -1;
        nArray[190] = -1;
        nArray[191] = -1;
        nArray[192] = -1;
        nArray[193] = 204;
        nArray[194] = 477;
        nArray[195] = 205;
        nArray[196] = 750;
        nArray[197] = 206;
        nArray[198] = 478;
        nArray[199] = 222;
        nArray[200] = -1;
        nArray[201] = 207;
        nArray[202] = 479;
        nArray[203] = 223;
        nArray[204] = 751;
        nArray[205] = 239;
        nArray[206] = 495;
        nArray[207] = -1;
        nArray[208] = -1;
        nArray[209] = 252;
        nArray[210] = 509;
        nArray[211] = 253;
        nArray[212] = 766;
        nArray[213] = 254;
        nArray[214] = 510;
        nArray[215] = -1;
        nArray[216] = -1;
        nArray[217] = 255;
        nArray[218] = 511;
        nArray[219] = -1;
        nArray[220] = 767;
        nArray[221] = -1;
        nArray[222] = -1;
        nArray[223] = -1;
        nArray[224] = -1;
        nArray[225] = 972;
        nArray[226] = 989;
        nArray[227] = 973;
        nArray[228] = 1006;
        nArray[229] = 974;
        nArray[230] = 990;
        nArray[231] = -1;
        nArray[232] = -1;
        nArray[233] = 975;
        nArray[234] = 991;
        nArray[235] = -1;
        nArray[236] = 1007;
        nArray[237] = -1;
        nArray[238] = -1;
        nArray[239] = -1;
        nArray[240] = -1;
        nArray[241] = 1020;
        nArray[242] = 1021;
        nArray[243] = -1;
        nArray[244] = 1022;
        nArray[245] = -1;
        nArray[246] = -1;
        nArray[247] = -1;
        nArray[248] = 1023;
        nArray[249] = -1;
        nArray[250] = -1;
        nArray[251] = -1;
        nArray[252] = -1;
        nArray[253] = -1;
        nArray[254] = -1;
        nArray[255] = -1;
        INPUT_CONF = nArray;
    }

    public NodeGPC(NodeLUT nodeLUT, NodeFF nodeFF, boolean bl, NetGlobal netGlobal) {
        super(9);
        int n;
        Net net;
        this.a = nodeLUT;
        this.ra = nodeFF;
        this.dir[8] = 2;
        this.dir[8] = 2;
        int n2 = 0;
        this.name = "";
        if (nodeLUT != null) {
            this.name = "(" + nodeLUT.name + ",";
            net = nodeLUT.ports[nodeLUT.width - 1];
            n = 0;
            while (n < nodeLUT.width - 1) {
                this.ports[n2++] = nodeLUT.ports[n];
                ++n;
            }
        } else {
            if (nodeFF != null) {
                throw new Error("FF does not have preceding LUT.");
            }
            net = null;
            this.name = "(null,";
        }
        if (n2 > 5) {
            throw new Error("Formed GPC too large.");
        }
        n = n2;
        while (n < 5) {
            this.ports[n] = netGlobal;
            ++n;
        }
        if (nodeFF != null) {
            this.ports[5] = nodeFF.ports[1];
            this.ports[6] = nodeFF.ports[2];
            this.ports[7] = nodeFF.ports[3];
            this.ports[8] = nodeFF.ports[4];
            this.name = String.valueOf(this.name) + nodeFF.name + ")";
        } else {
            this.ports[6] = this.ports[7] = netGlobal;
            this.ports[5] = this.ports[7];
            this.ports[8] = nodeLUT != null ? nodeLUT.ports[nodeLUT.width - 1] : null;
            this.name = String.valueOf(this.name) + "null)";
        }
        if (bl) {
            if (nodeLUT != null) {
                nodeLUT.unlinkNets();
            }
            if (nodeFF != null) {
                nodeFF.unlinkNets();
            }
            this.linkNets();
        }
        boolean bl2 = false;
        this.fx = nodeLUT.fx;
        this.fy = nodeLUT.fy;
        if (nodeFF != null) {
            this.fx += nodeFF.fx;
            this.fy += nodeFF.fy;
            this.fx /= 2.0f;
            this.fy /= 2.0f;
        }
    }

    public static int indexOf(int n, int n2) {
        return n + n2 * 24;
    }

    public boolean isConnectable(int n, int n2) {
        if (n < 5) {
            return true;
        }
        if (n == 5) {
            return n2 == 4;
        }
        if (n == 7) {
            return (n2 | 1) == 1;
        }
        if (n == 6) {
            return (n2 | 1) == 3;
        }
        throw new Error("Invalid Pin");
    }

    public int posX() {
        return NodeGPC.posX(this.idx);
    }

    public static int posX(int n) {
        int n2 = n % 24;
        return n2;
    }

    public int posY() {
        return NodeGPC.posY(this.idx);
    }

    public static int posY(int n) {
        int n2 = n / 24;
        return n2;
    }

    public String toString() {
        return "GPC " + super.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeBitstream(BitStreamWriter bitStreamWriter) throws IOException {
        int n = this.a.func.length - 1;
        while (n >= 0) {
            bitStreamWriter.write(this.a.func[n], 8);
            --n;
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < 5) {
            int n4 = 0;
            while (n4 < 8) {
                if (this.ports[n3] == this.segments[n4]) {
                    n2 |= 1 << n4;
                    break;
                }
                ++n4;
            }
            ++n3;
        }
        bitStreamWriter.write(INPUT_CONF[n2], 10);
        if (this.ra == null) {
            bitStreamWriter.write(3, 2);
            bitStreamWriter.write(3, 2);
            bitStreamWriter.write(3, 2);
        } else {
            if (this.ports[5] == this.segments[4]) {
                bitStreamWriter.write(0, 2);
            } else {
                if (!(this.ports[5] instanceof NetGlobal)) throw new Error("Cannot connect CLK signal to GPC " + this.name);
                NetGlobal netGlobal = (NetGlobal)this.ports[5];
                if (netGlobal.type == 2) {
                    bitStreamWriter.write(1, 2);
                } else {
                    if (netGlobal.type != 3) throw new Error("Cannot connect GCLKx signal to GPC " + this.name);
                    bitStreamWriter.write(2, 2);
                }
            }
            if (this.ports[7] == this.segments[0]) {
                bitStreamWriter.write(0, 2);
            }
            if (this.ports[7] == this.segments[1]) {
                bitStreamWriter.write(1, 2);
            } else if (this.ports[7] instanceof NetGlobal) {
                NetGlobal netGlobal = (NetGlobal)this.ports[7];
                if (netGlobal.type != 4) throw new Error("Cannot connect GRST signal to GPC " + this.name);
                bitStreamWriter.write(2, 2);
            } else {
                bitStreamWriter.write(3, 2);
            }
            if (this.ports[7] == this.segments[2]) {
                bitStreamWriter.write(0, 2);
            }
            if (this.ports[7] == this.segments[3]) {
                bitStreamWriter.write(1, 2);
            } else if (this.ports[6] instanceof NetGlobal) {
                NetGlobal netGlobal = (NetGlobal)this.ports[6];
                if (netGlobal.type != 5) throw new Error("Cannot connect GSET signal to GPC " + this.name);
                bitStreamWriter.write(2, 2);
            } else {
                bitStreamWriter.write(3, 2);
            }
        }
        int n5 = 7;
        while (n5 >= 0) {
            NodeRoutable nodeRoutable = this.neigh[n5];
            if (nodeRoutable == null) {
                bitStreamWriter.write(this.lessLoadedNeighbour(), 3);
            } else {
                Net net = nodeRoutable.segments[NodeRoutable.opposite(n5)];
                if (net == null) {
                    bitStreamWriter.write(this.lessLoadedNeighbour(), 3);
                } else {
                    int n6 = -1;
                    int n7 = 0;
                    while (n7 < 8) {
                        if (this.segments[n7] == net) {
                            n6 = n7;
                            break;
                        }
                        ++n7;
                    }
                    if (n6 < 0) {
                        throw new Error("Cannot find net source");
                    }
                    bitStreamWriter.write(n6, 3);
                }
            }
            --n5;
        }
    }
}

