/*
 * Decompiled with CFR 0.152.
 */
package org.opencores.structure;

import org.opencores.structure.Net;

public class Node {
    public static final int INPUT = 1;
    public static final int OUTPUT = 2;
    public static final int INOUT = 3;
    public String name;
    public Net[] ports;
    public float[] weight;
    public int[] dir;
    public int x;
    public int y;
    public float fx;
    public float fy;
    public boolean flag = false;
    public boolean visited = false;
    public int temp;
    public float nfx;
    public float nfy;
    public int width = 0;
    public Node link = null;

    Node() {
    }

    public Node(int n) {
        this.setWidth(n);
    }

    public Object clone() {
        Node node = new Node();
        node.duplicate(this);
        return node;
    }

    public void duplicate(Node node) {
        this.setWidth(node.width);
        this.name = node.name;
        this.flag = node.flag;
        this.temp = node.temp;
        this.x = node.x;
        this.y = node.y;
        this.fx = node.fx;
        this.fy = node.fy;
        int n = 0;
        while (n < node.width) {
            this.dir[n] = node.dir[n];
            this.weight[n] = node.weight[n];
            this.ports[n] = node.ports[n];
            ++n;
        }
    }

    public void linkNets() {
        int n = 0;
        while (n < this.ports.length) {
            if (this.ports[n] != null) {
                if (this.dir[n] == 1) {
                    this.ports[n].inputs.addElement(this);
                } else {
                    this.ports[n].output = this;
                }
            }
            ++n;
        }
    }

    public void setWidth(int n) {
        this.width = n;
        this.ports = new Net[n];
        this.weight = new float[n];
        this.dir = new int[n];
        int n2 = 0;
        while (n2 < n) {
            this.weight[n2] = 1.0f;
            this.dir[n2] = 1;
            this.ports[n2] = null;
            ++n2;
        }
    }

    public String toString() {
        String string = "Node: " + this.name + "(x" + this.x + " y" + this.y + " temp" + this.temp + ") nets(" + this.width + ")";
        int n = 58;
        int n2 = 0;
        while (n2 < this.width) {
            string = this.ports[n2] != null ? (this.dir[n2] == 2 ? String.valueOf(string) + (char)n + " *" + this.ports[n2].name : String.valueOf(string) + (char)n + " " + this.ports[n2].name) : (this.dir[n2] == 2 ? String.valueOf(string) + (char)n + " *null" : String.valueOf(string) + (char)n + " null");
            n = 44;
            ++n2;
        }
        return String.valueOf(string) + "\r\n";
    }

    public void unlinkNets() {
        int n = 0;
        while (n < this.ports.length) {
            if (this.ports[n] != null) {
                if (this.ports[n].output == this) {
                    this.ports[n].output = null;
                } else {
                    this.ports[n].inputs.removeElement(this);
                    this.ports[n] = null;
                }
            }
            ++n;
        }
    }
}

