/*
 * Decompiled with CFR 0.152.
 */
package org.opencores.structure;

import java.io.IOException;
import java.util.Vector;
import org.opencores.Conf;
import org.opencores.structure.IndexedNode;
import org.opencores.structure.Net;
import org.opencores.structure.NetGlobal;
import org.opencores.structure.Node;
import org.opencores.structure.NodePrim;
import org.opencores.structure.NodeRoutable;
import org.opencores.structure.NodeSR;
import org.opencores.util.BitStreamWriter;

public class Graph {
    public String name;
    public Vector nodes = new Vector();
    public Vector nets = new Vector();
    public NetGlobal[] global = new NetGlobal[7];
    public NodeRoutable[][] pos;
    public NodeSR[] SR = new NodeSR[6];
    public boolean mapped = false;

    public Graph() {
        int n = 0;
        while (n < 7) {
            this.global[n] = new NetGlobal(n);
            ++n;
        }
    }

    public void calcPositions() {
        int n = 0;
        while (n < this.nodes.size()) {
            Node node = (Node)this.nodes.elementAt(n);
            if (node instanceof IndexedNode) {
                node.x = ((IndexedNode)node).posX();
                node.y = ((IndexedNode)node).posY();
            }
            ++n;
        }
    }

    public int check(boolean bl) {
        Object object;
        Object object2;
        Object object3;
        int n = 0;
        int n2 = 0;
        while (n2 < this.nodes.size()) {
            Node node = (Node)this.nodes.elementAt(n2);
            node.temp = 0;
            int n3 = 0;
            while (n3 < node.width) {
                if (node.dir[n3] == 1) {
                    if (!node.ports[n3].inputs.contains(node)) {
                        if (bl) {
                            Conf.log.println("(node) " + node.name + " - (net) " + node.ports[n3].name + " Input connection not bidirectional.");
                        }
                        ++n;
                    }
                } else if (node.ports[n3] != null) {
                    if (node.ports[n3].output != node) {
                        if (bl) {
                            Conf.log.println("(node) " + node.name + " - (net) " + node.ports[n3].name + " Output connection not bidirectional.");
                        }
                        ++n;
                    }
                } else {
                    ++node.temp;
                }
                ++n3;
            }
            ++n2;
        }
        int n4 = 0;
        while (n4 < this.nets.size()) {
            Node node;
            Net net = (Net)this.nets.elementAt(n4);
            int n5 = 0;
            while (n5 < net.inputs.size()) {
                node = (Node)net.inputs.elementAt(n5);
                ++node.temp;
                ++n5;
            }
            node = net.output;
            if (node != null) {
                ++node.temp;
            }
            ++n4;
        }
        int n6 = 0;
        while (n6 < this.global.length) {
            NetGlobal netGlobal = this.global[n6];
            int n7 = 0;
            while (n7 < netGlobal.inputs.size()) {
                object3 = (Node)netGlobal.inputs.elementAt(n7);
                ++((Node)object3).temp;
                ++n7;
            }
            ++n6;
        }
        int n8 = 0;
        while (n8 < this.nodes.size()) {
            Node node = (Node)this.nodes.elementAt(n8);
            if (node.temp != node.width) {
                if (bl) {
                    Conf.log.println(String.valueOf(node.name) + " has inconsistent number of net references.");
                }
                ++n;
            }
            int n9 = 0;
            while (n9 < node.width) {
                object2 = node.ports[n9];
                if (object2 != null) {
                    ((Net)object2).link = object2;
                }
                ++n9;
            }
            ++n8;
        }
        int n10 = 0;
        while (n10 < this.nets.size()) {
            object3 = (Net)this.nets.elementAt(n10);
            ((Net)object3).link = null;
            int n11 = 0;
            while (n11 < ((Net)object3).inputs.size()) {
                object = (Node)((Net)object3).inputs.elementAt(n11);
                if (object != null) {
                    ((Node)object).flag = true;
                }
                ++n11;
            }
            if (((Net)object3).output != null) {
                ((Net)object3).output.flag = true;
            }
            ++n10;
        }
        int n12 = 0;
        while (n12 < this.nodes.size()) {
            object2 = (Node)this.nodes.elementAt(n12);
            ((Node)object2).flag = false;
            int n13 = 0;
            while (n13 < ((Node)object2).width) {
                if (!(((Node)object2).ports[n13] instanceof NetGlobal) && (((Node)object2).ports[n13] == null || ((Node)object2).ports[n13] != null && ((Node)object2).ports[n13].link != null)) {
                    if (((Node)object2).dir[n13] == 2) {
                        if (((Node)object2).ports[n13] != null) {
                            if (bl) {
                                Conf.log.println(String.valueOf(((Node)object2).name) + "'s output port(" + n13 + "+) not in graph!");
                            }
                            ++n;
                        }
                    } else {
                        if (bl) {
                            Conf.log.println(String.valueOf(((Node)object2).name) + "'s input port(" + n13 + "+) not in graph!");
                        }
                        ++n;
                    }
                }
                ++n13;
            }
            ++n12;
        }
        int n14 = 0;
        while (n14 < this.nets.size()) {
            Node node;
            object = (Net)this.nets.elementAt(n14);
            int n15 = 0;
            while (n15 < ((Net)object).inputs.size()) {
                node = (Node)((Net)object).inputs.elementAt(n15);
                if (node == null) {
                    node = new Node();
                    node.flag = true;
                }
                if (node.flag && !(node instanceof NodeSR)) {
                    if (bl) {
                        Conf.log.println("Node " + node.name + " not in graph.");
                    }
                    ++n;
                }
                ++n15;
            }
            node = ((Net)object).output;
            if (node == null) {
                node = new Node();
                node.flag = true;
            }
            if (node.flag && !(node instanceof NodeSR)) {
                if (bl) {
                    Conf.log.println("Node " + node.name + " not in graph.");
                }
                ++n;
            }
            ++n14;
        }
        return n;
    }

    public void clearNodes() {
        int n;
        int n2 = 0;
        while (n2 < this.pos.length) {
            n = 0;
            while (n < this.pos[n2].length) {
                NodeRoutable nodeRoutable = this.pos[n2][n];
                nodeRoutable.temp = 0;
                int n3 = 0;
                while (n3 < 8) {
                    nodeRoutable.cost = Float.MAX_VALUE;
                    ++n3;
                }
                ++n;
            }
            ++n2;
        }
        n = 0;
        while (n < 6) {
            if (this.SR[n] != null) {
                this.SR[n].temp = 0;
            }
            ++n;
        }
    }

    public void constructSegments() {
        boolean bl;
        int n;
        int n2;
        int n3;
        NodeRoutable nodeRoutable;
        int n4;
        int n5;
        this.pos = new NodeRoutable[26][];
        int n6 = 0;
        while (n6 < this.pos.length) {
            this.pos[n6] = new NodeRoutable[26];
            n5 = 0;
            while (n5 < this.pos[n6].length) {
                this.pos[n6][n5] = null;
                ++n5;
            }
            ++n6;
        }
        n5 = 0;
        while (n5 < this.nodes.size()) {
            Node node = (Node)this.nodes.elementAt(n5);
            if (node instanceof NodeRoutable) {
                NodeRoutable nodeRoutable2;
                this.pos[nodeRoutable2.x + 1][nodeRoutable2.y + 1] = nodeRoutable2 = (NodeRoutable)node;
            }
            ++n5;
        }
        int n7 = 0;
        while (n7 < this.pos.length) {
            int n8 = 0;
            while (n8 < this.pos[n7].length) {
                if (this.pos[n7][n8] == null) {
                    this.pos[n7][n8] = new NodeRoutable(n7 - 1, n8 - 1);
                }
                this.pos[n7][n8].nSegments = 0;
                ++n8;
            }
            ++n7;
        }
        int n9 = 0;
        while (n9 < this.pos.length) {
            n4 = 0;
            while (n4 < this.pos[n9].length) {
                nodeRoutable = this.pos[n9][n4];
                n3 = 0;
                while (n3 < 8) {
                    nodeRoutable.segments[n3] = null;
                    if (nodeRoutable.neigh[n3] != null) {
                        ++nodeRoutable.nSegments;
                    }
                    n2 = nodeRoutable.x + 1 + NodeRoutable.neighCoor[n3][0];
                    n = nodeRoutable.y + 1 + NodeRoutable.neighCoor[n3][1];
                    boolean bl2 = bl = !(n2 != 0 && n2 != 25 || n != 0 && n != 25);
                    if (n2 >= 0 && n >= 0 && n2 < 26 && n < 26 && !bl) {
                        nodeRoutable.neigh[n3] = this.pos[n2][n];
                        ++nodeRoutable.nSegments;
                    } else {
                        nodeRoutable.neigh[n3] = null;
                    }
                    ++n3;
                }
                ++n4;
            }
            ++n9;
        }
        n4 = 0;
        while (n4 < 6) {
            nodeRoutable = this.SR[n4];
            if (nodeRoutable != null) {
                n3 = 0;
                while (n3 < 8) {
                    n2 = nodeRoutable.x + NodeRoutable.neighCoor[n3][0] + 1;
                    n = nodeRoutable.y + NodeRoutable.neighCoor[n3][1] + 1;
                    boolean bl3 = bl = !(n2 != 0 && n2 != 25 || n != 0 && n != 25);
                    if (n2 >= 0 && n >= 0 && n2 < 26 && n < 26 && !bl) {
                        nodeRoutable.neigh[n3] = this.pos[n2][n];
                        ++nodeRoutable.nSegments;
                        this.pos[n2][n].neigh[NodeRoutable.opposite((int)n3)] = nodeRoutable;
                        ++this.pos[n2][n].nSegments;
                    }
                    ++n3;
                }
            }
            ++n4;
        }
    }

    public void createFloatPositions() {
        int n = 0;
        while (n < this.nodes.size()) {
            Node node = (Node)this.nodes.elementAt(n);
            node.fx = node.x;
            node.fy = node.y;
            ++n;
        }
    }

    public void emtpySegments() {
        int n;
        NodeRoutable nodeRoutable;
        int n2;
        int n3 = 0;
        while (n3 < this.pos.length) {
            n2 = 0;
            while (n2 < this.pos[n3].length) {
                nodeRoutable = this.pos[n3][n2];
                nodeRoutable.nSegments = 0;
                n = 0;
                while (n < 8) {
                    nodeRoutable.segments[n] = null;
                    if (nodeRoutable.neigh[n] != null) {
                        ++nodeRoutable.nSegments;
                    }
                    ++n;
                }
                nodeRoutable.portsUnassigned = 0;
                int n4 = nodeRoutable.ports.length - 1;
                while (n4 >= 0) {
                    nodeRoutable.portsUnassigned <<= 1;
                    if (nodeRoutable.dir[n4] == 1) {
                        nodeRoutable.portsUnassigned |= 1;
                    }
                    --n4;
                }
                ++n2;
            }
            ++n3;
        }
        n2 = 0;
        while (n2 < 6) {
            if (this.SR[n2] != null) {
                nodeRoutable = this.SR[n2];
                nodeRoutable.portsUnassigned = 0;
                n = nodeRoutable.ports.length - 1;
                while (n >= 0) {
                    nodeRoutable.portsUnassigned <<= 1;
                    if (nodeRoutable.dir[n] == 1) {
                        nodeRoutable.portsUnassigned |= 1;
                    }
                    --n;
                }
            }
            ++n2;
        }
    }

    public int repair(boolean bl) {
        Object object;
        int n = 0;
        int n2 = 0;
        while (n2 < this.nodes.size()) {
            Node node = (Node)this.nodes.elementAt(n2);
            int n3 = 0;
            while (n3 < node.width) {
                object = node.ports[n3];
                if (object != null) {
                    ((Net)object).link = object;
                }
                ++n3;
            }
            ++n2;
        }
        int n4 = 0;
        while (n4 < this.nets.size()) {
            Net net = (Net)this.nets.elementAt(n4);
            net.link = null;
            int n5 = 0;
            while (n5 < net.inputs.size()) {
                Node node = (Node)net.inputs.elementAt(n5);
                if (node != null) {
                    node.flag = true;
                }
                ++n5;
            }
            if (net.output != null) {
                net.output.flag = true;
            }
            ++n4;
        }
        int n6 = 0;
        while (n6 < this.nodes.size()) {
            object = (Node)this.nodes.elementAt(n6);
            ((Node)object).flag = false;
            int n7 = 0;
            while (n7 < ((Node)object).width) {
                if (!(((Node)object).ports[n7] instanceof NetGlobal) && (((Node)object).ports[n7] == null || ((Node)object).ports[n7] != null && ((Node)object).ports[n7].link != null)) {
                    if (((Node)object).dir[n7] == 2) {
                        if (((Node)object).ports[n7] != null) {
                            if (bl) {
                                Conf.log.println("Marking " + ((Node)object).name + "'s output port(" + n7 + "+) floating");
                            }
                            ((Node)object).ports[n7] = null;
                        } else {
                            --n;
                        }
                    } else {
                        Net net = new Net();
                        NodePrim nodePrim = new NodePrim(7);
                        net.name = ((Node)object).ports[n7] == null ? (nodePrim.name = String.valueOf(((Node)object).name) + "_fi" + n7) : (nodePrim.name = ((Node)object).ports[n7].name);
                        ((Node)object).ports[n7] = nodePrim.ports[0] = net;
                        net.inputs.addElement(object);
                        net.output = nodePrim;
                        this.nodes.addElement(net.output);
                        this.nets.addElement(net);
                        if (bl) {
                            Conf.log.println("Marking net " + net.name + " floating");
                        }
                    }
                    ++n;
                }
                ++n7;
            }
            ++n6;
        }
        return n;
    }

    public void setRandomPositions(int n, int n2) {
        int n3 = 0;
        while (n3 < this.nodes.size()) {
            Node node = (Node)this.nodes.elementAt(n3);
            node.x = (int)(Math.random() * (double)n);
            node.y = (int)(Math.random() * (double)n2);
            ++n3;
        }
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String string) {
        String string2 = "Graph: " + this.name + " " + string + "\r\n" + "Number of nodes: " + this.nodes.size() + "\r\n" + "\r\n";
        int n = 0;
        while (n < this.nodes.size()) {
            string2 = String.valueOf(string2) + this.nodes.elementAt(n).toString();
            ++n;
        }
        int n2 = 0;
        while (n2 < 7) {
            string2 = String.valueOf(string2) + this.global[n2].toString();
            ++n2;
        }
        string2 = String.valueOf(string2) + "Nets(" + this.nets.size() + "):" + "\r\n" + "\r\n";
        int n3 = 0;
        while (n3 < this.nets.size()) {
            string2 = String.valueOf(string2) + this.nets.elementAt(n3).toString();
            ++n3;
        }
        return string2;
    }

    public void writeBitstream(BitStreamWriter bitStreamWriter, boolean bl) throws IOException {
        int n;
        int n2;
        boolean bl2;
        int n3 = 0;
        while (n3 < 24) {
            if (bl) {
                bl2 = false;
            } else {
                bl2 = true;
                n2 = 0;
                while (n2 < 24) {
                    if (this.pos[n3 + 1][n2 + 1].width > 0) {
                        bl2 = false;
                        break;
                    }
                    n = 0;
                    while (n < 8) {
                        if (this.pos[n3 + 1][n2 + 1].segments[n] != null) {
                            bl2 = false;
                            break;
                        }
                        ++n;
                    }
                    if (!bl2) break;
                    ++n2;
                }
            }
            if (bl2) {
                bitStreamWriter.write(192, 16);
                bitStreamWriter.write(n3, 16);
                bitStreamWriter.write(0, 16);
                bitStreamWriter.write(54, 16);
                n2 = 0;
                while (n2 < 24) {
                    this.pos[n3 + 1][n2 + 1].writeBitstream(bitStreamWriter);
                    ++n2;
                }
            }
            ++n3;
        }
        if (bl) {
            bl2 = false;
        } else {
            bl2 = true;
            n2 = 0;
            while (n2 < 24) {
                if (this.pos[n2 + 1][0].width > 0) {
                    bl2 = false;
                    break;
                }
                n = 0;
                while (n < 8) {
                    if (this.pos[n2 + 1][0].segments[n] != null) {
                        bl2 = false;
                        break;
                    }
                    ++n;
                }
                if (!bl2) break;
                ++n2;
            }
        }
        if (bl2) {
            bitStreamWriter.write(193, 16);
            bitStreamWriter.write(0, 16);
            bitStreamWriter.write(0, 16);
            bitStreamWriter.write(25, 16);
            n2 = 0;
            while (n2 < 24) {
                this.pos[n2 + 1][0].writeBitstream(bitStreamWriter);
                ++n2;
            }
            bitStreamWriter.write(0, 8);
        }
        if (bl) {
            bl2 = false;
        } else {
            bl2 = true;
            n2 = 0;
            while (n2 < 24) {
                if (this.pos[n2 + 1][25].width > 0) {
                    bl2 = false;
                    break;
                }
                n = 0;
                while (n < 8) {
                    if (this.pos[n2 + 1][25].segments[n] != null) {
                        bl2 = false;
                        break;
                    }
                    ++n;
                }
                if (!bl2) break;
                ++n2;
            }
        }
        if (bl2) {
            bitStreamWriter.write(193, 16);
            bitStreamWriter.write(1, 16);
            bitStreamWriter.write(0, 16);
            bitStreamWriter.write(25, 16);
            n2 = 0;
            while (n2 < 24) {
                this.pos[n2 + 1][25].writeBitstream(bitStreamWriter);
                ++n2;
            }
            bitStreamWriter.write(0, 8);
        }
        if (bl) {
            bl2 = false;
        } else {
            bl2 = true;
            n2 = 0;
            while (n2 < 24) {
                if (this.pos[0][n2 + 1].width > 0) {
                    bl2 = false;
                    break;
                }
                n = 0;
                while (n < 8) {
                    if (this.pos[0][n2 + 1].segments[n] != null) {
                        bl2 = false;
                        break;
                    }
                    ++n;
                }
                if (!bl2) break;
                ++n2;
            }
        }
        if (bl2) {
            bitStreamWriter.write(193, 16);
            bitStreamWriter.write(2, 16);
            bitStreamWriter.write(0, 16);
            bitStreamWriter.write(25, 16);
            n2 = 0;
            while (n2 < 24) {
                this.pos[0][n2 + 1].writeBitstream(bitStreamWriter);
                ++n2;
            }
            bitStreamWriter.write(0, 8);
        }
        if (bl) {
            bl2 = false;
        } else {
            bl2 = true;
            n2 = 0;
            while (n2 < 24) {
                if (this.pos[25][n2 + 1].width > 0) {
                    bl2 = false;
                    break;
                }
                n = 0;
                while (n < 8) {
                    if (this.pos[25][n2 + 1].segments[n] != null) {
                        bl2 = false;
                        break;
                    }
                    ++n;
                }
                if (!bl2) break;
                ++n2;
            }
        }
        if (bl2) {
            bitStreamWriter.write(193, 16);
            bitStreamWriter.write(3, 16);
            bitStreamWriter.write(0, 16);
            bitStreamWriter.write(25, 16);
            n2 = 0;
            while (n2 < 24) {
                this.pos[25][n2 + 1].writeBitstream(bitStreamWriter);
                ++n2;
            }
            bitStreamWriter.write(0, 8);
        }
    }
}

