/*
 * Decompiled with CFR 0.152.
 */
package org.opencores.routing;

import java.util.Arrays;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.opencores.Conf;
import org.opencores.routing.Segment;
import org.opencores.structure.Graph;
import org.opencores.structure.Net;
import org.opencores.structure.Node;
import org.opencores.structure.NodeRoutable;
import org.opencores.util.Heap;

public class Wavefront {
    public static final int NUM_ITERATIONS = 45;
    public static final float COST_MODIFIER = 1.2f;
    private Graph g;
    private Vector tree;
    public Vector unroutedNets;
    public int[] statLenCnt = new int[120];
    public int[] statWireCnt = new int[120];
    public int[] statHopCnt = new int[120];

    public Wavefront(Graph graph) {
        this.g = graph;
        int n = 0;
        while (n < 120) {
            this.statHopCnt[n] = 0;
            this.statWireCnt[n] = 0;
            this.statLenCnt[n] = 0;
            ++n;
        }
    }

    void findWayBack(Segment segment, Heap heap) {
        Segment segment2 = segment;
        while (segment.c.cost != 0.0f) {
            this.tree.add(segment);
            segment.c.cost = 0.0f;
            Segment segment3 = segment.prev;
            if (segment3 != null) {
                if (segment3.c.segments[segment.s] != null) {
                    throw new Error("Segment should be free!");
                }
                int n = Math.abs(segment.c.x - segment3.c.x + segment.c.y - segment3.c.y);
                this.statLenCnt[n] = this.statLenCnt[n] + 1;
            }
            try {
                heap.remove(segment);
            }
            catch (NoSuchElementException noSuchElementException) {}
            heap.add(segment);
            segment = segment3;
        }
        heap.repair();
        int n = Math.abs(segment2.c.x - segment.c.x) + Math.abs(segment2.c.y - segment.c.y);
        if (n >= this.statWireCnt.length) {
            n = this.statWireCnt.length - 1;
        }
        int n2 = n;
        this.statWireCnt[n2] = this.statWireCnt[n2] + 1;
    }

    public int minFreeSegment() {
        int n = 8;
        int n2 = 0;
        while (n2 < this.g.pos.length) {
            int n3 = 0;
            while (n3 < this.g.pos[n2].length) {
                if (n > this.g.pos[n2][n3].nSegments) {
                    n = this.g.pos[n2][n3].nSegments;
                }
                ++n3;
            }
            ++n2;
        }
        return n;
    }

    public boolean route() {
        Net[] netArray;
        int n = 0;
        while (n < this.g.nodes.size()) {
            netArray = (Node)this.g.nodes.elementAt(n);
            netArray.temp = 0;
            ++n;
        }
        netArray = new Net[this.g.nets.size()];
        int n2 = 0;
        while (n2 < this.g.nets.size()) {
            Net net = (Net)this.g.nets.elementAt(n2);
            net.cost = 1.0f;
            netArray[n2] = net;
            ++n2;
        }
        int n3 = 0;
        while (n3 < 45) {
            Arrays.sort(netArray, new Comparator(){

                public int compare(Object object, Object object2) {
                    Net net = (Net)object;
                    Net net2 = (Net)object2;
                    if (net.cost < net2.cost) {
                        return 1;
                    }
                    if (net.cost > net2.cost) {
                        return -1;
                    }
                    return 0;
                }

                public boolean equals(Object object) {
                    throw new Error();
                }
            });
            this.spread(netArray);
            if (this.unroutedNets.size() == 0) {
                return true;
            }
            int n4 = 0;
            while (n4 < this.unroutedNets.size()) {
                Net net = (Net)this.unroutedNets.elementAt(n4);
                net.cost *= 1.2f;
                Conf.log.print(String.valueOf(net.name) + " ");
                ++n4;
            }
            Conf.log.println(String.valueOf(n3) + ": " + this.unroutedNets.size());
            System.out.print(String.valueOf(n3) + ": " + this.unroutedNets.size() + "   ");
            ++n3;
        }
        Conf.log.println();
        System.out.println();
        return false;
    }

    public boolean spread(Net net) {
        if (net.output == null) {
            throw new Error("Errorneous net " + net.name + "!");
        }
        NodeRoutable nodeRoutable = (NodeRoutable)net.output;
        Heap heap = new Heap();
        this.tree = new Vector(1);
        Segment segment = new Segment(nodeRoutable, -1, null);
        heap.add(segment);
        this.g.clearNodes();
        segment.c.cost = 0.0f;
        if (Conf.debug) {
            Conf.log.println("O:" + net.output.name + "(" + net.output.x + "," + net.output.y + ")");
        }
        int n = 0;
        while (n < net.inputs.size()) {
            Node node = (Node)net.inputs.elementAt(n);
            ++node.temp;
            if (Conf.debug) {
                Conf.log.print(String.valueOf(node.name) + "(" + node.x + "," + node.y + ") ");
            }
            ++n;
        }
        if (Conf.debug) {
            Conf.log.println();
        }
        int n2 = net.inputs.size();
        while (n2 > 0) {
            if (heap.isEmpty()) break;
            Segment segment2 = (Segment)heap.remove();
            if (Conf.debug) {
                if (segment2.prev != null) {
                    Conf.log.print(String.valueOf(segment2.prev.c.name) + "[" + segment2.prev.c.x + "," + segment2.prev.c.y + "]-");
                }
                Conf.log.print(String.valueOf(segment2.c.name) + "[" + segment2.c.x + "," + segment2.c.y + "] ");
            }
            int n3 = 0;
            while (n3 < segment2.c.neigh.length) {
                if (segment2.c.segments[n3] == null) {
                    NodeRoutable nodeRoutable2;
                    if (Conf.debug) {
                        Conf.log.print(n3);
                    }
                    if ((nodeRoutable2 = segment2.c.neigh[n3]) != null) {
                        int n4;
                        if (Conf.debug) {
                            Conf.log.print("!");
                        }
                        float f = segment2.c.cost + segment2.c.calcCost(n3);
                        if (nodeRoutable2.temp > 0) {
                            boolean bl = false;
                            n4 = 0;
                            while (n4 < nodeRoutable2.ports.length) {
                                if (nodeRoutable2.dir[n4] == 1 && nodeRoutable2.ports[n4] == net && (nodeRoutable2.portsUnassigned >> n4 & 1) == 1 && nodeRoutable2.isConnectable(n4, NodeRoutable.opposite(n3))) {
                                    nodeRoutable2.portsUnassigned ^= 1 >> n4;
                                    --nodeRoutable2.temp;
                                    --n2;
                                    bl = true;
                                    int n5 = (int)f;
                                    if (n5 >= this.statHopCnt.length) {
                                        n5 = this.statHopCnt.length - 1;
                                    }
                                    int n6 = n5;
                                    this.statHopCnt[n6] = this.statHopCnt[n6] + 1;
                                }
                                ++n4;
                            }
                            if (bl) {
                                this.findWayBack(new Segment(nodeRoutable2, n3, segment2), heap);
                            }
                        } else if (f < nodeRoutable2.cost) {
                            if (nodeRoutable2.cost != Float.MAX_VALUE) {
                                Segment segment3 = null;
                                n4 = 0;
                                while (n4 < heap.size()) {
                                    Segment segment4 = (Segment)heap.elementAt(n4);
                                    if (segment4.c == nodeRoutable2) {
                                        segment3 = segment4;
                                        break;
                                    }
                                    ++n4;
                                }
                                if (segment3 != null) {
                                    heap.remove(segment3);
                                    nodeRoutable2.cost = f;
                                    segment3.prev = segment2;
                                    segment3.s = n3;
                                    heap.add(segment3);
                                } else {
                                    nodeRoutable2.cost = f;
                                    heap.add(new Segment(nodeRoutable2, n3, segment2));
                                }
                            } else {
                                nodeRoutable2.cost = f;
                                heap.add(new Segment(nodeRoutable2, n3, segment2));
                            }
                        }
                    }
                }
                ++n3;
            }
            if (!Conf.debug) continue;
            Conf.log.println(" >" + segment2.c.cost);
        }
        if (Conf.debug) {
            Conf.log.println();
        }
        return n2 == 0;
    }

    public void spread(Net[] netArray) {
        this.g.emtpySegments();
        this.unroutedNets = new Vector();
        int n = 0;
        while (n < netArray.length) {
            Net net = netArray[n];
            if (Conf.debug) {
                Conf.log.println("Routing " + net.name + " ");
            }
            if (this.spread(net)) {
                int n2 = 0;
                while (n2 < this.tree.size()) {
                    Segment segment = (Segment)this.tree.elementAt(n2);
                    if (segment.prev != null) {
                        if (segment.prev.c.segments[segment.s] != null) {
                            throw new Error("Segment should be free!");
                        }
                        segment.prev.c.segments[segment.s] = net;
                        --segment.prev.c.nSegments;
                        if (segment.prev.c.nSegments < 0) {
                            throw new Error("Invalid count.");
                        }
                    }
                    if (Conf.debug) {
                        Conf.log.print("(" + segment.c.x + "," + segment.c.y + ") ");
                    }
                    ++n2;
                }
                if (Conf.debug) {
                    Conf.log.println();
                }
                if (Conf.debug) {
                    Conf.log.println("OK");
                }
            } else {
                if (Conf.debug) {
                    Conf.log.println("FAILED");
                }
                this.unroutedNets.add(net);
            }
            ++n;
        }
    }
}

