/*
 * Decompiled with CFR 0.152.
 */
package org.opencores.placement;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Vector;
import org.opencores.structure.Graph;
import org.opencores.structure.Net;
import org.opencores.structure.Node;
import org.opencores.structure.NodeGPC;
import org.opencores.structure.NodeIOC;

public class RxRPlacement {
    private static final float MIN_DIST = 0.2f;
    private static final float INIT_TEMP = 0.5f;
    private static final float FINAL_TEMP = 0.01f;
    private static final float INIT_FORCE = 0.01f;
    private static final float FINAL_FORCE = 0.05f;
    private static final float DONE_FACTOR = 1.1f;
    private static final int NUM_STEPS = 50;
    private Graph g;
    public float temperature = 0.5f;
    public float force = 0.01f;
    public float energy;
    private float prevEnergy;
    public int curStep = 50;
    public boolean done = false;
    public int nGPC = 0;
    public int nIOC = 0;
    public int nInputs = 0;
    public Vector vnl = new Vector();
    private int[] pos = new int[576];

    public RxRPlacement(Graph graph) {
        this.g = graph;
        graph.setRandomPositions(24, 24);
        graph.createFloatPositions();
    }

    public void approach(float f) {
        int n = 0;
        while (n < this.g.nodes.size()) {
            Node node = (Node)this.g.nodes.elementAt(n);
            this.energy = 0.0f;
            int n2 = 0;
            while (n2 < node.width) {
                Net net = node.ports[n2];
                if (net != null) {
                    int n3 = 0;
                    while (n3 < net.inputs.size()) {
                        Node node2 = (Node)net.inputs.elementAt(n3);
                        this.energy += (Math.abs(node2.fx - node.fx) + Math.abs(node2.fy - node.fy)) * node.weight[n2];
                        node2.fx -= (node2.fx - node.fx) * node.weight[n2] * f;
                        node2.fy -= (node2.fy - node.fy) * node.weight[n2] * f;
                        ++n3;
                    }
                }
                ++n2;
            }
            ++n;
        }
    }

    public void distance(float f) {
        int n = 0;
        while (n < this.g.nodes.size()) {
            Node node = (Node)this.g.nodes.elementAt(n);
            float f2 = 0.0f;
            float f3 = 0.0f;
            int n2 = 0;
            while (n2 < this.g.nodes.size()) {
                if (n != n2) {
                    Node node2 = (Node)this.g.nodes.elementAt(n2);
                    float f4 = (node2.fx - node.fx) * Math.abs(node2.fx - node.fx);
                    float f5 = (node2.fy - node.fy) * Math.abs(node2.fy - node.fy);
                    if (f4 >= 0.0f) {
                        if (f4 < 0.2f) {
                            f4 = 0.2f;
                        }
                    } else if (f4 > -0.2f) {
                        f4 = -0.2f;
                    }
                    if (f5 >= 0.0f) {
                        if (f5 < 0.2f) {
                            f5 = 0.2f;
                        }
                    } else if (f5 > -0.2f) {
                        f5 = -0.2f;
                    }
                    f2 += f / f4;
                    f3 += f / f5;
                }
                ++n2;
            }
            node.nfx = node.fx - f2;
            node.nfy = node.fy - f3;
            ++n;
        }
        int n3 = 0;
        while (n3 < this.g.nodes.size()) {
            Node node = (Node)this.g.nodes.elementAt(n3);
            node.fx = node.nfx;
            node.fy = node.nfy;
            ++n3;
        }
    }

    public void doStep() {
        this.prevEnergy = this.energy;
        this.approach(this.temperature);
        this.distance(this.force);
        this.zoom();
        if (this.energy * 1.1f > this.prevEnergy || this.energy < 1.0f) {
            if (this.curStep > 0) {
                --this.curStep;
                this.temperature = 0.49f * ((float)this.curStep / 50.0f) + 0.01f;
                this.force = -0.04f * ((float)this.curStep / 50.0f) + 0.05f;
            } else {
                this.done = true;
            }
        }
    }

    private float portDist(float f, float f2, int n) {
        int n2;
        int n3;
        if (n < 48) {
            if (n >= 24) {
                n3 = n - 24;
                n2 = 24;
            } else {
                n3 = n;
                n2 = -1;
            }
        } else if ((n -= 48) >= 24) {
            n2 = n - 24;
            n3 = 24;
        } else {
            n2 = n;
            n3 = -1;
        }
        return Math.abs((float)n3 - f) + Math.abs((float)n2 - f2);
    }

    public void prePlacement() {
        this.prePlacementGPC();
        this.prePlacementIOC();
    }

    public void prePlacementGPC() {
        int n;
        int n2 = 0;
        this.nInputs = 0;
        int n3 = 0;
        while (n3 < this.g.nodes.size()) {
            Node node = (Node)this.g.nodes.elementAt(n3);
            if (node instanceof NodeGPC) {
                this.nInputs += ((NodeGPC)node).a.width - 1;
                int n4 = Math.round(node.fx);
                n = Math.round(node.fy);
                if (n4 < 0) {
                    n4 = 0;
                }
                if (n < 0) {
                    n = 0;
                }
                if (n4 >= 24) {
                    n4 = 23;
                }
                if (n >= 24) {
                    n = 23;
                }
                int n5 = ((NodeGPC)node).idx = NodeGPC.indexOf(n4, n);
                this.pos[n5] = this.pos[n5] + 1;
                ++n2;
                this.vnl.addElement(node);
            }
            ++n3;
        }
        this.nGPC = n2;
        if (n2 > 576) {
            throw new Error("Number of GPCs too large for this architecture.");
        }
        int n6 = 0;
        while (n6 < this.vnl.size()) {
            NodeGPC nodeGPC = (NodeGPC)this.vnl.elementAt(n6);
            if (this.pos[nodeGPC.idx] > 1) {
                n = 0;
                int n7 = -1;
                while (n7 < 0) {
                    if (nodeGPC.idx - ++n > 0 && this.pos[nodeGPC.idx - n] == 0) {
                        n7 = nodeGPC.idx - n;
                        break;
                    }
                    if (nodeGPC.idx + n >= this.pos.length || this.pos[nodeGPC.idx + n] != 0) continue;
                    n7 = nodeGPC.idx + n;
                    break;
                }
                int n8 = nodeGPC.idx;
                this.pos[n8] = this.pos[n8] - 1;
                int n9 = nodeGPC.idx = n7;
                this.pos[n9] = this.pos[n9] + 1;
            }
            nodeGPC.x = nodeGPC.posX();
            nodeGPC.y = nodeGPC.posY();
            ++n6;
        }
    }

    public void prePlacementIOC() {
        Object[] objectArray;
        int n = 0;
        int[] nArray = new int[96];
        Vector<Object[]> vector = new Vector<Object[]>();
        int n2 = 0;
        while (n2 < this.g.nodes.size()) {
            objectArray = (Object[])this.g.nodes.elementAt(n2);
            if (objectArray instanceof NodeIOC) {
                ++n;
                vector.addElement(objectArray);
                objectArray.nfy = objectArray.weight[0];
            }
            ++n2;
        }
        this.nIOC = n;
        if (n > 96) {
            throw new Error("Number of ports too large for this architecture.");
        }
        objectArray = vector.toArray();
        Arrays.sort(objectArray, new Comparator(){

            public int compare(Object object, Object object2) {
                NodeIOC nodeIOC = (NodeIOC)object;
                NodeIOC nodeIOC2 = (NodeIOC)object2;
                if (nodeIOC.nfy < nodeIOC2.nfy) {
                    return 1;
                }
                if (nodeIOC.nfy > nodeIOC2.nfy) {
                    return -1;
                }
                return 0;
            }

            public boolean equals(Object object) {
                throw new Error();
            }
        });
        int n3 = 0;
        while (n3 < nArray.length) {
            nArray[n3] = 0;
            ++n3;
        }
        int n4 = 0;
        while (n4 < objectArray.length) {
            int n5 = 0;
            float f = Float.MAX_VALUE;
            int n6 = 0;
            while (n6 < nArray.length) {
                float f2;
                if (nArray[n6] == 0 && (f2 = this.portDist(((NodeIOC)objectArray[n4]).fx, ((NodeIOC)objectArray[n4]).fy, n6)) < f) {
                    f = f2;
                    n5 = n6;
                }
                ++n6;
            }
            int n7 = n5;
            nArray[n7] = nArray[n7] + 1;
            ((NodeIOC)objectArray[n4]).idx = n5;
            ((NodeIOC)objectArray[n4]).x = ((NodeIOC)objectArray[n4]).posX();
            ((NodeIOC)objectArray[n4]).y = ((NodeIOC)objectArray[n4]).posY();
            ++n4;
        }
    }

    public void setGraph(Graph graph) {
        this.g = graph;
    }

    public void zoom() {
        float f;
        float f2;
        if (this.g.nodes.size() == 0) {
            return;
        }
        float f3 = f2 = ((Node)this.g.nodes.elementAt((int)0)).fx;
        float f4 = f = ((Node)this.g.nodes.elementAt((int)0)).fy;
        int n = 1;
        while (n < this.g.nodes.size()) {
            Node node = (Node)this.g.nodes.elementAt(n);
            if (node.fx > f2) {
                f2 = node.fx;
            }
            if (node.fy > f) {
                f = node.fy;
            }
            if (node.fx < f3) {
                f3 = node.fx;
            }
            if (node.fy < f4) {
                f4 = node.fy;
            }
            ++n;
        }
        float f5 = 24.0f / (f2 - f3);
        float f6 = 24.0f / (f - f4);
        int n2 = 1;
        while (n2 < this.g.nodes.size()) {
            Node node = (Node)this.g.nodes.elementAt(n2);
            node.fx = (node.fx - f3) * f5;
            node.fy = (node.fy - f4) * f6;
            ++n2;
        }
    }
}

