/*
 * Decompiled with CFR 0.152.
 */
package org.opencores.placement;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Vector;
import org.opencores.structure.Graph;
import org.opencores.structure.Node;
import org.opencores.structure.NodeGPC;
import org.opencores.structure.NodeIOC;

public class PrePlacement {
    private Graph g;
    public int nGPC = 0;
    public int nIOC = 0;
    public int nInputs = 0;
    public Vector vnl = new Vector();
    private int[] pos = new int[576];

    public PrePlacement(Graph graph) {
        this.g = graph;
    }

    private float portDist(float f, float f2, int n) {
        int n2;
        int n3;
        if (n < 48) {
            if (n >= 24) {
                n3 = n - 24;
                n2 = 24;
            } else {
                n3 = n;
                n2 = -1;
            }
        } else if ((n -= 48) >= 24) {
            n2 = n - 24;
            n3 = 24;
        } else {
            n2 = n;
            n3 = -1;
        }
        return Math.abs((float)n3 - f) + Math.abs((float)n2 - f2);
    }

    public void prePlacement() {
        this.prePlacementGPC();
        this.prePlacementIOC();
    }

    public void prePlacementGPC() {
        int n;
        int n2 = 0;
        this.nInputs = 0;
        int n3 = 0;
        while (n3 < this.g.nodes.size()) {
            Node node = (Node)this.g.nodes.elementAt(n3);
            if (node instanceof NodeGPC) {
                this.nInputs += ((NodeGPC)node).a.width - 1;
                int n4 = Math.round(node.fx);
                n = Math.round(node.fy);
                if (n4 < 0) {
                    n4 = 0;
                }
                if (n < 0) {
                    n = 0;
                }
                if (n4 >= 24) {
                    n4 = 23;
                }
                if (n >= 24) {
                    n = 23;
                }
                int n5 = ((NodeGPC)node).idx = NodeGPC.indexOf(n4, n);
                this.pos[n5] = this.pos[n5] + 1;
                ++n2;
                this.vnl.addElement(node);
            }
            ++n3;
        }
        this.nGPC = n2;
        if (n2 > 576) {
            throw new Error("Number of GPCs too large for this architecture.");
        }
        int n6 = 0;
        while (n6 < this.vnl.size()) {
            NodeGPC nodeGPC = (NodeGPC)this.vnl.elementAt(n6);
            if (this.pos[nodeGPC.idx] > 1) {
                n = 0;
                int n7 = -1;
                while (n7 < 0) {
                    if (nodeGPC.idx - ++n > 0 && this.pos[nodeGPC.idx - n] == 0) {
                        n7 = nodeGPC.idx - n;
                        break;
                    }
                    if (nodeGPC.idx + n >= this.pos.length || this.pos[nodeGPC.idx + n] != 0) continue;
                    n7 = nodeGPC.idx + n;
                    break;
                }
                int n8 = nodeGPC.idx;
                this.pos[n8] = this.pos[n8] - 1;
                int n9 = nodeGPC.idx = n7;
                this.pos[n9] = this.pos[n9] + 1;
            }
            nodeGPC.x = nodeGPC.posX();
            nodeGPC.y = nodeGPC.posY();
            ++n6;
        }
    }

    public void prePlacementIOC() {
        Object[] objectArray;
        int n = 0;
        int[] nArray = new int[96];
        Vector<Object[]> vector = new Vector<Object[]>();
        int n2 = 0;
        while (n2 < this.g.nodes.size()) {
            objectArray = (Object[])this.g.nodes.elementAt(n2);
            if (objectArray instanceof NodeIOC) {
                ++n;
                vector.addElement(objectArray);
                objectArray.nfy = objectArray.weight[0];
            }
            ++n2;
        }
        this.nIOC = n;
        if (n > 96) {
            throw new Error("Number of ports too large for this architecture.");
        }
        objectArray = vector.toArray();
        Arrays.sort(objectArray, new Comparator(){

            public int compare(Object object, Object object2) {
                NodeIOC nodeIOC = (NodeIOC)object;
                NodeIOC nodeIOC2 = (NodeIOC)object2;
                if (nodeIOC.nfy < nodeIOC2.nfy) {
                    return 1;
                }
                if (nodeIOC.nfy > nodeIOC2.nfy) {
                    return -1;
                }
                return 0;
            }

            public boolean equals(Object object) {
                throw new Error();
            }
        });
        int n3 = 0;
        while (n3 < nArray.length) {
            nArray[n3] = 0;
            ++n3;
        }
        int n4 = 0;
        while (n4 < objectArray.length) {
            int n5 = 0;
            float f = Float.MAX_VALUE;
            int n6 = 0;
            while (n6 < nArray.length) {
                float f2;
                if (nArray[n6] == 0 && (f2 = this.portDist(((NodeIOC)objectArray[n4]).fx, ((NodeIOC)objectArray[n4]).fy, n6)) < f) {
                    f = f2;
                    n5 = n6;
                }
                ++n6;
            }
            int n7 = n5;
            nArray[n7] = nArray[n7] + 1;
            ((NodeIOC)objectArray[n4]).idx = n5;
            ((NodeIOC)objectArray[n4]).x = ((NodeIOC)objectArray[n4]).posX();
            ((NodeIOC)objectArray[n4]).y = ((NodeIOC)objectArray[n4]).posY();
            ++n4;
        }
    }

    public void setGraph(Graph graph) {
        this.g = graph;
    }
}

