/*
 * Decompiled with CFR 0.152.
 */
package org.opencores.placement;

import org.opencores.Conf;
import org.opencores.structure.Graph;
import org.opencores.structure.IndexedNode;
import org.opencores.structure.Net;
import org.opencores.structure.NetGlobal;
import org.opencores.structure.Node;
import org.opencores.structure.NodeGPC;
import org.opencores.structure.NodeIOC;
import org.opencores.structure.NodeRoutable;

public class Annealing {
    private static final int INNER_NUM_K = 10;
    private static final int INITIAL_TEMP_K = 1;
    private int INNER_NUM;
    private static final double DONE_CONSTANT = 0.001;
    private Graph g;
    private NodeGPC[] posGPC = new NodeGPC[576];
    private NodeIOC[] posIOC = new NodeIOC[96];
    private double temp;
    private int wiringCost;
    private int tempMoves = 0;
    private int tempAccepted = 0;
    private int tempWiringChange = 0;
    private final double[][] alpha = new double[][]{{0.15, 0.8}, {0.8, 0.95}, {0.96, 0.9}, {1.0, 0.5}};
    private float[] costs = null;
    private int[][] distance;

    public Annealing(Graph graph) {
        this.g = graph;
        this.buildDist();
        this.reset();
    }

    private int MST(Net net) {
        Node[] nodeArray;
        int n = net.inputs.size();
        if (net.output != null) {
            if (net.inputs.size() == 1) {
                Node node = (Node)net.inputs.firstElement();
                return this.dist(net.output.x - node.x, net.output.y - node.y);
            }
            nodeArray = new Node[++n];
            nodeArray[n - 1] = net.output;
        } else {
            nodeArray = new Node[n];
        }
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < net.inputs.size()) {
            nodeArray[n2] = (Node)net.inputs.elementAt(n2);
            ++n2;
        }
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            nArray[n4] = Integer.MAX_VALUE;
            ++n4;
        }
        n3 = 0;
        nArray[n3] = 0;
        int n5 = 0;
        int n6 = 0;
        while (n6 < n) {
            int n7 = Integer.MAX_VALUE;
            int n8 = 0;
            int n9 = nodeArray[n3].x;
            int n10 = nodeArray[n3].y;
            nodeArray[n3] = null;
            int n11 = 1;
            while (n11 < n) {
                if (nodeArray[n11] != null) {
                    nArray[n11] = Math.min(nArray[n11], this.dist(n9 - nodeArray[n11].x, n10 - nodeArray[n11].y));
                    if (n7 > nArray[n11]) {
                        n7 = nArray[n11];
                        n8 = n11;
                    }
                }
                ++n11;
            }
            n5 += nArray[n3];
            n3 = n8;
            ++n6;
        }
        return n5;
    }

    private final boolean allowMove(float f) {
        if (f < 0.0f) {
            return true;
        }
        return Math.random() <= Math.exp((double)(-f) / this.temp);
    }

    public void anneal() {
        while (!this.stopCriteria()) {
            Node node = (Node)this.g.nodes.elementAt((int)(Math.random() * (double)this.g.nodes.size()));
            if (node instanceof NodeGPC) {
                this.move((NodeGPC)node);
            } else {
                this.move((NodeIOC)node);
            }
            ++this.tempMoves;
        }
    }

    private final void buildDist() {
        this.distance = new int[27][];
        int n = 0;
        while (n < this.distance.length) {
            this.distance[n] = new int[27];
            int n2 = 0;
            while (n2 < this.distance[n].length) {
                int n3 = 0;
                int n4 = n;
                int n5 = n2;
                while (Annealing.manhattan(n4, n5) > 0) {
                    int n6 = -1;
                    int n7 = Integer.MAX_VALUE;
                    int n8 = 0;
                    while (n8 < 8) {
                        int n9 = Math.abs(n4 - NodeRoutable.neighCoor[n8][0]) + Math.abs(n5 - NodeRoutable.neighCoor[n8][1]);
                        if (n9 < n7) {
                            n7 = n9;
                            n6 = n8;
                        }
                        ++n8;
                    }
                    n4 -= NodeRoutable.neighCoor[n6][0];
                    n5 -= NodeRoutable.neighCoor[n6][1];
                    ++n3;
                }
                this.distance[n][n2] = n3;
                ++n2;
            }
            ++n;
        }
    }

    private int calcTotalWiringCost() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.g.nets.size()) {
            Net net = (Net)this.g.nets.elementAt(n2);
            if (net != null && !(net instanceof NetGlobal)) {
                net.cost = this.MST(net);
                n = (int)((float)n + net.cost);
            }
            ++n2;
        }
        return n;
    }

    private float checkWiringCost() {
        float f = 0.0f;
        float f2 = 0.0f;
        int n = 0;
        while (n < this.g.nets.size()) {
            Net net = (Net)this.g.nets.elementAt(n);
            if (net != null && !(net instanceof NetGlobal)) {
                float f3 = net.cost;
                f += f3;
                float f4 = this.MST(net);
                f2 += f4;
                if (f3 != f4) {
                    Conf.log.println("!!! " + net.name + "(" + f3 + ',' + f4 + ")");
                }
            }
            ++n;
        }
        return f - f2;
    }

    private final int dist(int n, int n2) {
        return this.distance[Math.abs(n)][Math.abs(n2)];
    }

    public final boolean doneCriteria() {
        return this.tempWiringChange >= 0 && (this.temp < 0.001 * (double)this.tempWiringChange / (double)this.g.nets.size() || this.tempWiringChange == 0);
    }

    public double getTemp() {
        return this.temp;
    }

    public int getWiringCost() {
        return this.wiringCost;
    }

    private static final int manhattan(int n, int n2) {
        return Math.abs(n) + Math.abs(n2);
    }

    private boolean move(IndexedNode indexedNode, IndexedNode indexedNode2, int n, int n2, int n3) {
        if (indexedNode2 != null) {
            return false;
        }
        int n4 = indexedNode.x;
        int n5 = indexedNode.y;
        float f = this.moveCost(indexedNode, n, n2);
        float[] fArray = this.costs;
        if (indexedNode2 != null) {
            f += this.moveCost(indexedNode2, n4, n5);
        }
        if (this.allowMove(f)) {
            if (indexedNode2 != null) {
                indexedNode2.idx = indexedNode.idx;
            }
            indexedNode.idx = n3;
            ++this.tempAccepted;
            this.tempWiringChange = (int)((float)this.tempWiringChange + f);
            return true;
        }
        if (indexedNode2 != null) {
            this.takeBackMove(indexedNode2);
            indexedNode2.x = n;
            indexedNode2.y = n2;
        }
        this.costs = fArray;
        this.takeBackMove(indexedNode);
        indexedNode.x = n4;
        indexedNode.y = n5;
        return false;
    }

    private void move(NodeGPC nodeGPC) {
        int n;
        int n2;
        int n3 = (int)(Math.random() * 576.0);
        NodeGPC nodeGPC2 = this.posGPC[n3];
        if (nodeGPC2 != null) {
            n2 = nodeGPC2.x;
            n = nodeGPC2.y;
        } else {
            n2 = NodeGPC.posX(n3);
            n = NodeGPC.posY(n3);
        }
        int n4 = nodeGPC.idx;
        if (this.move(nodeGPC, nodeGPC2, n2, n, n3)) {
            this.posGPC[n4] = nodeGPC2;
            this.posGPC[n3] = nodeGPC;
        }
    }

    private void move(NodeIOC nodeIOC) {
        int n;
        int n2;
        int n3 = (int)(Math.random() * 96.0);
        NodeIOC nodeIOC2 = this.posIOC[n3];
        if (nodeIOC2 != null) {
            n2 = nodeIOC2.x;
            n = nodeIOC2.y;
        } else {
            n2 = NodeIOC.posX(n3);
            n = NodeIOC.posY(n3);
        }
        int n4 = nodeIOC.idx;
        if (this.move(nodeIOC, nodeIOC2, n2, n, n3)) {
            this.posIOC[n4] = nodeIOC2;
            this.posIOC[n3] = nodeIOC;
        }
    }

    private final float moveCost(Node node, int n, int n2) {
        Object object;
        float f = 0.0f;
        float f2 = 0.0f;
        this.costs = new float[node.width];
        node.x = n;
        node.y = n2;
        int n3 = 0;
        while (n3 < node.width) {
            object = node.ports[n3];
            if (object != null && !(object instanceof NetGlobal)) {
                object.link = object;
            }
            ++n3;
        }
        object = new boolean[node.width];
        int n4 = 0;
        while (n4 < node.width) {
            Net net = node.ports[n4];
            if (net != null && !(net instanceof NetGlobal)) {
                this.costs[n4] = net.cost;
                object[n4] = false;
                if (net.link != null) {
                    net.link = null;
                    object[n4] = true;
                    f2 += net.cost;
                }
            }
            ++n4;
        }
        int n5 = 0;
        while (n5 < node.width) {
            Net net = node.ports[n5];
            if (net != null && !(net instanceof NetGlobal) && object[n5]) {
                net.cost = this.MST(net);
                f += net.cost;
            }
            ++n5;
        }
        return f - f2;
    }

    public void reset() {
        int n = 0;
        while (n < 576) {
            this.posGPC[n] = null;
            ++n;
        }
        int n2 = 0;
        while (n2 < 96) {
            this.posIOC[n2] = null;
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.g.nodes.size()) {
            int n4;
            Node node = (Node)this.g.nodes.elementAt(n3);
            if (node instanceof NodeGPC) {
                n4 = ((NodeGPC)node).idx;
                if (this.posGPC[n4] != null) {
                    throw new Error("GPC pos not unique");
                }
                this.posGPC[n4] = (NodeGPC)node;
            } else {
                n4 = ((NodeIOC)node).idx;
                if (this.posIOC[n4] != null) {
                    throw new Error("Port pos not unique");
                }
                this.posIOC[n4] = (NodeIOC)node;
            }
            ++n3;
        }
        this.wiringCost = this.calcTotalWiringCost();
        this.INNER_NUM = (int)(10.0 * Math.pow(this.g.nodes.size(), 1.3333333333333333));
        this.setTemp(this.stdDev());
    }

    public void setTemp(double d) {
        this.wiringCost += this.tempWiringChange;
        this.tempWiringChange = 0;
        this.tempAccepted = 0;
        this.tempMoves = 0;
        this.temp = d;
    }

    private double stdDev() {
        double d = 0.0;
        int n = 0;
        while (n < this.g.nodes.size()) {
            Node node = (Node)this.g.nodes.elementAt(n);
            int n2 = node.x;
            int n3 = node.y;
            int n4 = (int)(Math.random() * 24.0);
            int n5 = (int)(Math.random() * 24.0);
            double d2 = this.moveCost(node, n4, n5);
            this.takeBackMove(node);
            node.x = n2;
            node.y = n3;
            d += d2 * d2;
            ++n;
        }
        Conf.log.println();
        return d / (double)this.g.nodes.size();
    }

    private final boolean stopCriteria() {
        return this.tempMoves > this.INNER_NUM;
    }

    private void takeBackMove(Node node) {
        if (this.costs.length != node.width) {
            throw new Error();
        }
        int n = 0;
        while (n < node.width) {
            Net net = node.ports[n];
            if (net != null && !(net instanceof NetGlobal)) {
                net.cost = this.costs[n];
            }
            ++n;
        }
    }

    public void updateTemperature() {
        if (this.tempMoves == 0) {
            return;
        }
        int n = 0;
        double d = (double)this.tempAccepted / (double)this.tempMoves;
        while (d > this.alpha[n][0]) {
            ++n;
        }
        this.setTemp(this.temp * this.alpha[n][1]);
    }
}

