/*
 * Decompiled with CFR 0.152.
 */
package org.opencores.graphics;

import java.awt.Color;
import java.awt.Graphics;
import java.util.Vector;

public class LineChartData {
    private Vector data = new Vector();
    private double maxy = 1.0;
    private Color color;

    public LineChartData(Color color) {
        this.color = color;
    }

    public void addData(double d) {
        if (d > this.maxy) {
            this.maxy = d;
        }
        this.data.addElement(new Double(d));
    }

    public void paint(Graphics graphics, int n, int n2, int n3) {
        graphics.setColor(this.color);
        if (this.data.isEmpty()) {
            return;
        }
        double d = (Double)this.data.firstElement() / this.maxy;
        int n4 = 1;
        while (n4 < this.data.size()) {
            double d2 = (Double)this.data.elementAt(n4) / this.maxy;
            graphics.drawLine(n4 - 1 + n3, (int)((1.0 - d) * (double)n2) + n, n4 + n3, (int)((1.0 - d2) * (double)n2) + n);
            d = d2;
            ++n4;
        }
    }

    public void resetData() {
        this.data = new Vector();
        this.maxy = Double.MIN_VALUE;
    }
}

