/*
 * Decompiled with CFR 0.152.
 */
package org.opencores.graphics;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import org.opencores.structure.Graph;
import org.opencores.structure.Net;
import org.opencores.structure.Node;
import org.opencores.structure.NodeFF;
import org.opencores.structure.NodeGPC;
import org.opencores.structure.NodeIOC;
import org.opencores.structure.NodeLUT;
import org.opencores.structure.NodePort;
import org.opencores.structure.NodePrim;
import org.opencores.structure.NodeRoutable;

public class Draw
extends Canvas {
    private static final int GRID = 16;
    public static final int DM_LINEAR = 1;
    public static final int DM_GRID = 2;
    public static final int DM_SEGMENT = 3;
    private Graph g;
    private int mode = 1;
    private Object holding = null;

    public Draw(Graph graph) {
        this.g = graph;
        this.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent mouseEvent) {
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }

            public void mousePressed(MouseEvent mouseEvent) {
                Draw.this.holding = Draw.this.pick(mouseEvent.getX(), mouseEvent.getY());
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                Draw.this.moveTo(Draw.this.holding, mouseEvent.getX(), mouseEvent.getY());
                Draw.this.repaint();
            }
        });
    }

    public void moveTo(Object object, int n, int n2) {
        float f = (float)n / 16.0f - 1.5f;
        float f2 = (float)n2 / 16.0f - 1.5f;
        if (object instanceof Node) {
            Node node = (Node)object;
            node.fx = f;
            node.fy = f2;
        }
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        graphics.setColor(Color.darkGray);
        graphics.fillRect(0, 0, 416, 416);
        if (this.mode == 2) {
            int n5;
            n4 = 0;
            while (n4 < 24) {
                if (n4 % 8 == 0) {
                    graphics.setColor(Color.lightGray);
                } else {
                    graphics.setColor(Color.gray);
                }
                n5 = 16 * (1 + n4) - 1;
                graphics.drawLine(n5, 16, n5, 399);
                ++n4;
            }
            graphics.setColor(Color.gray);
            graphics.drawLine(399, 16, 399, 399);
            n5 = 0;
            while (n5 < 24) {
                n3 = 16 * (1 + n5) - 1;
                if (n5 % 8 == 0) {
                    graphics.setColor(Color.lightGray);
                } else {
                    graphics.setColor(Color.gray);
                }
                graphics.drawLine(15, n3, 399, n3);
                ++n5;
            }
            graphics.drawLine(16, 399, 399, 400);
        }
        if (this.mode == 2 || this.mode == 1) {
            n4 = 0;
            while (n4 < this.g.nets.size()) {
                Net net = (Net)this.g.nets.elementAt(n4);
                if (net.output == null) {
                    System.out.println("Errorneous net: " + net.name);
                } else {
                    Node node;
                    float f = net.output.fx;
                    float f2 = net.output.fy;
                    n2 = 0;
                    while (n2 < net.inputs.size()) {
                        Node node2 = (Node)net.inputs.elementAt(n2);
                        f += node2.fx;
                        f2 += node2.fy;
                        ++n2;
                    }
                    f /= (float)(net.inputs.size() + 1);
                    f2 /= (float)(net.inputs.size() + 1);
                    graphics.setColor(Color.lightGray);
                    n = 0;
                    while (n < net.inputs.size()) {
                        node = (Node)net.inputs.elementAt(n);
                        graphics.drawLine((int)(node.fx * 16.0f) + 8 + 16, (int)(node.fy * 16.0f) + 8 + 16, (int)(f * 16.0f) + 8 + 16, (int)(f2 * 16.0f) + 8 + 16);
                        ++n;
                    }
                    node = net.output;
                    graphics.setColor(Color.yellow);
                    graphics.drawLine((int)(node.fx * 16.0f) + 8 + 16, (int)(node.fy * 16.0f) + 8 + 16, (int)(f * 16.0f) + 8 + 16, (int)(f2 * 16.0f) + 8 + 16);
                    graphics.fillRect((int)(f * 16.0f - 1.0f) + 8 + 16, (int)(f2 * 16.0f - 1.0f) + 8 + 16, 3, 3);
                }
                ++n4;
            }
        }
        n4 = 0;
        while (n4 < this.g.nodes.size()) {
            Node node = (Node)this.g.nodes.elementAt(n4);
            if (node instanceof NodePrim) {
                graphics.setColor(Color.magenta);
            } else if (node instanceof NodeGPC) {
                graphics.setColor(Color.orange);
            } else if (node instanceof NodeLUT) {
                graphics.setColor(Color.red);
            } else if (node instanceof NodePort) {
                graphics.setColor(Color.cyan);
            } else if (node instanceof NodeIOC) {
                graphics.setColor(Color.blue);
            } else if (node instanceof NodeFF) {
                graphics.setColor(Color.yellow);
            } else {
                graphics.setColor(Color.gray);
            }
            graphics.fill3DRect((int)(node.fx * 16.0f - 1.0f) + 16 + 1, (int)(node.fy * 16.0f - 1.0f) + 16 + 1, 15, 15, true);
            ++n4;
        }
        if (this.mode == 3 && this.g.pos != null) {
            int n6 = 0;
            while (n6 < this.g.pos.length) {
                n3 = 0;
                while (n3 < this.g.pos[n6].length) {
                    if (n6 != 0 && n6 != 25 || n3 != 0 && n3 != 25) {
                        NodeRoutable nodeRoutable = this.g.pos[n6][n3];
                        n2 = 0;
                        while (n2 < 8) {
                            if (nodeRoutable.segments[n2] != null) {
                                n = NodeRoutable.neighCoor[n2][0];
                                int n7 = NodeRoutable.neighCoor[n2][1];
                                int n8 = Math.abs(n) > Math.abs(n7) ? 0 : 1;
                                int n9 = 1 - n8;
                                if ((n2 & 1) == 1) {
                                    n8 = -n8;
                                    n9 = -n9;
                                }
                                graphics.setColor(Color.white);
                                graphics.drawLine(nodeRoutable.x * 16 + 8 + 16 + n + n8, nodeRoutable.y * 16 + 8 + 16 + n7 + n9, (nodeRoutable.x + n) * 16 + 8 + 16 - n + n8, (nodeRoutable.y + n7) * 16 + 8 + 16 - n7 + n9);
                                graphics.setColor(Color.red);
                                graphics.drawLine(nodeRoutable.x * 16 + 8 + 16 + n + n8, nodeRoutable.y * 16 + 8 + 16 + n7 + n9, nodeRoutable.x * 16 + 8 + 16 + n + n8, nodeRoutable.y * 16 + 8 + 16 + n7 + n9);
                            }
                            ++n2;
                        }
                    }
                    ++n3;
                }
                ++n6;
            }
            n3 = 0;
            while (n3 < this.g.pos.length) {
                int n10 = 0;
                while (n10 < this.g.pos[n3].length) {
                    if (n3 != 0 && n3 != 25 || n10 != 0 && n10 != 25) {
                        NodeRoutable nodeRoutable = this.g.pos[n3][n10];
                        n = nodeRoutable.nSegments;
                        int n11 = n * 256 / 8;
                        if (n11 > 255) {
                            n11 = 255;
                        }
                        graphics.setColor(new Color(255 - n11, n11, 10));
                        graphics.drawString(String.valueOf(n), n3 * 16 + 1, (n10 + 1) * 16 - 2);
                    }
                    ++n10;
                }
                ++n3;
            }
        }
    }

    public Object pick(int n, int n2) {
        float f = (float)n / 16.0f - 1.5f;
        float f2 = (float)n2 / 16.0f - 1.5f;
        int n3 = this.g.nodes.size() - 1;
        while (n3 >= 0) {
            Node node = (Node)this.g.nodes.elementAt(n3);
            if (Math.abs(node.fx - f) < 0.5f && Math.abs(node.fy - f2) < 0.5f) {
                return node;
            }
            --n3;
        }
        if (this.mode == 3) {
            return null;
        }
        int n4 = this.g.nets.size() - 1;
        while (n4 >= 0) {
            Net net = (Net)this.g.nets.elementAt(n4);
            if (net.output != null) {
                float f3 = net.output.fx;
                float f4 = net.output.fy;
                int n5 = 0;
                while (n5 < net.inputs.size()) {
                    Node node = (Node)net.inputs.elementAt(n5);
                    f3 += node.fx;
                    f4 += node.fy;
                    ++n5;
                }
                f3 /= (float)(net.inputs.size() + 1);
                f4 /= (float)(net.inputs.size() + 1);
                if (Math.abs(f3 - f) < 0.2f && Math.abs(f4 - f2) < 0.2f) {
                    return net;
                }
            }
            --n4;
        }
        return null;
    }

    public void setGraph(Graph graph) {
        this.g = graph;
        this.repaint();
    }

    public void setMode(int n) {
        this.mode = n;
    }
}

