/*
 * Decompiled with CFR 0.152.
 */
package org.opencores.edifp;

import java.io.FileInputStream;
import java.io.PrintWriter;
import java.util.Vector;
import org.opencores.Conf;
import org.opencores.edifp.Cell;
import org.opencores.edifp.Convert;
import org.opencores.edifp.ENet;
import org.opencores.edifp.Edif;
import org.opencores.edifp.Instance;
import org.opencores.edifp.Lex;
import org.opencores.edifp.Library;
import org.opencores.edifp.PathScope;
import org.opencores.edifp.Port;
import org.opencores.edifp.Symbol;
import org.opencores.structure.Graph;

public class Parser {
    private static boolean debug = false;
    private Lex lex;
    private static PrintWriter err;
    private String realName;
    private int numArray;
    private int arrayElt;
    private PathScope curPath = new PathScope();
    private PathScope refPath = new PathScope();

    public Parser(Lex lex) {
        this.lex = lex;
    }

    private void _interface() throws Exception {
        boolean bl = this.checkEmpty();
        while (!bl) {
            Symbol symbol = this.next();
            switch (symbol.s) {
                case 16: {
                    this.port();
                    break;
                }
                default: {
                    this.skipBlock(symbol);
                }
            }
            bl = this.checkEmpty();
        }
    }

    private void cell() throws Exception {
        Cell cell;
        this.curPath.cell = cell = new Cell();
        cell.name = this.getID();
        this.curPath.lib.cells.addElement(cell);
        boolean bl = this.checkEmpty();
        while (!bl) {
            Symbol symbol = this.next();
            switch (symbol.s) {
                case 13: {
                    this.view();
                    break;
                }
                default: {
                    this.skipBlock(symbol);
                }
            }
            bl = this.checkEmpty();
        }
    }

    private void cellRef() throws Exception {
        String string = this.getID();
        this.refPath.lib = null;
        this.dissolveRef(1);
        if (this.refPath.lib == null) {
            this.refPath.lib = this.curPath.lib;
        }
        Vector vector = this.refPath.lib.cells;
        int n = -1;
        int n2 = 0;
        while (n < 0 && n2 < vector.size()) {
            if (string.equalsIgnoreCase(((Cell)vector.elementAt((int)n2)).name)) {
                n = n2;
            }
            ++n2;
        }
        if (n >= 0) {
            this.refPath.cell = (Cell)vector.elementAt(n);
        } else {
            this.error("Invalid reference '" + string + "'.");
        }
    }

    private boolean checkEmpty() throws Exception {
        Symbol symbol = this.next();
        if (symbol.s == 1) {
            return false;
        }
        if (symbol.s == 2) {
            return true;
        }
        this.error(2);
        return false;
    }

    private void contents() throws Exception {
        boolean bl = this.checkEmpty();
        while (!bl) {
            Symbol symbol = this.next();
            switch (symbol.s) {
                case 20: {
                    this.instance();
                    break;
                }
                case 14: {
                    this.net();
                    break;
                }
                default: {
                    this.skipBlock(symbol);
                }
            }
            bl = this.checkEmpty();
        }
    }

    private void design() throws Exception {
        this.getID();
        boolean bl = this.checkEmpty();
        while (!bl) {
            Symbol symbol = this.next();
            switch (symbol.s) {
                case 22: {
                    this.cellRef();
                    this.curPath.edif.design = this.refPath.cell;
                    break;
                }
                default: {
                    this.skipBlock(symbol);
                }
            }
            bl = this.checkEmpty();
        }
    }

    private void dissolveRef(int n) throws Exception {
        boolean bl = this.checkEmpty();
        while (!bl) {
            Symbol symbol = this.next();
            switch (symbol.s) {
                case 25: {
                    if (n >= 1) {
                        this.libraryRef();
                        break;
                    }
                    this.skipBlock(symbol);
                    break;
                }
                case 22: {
                    if (n >= 2) {
                        this.cellRef();
                        break;
                    }
                    this.skipBlock(symbol);
                    break;
                }
                case 21: {
                    if (n >= 3) {
                        this.viewRef();
                        break;
                    }
                    this.skipBlock(symbol);
                    break;
                }
                case 24: {
                    if (n >= 4) {
                        this.instanceRef();
                        break;
                    }
                    this.skipBlock(symbol);
                    break;
                }
                case 23: {
                    if (n >= 5) {
                        this.portRef();
                        break;
                    }
                    this.skipBlock(symbol);
                    break;
                }
                case 14: {
                    if (n >= 4) {
                        this.netRef();
                        break;
                    }
                    this.skipBlock(symbol);
                    break;
                }
                default: {
                    this.skipBlock(symbol);
                }
            }
            bl = this.checkEmpty();
        }
    }

    private Graph edif() throws Exception {
        Object object;
        Edif edif;
        this.lp();
        this.get(10);
        this.curPath.edif = edif = new Edif();
        edif.name = this.getID();
        if (debug) {
            err.println(edif.name);
        }
        boolean bl = this.checkEmpty();
        while (!bl) {
            object = this.next();
            switch (((Symbol)object).s) {
                case 11: {
                    edif.version[0] = this.getNum();
                    edif.version[1] = this.getNum();
                    edif.version[2] = this.getNum();
                    this.rp();
                    break;
                }
                case 12: {
                    this.library();
                    break;
                }
                case 32: {
                    this.external();
                    break;
                }
                case 28: {
                    this.design();
                    break;
                }
                default: {
                    this.skipBlock((Symbol)object);
                }
            }
            bl = this.checkEmpty();
        }
        object = new Convert(edif);
        return ((Convert)object).graph;
    }

    void error(int n) {
        this.error("Invalid token found (expected #" + n + ").");
    }

    void error(String string) {
        err.println();
        err.println(string);
        err.close();
        throw new Error(string);
    }

    private void external() throws Exception {
        Library library = new Library();
        library.external = true;
        this.curPath.lib = library;
        this.curPath.edif.libraries.addElement(library);
        library.name = this.getID();
        boolean bl = this.checkEmpty();
        while (!bl) {
            Symbol symbol = this.next();
            switch (symbol.s) {
                case 29: {
                    this.cell();
                    break;
                }
                default: {
                    this.skipBlock(symbol);
                }
            }
            bl = this.checkEmpty();
        }
    }

    private Symbol get(int n) throws Exception {
        Symbol symbol = this.next();
        if (symbol.s != n) {
            this.error(n);
        }
        return symbol;
    }

    private String getID() throws Exception {
        return this.getID(false);
    }

    private String getID(boolean bl) throws Exception {
        Symbol symbol = this.next();
        this.numArray = 1;
        this.arrayElt = 0;
        switch (symbol.s) {
            case 14: {
                symbol.o = new String("net");
                symbol.s = 5;
                this.realName = (String)symbol.o;
                break;
            }
            case 31: {
                symbol.o = new String("netlist");
                symbol.s = 5;
                this.realName = (String)symbol.o;
                break;
            }
            case 5: {
                this.realName = (String)symbol.o;
                break;
            }
            case 1: {
                symbol.o = this.rename(bl);
                break;
            }
            default: {
                this.error("Invalid ID");
            }
        }
        return (String)symbol.o;
    }

    private int getNum() throws Exception {
        return (Integer)this.get((int)4).o;
    }

    private void instance() throws Exception {
        Instance instance;
        this.curPath.inst = instance = new Instance();
        instance.name = this.getID();
        this.curPath.cell.inst.addElement(instance);
        boolean bl = this.checkEmpty();
        while (!bl) {
            Symbol symbol = this.next();
            switch (symbol.s) {
                case 21: {
                    this.viewRef();
                    instance.cell = this.refPath.cell;
                    break;
                }
                case 26: {
                    this.property(instance);
                    break;
                }
                default: {
                    this.skipBlock(symbol);
                }
            }
            bl = this.checkEmpty();
        }
    }

    private void instanceRef() throws Exception {
        String string = this.getID();
        this.refPath.cell = null;
        this.dissolveRef(3);
        if (this.refPath.cell == null) {
            this.refPath.cell = this.curPath.cell;
        }
        Vector vector = this.refPath.cell.inst;
        int n = -1;
        int n2 = 0;
        while (n < 0 && n2 < vector.size()) {
            if (string.equalsIgnoreCase(((Instance)vector.elementAt((int)n2)).name)) {
                n = n2;
            }
            ++n2;
        }
        if (n >= 0) {
            this.refPath.inst = (Instance)vector.elementAt(n);
        } else {
            this.error("Invalid reference '" + string + "'.");
        }
    }

    private void joined() throws Exception {
        boolean bl = this.checkEmpty();
        while (!bl) {
            Symbol symbol = this.next();
            switch (symbol.s) {
                case 23: {
                    this.portRef();
                    this.curPath.net.inst.addElement(this.refPath.inst);
                    this.curPath.net.ports.addElement(this.refPath.port);
                    this.curPath.net.ports_i.addElement(new Integer(this.refPath.port_i));
                    break;
                }
                default: {
                    this.skipBlock(symbol);
                }
            }
            bl = this.checkEmpty();
        }
    }

    private void library() throws Exception {
        Library library = new Library();
        library.external = false;
        this.curPath.lib = library;
        this.curPath.edif.libraries.addElement(library);
        library.name = this.getID();
        boolean bl = this.checkEmpty();
        while (!bl) {
            Symbol symbol = this.next();
            switch (symbol.s) {
                case 29: {
                    this.cell();
                    break;
                }
                default: {
                    this.skipBlock(symbol);
                }
            }
            bl = this.checkEmpty();
        }
    }

    private void libraryRef() throws Exception {
        String string = this.getID();
        this.rp();
        Vector vector = this.curPath.edif.libraries;
        int n = -1;
        int n2 = 0;
        while (n < 0 && n2 < vector.size()) {
            if (string.equalsIgnoreCase(((Library)vector.elementAt((int)n2)).name)) {
                n = n2;
            }
            ++n2;
        }
        if (n >= 0) {
            this.refPath.lib = (Library)vector.elementAt(n);
        } else {
            this.error("Invalid reference '" + string + "'.");
        }
    }

    private void lp() throws Exception {
        this.get(1);
    }

    public static Graph main(String string) throws Exception {
        Graph graph = null;
        Lex lex = new Lex(new FileInputStream(String.valueOf(Conf.sdir) + string));
        err = Conf.log;
        debug = Conf.debug;
        Parser parser = new Parser(lex);
        graph = parser.parse();
        return graph;
    }

    private void net() throws Exception {
        ENet eNet;
        this.curPath.net = eNet = new ENet();
        eNet.name = this.getID();
        this.curPath.cell.nets.addElement(eNet);
        boolean bl = this.checkEmpty();
        while (!bl) {
            Symbol symbol = this.next();
            switch (symbol.s) {
                case 27: {
                    this.joined();
                    break;
                }
                default: {
                    this.skipBlock(symbol);
                }
            }
            bl = this.checkEmpty();
        }
    }

    private void netRef() throws Exception {
        String string = this.getID();
        this.refPath.cell = null;
        this.dissolveRef(3);
        if (this.refPath.cell == null) {
            this.refPath.cell = this.curPath.cell;
        }
        Vector vector = this.refPath.cell.nets;
        int n = -1;
        int n2 = 0;
        while (n < 0 && n2 < vector.size()) {
            if (string.equalsIgnoreCase(((ENet)vector.elementAt((int)n2)).name)) {
                n = n2;
            }
            ++n2;
        }
        if (n >= 0) {
            this.refPath.net = (ENet)vector.elementAt(n);
        } else {
            this.error("Invalid reference '" + string + "'.");
        }
    }

    private Symbol next() throws Exception {
        Symbol symbol = this.lex.getToken();
        if (debug) {
            err.print(symbol);
        }
        return symbol;
    }

    public Graph parse() throws Exception {
        return this.edif();
    }

    private void port() throws Exception {
        Port port;
        this.curPath.port = port = new Port();
        port.name = this.getID(true);
        port.width = this.numArray;
        this.curPath.cell.ports.addElement(port);
        boolean bl = this.checkEmpty();
        while (!bl) {
            Symbol symbol = this.next();
            switch (symbol.s) {
                case 17: {
                    symbol = this.next();
                    switch (symbol.s) {
                        case 7: {
                            port.direction = 3;
                            break;
                        }
                        case 8: {
                            port.direction = 1;
                            break;
                        }
                        case 9: {
                            port.direction = 2;
                            break;
                        }
                        default: {
                            this.error(9);
                        }
                    }
                    this.rp();
                    break;
                }
                default: {
                    this.skipBlock(symbol);
                }
            }
            bl = this.checkEmpty();
        }
    }

    private void portRef() throws Exception {
        String string = this.getID();
        int n = this.arrayElt;
        this.refPath.inst = null;
        this.dissolveRef(4);
        Vector vector = this.refPath.inst == null ? this.curPath.cell.ports : this.refPath.inst.cell.ports;
        int n2 = -1;
        int n3 = 0;
        while (n2 < 0 && n3 < vector.size()) {
            if (string.equalsIgnoreCase(((Port)vector.elementAt((int)n3)).name)) {
                n2 = n3;
            }
            ++n3;
        }
        if (n2 >= 0) {
            this.refPath.port = (Port)vector.elementAt(n2);
            this.refPath.port_i = n;
            if (n >= this.refPath.port.width || n < 0) {
                this.error("Invalid index.");
            }
        } else {
            this.error("Invalid reference '" + string + "'.");
        }
    }

    private void property(Instance instance) throws Exception {
        String string = this.getID();
        if (string.equalsIgnoreCase("LIBVER")) {
            this.lp();
            Symbol symbol = this.next();
            this.skipBlock(symbol);
            this.rp();
            return;
        }
        this.lp();
        Symbol symbol = this.next();
        this.skipBlock(symbol);
        this.rp();
    }

    private String rename(boolean bl) throws Exception {
        Symbol symbol = this.next();
        String string = null;
        switch (symbol.s) {
            case 18: {
                string = this.getID();
                Symbol symbol2 = this.get(3);
                this.realName = (String)symbol2.o;
                this.rp();
                break;
            }
            case 34: {
                string = this.getID();
                this.arrayElt = this.getNum();
                this.rp();
                break;
            }
            case 33: {
                if (!bl) {
                    this.error("Array not allowed here.");
                }
                string = this.getID();
                this.numArray = this.getNum();
                this.rp();
                break;
            }
            default: {
                this.error("Renaming, member or array expected.");
            }
        }
        return string;
    }

    private void rp() throws Exception {
        this.get(2);
    }

    private void skipBlock(Symbol symbol) throws Exception {
        int n = 1;
        if (symbol.s != 26) {
            err.println("Unknown token found: " + symbol);
        }
        while (n > 0) {
            Symbol symbol2 = this.next();
            switch (symbol2.s) {
                case 1: {
                    ++n;
                    break;
                }
                case 2: {
                    --n;
                    break;
                }
            }
        }
    }

    private void view() throws Exception {
        this.curPath.cell.view = this.getID();
        boolean bl = this.checkEmpty();
        boolean bl2 = false;
        while (!bl) {
            Symbol symbol = this.next();
            switch (symbol.s) {
                case 30: {
                    symbol = this.next();
                    if (symbol.s == 31) {
                        this.rp();
                        bl2 = true;
                        break;
                    }
                    this.skipBlock(symbol);
                    break;
                }
                case 15: {
                    this._interface();
                    break;
                }
                case 19: {
                    this.contents();
                    break;
                }
                default: {
                    this.skipBlock(symbol);
                }
            }
            bl = this.checkEmpty();
        }
    }

    private void viewRef() throws Exception {
        String string = this.getID();
        this.refPath.lib = null;
        this.dissolveRef(2);
        if (this.refPath.lib == null) {
            this.refPath.lib = this.curPath.lib;
        }
        Vector vector = this.refPath.lib.cells;
        int n = -1;
        int n2 = 0;
        while (n < 0 && n2 < vector.size()) {
            if (string.equalsIgnoreCase(((Cell)vector.elementAt((int)n2)).view)) {
                n = n2;
            }
            ++n2;
        }
        if (n < 0) {
            this.error("Invalid reference '" + string + "'.");
        }
    }
}

