/*
 * Decompiled with CFR 0.152.
 */
package org.opencores;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Label;
import java.awt.List;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.opencores.Conf;
import org.opencores.graphics.Draw;
import org.opencores.graphics.LineChart;
import org.opencores.graphics.LineChartData;
import org.opencores.mapping.FlipFlopMap;
import org.opencores.mapping.FlowMap;
import org.opencores.mapping.GPCMap;
import org.opencores.mapping.GlobalMap;
import org.opencores.mapping.IOCMap;
import org.opencores.placement.Annealing;
import org.opencores.placement.PrePlacement;
import org.opencores.placement.Statistics;
import org.opencores.routing.Wavefront;
import org.opencores.structure.Graph;
import org.opencores.structure.Net;
import org.opencores.util.BitStreamWriter;
import org.opencores.verilogp.Parser;

public final class Main
extends Frame {
    private static Graph graph;
    private static Main display;
    private Draw draw;
    private LineChart chart = new LineChart(300, 200);
    private LineChartData edata = new LineChartData(Color.blue);
    private LineChartData tdata = new LineChartData(Color.red);
    private Label label = new Label();
    private Label status = new Label();
    private List list = new List();
    private static final String[] OPTIONS;

    static {
        display = new Main();
        OPTIONS = new String[]{"All", "Random positions", "Mapping", "Preplacement", "Placement", "Routing", "Write bitstream"};
    }

    private void init() {
        this.draw = new Draw(graph);
        int n = 0;
        while (n < OPTIONS.length) {
            this.list.add(OPTIONS[n]);
            ++n;
        }
        this.setLayout(null);
        this.add(this.draw);
        this.add(this.status);
        this.add(this.label);
        this.add(this.list);
        this.chart.addData(this.edata);
        this.chart.addData(this.tdata);
        this.chart.setTitle("KRPAN chart");
        ((Component)this.chart).setLocation(750, 0);
        ((Component)this.chart).setVisible(true);
        this.draw.setBounds(50, 50, 550, 550);
        this.list.setBounds(600, 160, 140, 200);
        this.status.setBounds(30, 600, 700, 20);
        this.label.setBounds(30, 630, 700, 20);
        this.list.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Main.this.processOption(Main.this.list.getSelectedIndex());
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Conf.log.close();
                System.exit(0);
            }
        });
        ((Component)this).setBackground(Color.gray);
        ((Component)this).setSize(750, 700);
        ((Component)this).setVisible(true);
        this.setupDraw();
    }

    public static void main(String[] stringArray) throws Exception {
        if (Conf.setParameters(stringArray)) {
            Object object;
            if (Conf.outFile == null) {
                Conf.outFile = String.valueOf(Conf.inFile) + ".bin";
            }
            switch (Conf.fileType(Conf.inFile)) {
                case 0: {
                    System.out.println("Reading EDIF file " + Conf.inFile);
                    graph = org.opencores.edifp.Parser.main(Conf.inFile);
                    break;
                }
                case 1: {
                    System.out.println("Reading Verilog-HDL file " + Conf.inFile);
                    object = new Parser(Conf.inFile);
                    graph = ((Parser)object).getGraph();
                    System.out.println("Done.");
                    break;
                }
                default: {
                    throw new Error("Unknown file extension.");
                }
            }
            if (Conf.debug) {
                Conf.log.println("Number of repairs: " + graph.repair(true));
            }
            if (Conf.debug) {
                Conf.log.println("Number of errors : " + graph.check(true));
            }
            graph.setRandomPositions(24, 24);
            graph.createFloatPositions();
            if (Conf.graphics) {
                object = new Main();
                super.init();
            } else {
                object = new Main();
                super.processOption(0);
                object = null;
            }
            if (!Conf.graphics) {
                Conf.log.close();
            }
        }
    }

    private void processOption(int n) {
        switch (n) {
            case 0: {
                this.processOption(2);
                this.processOption(3);
                this.processOption(4);
                this.processOption(5);
                this.processOption(6);
                break;
            }
            case 1: {
                graph.setRandomPositions(24, 24);
                graph.createFloatPositions();
                break;
            }
            case 2: {
                Graph graph;
                if (Main.graph.mapped) {
                    System.out.println("Graph already mapped!");
                    if (this.draw == null) break;
                    this.label.setText("Graph already mapped!");
                    break;
                }
                System.out.println("Mapping...");
                Conf.log.println("Number of repairs: " + Main.graph.repair(true));
                Conf.log.println("Number of errors : " + Main.graph.check(true));
                FlipFlopMap.addLUTs(Main.graph);
                Conf.log.println("Number of repairs: " + Main.graph.repair(true));
                Conf.log.println("Number of errors : " + Main.graph.check(true));
                FlowMap flowMap = new FlowMap();
                flowMap.labeling(Main.graph);
                Conf.log.println("Number of repairs: " + Main.graph.repair(true));
                Conf.log.println("Number of errors : " + Main.graph.check(true));
                Main.graph = graph = flowMap.mapping(Main.graph);
                Conf.log.println("Number of repairs: " + Main.graph.repair(true));
                Conf.log.println("Number of errors : " + Main.graph.check(true));
                GlobalMap globalMap = new GlobalMap(Main.graph);
                globalMap.mapping();
                Conf.log.println("Number of repairs: " + Main.graph.repair(true));
                Conf.log.println("Number of errors : " + Main.graph.check(true));
                IOCMap.group(Main.graph);
                GPCMap.group(Main.graph);
                Conf.log.println("Number of repairs: " + Main.graph.repair(true));
                Conf.log.println("Number of errors : " + Main.graph.check(true));
                Conf.log.println("Number of repairs: " + Main.graph.repair(true));
                Conf.log.println("Number of errors : " + Main.graph.check(true));
                Main.graph.name = String.valueOf(Main.graph.name) + ".mapped";
                Main.graph.mapped = true;
                if (this.draw == null) break;
                this.draw.setGraph(Main.graph);
                this.setupDraw();
                break;
            }
            case 3: {
                System.out.println("Preplacing...");
                PrePlacement prePlacement = new PrePlacement(graph);
                prePlacement.setGraph(graph);
                prePlacement.prePlacement();
                System.out.println("Number of repairs: " + graph.repair(true));
                System.out.println("Number of errors : " + graph.check(true));
                graph.createFloatPositions();
                Main.graph.name = String.valueOf(Main.graph.name) + ".preplaced";
                Conf.log.println("IOCs: " + 100 * prePlacement.nIOC / 96 + "%");
                Conf.log.println("GPCs: " + 100 * prePlacement.nGPC / 576 + "%");
                if (this.draw == null) break;
                this.draw.setMode(2);
                this.label.setText("IOCs: " + 100 * prePlacement.nIOC / 96 + "%   " + "GPCs: " + 100 * prePlacement.nGPC / 576 + "%");
                break;
            }
            case 4: {
                System.out.println("Placing...");
                Conf.log.println(graph.toString("before annealing"));
                Conf.log.println("Number of repairs: " + graph.repair(true));
                Conf.log.println("Number of errors : " + graph.check(true));
                Annealing annealing = new Annealing(graph);
                if (this.draw != null) {
                    this.edata.resetData();
                    this.tdata.resetData();
                }
                while (true) {
                    annealing.anneal();
                    if (annealing.doneCriteria()) break;
                    annealing.updateTemperature();
                    if (this.draw == null) continue;
                    this.edata.addData(annealing.getWiringCost());
                    this.tdata.addData(annealing.getTemp());
                    this.label.setText("energy " + annealing.getWiringCost() + " temperature " + annealing.getTemp());
                }
                Main.graph.name = String.valueOf(Main.graph.name) + ".placed";
                if (this.draw != null) {
                    graph.createFloatPositions();
                    this.draw.setMode(2);
                    this.chart.repaint();
                }
                Statistics statistics = new Statistics(graph);
                int n2 = 0;
                while (n2 < statistics.distCnt.length) {
                    Conf.log.println(String.valueOf(n2) + "\t" + statistics.distCnt[n2]);
                    ++n2;
                }
                Conf.log.println();
                break;
            }
            case 5: {
                System.out.println("Routing...");
                graph.constructSegments();
                graph.emtpySegments();
                Wavefront wavefront = new Wavefront(graph);
                boolean bl = wavefront.route();
                if (this.draw != null) {
                    this.label.setText("min free segments: " + wavefront.minFreeSegment() + " routed " + bl);
                }
                Conf.log.println("Number of unrouted nets " + wavefront.unroutedNets.size() + "/" + Main.graph.nets.size());
                System.out.println("Number of unrouted nets " + wavefront.unroutedNets.size() + "/" + Main.graph.nets.size());
                int n3 = 0;
                while (n3 < wavefront.unroutedNets.size()) {
                    Conf.log.print(String.valueOf(((Net)wavefront.unroutedNets.elementAt((int)n3)).name) + ", ");
                    System.out.print(String.valueOf(((Net)wavefront.unroutedNets.elementAt((int)n3)).name) + ", ");
                    ++n3;
                }
                System.out.println();
                Conf.log.println();
                if (this.draw != null) {
                    this.draw.setMode(3);
                }
                if (!bl) break;
                Main.graph.name = String.valueOf(Main.graph.name) + ".routed";
                break;
            }
            case 6: {
                System.out.println("Writing bistream...");
                try {
                    BitStreamWriter bitStreamWriter = new BitStreamWriter(new BufferedOutputStream(new FileOutputStream(Conf.outFile)));
                    graph.writeBitstream(bitStreamWriter, Conf.clear);
                    bitStreamWriter.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    Conf.log.close();
                    System.exit(0);
                }
                break;
            }
        }
        System.out.println("Number of repairs: " + graph.repair(true));
        System.out.println("Number of errors : " + graph.check(true));
        if (this.draw != null) {
            this.draw.repaint();
        }
    }

    private void setupDraw() {
        this.setTitle("KRPAN graphics view - " + Main.graph.name);
        this.draw.addMouseMotionListener(new MouseMotionListener(){

            public void mouseDragged(MouseEvent mouseEvent) {
            }

            public void mouseMoved(MouseEvent mouseEvent) {
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                Object object = Main.this.draw.pick(n, n2);
                String string = "";
                if (object != null) {
                    string = object.toString();
                }
                Main.this.status.setText(string);
            }
        });
    }
}

