/*
 * Decompiled with CFR 0.152.
 */
package org.opencores.JLex;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import org.opencores.JLex.CUtility;

final class SparseBitSet
implements Cloneable {
    int[] offs;
    long[] bits;
    int size;
    private static final int LG_BITS = 6;
    private static final int BITS = 64;
    private static final int BITS_M1 = 63;
    private static final BinOp AND = new BinOp(){

        public final long op(long l, long l2) {
            return l & l2;
        }
    };
    private static final BinOp OR = new BinOp(){

        public final long op(long l, long l2) {
            return l | l2;
        }
    };
    private static final BinOp XOR = new BinOp(){

        public final long op(long l, long l2) {
            return l ^ l2;
        }
    };

    public SparseBitSet() {
        this.bits = new long[4];
        this.offs = new int[4];
        this.size = 0;
    }

    public SparseBitSet(int n) {
        this();
    }

    public SparseBitSet(SparseBitSet sparseBitSet) {
        this.bits = new long[sparseBitSet.size];
        this.offs = new int[sparseBitSet.size];
        this.size = 0;
    }

    public void and(SparseBitSet sparseBitSet) {
        SparseBitSet.binop(this, sparseBitSet, AND);
    }

    private static final void binop(SparseBitSet sparseBitSet, SparseBitSet sparseBitSet2, BinOp binOp) {
        int n;
        int n2;
        int[] nArray;
        long[] lArray;
        int n3 = sparseBitSet.size + sparseBitSet2.size;
        if (sparseBitSet.bits.length < n3) {
            lArray = new long[n3];
            nArray = new int[n3];
            n2 = 0;
            n = sparseBitSet.size;
        } else {
            lArray = sparseBitSet.bits;
            nArray = sparseBitSet.offs;
            n2 = sparseBitSet.bits.length - sparseBitSet.size;
            n = sparseBitSet.bits.length;
            System.arraycopy(sparseBitSet.bits, 0, sparseBitSet.bits, n2, sparseBitSet.size);
            System.arraycopy(sparseBitSet.offs, 0, sparseBitSet.offs, n2, sparseBitSet.size);
        }
        n3 = 0;
        int n4 = n2;
        int n5 = 0;
        while (n4 < n || n5 < sparseBitSet2.size) {
            int n6;
            long l;
            if (n4 < n && (n5 >= sparseBitSet2.size || sparseBitSet.offs[n4] < sparseBitSet2.offs[n5])) {
                l = binOp.op(sparseBitSet.bits[n4], 0L);
                n6 = sparseBitSet.offs[n4];
                ++n4;
            } else if (n5 < sparseBitSet2.size && (n4 >= n || sparseBitSet.offs[n4] > sparseBitSet2.offs[n5])) {
                l = binOp.op(0L, sparseBitSet2.bits[n5]);
                n6 = sparseBitSet2.offs[n5];
                ++n5;
            } else {
                l = binOp.op(sparseBitSet.bits[n4], sparseBitSet2.bits[n5]);
                n6 = sparseBitSet.offs[n4];
                ++n4;
                ++n5;
            }
            if (l == 0L) continue;
            lArray[n3] = l;
            nArray[n3] = n6;
            ++n3;
        }
        sparseBitSet.bits = lArray;
        sparseBitSet.offs = nArray;
        sparseBitSet.size = n3;
    }

    private int bsearch(int n) {
        int n2 = 0;
        int n3 = this.size;
        while (n2 < n3) {
            int n4 = (n2 + n3) / 2;
            if (n < this.offs[n4]) {
                n3 = n4;
                continue;
            }
            if (n > this.offs[n4]) {
                n2 = n4 + 1;
                continue;
            }
            return n4;
        }
        CUtility.assert(n2 == n3);
        return n2;
    }

    public void clear(int n) {
        int n2 = n >> 6;
        int n3 = this.bsearch(n2);
        if (n3 >= this.size || this.offs[n3] != n2) {
            this.new_block(n3, n2);
        }
        int n4 = n3;
        this.bits[n4] = this.bits[n4] & (1L << (n & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public void clearAll() {
        this.size = 0;
    }

    public Object clone() {
        try {
            SparseBitSet sparseBitSet = (SparseBitSet)super.clone();
            sparseBitSet.bits = (long[])this.bits.clone();
            sparseBitSet.offs = (int[])this.offs.clone();
            return sparseBitSet;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public Enumeration elements() {
        return new Enumeration(){
            int idx = -1;
            int bit = 64;
            {
                this.advance();
            }

            /*
             * Unable to fully structure code
             */
            private void advance() {
                ** GOTO lbl8
                {
                    if ((SparseBitSet.this.bits[this.idx] & 1L << this.bit) != 0L) {
                        return;
                    }
                    do {
                        if (++this.bit < 64) continue block0;
                        ++this.idx;
                        this.bit = -1;
lbl8:
                        // 2 sources

                    } while (this.idx < SparseBitSet.this.size);
                }
            }

            public boolean hasMoreElements() {
                return this.idx < SparseBitSet.this.size;
            }

            public Object nextElement() {
                int n = this.bit + (SparseBitSet.this.offs[this.idx] << 6);
                this.advance();
                return new Integer(n);
            }
        };
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof SparseBitSet) {
            return SparseBitSet.equals(this, (SparseBitSet)object);
        }
        return false;
    }

    public static boolean equals(SparseBitSet sparseBitSet, SparseBitSet sparseBitSet2) {
        int n = 0;
        int n2 = 0;
        while (n < sparseBitSet.size || n2 < sparseBitSet2.size) {
            if (!(n < sparseBitSet.size && (n2 >= sparseBitSet2.size || sparseBitSet.offs[n] < sparseBitSet2.offs[n2]) ? sparseBitSet.bits[n++] != 0L : (n2 < sparseBitSet2.size && (n >= sparseBitSet.size || sparseBitSet.offs[n] > sparseBitSet2.offs[n2]) ? sparseBitSet2.bits[n2++] != 0L : sparseBitSet.bits[n++] != sparseBitSet2.bits[n2++]))) continue;
            return false;
        }
        return true;
    }

    public boolean get(int n) {
        int n2 = n >> 6;
        int n3 = this.bsearch(n2);
        if (n3 >= this.size || this.offs[n3] != n2) {
            return false;
        }
        return (this.bits[n3] & 1L << (n & 0x3F)) != 0L;
    }

    public int hashCode() {
        long l = 1234L;
        int n = 0;
        while (n < this.size) {
            l ^= this.bits[n] * (long)this.offs[n];
            ++n;
        }
        return (int)(l >> 32 ^ l);
    }

    private void insert_block(int n, int n2) {
        CUtility.assert(n <= this.size);
        CUtility.assert(n == this.size || this.offs[n] != n2);
        System.arraycopy(this.bits, n, this.bits, n + 1, this.size - n);
        System.arraycopy(this.offs, n, this.offs, n + 1, this.size - n);
        this.offs[n] = n2;
        this.bits[n] = 0L;
        ++this.size;
    }

    private boolean isValid() {
        if (this.bits.length != this.offs.length) {
            return false;
        }
        if (this.size > this.bits.length) {
            return false;
        }
        if (this.size != 0 && this.offs[0] >= 0) {
            return false;
        }
        int n = 1;
        while (n < this.size) {
            if (this.offs[n] < this.offs[n - 1]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static void main(String[] stringArray) {
        int n;
        int n2 = 500;
        int n3 = 65536;
        SparseBitSet sparseBitSet = new SparseBitSet();
        CUtility.assert(!sparseBitSet.get(0) && !sparseBitSet.get(1));
        CUtility.assert(sparseBitSet.get(123329) ^ true);
        sparseBitSet.set(0);
        CUtility.assert(sparseBitSet.get(0) && !sparseBitSet.get(1));
        sparseBitSet.set(1);
        CUtility.assert(sparseBitSet.get(0) && sparseBitSet.get(1));
        sparseBitSet.clearAll();
        CUtility.assert(!sparseBitSet.get(0) && !sparseBitSet.get(1));
        Random random = new Random();
        Vector<Integer> vector = new Vector<Integer>();
        int n4 = 0;
        while (n4 < 500) {
            int n5 = (random.nextInt() >>> 1) % 65536 << 1;
            sparseBitSet.set(n5);
            vector.addElement(new Integer(n5));
            CUtility.assert(sparseBitSet.get(n5) && !sparseBitSet.get(n5 + 1) && !sparseBitSet.get(n5 - 1));
            n = 0;
            while (n < vector.size()) {
                CUtility.assert(sparseBitSet.get((Integer)vector.elementAt(n)));
                ++n;
            }
            ++n4;
        }
        SparseBitSet sparseBitSet2 = (SparseBitSet)sparseBitSet.clone();
        CUtility.assert(sparseBitSet.equals(sparseBitSet2) && sparseBitSet2.equals(sparseBitSet));
        n = 0;
        while (n < 250) {
            int n6 = (random.nextInt() >>> 1) % vector.size();
            int n7 = (Integer)vector.elementAt(n6);
            sparseBitSet2.clear(n7);
            vector.removeElementAt(n6);
            CUtility.assert(sparseBitSet2.get(n7) ^ true);
            ++n;
        }
        CUtility.assert(sparseBitSet.equals(sparseBitSet2) ^ true);
        SparseBitSet sparseBitSet3 = (SparseBitSet)sparseBitSet.clone();
        SparseBitSet sparseBitSet4 = (SparseBitSet)sparseBitSet.clone();
        sparseBitSet3.and(sparseBitSet);
        CUtility.assert(sparseBitSet3.equals(sparseBitSet) && sparseBitSet.equals(sparseBitSet3));
        sparseBitSet3.xor(sparseBitSet);
        CUtility.assert(!sparseBitSet3.equals(sparseBitSet) && sparseBitSet3.size() == 0);
        sparseBitSet4.or(sparseBitSet2);
        CUtility.assert(sparseBitSet4.equals(sparseBitSet) && !sparseBitSet2.equals(sparseBitSet4));
        sparseBitSet4.and(sparseBitSet2);
        CUtility.assert(!sparseBitSet4.equals(sparseBitSet) && sparseBitSet2.equals(sparseBitSet4));
        sparseBitSet4.xor(sparseBitSet);
        CUtility.assert(!sparseBitSet4.equals(sparseBitSet) && !sparseBitSet2.equals(sparseBitSet4));
        sparseBitSet3.or(sparseBitSet4);
        sparseBitSet3.or(sparseBitSet2);
        CUtility.assert(sparseBitSet3.equals(sparseBitSet) && sparseBitSet.equals(sparseBitSet3));
        sparseBitSet3 = (SparseBitSet)sparseBitSet4.clone();
        sparseBitSet3.and(sparseBitSet2);
        CUtility.assert(sparseBitSet3.size() == 0);
        System.out.println("Success.");
    }

    private void new_block(int n) {
        this.new_block(this.bsearch(n), n);
    }

    private void new_block(int n, int n2) {
        if (this.size == this.bits.length) {
            long[] lArray = new long[this.size * 3];
            int[] nArray = new int[this.size * 3];
            System.arraycopy(this.bits, 0, lArray, 0, this.size);
            System.arraycopy(this.offs, 0, nArray, 0, this.size);
            this.bits = lArray;
            this.offs = nArray;
        }
        CUtility.assert(this.size < this.bits.length);
        this.insert_block(n, n2);
    }

    public void or(SparseBitSet sparseBitSet) {
        SparseBitSet.binop(this, sparseBitSet, OR);
    }

    public void set(int n) {
        int n2 = n >> 6;
        int n3 = this.bsearch(n2);
        if (n3 >= this.size || this.offs[n3] != n2) {
            this.new_block(n3, n2);
        }
        int n4 = n3;
        this.bits[n4] = this.bits[n4] | 1L << (n & 0x3F);
    }

    public int size() {
        return this.size == 0 ? 0 : 1 + this.offs[this.size - 1] << 6;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('{');
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            if (stringBuffer.length() > 1) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(enumeration.nextElement());
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    public void xor(SparseBitSet sparseBitSet) {
        SparseBitSet.binop(this, sparseBitSet, XOR);
    }

    private static interface BinOp {
        public long op(long var1, long var3);
    }
}

