/*
 * Decompiled with CFR 0.152.
 */
package org.opencores.JLex;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import org.opencores.JLex.CUtility;

class CInput {
    private BufferedReader m_input;
    boolean m_eof_reached;
    boolean m_pushback_line;
    char[] m_line;
    int m_line_read;
    int m_line_index;
    int m_line_number;
    static final boolean EOF = true;
    static final boolean NOT_EOF = false;

    CInput(Reader reader) {
        CUtility.assert(reader != null);
        this.m_input = new BufferedReader(reader);
        this.m_line = null;
        this.m_line_read = 0;
        this.m_line_index = 0;
        this.m_eof_reached = false;
        this.m_line_number = 0;
        this.m_pushback_line = false;
    }

    boolean getLine() throws IOException {
        int n;
        if (this.m_eof_reached) {
            return true;
        }
        if (this.m_pushback_line) {
            this.m_pushback_line = false;
            n = 0;
            while (n < this.m_line_read) {
                if (!CUtility.isspace(this.m_line[n])) break;
                ++n;
            }
            if (n < this.m_line_read) {
                this.m_line_index = 0;
                return false;
            }
        }
        block1: do {
            String string;
            if ((string = this.m_input.readLine()) == null) {
                this.m_eof_reached = true;
                this.m_line_index = 0;
                return true;
            }
            this.m_line = (String.valueOf(string) + "\n").toCharArray();
            this.m_line_read = this.m_line.length;
            ++this.m_line_number;
            n = 0;
            while (CUtility.isspace(this.m_line[n])) {
                if (++n == this.m_line_read) continue block1;
            }
        } while (n >= this.m_line_read);
        this.m_line_index = 0;
        return false;
    }
}

