/*
 * Decompiled with CFR 0.152.
 */
package org.opencores;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;

public class Conf {
    public static final int X = 24;
    public static final int Y = 24;
    public static final int K = 5;
    public static final int NUM_GPC = 576;
    public static final int NUM_IOC = 96;
    public static final int NUM_SR = 6;
    public static final int GNET_MIN = 1;
    public static final int DIR_N = 0;
    public static final int DIR_S = 1;
    public static final int DIR_W = 2;
    public static final int DIR_E = 3;
    public static final int[] OPPOSITE_DIR;
    public static PrintWriter log;
    public static final String NAME = "KRPAN";
    public static final String VERSION = "0.2";
    public static String inFile;
    public static String outFile;
    public static String logFile;
    public static boolean help;
    public static boolean verbose;
    public static boolean debug;
    public static boolean graphics;
    public static String sdir;
    public static String ddir;
    public static boolean clear;
    public static final int BSH_GPC = 192;
    public static final int BSH_IOC = 193;
    public static final String NL = "\r\n";
    public static final String PROGRAM_DESC = "Program KRPAN v0.2, FPGA Mapping&Placement&Routing utility.\r\n(C) 2001 Marko Mlinar.\r\nKRPAN comes with ABSOLUTELY NO WARRANTY; see license.txt for details.";
    public static final String PARAM_HELP;
    public static final String[] OPTION_NAME;
    public static final int[] OPTION_ENUM;
    private static int pIdx;
    public static final String[] exts;
    public static final int FT_UNKNOWN = -1;
    public static final int FT_EDIF = 0;
    public static final int FT_VERILOG = 1;

    static {
        int[] nArray = new int[4];
        nArray[0] = 1;
        nArray[2] = 3;
        nArray[3] = 2;
        OPPOSITE_DIR = nArray;
        outFile = null;
        logFile = "KRPAN.log";
        help = false;
        verbose = false;
        debug = false;
        graphics = false;
        sdir = "";
        ddir = "";
        clear = false;
        PARAM_HELP = "\n\tUsage: KRPAN input_file [output_file] [-option [-option ...]]\r\n\n Valid options:\r\n -h -? --help     this screen\r\n -v --verbose     verbose output to log file\r\n -d --debug\t\t   verbose debug output to log file\r\n -g --graphics    display progress graphically\r\n -sd --sdir {dir} sets source dir (default \".\")\r\n -dd --ddir {dir} sets destination dir (default \".\")\r\n -l  --log {file} sets different log file (default \"" + logFile + "\")" + NL + NL + " -c --clear       include unused cells in configuration" + NL + NL + "Usage example:" + NL + NAME + " -sd examples -dd . -g test.v" + NL + "(generates bit stream specification file named 'test.v.bin', if successful)" + NL;
        OPTION_NAME = new String[]{"-h", "-?", "--help", "-v", "--verbose", "-d", "--debug", "-g", "--graphics", "-sd", "--sdir", "-dd", "--ddir", "-l", "--log"};
        OPTION_ENUM = new int[]{1, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8};
        exts = new String[]{"edf", "v"};
    }

    public static final int fileType(String string) {
        int n = -1;
        try {
            int n2 = string.length() - 1;
            while (n2 >= 0) {
                if (string.charAt(n2) == '.') {
                    n = n2;
                    break;
                }
                --n2;
            }
            if (n < 0) {
                return -1;
            }
            String string2 = string.substring(n + 1);
            int n3 = 0;
            while (n3 < exts.length) {
                if (exts[n3].equalsIgnoreCase(string2)) {
                    return n3;
                }
                ++n3;
            }
        }
        catch (Exception exception) {
            return -1;
        }
        return -1;
    }

    private static void setOption(String[] stringArray, int n) {
        switch (n) {
            case 1: {
                help = true;
                break;
            }
            case 2: {
                verbose = true;
                break;
            }
            case 3: {
                debug = true;
                break;
            }
            case 4: {
                graphics = true;
                break;
            }
            case 5: {
                String string;
                if (++pIdx >= stringArray.length) {
                    throw new Error("Directory expected");
                }
                sdir = string = Conf.toDirectory(stringArray[pIdx]);
                break;
            }
            case 6: {
                String string;
                if (++pIdx >= stringArray.length) {
                    throw new Error("Directory expected");
                }
                ddir = string = Conf.toDirectory(stringArray[pIdx]);
                break;
            }
            case 7: {
                if (++pIdx >= stringArray.length) {
                    throw new Error("File name expected");
                }
                logFile = stringArray[pIdx];
                break;
            }
            case 8: {
                clear = true;
                break;
            }
            default: {
                throw new Error("Invalid parameter.");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean setParameters(String[] stringArray) throws Exception {
        int n = 0;
        System.out.println(PROGRAM_DESC);
        pIdx = 0;
        while (pIdx < stringArray.length) {
            if (stringArray[pIdx].charAt(0) == '-') {
                int n2 = -1;
                int n3 = 0;
                while (n3 < OPTION_NAME.length) {
                    if (OPTION_NAME[n3].equalsIgnoreCase(stringArray[pIdx])) {
                        n2 = n3;
                        break;
                    }
                    ++n3;
                }
                if (n2 < 0) throw new Error("Invalid option " + stringArray[pIdx]);
                Conf.setOption(stringArray, OPTION_ENUM[n2]);
            } else {
                switch (n) {
                    case 0: {
                        inFile = stringArray[pIdx];
                        break;
                    }
                    case 1: {
                        outFile = stringArray[pIdx];
                        break;
                    }
                    default: {
                        throw new Error("Invalid parameter " + stringArray[pIdx]);
                    }
                }
                ++n;
            }
            ++pIdx;
        }
        if (n == 0) {
            System.out.print(PARAM_HELP);
            return false;
        }
        log = new PrintWriter((Writer)new BufferedWriter(new FileWriter(String.valueOf(ddir) + logFile)), false);
        return true;
    }

    private static String toDirectory(String string) {
        int n = string.length();
        if (string.charAt(n - 1) == '/') {
            return string;
        }
        return String.valueOf(string) + '/';
    }
}

