-------------------------------------------------------------------------------
-- Title      : Distributed Arithmetic Lookup table     
-- Project    : Arithmetic blocks
-------------------------------------------------------------------------------
-- File        : dalut.VHD
-- Author      : Jamil Khatib  
-- Organization: OpenIPCore Project
-- Created     : 2000/04/17
-- Last update : 2000/04/17
-- Platform    : 
-- Simulators  : Modelsim 5.3XE / Windows98
-- Synthesizers: Leonardo / WindowsNT
-- Target      : 
-- Dependency  : mempkg and dapkg
-------------------------------------------------------------------------------
-- Description: Distributed Arithmetic Lookup table 
-------------------------------------------------------------------------------
-- Copyright (c) 2000 Jamil Khatib
-- 
-- This VHDL design file is an open design; you can redistribute it and/or
-- modify it and/or implement it under the terms of the Openip General Public
-- License as it is going to be published by the OpenIPCore Organization and
-- any coming versions of this license.
-- You can check the draft license at
-- http://www.openip.org/oc/license.html

-------------------------------------------------------------------------------
-- Revisions  :
-- Revision Number :   1
-- Version         :   0.1
-- Date            :   17th Apr 2000
-- Modifier        :   Jamil Khatib (khatib@ieee.org)
-- Desccription    :   Created
--
-------------------------------------------------------------------------------

library ieee;
use ieee.std_logic_1164.all;
use work.dapkg.all;

entity DALUT is

  generic (
    ADDR_SIZE   : integer := BUFFER_SIZE;
                                        -- LUT address size or number of input terms
    OUTPUT_SIZE : integer := DATA_SIZE;  -- Output size
    CONTENTS    : TABLE  --:= ("1111", "1110", "1101", "1100", "1011", "1010", "1001", "1000", "0111", "0110", "0101", "0100", "0011", "0010", "0001", "0000")  --
    -- These values should be generated automaticlly from the original
    -- constants of the filter

    );

  port (
    Address : in  std_logic_vector(ADDR_SIZE -1 downto 0);     -- DALUT Address
    Result  : out std_logic_vector(OUTPUT_SIZE -1 downto 0));  -- Result

end DALUT;

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;
use ieee.std_logic_arith.all;

use work.mempkg.all;



use work.dapkg.all;

architecture structure of DALUT is

  constant DALUTtable : TABLE := CONTENTS;
begin  -- structure

  Result <= DALUTtable(SLV_2_int(Address));

end structure;



