-------------------------------------------------------------------------------
-- Title      :Distributed Arithmetic Package
-- Project    : Arithmetic blocks
-------------------------------------------------------------------------------
-- File        : DApkg.VHD
-- Author      : Jamil Khatib  
-- Organization: OpenIPCore Project
-- Created     : 2000/04/17
-- Last update : 2000/04/17
-- Platform    : 
-- Simulators  : Modelsim 5.3XE / Windows98
-- Synthesizers: Leonardo / WindowsNT
-- Target      : 
-- Dependency  : 
-------------------------------------------------------------------------------
-- Description: Distributed Arithmetic Package
-------------------------------------------------------------------------------
-- Copyright (c) 2000 Jamil Khatib
-- 
-- This VHDL design file is an open design; you can redistribute it and/or
-- modify it and/or implement it under the terms of the Openip General Public
-- License as it is going to be published by the OpenIPCore Organization and
-- any coming versions of this license.
-- You can check the draft license at
-- http://www.openip.org/oc/license.html

-------------------------------------------------------------------------------
-- Revisions  :
-- Revision Number :   1
-- Version         :   0.1
-- Date            :   17th Apr 2000
-- Modifier        :   Jamil Khatib (khatib@ieee.org)
-- Desccription    :   Created
--
-------------------------------------------------------------------------------
-- Revisions  :
-- Revision Number :   2
-- Version         :   0.2
-- Date            :   30h Apr 2000
-- Modifier        :   Jamil Khatib (khatib@ieee.org)
-- Desccription    :   defining the constant CONSTANTS for DALUT contents
--					   which should be genrated automatically in later versions
--
-------------------------------------------------------------------------------


library ieee;
use ieee.std_logic_1164.all;

package DApkg is
  constant BUFFER_SIZE : integer := 4;  -- No. of inputs, No of filter taps,
                                        -- No. of constants , Buffer Size
  constant DATA_SIZE   : integer := 8;  -- Word size

  type TABLE is array ( 0 to (2**BUFFER_SIZE) -1) of std_logic_vector((DATA_SIZE -1 ) downto 0);
                                        -- Memory type
  constant CONSTANTS : TABLE := ("00000000", "00000001", "00000000", "00000001",
                                 "00000000", "00000001", "00000000", "00000001",
                                 "00000001", "00000010", "00000001", "00000010",
                                 "00000001", "00000010", "00000001", "00000010");
  -- Constants table
-------------------------------------------------------------------------------
-- DA filter top core

  component DA
    generic (
      NOINPUTS  :     integer := BUFFER_SIZE;  -- number of inputs, no. of filter tabs
      WORD_SIZE :     integer := DATA_SIZE;  -- word size
      CONTENTS  :     TABLE   := CONSTANTS);
    port (
      data      : in  std_logic_vector(WORD_SIZE -1 downto 0);  -- input data
      Clk       : in  std_logic;        -- system clock
      Rst_n     : in  std_logic;        -- System reset
      Result    : out std_logic_vector(WORD_SIZE -1 downto 0);  -- Result
      ValidOut  : out std_logic;        -- Output valid
      Overflow  : out std_logic);       -- Overflow signal
  end component;
-------------------------------------------------------------------------------
-- DALUT Distributed Arithmetic Lookup table

  component DALUT
    generic (
      ADDR_SIZE   : integer;                   --:= BUFFER_SIZE;
      -- LUT address size or number of input terms
      OUTPUT_SIZE : integer;  --:= DATA_SIZE;  -- Output size
      CONTENTS    : TABLE                      -- CONSTANTS
      -- These values should be generated automaticlly from the original
      -- constants of the filter

      );

    port (
      Address : in  std_logic_vector(ADDR_SIZE -1 downto 0);  -- DALUT Address
      Result  : out std_logic_vector(OUTPUT_SIZE -1 downto 0));  -- Result

  end component;

  ------------------------------------------------------------------------------
  -- Scaling MAC
  component ScalMAC
    generic (
      OPSIZE : integer );  --:= BUFFER_SIZE);  -- Operand size


    port (
      Op1 : in  std_logic_vector(OPSIZE - 1 downto 0);  -- Operand 1
      Op2 : in  std_logic_vector(OPSIZE - 1 downto 0);  -- Operand 2
      Res : out std_logic_vector(OPSIZE -1 downto 0);   -- Result

      Overflow : out std_logic;         -- Overflow
      ValidOut : out std_logic;         -- valid output active high
      clk      : in  std_logic;         -- system clock positive edge
      rst_n    : in  std_logic);        -- system reset active low

  end component;

-------------------------------------------------------------------------------
  -- Scalling adder
  component ScaleAddr
    generic (
      OPSIZE : integer );  --:= BUFFER_SIZE);  -- Operand size


    port (
      Op  : in  std_logic_vector(OPSIZE - 1 downto 0);  -- Operand
      Res : out std_logic_vector(OPSIZE -1 downto 0);   -- Result

      Overflow : out std_logic;         -- Overflow
      ValidOut : out std_logic;         -- valid output active high
      clk      : in  std_logic;         -- system clock positive edge
      rst_n    : in  std_logic);        -- system reset active low

  end component;


end DApkg;
package body DApkg is




end DApkg;








