/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.tr;

import com.jclark.xsl.conv.NumberListFormat;
import com.jclark.xsl.expr.DescendantsOrSelfNodeIterator;
import com.jclark.xsl.expr.Pattern;
import com.jclark.xsl.om.Name;
import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.XSLException;
import com.jclark.xsl.tr.Action;
import com.jclark.xsl.tr.NumberListFormatTemplate;
import com.jclark.xsl.tr.ProcessContext;
import com.jclark.xsl.tr.Result;
import java.util.Hashtable;

class AnyLevelNumberAction
implements Action {
    private Pattern count;
    private Pattern from;
    private NumberListFormatTemplate formatTemplate;

    AnyLevelNumberAction(Pattern pattern, Pattern pattern2, NumberListFormatTemplate numberListFormatTemplate) {
        this.count = pattern;
        this.from = pattern2;
        this.formatTemplate = numberListFormatTemplate;
    }

    public void invoke(ProcessContext processContext, Node node, Result result) throws XSLException {
        Cache cache;
        NumberListFormat numberListFormat = this.formatTemplate.instantiate(processContext, node);
        Node node2 = node.getRoot();
        Hashtable<Node, Object> hashtable = (Hashtable<Node, Object>)processContext.get(this);
        if (hashtable == null) {
            hashtable = new Hashtable<Node, Object>();
            processContext.put(this, hashtable);
        }
        if (this.count != null) {
            cache = (Cache)hashtable.get(node2);
            if (cache == null) {
                Node node3;
                cache = new Cache();
                hashtable.put(node2, cache);
                int n = 0;
                DescendantsOrSelfNodeIterator descendantsOrSelfNodeIterator = new DescendantsOrSelfNodeIterator(node2);
                while ((node3 = descendantsOrSelfNodeIterator.next()) != null) {
                    if (this.from != null && this.from.matches(node3, processContext)) {
                        n = 0;
                        continue;
                    }
                    if (!this.count.matches(node3, processContext)) continue;
                    cache.append(node3, n++);
                }
            }
        } else if (node.getType() == 0) {
            Name name;
            Hashtable<Name, Cache> hashtable2 = (Hashtable<Name, Cache>)hashtable.get(node2);
            if (hashtable2 == null) {
                hashtable2 = new Hashtable<Name, Cache>();
                hashtable.put(node2, hashtable2);
            }
            if ((cache = (Cache)hashtable2.get(name = node.getName())) == null) {
                Node node4;
                cache = new Cache();
                hashtable2.put(name, cache);
                int n = 0;
                DescendantsOrSelfNodeIterator descendantsOrSelfNodeIterator = new DescendantsOrSelfNodeIterator(node2);
                while ((node4 = descendantsOrSelfNodeIterator.next()) != null) {
                    if (this.from != null && this.from.matches(node4, processContext)) {
                        n = 0;
                        continue;
                    }
                    if (!name.equals(node4.getName()) || node4.getType() != 0) continue;
                    cache.append(node4, n++);
                }
            }
        } else {
            return;
        }
        result.characters(numberListFormat.getPrefix(0));
        result.characters(numberListFormat.formatNumber(0, cache.getNumber(node)));
        result.characters(numberListFormat.getSuffix());
    }

    static final class Cache {
        Node[] nodes = new Node[10];
        int[] numbers;
        int used = 0;

        Cache() {
        }

        private void append(Node node, int n) {
            if (this.used == this.nodes.length) {
                Node[] nodeArray = this.nodes;
                this.nodes = new Node[nodeArray.length * 2];
                System.arraycopy(nodeArray, 0, this.nodes, 0, nodeArray.length);
                if (this.numbers != null) {
                    int[] nArray = this.numbers;
                    this.numbers = new int[nArray.length * 2];
                    System.arraycopy(nArray, 0, this.numbers, 0, nArray.length);
                }
            }
            this.nodes[this.used] = node;
            if (this.numbers != null) {
                this.numbers[this.used] = n;
            } else if (n != this.used) {
                this.numbers = new int[this.nodes.length];
                int n2 = 0;
                while (n2 < this.used) {
                    this.numbers[n2] = n2;
                    ++n2;
                }
                this.numbers[this.used] = n;
            }
            ++this.used;
        }

        private int numberOf(int n) {
            if (this.numbers == null) {
                return n + 1;
            }
            return this.numbers[n] + 1;
        }

        int getNumber(Node node) {
            int n = 0;
            int n2 = this.used;
            while (n != n2) {
                int n3 = n + n2 >> 1;
                int n4 = node.compareTo(this.nodes[n3]);
                if (n4 == 0) {
                    return this.numberOf(n3);
                }
                if (n4 < 0) {
                    n2 = n3;
                    continue;
                }
                n = n3;
            }
            if (n == 0) {
                return 0;
            }
            return this.numberOf(n - 1);
        }
    }
}

