/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.sax;

import com.jclark.xsl.om.Name;
import com.jclark.xsl.sax.CommentHandler;
import com.jclark.xsl.sax.RawCharactersHandler;
import com.jclark.xsl.sax.ResultBase;
import com.jclark.xsl.tr.OutputMethod;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

class OutputMethodDefaulter
implements DocumentHandler,
CommentHandler,
RawCharactersHandler {
    private final ResultBase result;
    private final OutputMethod outputMethod;
    private final Vector savedEvents = new Vector();
    private Locator locator;

    public void startDocument() {
    }

    public void endDocument() throws SAXException {
        this.getDocumentHandler(false).endDocument();
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        this.getDocumentHandler(string.equalsIgnoreCase("html") && attributeList.getValue("xmlns") == null).startElement(string, attributeList);
    }

    public void endElement(String string) {
        throw new Error("unbalanced call to endElement");
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        int n3 = 0;
        while (n3 < n2) {
            switch (cArray[n + n3]) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    break;
                }
                default: {
                    this.getDocumentHandler(false).characters(cArray, n, n2);
                    return;
                }
            }
            ++n3;
        }
        this.savedEvents.addElement(new CharactersEvent(cArray, n, n2));
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.savedEvents.addElement(new IgnorableWhitespaceEvent(cArray, n, n2));
    }

    public void comment(String string) {
        this.savedEvents.addElement(new CommentEvent(string));
    }

    public void processingInstruction(String string, String string2) {
        this.savedEvents.addElement(new ProcessingInstructionEvent(string, string2));
    }

    public void rawCharacters(String string) {
        this.savedEvents.addElement(new RawCharactersEvent(string));
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    OutputMethodDefaulter(ResultBase resultBase, OutputMethod outputMethod) {
        this.result = resultBase;
        this.outputMethod = outputMethod;
    }

    private DocumentHandler getDocumentHandler(boolean bl) throws SAXException {
        Name name = this.outputMethod.getNameTable().createName(bl ? "html" : "xml");
        try {
            DocumentHandler documentHandler = this.result.setOutputMethod(name, this.outputMethod);
            if (this.locator != null) {
                documentHandler.setDocumentLocator(this.locator);
            }
            documentHandler.startDocument();
            Enumeration enumeration = this.savedEvents.elements();
            while (enumeration.hasMoreElements()) {
                ((Event)enumeration.nextElement()).emit(documentHandler);
            }
            return documentHandler;
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    static class IgnorableWhitespaceEvent
    extends Event {
        private char[] buf;

        IgnorableWhitespaceEvent(char[] cArray, int n, int n2) {
            this.buf = new char[n2];
            System.arraycopy(cArray, n, this.buf, 0, n2);
        }

        void emit(DocumentHandler documentHandler) throws SAXException {
            documentHandler.ignorableWhitespace(this.buf, 0, this.buf.length);
        }
    }

    static class CharactersEvent
    extends Event {
        private char[] buf;

        CharactersEvent(char[] cArray, int n, int n2) {
            this.buf = new char[n2];
            System.arraycopy(cArray, n, this.buf, 0, n2);
        }

        void emit(DocumentHandler documentHandler) throws SAXException {
            documentHandler.characters(this.buf, 0, this.buf.length);
        }
    }

    static class RawCharactersEvent
    extends Event {
        private String chars;

        RawCharactersEvent(String string) {
            this.chars = string;
        }

        void emit(DocumentHandler documentHandler) throws SAXException {
            if (documentHandler instanceof RawCharactersHandler) {
                ((RawCharactersHandler)((Object)documentHandler)).rawCharacters(this.chars);
            } else {
                char[] cArray = this.chars.toCharArray();
                documentHandler.characters(cArray, 0, cArray.length);
            }
        }
    }

    static class CommentEvent
    extends Event {
        private String content;

        CommentEvent(String string) {
            this.content = string;
        }

        void emit(DocumentHandler documentHandler) throws SAXException {
            if (documentHandler instanceof CommentHandler) {
                ((CommentHandler)((Object)documentHandler)).comment(this.content);
            }
        }
    }

    static class ProcessingInstructionEvent
    extends Event {
        private String target;
        private String content;

        ProcessingInstructionEvent(String string, String string2) {
            this.target = string;
            this.content = string2;
        }

        void emit(DocumentHandler documentHandler) throws SAXException {
            documentHandler.processingInstruction(this.target, this.content);
        }
    }

    static abstract class Event {
        Event() {
        }

        abstract void emit(DocumentHandler var1) throws SAXException;
    }
}

