/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.sax;

import com.jclark.xsl.sax.FileDescriptorDestination;
import com.jclark.xsl.sax.FileDestination;
import com.jclark.xsl.sax.GenericDestination;
import com.jclark.xsl.sax.OutputMethodHandlerImpl;
import com.jclark.xsl.sax.XMLProcessorEx;
import com.jclark.xsl.sax.XSLProcessor;
import com.jclark.xsl.sax.XSLProcessorImpl;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Driver {
    public static void main(String[] stringArray) {
        File file;
        XSLProcessorImpl xSLProcessorImpl = new XSLProcessorImpl();
        Driver.setParser(xSLProcessorImpl);
        xSLProcessorImpl.setErrorHandler(new ErrorHandlerImpl());
        int n = 0;
        int n2 = 0;
        while (n2 < stringArray.length) {
            int n3 = stringArray[n2].indexOf(61);
            if (n3 > 0) {
                xSLProcessorImpl.setParameter(stringArray[n2].substring(0, n3), stringArray[n2].substring(n3 + 1));
            } else {
                stringArray[n++] = stringArray[n2];
            }
            ++n2;
        }
        if (n != 2 && n != 3) {
            System.err.println("usage: java com.jclark.xsl.sax.Driver source stylesheet [result] [param=value]...");
            System.exit(1);
        }
        OutputMethodHandlerImpl outputMethodHandlerImpl = new OutputMethodHandlerImpl(xSLProcessorImpl);
        xSLProcessorImpl.setOutputMethodHandler(outputMethodHandlerImpl);
        boolean bl = true;
        File file2 = new File(stringArray[0]);
        File file3 = new File(stringArray[1]);
        File file4 = file = n == 3 ? new File(stringArray[2]) : null;
        if (!file2.isDirectory()) {
            bl = Driver.transformFile(xSLProcessorImpl, outputMethodHandlerImpl, file2, file3, file);
        } else {
            String[] stringArray2 = file2.list();
            int n4 = 0;
            while (n4 < stringArray2.length) {
                File file5 = new File(file2, stringArray2[n4]);
                if (!file5.isDirectory()) {
                    if (!file3.isDirectory()) {
                        if (!Driver.transformFile(xSLProcessorImpl, outputMethodHandlerImpl, file5, file3, new File(file, stringArray2[n4]))) {
                            bl = false;
                        }
                    } else {
                        int n5 = stringArray2[n4].lastIndexOf(46);
                        File file6 = new File(file3, n5 < 0 ? stringArray2[n4] : stringArray2[n4].substring(0, n5) + ".xsl");
                        if (file6.exists() && !Driver.transformFile(xSLProcessorImpl, outputMethodHandlerImpl, file5, file6, new File(file, stringArray2[n4]))) {
                            bl = false;
                        }
                    }
                }
                ++n4;
            }
        }
        if (!bl) {
            System.exit(1);
        }
    }

    static boolean transformFile(XSLProcessor xSLProcessor, OutputMethodHandlerImpl outputMethodHandlerImpl, File file, File file2, File file3) {
        GenericDestination genericDestination = file3 == null ? new FileDescriptorDestination(FileDescriptor.out) : new FileDestination(file3);
        outputMethodHandlerImpl.setDestination(genericDestination);
        return Driver.transform(xSLProcessor, Driver.fileInputSource(file2), Driver.fileInputSource(file));
    }

    static boolean transform(XSLProcessor xSLProcessor, InputSource inputSource, InputSource inputSource2) {
        try {
            xSLProcessor.loadStylesheet(inputSource);
            xSLProcessor.parse(inputSource2);
            return true;
        }
        catch (SAXParseException sAXParseException) {
            Driver.printSAXParseException(sAXParseException);
        }
        catch (SAXException sAXException) {
            System.err.println(sAXException.getMessage());
        }
        catch (IOException iOException) {
            System.err.println(iOException.toString());
        }
        return false;
    }

    static void printSAXParseException(SAXParseException sAXParseException) {
        String string = sAXParseException.getSystemId();
        int n = sAXParseException.getLineNumber();
        if (string != null) {
            System.err.print(string + ":");
        }
        if (n >= 0) {
            System.err.print(n + ":");
        }
        if (string != null || n >= 0) {
            System.err.print(" ");
        }
        System.err.println(sAXParseException.getMessage());
    }

    static void setParser(XSLProcessorImpl xSLProcessorImpl) {
        String string = System.getProperty("com.jclark.xsl.sax.parser");
        if (string == null) {
            string = System.getProperty("org.xml.sax.parser");
        }
        if (string == null) {
            string = "com.jclark.xml.sax.CommentDriver";
        }
        try {
            Object obj = Class.forName(string).newInstance();
            if (obj instanceof XMLProcessorEx) {
                xSLProcessorImpl.setParser((XMLProcessorEx)obj);
            } else {
                xSLProcessorImpl.setParser((Parser)obj);
            }
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println(classNotFoundException.toString());
        }
        catch (InstantiationException instantiationException) {
            System.err.println(instantiationException.toString());
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println(illegalAccessException.toString());
        }
        catch (ClassCastException classCastException) {
            System.err.println(string + " is not a SAX driver");
        }
        System.exit(1);
    }

    public static InputSource fileInputSource(String string) {
        return Driver.fileInputSource(new File(string));
    }

    public static InputSource fileInputSource(File file) {
        String string = file.getAbsolutePath();
        String string2 = System.getProperty("file.separator");
        if (string2 != null && string2.length() == 1) {
            string = string.replace(string2.charAt(0), '/');
        }
        if (string.length() > 0 && string.charAt(0) != '/') {
            string = '/' + string;
        }
        try {
            return new InputSource(new URL("file", "", string).toString());
        }
        catch (MalformedURLException malformedURLException) {
            throw new Error("unexpected MalformedURLException");
        }
    }

    static class ErrorHandlerImpl
    implements ErrorHandler {
        ErrorHandlerImpl() {
        }

        public void warning(SAXParseException sAXParseException) {
            Driver.printSAXParseException(sAXParseException);
        }

        public void error(SAXParseException sAXParseException) {
            Driver.printSAXParseException(sAXParseException);
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }
    }
}

