/*
 * Decompiled with CFR 0.152.
 */
package stardiv.controller;

import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class PropertyEditor
extends Dialog
implements ItemListener,
ActionListener,
TextListener {
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    static final String FILENAME = "staroffice.properties";
    static final char DELEMITER = ' ';
    static Vector c_DefaultProperties = null;
    Properties m_Properties = new Properties();
    List m_DefaultList = new List();
    List m_List = new List();
    TextField m_KeyInput = new TextField();
    TextField m_ValueInput = new TextField();
    Button m_SetButton = new Button("   set   ");
    Button m_DeleteButton = new Button("  delete  ");
    Button m_OkButton = new Button("   OK   ");
    char[] m_Delemiters = new char[0];

    public PropertyEditor(Frame frame) {
        super(frame, "Java Property Editor");
        Panel panel = new Panel(new GridBagLayout());
        panel.setBackground(Color.lightGray);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.m_DefaultList.setBackground(Color.white);
        panel.add((Component)this.m_DefaultList, gridBagConstraints);
        this.m_List.setBackground(Color.white);
        panel.add((Component)this.m_List, gridBagConstraints);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = -1;
        panel.add((Component)new Label("variable:"), gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        this.m_KeyInput.setBackground(Color.white);
        panel.add((Component)this.m_KeyInput, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = -1;
        panel.add((Component)new Label("value:"), gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        this.m_ValueInput.setBackground(Color.white);
        panel.add((Component)this.m_ValueInput, gridBagConstraints);
        Panel panel2 = new Panel(new FlowLayout(1, 10, 0));
        panel2.add(this.m_SetButton);
        panel2.add(this.m_DeleteButton);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.insets = new Insets(10, 10, 10, 0);
        panel.add((Component)this.m_OkButton, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 13;
        panel.add((Component)panel2, gridBagConstraints);
        this.add(panel);
        Font font = new Font("Courier", 0, 10);
        this.m_List.setFont(font);
        this.m_DefaultList.setFont(font);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                PropertyEditor.this.setVisible(false);
            }
        });
        this.m_KeyInput.addTextListener(this);
        this.m_ValueInput.addTextListener(this);
        this.m_ValueInput.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\\') {
                    int n = PropertyEditor.this.m_ValueInput.getCaretPosition();
                    PropertyEditor.this.m_ValueInput.setText(PropertyEditor.this.m_ValueInput.getText().substring(0, n) + "\\" + PropertyEditor.this.m_ValueInput.getText().substring(n));
                    PropertyEditor.this.m_ValueInput.setCaretPosition(++n);
                }
            }
        });
        this.m_SetButton.setEnabled(false);
        this.m_DeleteButton.setEnabled(false);
        this.m_OkButton.addActionListener(this);
        this.m_SetButton.addActionListener(this);
        this.m_DeleteButton.addActionListener(this);
        this.m_List.addItemListener(this);
        this.setSize(500, 600);
    }

    public void setVisible(boolean bl) {
        if (bl) {
            try {
                this.m_Properties = System.getProperties();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.actualizeDelemiterArray();
            this.m_DefaultList.removeAll();
            this.m_List.removeAll();
            Enumeration<?> enumeration = this.m_Properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (PropertyEditor.isDefaultKey(string)) {
                    this.addToList(this.m_DefaultList, string, this.m_Properties.getProperty(string));
                    continue;
                }
                this.addToList(this.m_List, string, this.m_Properties.getProperty(string));
            }
        }
        super.setVisible(bl);
    }

    protected void actualizeDelemiterArray() {
        int n = PropertyEditor.getMaxKeyLength(this.m_Properties);
        if (n != this.m_Delemiters.length) {
            this.m_Delemiters = new char[n];
            int n2 = 0;
            while (n2 < n) {
                this.m_Delemiters[n2] = 32;
                ++n2;
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        String string = this.m_List.getSelectedItem();
        if (string != null) {
            String[] stringArray = this.getKeyValue(string);
            this.m_KeyInput.setText(stringArray[0]);
            this.m_ValueInput.setText(stringArray[1]);
        } else {
            this.m_KeyInput.setText("");
            this.m_ValueInput.setText("");
        }
    }

    protected String[] getKeyValue(String string) {
        String[] stringArray = new String[]{"", ""};
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        if (stringTokenizer.hasMoreTokens()) {
            stringArray[0] = stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            stringArray[1] = stringTokenizer.nextToken();
        }
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[1] = stringArray[1] + " " + stringTokenizer.nextToken();
        }
        return stringArray;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.m_OkButton) {
            this.setVisible(false);
        } else {
            this.m_KeyInput.setText(this.m_KeyInput.getText().trim());
            this.m_ValueInput.setText(this.m_ValueInput.getText().trim());
            if (PropertyEditor.isDefaultKey(this.m_KeyInput.getText())) {
                return;
            }
            Properties properties = (Properties)this.m_Properties.clone();
            if (actionEvent.getSource() == this.m_SetButton) {
                properties.put(this.m_KeyInput.getText(), PropertyEditor.convertOutToString(this.m_ValueInput.getText()));
            } else if (actionEvent.getSource() == this.m_DeleteButton) {
                properties.remove(this.m_KeyInput.getText());
            }
            try {
                System.setProperties(properties);
                this.m_Properties = properties;
                this.saveProperties();
                if (actionEvent.getSource() == this.m_SetButton) {
                    String[] stringArray = this.m_List.getItems();
                    int n = -1;
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        if (stringArray[n2].startsWith(this.m_KeyInput.getText() + ' ')) {
                            n = n2;
                        }
                        ++n2;
                    }
                    if (n != -1) {
                        this.m_List.replaceItem(this.createListItem(this.m_KeyInput.getText(), PropertyEditor.convertOutToString(this.m_ValueInput.getText())), n);
                    } else {
                        n = this.addToList(this.m_List, this.m_KeyInput.getText(), this.m_ValueInput.getText());
                    }
                    this.m_List.select(n);
                } else if (actionEvent.getSource() == this.m_DeleteButton) {
                    String[] stringArray = this.m_List.getItems();
                    int n = 0;
                    while (n < stringArray.length) {
                        if (stringArray[n].startsWith(this.m_KeyInput.getText() + ' ')) {
                            this.m_List.remove(n);
                        }
                        ++n;
                    }
                }
                this.updateDelemiters();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setButtons();
        }
    }

    public void textValueChanged(TextEvent textEvent) {
        this.setButtons();
    }

    protected void setButtons() {
        if (!this.m_KeyInput.getText().trim().equals("") && this.m_KeyInput.getText().trim().indexOf(32, 0) == -1 && !PropertyEditor.isDefaultKey(this.m_KeyInput.getText().trim())) {
            try {
                if (System.getProperty(this.m_KeyInput.getText()) == null) {
                    throw new Exception();
                }
                this.m_DeleteButton.setEnabled(true);
            }
            catch (Exception exception) {
                this.m_DeleteButton.setEnabled(false);
            }
            this.m_SetButton.setEnabled(!this.m_ValueInput.getText().trim().equals(""));
        } else {
            this.m_DeleteButton.setEnabled(false);
            this.m_SetButton.setEnabled(false);
        }
    }

    protected int addToList(List list, String string, String string2) {
        String[] stringArray = list.getItems();
        String string3 = this.createListItem(string, string2);
        int n = 0;
        while (n < stringArray.length && stringArray[n].compareTo(string3) < 0) {
            ++n;
        }
        list.addItem(string3, n);
        return n;
    }

    protected void updateDelemiters() {
        int n = PropertyEditor.getMaxKeyLength(this.m_Properties);
        if (n != this.m_Delemiters.length) {
            this.actualizeDelemiterArray();
            this.updateDelemiters(n, this.m_List);
        }
    }

    protected void updateDelemiters(int n, List list) {
        list.setVisible(false);
        String[] stringArray = list.getItems();
        int n2 = 0;
        while (n2 < stringArray.length) {
            String[] stringArray2 = this.getKeyValue(stringArray[n2]);
            list.replaceItem(this.createListItem(stringArray2[0], stringArray2[1]), n2);
            ++n2;
        }
        list.setVisible(true);
    }

    protected String createListItem(String string, String string2) {
        char[] cArray = null;
        if (this.m_Delemiters.length - string.length() > 0) {
            cArray = new char[this.m_Delemiters.length - string.length()];
            int n = 0;
            while (n < this.m_Delemiters.length - string.length()) {
                cArray[n] = 32;
                ++n;
            }
        } else {
            cArray = new char[]{' '};
        }
        return string + new String(cArray) + PropertyEditor.convertStringToOut(string2);
    }

    protected static String convertStringToOut(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case '\\': {
                    stringBuffer.append('\\');
                    stringBuffer.append('\\');
                    break;
                }
                case '\t': {
                    stringBuffer.append('\\');
                    stringBuffer.append('t');
                    break;
                }
                case '\n': {
                    stringBuffer.append('\\');
                    stringBuffer.append('n');
                    break;
                }
                case '\r': {
                    stringBuffer.append('\\');
                    stringBuffer.append('r');
                    break;
                }
                default: {
                    if (c < ' ' || c >= '\u007f') {
                        stringBuffer.append('\\');
                        stringBuffer.append('u');
                        stringBuffer.append(PropertyEditor.toHex(c >> 12 & 0xF));
                        stringBuffer.append(PropertyEditor.toHex(c >> 8 & 0xF));
                        stringBuffer.append(PropertyEditor.toHex(c >> 4 & 0xF));
                        stringBuffer.append(PropertyEditor.toHex(c >> 0 & 0xF));
                        break;
                    }
                    stringBuffer.append(c);
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    protected static String convertOutToString(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        if (string.length() > 1) {
            int n = 0;
            char c = string.charAt(0);
            while (n < string.length() - 1) {
                char c2 = string.charAt(++n);
                if (c == '\\') {
                    if (c2 == '\\') {
                        stringBuffer.append('\\');
                    } else if (c2 == 't') {
                        stringBuffer.append('\t');
                    } else if (c2 == 'n') {
                        stringBuffer.append('\n');
                    } else if (c2 == 'r') {
                        stringBuffer.append('\r');
                    } else if (c2 == 'u') {
                        if (n + 5 <= string.length()) {
                            int n2 = PropertyEditor.hexToInt(string.substring(n + 1, n + 5));
                            if (n2 != -1) {
                                stringBuffer.append((char)n2);
                                c2 = string.charAt(n += 4);
                            } else {
                                stringBuffer.append("\\");
                            }
                        } else {
                            stringBuffer.append("\\u");
                        }
                    } else {
                        stringBuffer.append('\\');
                        stringBuffer.append(c2);
                    }
                    c2 = string.charAt(++n);
                } else {
                    stringBuffer.append(c);
                }
                c = c2;
                if (n != string.length() - 1) continue;
                stringBuffer.append(c);
            }
        } else {
            return string;
        }
        return stringBuffer.toString();
    }

    protected static int hexToInt(String string) {
        if (string.length() != 4) {
            return -1;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < 4) {
            char c = string.charAt(n2);
            if (c >= 'A' && c <= 'Z') {
                n = (int)((double)n + (double)(c - 65 + 10) * Math.pow(16.0, 3 - n2));
            } else if (c >= 'a' && c <= 'f') {
                n = (int)((double)n + (double)(c - 97 + 10) * Math.pow(16.0, 3 - n2));
            } else if (c >= '0' && c <= '9') {
                n = (int)((double)n + (double)(c - 48) * Math.pow(16.0, 3 - n2));
            } else {
                return -1;
            }
            ++n2;
        }
        return n;
    }

    private static char toHex(int n) {
        return hexDigit[n & 0xF];
    }

    protected static int getMaxKeyLength(Properties properties) {
        int n = 0;
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            n = Math.max(n, ((String)enumeration.nextElement()).length());
        }
        return n + 2;
    }

    protected static boolean isDefaultKey(String string) {
        Enumeration enumeration = c_DefaultProperties.elements();
        while (enumeration.hasMoreElements()) {
            if (!string.equals((String)enumeration.nextElement())) continue;
            return true;
        }
        return false;
    }

    protected void saveProperties() {
        Properties properties = new Properties();
        Enumeration<?> enumeration = this.m_Properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (PropertyEditor.isDefaultKey(string)) continue;
            properties.put(string, this.m_Properties.getProperty(string));
        }
        try {
            PropertyEditor.saveProperties(properties, System.getProperty("java.home"));
            return;
        }
        catch (Exception exception) {
            try {
                PropertyEditor.saveProperties(properties, System.getProperty("user.home"));
                return;
            }
            catch (Exception exception2) {
                return;
            }
        }
    }

    protected static void saveProperties(Properties properties, String string) throws IOException {
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        string = string + FILENAME;
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        properties.save(fileOutputStream, "properties");
        fileOutputStream.flush();
        fileOutputStream.close();
    }

    private static void initializeProperties() {
        Object object;
        if (c_DefaultProperties == null) {
            c_DefaultProperties = new Vector();
            try {
                object = System.getProperties().propertyNames();
                while (object.hasMoreElements()) {
                    c_DefaultProperties.addElement(object.nextElement());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        object = new Properties();
        try {
            PropertyEditor.loadProperties((Properties)object, System.getProperty("user.home"));
        }
        catch (Exception exception) {
            try {
                PropertyEditor.loadProperties((Properties)object, System.getProperty("java.home"));
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        Properties properties = new Properties();
        try {
            properties = (Properties)System.getProperties().clone();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Enumeration<?> enumeration = ((Properties)object).propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (PropertyEditor.isDefaultKey(string)) continue;
            properties.put(string, ((Properties)object).get(string));
        }
        System.setProperties(properties);
    }

    protected static void loadProperties(Properties properties, String string) throws IOException, ClassNotFoundException {
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        string = string + FILENAME;
        FileInputStream fileInputStream = new FileInputStream(string);
        properties.load(fileInputStream);
        fileInputStream.close();
    }

    public static void main(String[] stringArray) {
        PropertyEditor.initializeProperties();
        Frame frame = new Frame();
        PropertyEditor propertyEditor = new PropertyEditor(frame);
        propertyEditor.setVisible(true);
    }
}

