// install.js
// original code by Patrick Callahan
// modified by Chris Walcott
//
// installer for win16, win32 and MacPPC
//
// specific shockwave comments - search for this: **sw**
// all changing variables are listed at the end of this script 
// and are marked with **sw**

function fileInfoObject(fileName, fileDestFolder, fileSourcePath, fileVersion, fileLocalPath ) {
        this.fileName = fileName ;
        this.fileDestFolder = fileDestFolder ;
        this.fileVersion = fileVersion;  
		this.fileLocalPath = fileLocalPath ;
		}


function setupWindows()

 {

// just for clienteng release

	wndw= window.open("","installer","toolbar=0,menubar=0,status=0,directories=0,location=0,scrollbars=0,resizable=0,width=480,height=280,top=50,left=100");

// get the users' screen size

	ScreenSize();  // another object made by us (See Below).
	wndw.moveTo(width/2-250, height/2-200);          //center the window now that we know the dims.
	wndw.document.open("text/html");       //open a window that has the text/html mime type.
	wndw.document.close() ;  // flush to window.

// WRITE OUT THE HTML TO THE WINDOW, CREATING THE FRAMESET

	line = "<TITLE>"+topWindowTitle+"</TITLE><FRAMESET ROWS='50%, 50%' border=0 frameborder='no' marginwidth=0><FRAME SRC='about:blank' NAME='TOP'> <FRAME SRC='about:blank' NAME='BOTTOM'></FRAMESET>" ;
	wndw.document.write(line);
	wndw.document.close() ;  // flush to window.

// an effort to clean the window of background info.

	wndw.frames[0].document.write("<center><br><br><h3></h3></center>") ;
	wndw.frames[0].document.close() ;  //clean the window first.

	wndw.frames[1].document.write("<center><br><br><h3></h3></center>") 
	wndw.frames[1].document.close() ;  //clean the window first.

// put text into the window first, then update it with a graphic.
// **sw** Made With Macromedia logo.
	line="<HTML><BODY><CENTER><IMG SRC=http://www.macromedia.com/images/mwm.small.gif><H4>"+topWindowTitle+"</H4></CENTER></BODY></HTML>";
	wndw.frames[0].document.close() ;  //clean the window first.
	wndw.frames[0].document.write(line) ;
	updateStatusText(hSize, defaultText, 3, false, normalGraphic) ;

 }


function delay(amount) {
	// init the values
	var time = new Date() ;
	var seconds = time.getSeconds() ;
	var startCount = 80 ;
	var newSeconds = 70 ;
	//-------------------
	startCount = (seconds + amount ) % 60 ;
	time = new Date() ;
	newSeconds = time.getSeconds() ;
	while (newSeconds != startCount ) {
		time = new Date() ;
		newSeconds = time.getSeconds() ;
		}
 }



function ScreenSize()
{
      if (navigator.javaEnabled())    // if Enable Java checkbox is checked then we can do the rest...
      {
         var tools=java.awt.Toolkit.getDefaultToolkit(); // tools object now exists and we can use 'em
         var size=tools.getScreenSize();	// Identify the users' screen size.
         width=size.width;					//on-the-fly declaration of global variable width
         height=size.height;				//on-the-fly declaration of global variable height
      }
}

function checkJava() 
{ 
	javaOn = navigator.javaEnabled() ; //check to see if java is enabled - nothing here works without it. 
	if (javaOn == false)  
	{  
		alert("You do not have java turned on, please enable Java, restart, and try again") ;  
		return false ;  
	} 
	return true ; 
}

function checkASD() 
{ 
	SUEnabled = netscape.softupdate.Trigger.UpdateEnabled() ;  // SmartUpdate won't work without it being on. 
	if (SUEnabled == false)  
	{  
		alert("AutoInstall is not turned on in Advanced Preferences, please enable it, restart, and try again") ;  
		return false ;  
	} 
	return true ; 
} 


function updateStatusText(hSize, text, delayTime, debugState, graphic )
//  we do not use error graphics.  nothing to cange here.
{
		if (debugState == true) {
			java.lang.System.out.println(text) ;		
			}
		if (!silentValue) {
			wndw.frames[1].document.close() ;
			line="<HTML><BODY><CENTER><FONT FACE='Arial, Helvetica' SIZE=5 COLOR=BLUE><BR><H"+hSize+">"+text+"</H"+hSize+"><BR></CENTER></BODY></HTML>";
			wndw.frames[1].document.close() ;  //clean the window first.
			wndw.frames[1].document.write(line) ;
			wndw.frames[1].document.close() ;  //clean the window first.

			if (graphic != "") {
				if (graphic == normalGraphic)
					line="<HTML><BODY><CENTER><IMG WIDTH=360 SRC="+graphic+"></CENTER></BODY></HTML>" ;
				if (graphic == errorGraphic)
					line="<HTML><BODY><CENTER><IMG HEIGHT=100 SRC="+graphic+"></CENTER></BODY></HTML>" ;
				
				}

			if (delayTime != 0)	delay(delayTime) ;

		}
}


function abortMe() 
{
			// check here for what the error numbers are.
			java.lang.System.out.println("Installer error: " + err) ;
			if (!silentValue) { 
				wndw.close() ;
				}

			su.AbortInstall() ;
			errorFlag = true ;
}



function errorParse(err) {
	switch (err) {
		case -210 :
			updateStatusText(4, "Install cancelled! Exiting installation...", 5, true, errorGraphic) ;
			break ;
		case -201 :
			updateStatusText(4, "An unknown, unexpected error has occurred, Exiting...", 5, true, errorGraphic) ;
			break ;
		case -200 :
			updateStatusText(4, "ERROR! Incorrect / Bad install package name.  Exiting...", 5, true, errorGraphic) ;
			break ;
		case -202 :
			updateStatusText(4, "ERROR! Access denied.  Cannot write to system.  Exiting...", 5, true, errorGraphic) ;
			break ;
		case -203 :
			updateStatusText(4, "ERROR! Too many certificates, only 1 is allowed. Exiting...", 5, true, errorGraphic) ;
			break ;
		case -204 :
			updateStatusText(4, "ERROR! No installer certificate found! Exiting...", 5, true, errorGraphic) ;
			break ;
		case -205 :
			updateStatusText(4, "ERROR! Extracted file is not signed. Exiting...", 5, true, errorGraphic) ;
			break ;
		case -206 :
			updateStatusText(4, "ERROR! Extracted file does not match installer certificate. Exiting...", 5, true, errorGraphic) ;
			break ;
		case -207 :
			updateStatusText(4, "ERROR! Jar file hasn't been opened/found. Exiting...", 5, true, errorGraphic) ;
			break ;
		case -208 :
			updateStatusText(4, "ERROR! Error calling function (bad arguments). Exiting...", 5, true, errorGraphic) ;
			break ;
		case -209 :
			updateStatusText(4, "ERROR! Illegal relative path to destination. Exiting...", 5, true, errorGraphic) ;
			break ;
		case -211 :
			updateStatusText(4, "ERROR! Install never started. Exiting...", 5, true, errorGraphic) ;
			break ;
		case -20:
			updateStatusText(4, "ERROR, trying to setupFiles.", 4, true, errorGraphic) ;
			break ;
		case -1:
			updateStatusText(4, "ERROR, Adding components to the install.", 4, true, errorGraphic) ;
			break ;
		case -2:
			updateStatusText(4, "ERROR: Install not approved.  Exiting...", 4, true, errorGraphic) ;
			break ;

		default :
			updateStatusText(4, "An install error has occurred. Exiting...", 5, true, errorGraphic) ;
		} //endswitch
} //end errorParse

//*************************** END OF HEADER FILE ****************************


function updateRegistry() {

var result = 0 ;
fWinSystem = su.GetFolder("Win System") ;
fCommunicator = su.GetFolder("Communicator") ;
fWindows = su.GetFolder("Windows") ;
winreg = su.GetWinRegistry() ;
iniFile = su.GetWinProfile(fWindows, "system.ini") ;
// Notes:
// can't use a double backslash before subkey - Windows already puts it in.			
// subkeys have to exist before values can be put in.
// You can create subkeys all at once however.
//---------------------------------------------

//Setup default Win32 registry stuff:
// CREATE KEYS
return err ;
}

function buildArray() //stores the information for each file in the array.
	{
//Build used folder list here:
fPlugins = su.GetFolder("Plugins") ;
//fProgram = su.GetFolder("Program") ;
//fJavaBin = su.GetFolder("Netscape Java Bin") ;
//fJavaClasses = su.GetFolder("Netscape Java Classes") ;
//fWinSystem = su.GetFolder("Win System") ;
//fWindows = su.GetFolder("Windows") ;
//fCommunicator = su.GetFolder("Communicator") ;
// check folders before using them.

icount = 0 ;
	// ------Migration Agent plugin FOR 32BIT---------------
	// **sw** this is all the director files we install for win-32
if (OSFlavor == "Win32") {
	// Shockwave for Director Plugins
	file[icount].fileName = "NP32DSW.DLL" ;
	file[icount].fileDestFolder = fPlugins ;
	file[icount].fileSourcePath = file[icount].fileName ;
	file[icount].fileVersion = vi ;
	file[icount].fileLocalPath =  file[icount].fileName ;
	icount ++ ;

	file[icount].fileName = "DIRAPI.DLL" ;
	file[icount].fileDestFolder = fPlugins ;
	file[icount].fileSourcePath = file[icount].fileName ;
	file[icount].fileVersion = vi ;
	file[icount].fileLocalPath =  file[icount].fileName ;
	icount ++ ;

	file[icount].fileName = "IDLE32.EXE" ;
	file[icount].fileDestFolder = fPlugins ;
	file[icount].fileSourcePath = file[icount].fileName ;
	file[icount].fileVersion = vi ;
	file[icount].fileLocalPath =  file[icount].fileName ;
	icount ++;

	file[icount].fileName = "IML32.DLL" ;
	file[icount].fileDestFolder = fPlugins ;
	file[icount].fileSourcePath = file[icount].fileName ;
	file[icount].fileVersion = vi ;
	file[icount].fileLocalPath =  file[icount].fileName ;
	icount ++;

	file[icount].fileName = "ShockwavePlugin.class" ;
	file[icount].fileDestFolder = fPlugins ;
	file[icount].fileSourcePath = file[icount].fileName ;
	file[icount].fileVersion = vi ;
	file[icount].fileLocalPath =  file[icount].fileName ;
	icount ++;

	file[icount].fileName = "SWADCMPR.X32" ;
	file[icount].fileDestFolder = fPlugins ;
	file[icount].fileSourcePath = file[icount].fileName ;
	file[icount].fileVersion = vi ;
	file[icount].fileLocalPath =  "Np32dsw/" + file[icount].fileName ;
	icount ++;

	file[icount].fileName = "SWASTRM.X32" ;
	file[icount].fileDestFolder = fPlugins ;
	file[icount].fileSourcePath = file[icount].fileName ;
	file[icount].fileVersion = vi ;
	file[icount].fileLocalPath =  "Np32dsw/" + file[icount].fileName ;

	}
	
	//Migration Agent plugin FOR 16 BIT --------------------
	// **sw** this is all the Director files we install for win-16
if (OSFlavor == "Win16") {
	// Shockwave for Director Plugins
	file[icount].fileName = "NP16DSW.DLL" ;
	file[icount].fileDestFolder = fPlugins ;
	file[icount].fileSourcePath = file[icount].fileName ;
	file[icount].fileVersion = vi ;
	file[icount].fileLocalPath =  file[icount].fileName ;
	icount ++ ;

	file[icount].fileName = "DIRAPI.DLL" ;
	file[icount].fileDestFolder = fPlugins ;
	file[icount].fileSourcePath = file[icount].fileName ;
	file[icount].fileVersion = vi ;
	file[icount].fileLocalPath =  file[icount].fileName ;
	icount ++ ;

	file[icount].fileName = "IDLE16.EXE" ;
	file[icount].fileDestFolder = fPlugins ;
	file[icount].fileSourcePath = file[icount].fileName ;
	file[icount].fileVersion = vi ;
	file[icount].fileLocalPath =  file[icount].fileName ;
	icount ++;

	file[icount].fileName = "IML.DLL" ;
	file[icount].fileDestFolder = fPlugins ;
	file[icount].fileSourcePath = file[icount].fileName ;
	file[icount].fileVersion = vi ;
	file[icount].fileLocalPath =  file[icount].fileName ;
	icount ++;

	file[icount].fileName = "MACROMIX.DLL" ;
	file[icount].fileDestFolder = fPlugins ;
	file[icount].fileSourcePath = file[icount].fileName ;
	file[icount].fileVersion = vi ;
	file[icount].fileLocalPath =  file[icount].fileName ;
	icount ++;

	file[icount].fileName = "DIRDIB.DRV" ;
	file[icount].fileDestFolder = fPlugins ;
	file[icount].fileSourcePath = file[icount].fileName ;
	file[icount].fileVersion = vi ;
	file[icount].fileLocalPath =  file[icount].fileName ;
	icount ++;

	file[icount].fileName = "SWADCMPR.X16" ;
	file[icount].fileDestFolder = fPlugins ;
	file[icount].fileSourcePath = file[icount].fileName ;
	file[icount].fileVersion = vi ;
	file[icount].fileLocalPath =  "Np16dsw/" + file[icount].fileName ;
	icount ++;

	file[icount].fileName = "SWASTRM.X16" ;
	file[icount].fileDestFolder = fPlugins ;
	file[icount].fileSourcePath = file[icount].fileName ;
	file[icount].fileVersion = vi ;
	file[icount].fileLocalPath =  "Np16dsw/" + file[icount].fileName ;  
	
	}

	//Migration Agent plugin FOR MacPPC --------------------
	// **sw** this is all the Director files we install for Mac PPC
if (OSFlavor == "MacPPC") {
	// Shockwave for Director Plugins
	file[icount].fileName = "IMLlib" ;
	file[icount].fileDestFolder = fPlugins ;
	file[icount].fileSourcePath = file[icount].fileName ;
	file[icount].fileVersion = vi ;
	file[icount].fileLocalPath =  file[icount].fileName ;
	icount ++ ;

	file[icount].fileName = "NP-PPC-Dir-Shockwave" ;
	file[icount].fileDestFolder = fPlugins ;
	file[icount].fileSourcePath = file[icount].fileName ;
	file[icount].fileVersion = vi ;
	file[icount].fileLocalPath =  file[icount].fileName ;
	icount ++ ;

	file[icount].fileName = "ShockwavePlugin.class" ;
	file[icount].fileDestFolder = fPlugins ;
	file[icount].fileSourcePath = file[icount].fileName ;
	file[icount].fileVersion = vi ;
	file[icount].fileLocalPath =  file[icount].fileName ;
	icount ++ ;

	file[icount].fileName = "SWA Decompression PPC Xtra" ;
	file[icount].fileDestFolder = fPlugins ;
	file[icount].fileSourcePath = file[icount].fileName ;
	file[icount].fileVersion = vi ;
	file[icount].fileLocalPath =  "NP-PPC-Dir-Shockwave Folder/Xtras/" + file[icount].fileName ;
	icount ++ ;

	file[icount].fileName = "SWA Streaming PPC Xtra" ;
	file[icount].fileDestFolder = fPlugins ;
	file[icount].fileSourcePath = file[icount].fileName ;
	file[icount].fileVersion = vi ;
	file[icount].fileLocalPath =  "NP-PPC-Dir-Shockwave Folder/Xtras/" + file[icount].fileName ;		  
	icount ++ ;
	
	file[icount].fileName = "ShockInstall" ;
	file[icount].fileDestFolder = fPlugins ;
	file[icount].fileSourcePath = file[icount].fileName ;
	file[icount].fileVersion = vi ;
	file[icount].fileLocalPath =  file[icount].fileName ;
	icount ++;

	file[icount].fileName = "ReadMe - Director 6 PPC Plug-in" ;
	file[icount].fileDestFolder = fPlugins ;
	file[icount].fileSourcePath = file[icount].fileName ;
	file[icount].fileVersion = vi ;
	file[icount].fileLocalPath =  file[icount].fileName ;
			  
	
	}

	//Migration Agent plugin FOR Mac68K --------------------
	// **sw** this is all the Director files we install for Mac 68k
	// 68k does not currently support javaScript 1.2
if (OSFlavor == "Mac68K") {
	// Shockwave for Director Plugins
	file[icount].fileName = "NP-68K-Dir-Shockwave" ;
	file[icount].fileDestFolder = fPlugins ;
	file[icount].fileSourcePath = file[icount].fileName ;
	file[icount].fileVersion = vi ;
	file[icount].fileLocalPath =  file[icount].fileName ;
	icount ++ ;

	file[icount].fileName = "SWA Decompression 68K Xtra" ;
	file[icount].fileDestFolder = fPlugins ;
	file[icount].fileSourcePath = file[icount].fileName ;
	file[icount].fileVersion = vi ;
	file[icount].fileLocalPath =  "NP-68K-Dir-Shockwave Folder/Xtras/" + file[icount].fileName ;
	icount ++ ;

	file[icount].fileName = "SWA Streaming 68K Xtra" ;
	file[icount].fileDestFolder = fPlugins ;
	file[icount].fileSourcePath = file[icount].fileName ;
	file[icount].fileVersion = vi ;
	file[icount].fileLocalPath =  "NP-68K-Dir-Shockwave Folder/Xtras/" + file[icount].fileName ;		  

	}

return err ;
}
// -----------------------------------------------------

function checkSystemEnvironment()  // OS check, memcheck, etc go here.
	{
	//vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld) ;
	//vi = new netscape.softupdate.VersionInfo(shockwaveVersion) ;
	if (vi == null ) java.lang.System.out.println("new vi RETURNED NULL!!") ;
	
	registry_vi = netscape.softupdate.Trigger.GetVersionInfo(swRegName);
	if (registry_vi == null ) 
	{
		java.lang.System.out.println("registry_vi returned Null.  Must assume there isn't a node there yet. (fresh install)") ;
	} else {
		java.lang.System.out.println(registry_vi) ;
	}
	return err ;
}

function setupFiles(su){
	var errFlag = false ; // to catch errors inside the addsubcomponent loops.

	updateStatusText(4, "Checking install privileges.  Click 'grant' if you are asked to approve the installation in the Java Security dialog.", 3, false, normalGraphic) ;	
// clean up window from redraw problem
    wndw.frames[0].document.close() ;  //clean the window first.
    wndw.frames[1].document.close() ;  //clean the window first.
	err = su.StartInstall(swRegName, // Package name for registry
							vi,
							1);  //new api 1= full install
	if (err !=0){
		updateStatusText(hSize,"ERROR at StartInstall...", 4, true, errorGraphic) ;
		return err ;
		}
	updateStatusText(hSize,"Organizing Installation Components...", 1, false, normalGraphic) ;

	   //totalFiles ; i++
	   // **sw** this routine installs the Director files
	for (i=0 ; i < totalFiles ; i++ ) {
		updateStatusText(5, "Adding file number: " +(i+1)+ " to the install: " + file[i].fileName, 0, false, normalGraphic) ;
		err = su.AddSubcomponent(file[i].fileName, 	//nice registry name,
							file[i].fileVersion,	// versionInfoObject, 
							file[i].fileSourcePath,		//Full name from inside .jar including path,
							file[i].fileDestFolder,	// folderSpecobj, 
							file[i].fileLocalPath,  //path for destination.  null=whatever destfolder is.
							this.force);			//dest file name (can be null) NEW api
		if (err != 0) {
				updateStatusText(5, "Problem with file: " + file[i].fileName, 0, true, normalGraphic) ;
				errFlag = true ;
				}
		
		}

		if (OSFlavor == "MacPPC") {
			err = su.Execute("ShockInstall") ;
		}



   
	// **sw** these routines installs flash
	// **sw** fvi sets the Flash plugin version
	if (OSFlavor == "Win32") {
		updateStatusText(5, "Adding file number: " +(totalFiles+1)+ " to the install: NPSWF32.dll", 0, false, normalGraphic) ;
		err = su.AddSubcomponent("=comm=/plugins/Macromedia Shockwave/Flash",  //sets registry name
							fvi,		    // version
							"NPSWF32.dll",  //source path filename
							fPlugins,		//destination folder
							"NPSWF32.dll",	//destination path filename
							this.force);
		if (err != 0) {
			updateStatusText(5, "Problem with file: NPSWF32.dll", 0, true, normalGraphic) ;
			errFlag = true ;
		}

   	}

	if (OSFlavor == "Win16") {
			updateStatusText(5, "Adding file number: " +(totalFiles+1)+ " to the install: Npswf16.dll", 0, false, normalGraphic) ;
		err = su.AddSubcomponent("=comm=/plugins/Macromedia Shockwave/Flash",  //sets registry name
							fvi,		    // version
							"Npswf16.dll",  //source path filename
							fPlugins,		//destination folder
							"Npswf16.dll",	//destination path filename
							this.force);
		if (err != 0) {
			updateStatusText(5, "Problem with file: Npswf16.dll", 0, true, normalGraphic) ;
			errFlag = true ;
		}
	}

	if (OSFlavor == "MacPPC") {
		su.Execute("ShockInstall") ;
		updateStatusText(5, "Adding file number: " +(totalFiles+1)+ " to the install: Shockwave Flash NP-PPC", 0, false, normalGraphic) ;
		err = su.AddSubcomponent("=comm=/plugins/Macromedia Shockwave/Flash",  //sets registry name
							fvi,		    // version
							"Shockwave Flash NP-PPC",  //source path filename
							fPlugins,		//destination folder
							"Shockwave Flash NP-PPC",	//destination path filename
							this.force);
		if (err != 0) {
			updateStatusText(5, "Problem with file: Shockwave Flash NP-PPC", 0, true, normalGraphic) ;
			errFlag = true ;
		}


	}

		if (OSFlavor == "Mac68k") {
			su.Execute("ShockInstall") ;
			updateStatusText(5, "Adding file number: " +(totalFiles+1)+ " to the install: Shockwave Flash NP-PPC", 0, false, normalGraphic) ;
			err = su.AddSubcomponent("=comm=/plugins/Macromedia Shockwave/Flash",  //sets registry name
							fvi,		    // version
							"Shockwave Flash NP-68K",  //source path filename
							fPlugins,		//destination folder
							"Shockwave Flash NP-68K",	//destination path filename
							this.force);
		if (err != 0) {
			updateStatusText(5, "Problem with file: Shockwave Flash NP-68K", 0, true, normalGraphic) ;
			errFlag = true ;
		}
	}

	 	if (errFlag == true) {
			err = -1 ;
			updateStatusText(4, "Error adding subcomponents to the install...", 0, true, errorGraphic) ;
	 		return err ;
			}

	 return 0;

}

function body() {	//this section works in clumps - each clump gets an error check after it's called.
					// the errorFlag is there to make sure I only call abortMe once.
	if ( (su != null) )
		{
		updateStatusText(hSize,"Checking your system environment...", 2, false, "") ;
		err = checkSystemEnvironment() ;  //checksystemenvironments, if it returns error, abort
		if (( err != 0 ) && (errorFlag == false)) 
				abortMe() ;
		if (err == 0) {
			updateStatusText(hSize,"Setting up files for the install...", 1, false, "") ;
			err = buildArray() ;
			if (( err != 0 ) && (errorFlag ==false)) {
				errorParse(err)
				abortMe() ;
				}
			}

		if (err == 0) {		
			updateStatusText(hSize,"Setting up the rest of the install...", 1, false, "") ;
			err = setupFiles(su) ;		  // and abort.
			if (( err != 0 ) && (errorFlag ==false)) {
				errorParse(err) ;
				abortMe() ;
				}
			}

		if (err == 0) {
			err = updateRegistry() ;
			if (( err != 0 ) && (errorFlag ==false)) {
				errorParse(err) ;
				abortMe() ;
				}
			}

		if (err == 0) 			// if we get to here, everythings cool and we can finalize install.
			{
			updateStatusText(hSize,"Readying files.  Please click 'Install' or 'Cancel' to abort in the SmartUpdate window...", 4, false, "") ;   
			err = su.FinalizeInstall();	// This actually copies all the files to their right place
			if (( err != 0 ) && (errorFlag ==false)) {
				errorParse(err) ;
				abortMe() ;
				}
			else {
				navigator.plugins.refresh(true) ;
				updateStatusText(hSize, "Refreshing and restarting plugins...", 3, false, "") ;
				}
			}
			
		if (( err != 0 ) && (errorFlag ==false))	// If we have an error, write it to the console
			{
			errorParse(err) ;
			abortMe() ;
			}

		if (err == 0)
			{
			updateStatusText(hSize, "INSTALL COMPLETED SUCCESSFULLY!", 2, false, "") ;
				if ((OSFlavor == "MacPPC") || (OSFlavor == "Mac68K"))			 {
					updateStatusText(hSize, "Netscape Communicator will now restart.", 4, false, "") ;
				}			   
			wndw.close() ;
			}
	} 
}

// ================ START ================
// this installer handles both Win16 and Win32 platforms

// first thing we do is make sure javaScript is on and ASD is enabled
if ( checkJava() && checkASD() ) 
{
	//--- PRE FLIGHT CHECKS ------
	var dbg = java.lang.System.out.println ;
	var chkOS ;
	var chkOSNum ;
	var OSFlavor ;
	var fPlugins ;
	chkOS = java.lang.System.getProperty("os.name") ;
	chkOSNum = java.lang.System.getProperty("os.version") ;
	OSFlavor = navigator.platform ;
	dbg("chkOS = " +chkOS) ;	
	dbg("chkOSNum = " +chkOSNum) ;	
	dbg("Platform is:" + OSFlavor) ;

	// VARIABLE DECLARATIONS

 	// **sw** set the number of Director files to be installed
	// and set the version numbers
	if (OSFlavor == "Win32") {
		var totalFiles = 7 ;
		var vi = new netscape.softupdate.VersionInfo(6, 0, 0, 57) ;
	}
	if (OSFlavor == "Win16") {
		var totalFiles = 8 ;
  		var vi = new netscape.softupdate.VersionInfo(6, 0, 0, 57) ;
	}
	if (OSFlavor == "MacPPC") {
		var totalFiles = 7 ;
		var vi = new netscape.softupdate.VersionInfo(6, 0, 0, 59) ;
	}
	if (OSFlavor == "Mac68K") {
		var totalFiles = 3 ;
		var vi = new netscape.softupdate.VersionInfo(6, 0, 0, 59) ;
	}

	var file = new Array(totalFiles) ;
	for (i=0 ; i<totalFiles ; i++ ) {
		file[i] = new fileInfoObject ;
	}

	var swRegName = "plugins/Macromedia Shockwave/Director" ;	
	var topWindowTitle = "Shockwave for Director Installer" ;
	var updateObjectName = "Shockwave for Director Plugin" ;      

	// Flash version variable **sw**
	var fvi = new netscape.softupdate.VersionInfo(2, 0, 0, 11)
	
	// other variables
	var defaultText = "Welcome to the installer." ;
	var text = "default text" ;  // string container for status update messages in bottom frame.
	var err = 0 ;
	var hSize = "4" ;
	var su = null ;
	var suEnv = this ;
	var errorFlag = false ;
	var delayTime = 1 ;
	var debugState = true ;
	var graphic = "" ;
	var errorGraphic = "http://home.netscape.com/images/mozilla_bungee.gif" ;
	var normalGraphic = "http://home.netscape.com/images/mozilla_hurdles.gif" ;
	var silentValue = false ;  // = this.silent ;

	//var versionMaj = 6 ;  
	//var versionMin = 0 ;   
	//var versionRel = 0 ;    
	//var versionBld = 57 ;

	//======================================================

	if (!silentValue) setupWindows() ;
	updateStatusText(hSize,"Starting the install...",4, true, normalGraphic) ;
	su = new netscape.softupdate.SoftwareUpdate( this, updateObjectName ) ;

	if (su == null) updateStatusText(hSize,"Failed to create new softupdate obj.",1, true, errorGraphic) ;

	body() ;
}