// File: install.js
// 
// Author: Keith Wong (keith@netnanny.com)
// Company: Net Nanny Software
// Date: May 25, 1998

// This is the installation file for netnanny.  It is in JavaScript.

// --------------------------------------------
// Some useful functions
// --------------------------------------------

// Conditional alert.
function cAlert( message )
{
   if (!this.silent)
      alert( message );
}

// Conditional confirm.
function cConfirm( message )
{
   if (this.silent)
      return true;
   else
      return confirm( message );
}


// --------------------------------------------
// Installation
// --------------------------------------------

// See if java is enabled.
if ( navigator.javaEnabled() )
{
   if (( navigator.platform == "Win16" ) || ( navigator.platform == "Win32" ))
   {
      // The operating system is Windows.  Allow the installation of netnanny.
      // Create a version object and a software update object.
      vi = new netscape.softupdate.VersionInfo(3, 1, 0, 0);
      su = new netscape.softupdate.SoftwareUpdate( this, 
                 "Net Nanny 30-day Evaluation Program");

      // Start the install process
      su.StartInstall( "/netnanny", vi, 
                 netscape.softupdate.SoftwareUpdate.FULL_INSTALL );

      // Unpack the installer (written in InstallShield) in the JAR archive
      // to a temporary location.
      su.Execute("netnanny.exe");

      // Perform requested execution.
      su.FinalizeInstall();
   }
   else
   {
      // The operating system is not Windows.  Cannot allow the installation.
      cAlert( "Netnanny works only in Windows environment.");
   }
}
else
{
   // Java is not enabled.  Cannot start the installation.
   cAlert( "Java must be enabled to install." );
}
