


// Localizers: please translate the strings found between the double quotes

//Errors and warnings
var ERR_WIN_ONLY = "This installer is not designed for a non-windows platform.  Please locate the correct installer.  Exiting.";
var ERR_JAVA_IS_OFF = "You do not have java turned on, please enable Java, restart, and try again";
var ERR_AUTOINSTALL_IS_OFF = "AutoInstall is not turned on in Advanced Preferences, please enable it, restart, and try again" ;
var ERR_NOT_FOR_THIS_OS = "Sorry, the install you are downloading doesn't support your operating system.  Install will not continue";
var ERR_210_INSTALL_CANCELLED = "Install cancelled! Exiting installation..." ;
var ERR_201_NOT_GRANTED = "Privileges not granted, Exiting..." ;
var ERR_200_BAD_PACK_NAME = "ERROR! Incorrect / Bad install package name.  Exiting..." ;
var ERR_202_ACCESS_DENIED = "ERROR! Access denied.  Cannot write to system.  Exiting..." ;
var ERR_203_TOO_MANY_CERTS = "ERROR! Too many certificates, only 1 is allowed. Exiting..." ;
var ERR_204_NO_CERTS = "ERROR! No installer certificate found! Exiting...";
var ERR_205_FILE_NOT_SIGNED = "ERROR! Extracted file is not signed. Exiting..." ;
var ERR_206_FILE_NOT_CERTS = "ERROR! Extracted file does not match installer certificate. Exiting..." ;
var ERR_207_JAR_NOT_OPENED = "ERROR! Jar file hasn't been opened/found. Exiting..." ;
var ERR_208_BAD_ARGS_TO_FUNC = "ERROR! Error calling function (bad arguments). Exiting..." ;
var ERR_209_BAD_PATH = "ERROR! Illegal relative path to destination. Exiting..." ;
var ERR_211_INSTALL_WONT_START = "ERROR! Install never started. Exiting..." ;
var ERR_20_CANT_SETUP_FILES = "ERROR, trying to setupFiles." ;
var ERR_1_CANT_ADD_COMP = "ERROR, Adding components to the install." ;
var ERR_2_NOT_APPROVED = "ERROR: Install not approved.  Exiting..." ;
var ERR_3_WIN32_ONLY = "ERROR: This installer is for 32 bit Windows only.  Exiting..." ;
var ERR_GENERIC_INSTALL_ERR = "an install error has occurred. Exiting..." ;
var ERR_ABORT_WITH_ERRNO = "ABORT! Installer error: ";
var ERR_999_FILES_IN_USE = "<FONT SIZE=+1 COLOR=#990000><i>WARNING!</FONT>  Some of the files are in use, you will have to restart your computer after installing your software.</i>" ;


// Take care of the embedded HTML in the following string
var WARN_999_MUST_RESTART = "<FONT SIZE=+1 COLOR=#990000><i>WARNING!</FONT>  Some of the files are in use, you will have to restart your computer after installing your software.</i>" ;

//Note: CheckLang will currently only handle English.  What happens to the script when
//we support Int'l?
var ERR_NEED_COM4_ENGLISH = "Sorry, you must have Communicator 4.0 in English in order to upgrade.  Install will not continue" ;
var STATUS_PLEASE_WAIT = "Please Wait..." ;

//Font face and size for status updates.  Note the single quotes inside the string
// for font face; this is essential.
var PARAM_FONT_FACE = "'Arial, Helvetica'" ;
var PARAM_FONT_SIZE = 5 ;
var PARAM_FONT_SIZE_FOR_UPDATE = 4;

var PARAM_LANG_FOR_SCRIPT = "en";


// ###### END OF SHARED LOCALIZABLE TEXT #########


// Localizers: please translate the strings found between the double quotes

//Errors and warnings
var DBG_NO_SUBKEY = "error setting creating key for " ;
var DBG_SET_WINREGVALUE = "error setting winreg value for " ;
var DBG_VI_EQUALS = "vi equals: " ;

var TEXT_BAD_PREV_INSTALL = "<FONT COLOR='#CC0000'>Error extracting values from registry - you must re-install your current version before performing the upgrade.</FONT>" ;
var TEXT_ORGANIZING_INSTALL = "Organizing Installation Components..." ;
var TEXT_ADDING_FILENUM = "Adding file number: "  ;
var INFO_ADDFILESTR = "Adding file number : {0} to the install: {1} " ;
var TEXT_TO_INSTALL = " to the install: " ;
var TEXT_ERR_ADDINGFILE = "Error adding " ;
var TEXT_WRONG_COMM_VER = "You do not have the correct version of communicator (4.02), exiting the installer" ;
var TEXT_ALREADY_HAVEIT = "You already have a version of 4.05 on your system, do you wish to continue?" ;
var TEXT_CLICK_GRANT = "Click 'grant' if you are asked to approve the installation in the Java Security dialog." ;
var TEXT_NONEWSUOBJ = "Failed to create new softupdate obj." ;
var TEXT_CHECKINGSYSTEM = "Checking your system environment..." ;
var TEXT_SETTINGUP_FILES = "Setting up files for the install..." ;
var TEXT_SETTINGUP_REST = "Setting up the rest of the install..." ;
var TEXT_READYING_FILES = "Readying files.  Please click 'Install' or 'Cancel' to abort in the SmartUpdate window..." ;
var TEXT_INSTALL_COMPLETED = "INSTALL COMPLETED SUCCESSFULLY!" ;
var TEXT_TOPWINDOW_TITLE = "Bonzi Voice E-mail 3.0 for Netscape" ;
var TEXT_UPDATEOBJ_NAME = "Bonzi Voice E-mail 3.0 for Netscape" ;
var TEXT_DEFAULT_TEXT = "Starting the install..." ;


//Errors and warnings
var ERR_NEED_SPECIFIC_VERSION_1 = "This installer requires Communicator 4.04 or later which you are not running.";
var ERR_NEED_SPECIFIC_VERSION_2 = "If you are running a previous version of communicator, you can upgrade to 4.04 easily...";
var ERR_NEED_SPECIFIC_VERSION_3 = "By choosing the HELP | SOFTWARE UPDATES menu.";
var ERR_NEED_SPECIFIC_VERSION_4 = "This install will exit now.";
var ERR_FAILED_TO_CREATE_OBJ = "Failed to create new softupdate obj.";

//Status Messages
var STATUS_ORGANIZING_FILES = "Organizing Installation Components...";
var STATUS_SETTING_UP_FILES = "Setting up files for the install...";
var STATUS_REST_OF_INSTALL = "Setting up the rest of the install...";
var STATUS_CHECKING_ENVIRONMENT = "Checking your system environment...";
var STATUS_OPENING_INFO_FILE = "Opening information file, please wait...";
var STATUS_STARTING_INSTALL = "Starting the install...";


var INSTRUCTION_GRANT_PRIVILEDGE = "Checking install privileges.  Click 'grant' if you are asked to approve the installation in the Java Security dialog.";
var INSTRUCTION_INSTALL_OR_CANCEL = "Readying files.  Please click 'Install' or 'Cancel' to abort in the SmartUpdate window...";
var INSTRUCTION_PLEASE_WAIT = "please wait...";

var WINDOW_TITLE_INFO_FILE = "informationWindow";

var FORMAT_STRING_ADDING_FILE = "Adding file number: %0 to the install: %1";
var FORMAT_STRING_ERROR_ADDING_FILE = "Error adding %0 to the install...";

// Take care of the embedded HTML in the following strings
var HTML_INSTRUCTIONS_WINDOW_TITLE = "<HTML><HEAD><META HTTP-EQUIV='Content-Type' CONTENT='text/html; charset=iso-8859-1'><TITLE>Navigator Install Information</TITLE></HEAD>";
var HTML_INSTRUCTIONS_TITLE = "<BODY><CENTER><H2><FONT COLOR='#CC0000'><FONTSIZE=+3>Installation Stopped</FONT></FONT></H2></CENTER>";

var HTML_INSTRUCTIONS_1 = "We're sorry but this SmartUpdate is unable to automatically update all the files to your Communicator installation." ;
var HTML_INSTRUCTIONS_2 = "You will need to copy over some files manually to complete the install.  Please print out the following instructions on how to upgrade your version of Communicator.";
var HTML_INSTRUCTIONS_3 = "Your copy of Communicator has not been changed as a result of running this Update.";
var HTML_INSTRUCTIONS_4 = "Print out this page, for viewing outside of Communicator.";
var HTML_INSTRUCTIONS_5 = "Quit Communicator.";

// Please note these are dynamically generated strings that contain file path names
var FORMAT_STRING_HTML_INSTRUCTIONS_6 = "Copy %0install\\*.* to %1";
var FORMAT_STRING_HTML_INSTRUCTIONS_7 = "Copy %0install\\java\\bin\\*.* to %1java\\BIN\\";
var FORMAT_STRING_HTML_INSTRUCTIONS_8 = "Copy the entire contents of %0install\\java\\classes\\ to %1java\\classes\\";

var HTML_INSTRUCTIONS_9 = "You can now remove the \\install directories mentioned above and restart Communicator.";
var HTML_INSTRUCTIONS_10 = "Sorry for the inconvenience.  ";


var INSTALLER_WELCOME = "Welcome to the installer.";
var SPECIFIC_PRODUCT_WELCOME = "Welcome to the JDK 1.1 Patch Installer";

var TEXT_ADDING_AIM = "Please wait - adding the Instant Messanger component." ;
var TEXT_DONE_ADDING_AIM = "Finished downloading Instant Message Component.  Launching Install." ;
var TEXT_AIM_LAUNCHED = "Finished launching Instant Message Component.  Launching Install." ;


// #### CODE FOLLOWS.  DO NOT LOCALIZE BELOW THIS LINE!!

// Displays a message only when debugging.


// StrBuilder Utility Class
// *************************
// The function below takes a Win32-style format string and converts it to
// a JavaScript object that contains a table that can very efficiently
// be processed into a formatted string.
//
// Ex:  
// var objRef = new StrBuilder("One is %0, Two is %1, and %2%%");
//
// The objRef can then be used with the BuildString function to build a
// formatted string:
//
// var formattedString = BuildString(objRef,"Uno","Dos",100);
//
// formattedString will be "One is Uno, Two is Dos, and 100%"
//
// Note that the order in the format string can be switched, and BuildString
// will still correctly build the string:
// var objRef2 = new StrBuilder("%2%%: Ithnen hu %1, Wa Wahad hu %0");
// formattedString = BuildString(objRef,"Uno","Dos",100);
//
// Here, formattedString will now be "100%: Ithnen hu Dos, Wa Wahad hu Uno"
//

// Put the following two function definitions into your common functions file or
// headers:

//
// Function StrBuilder: constructor for Win32 style formatter
//
function StrBuilder(fmtStr){

	this.table = new Array(); // Initialize some class variables
	this.valid = true;
	this.numSlots = 1;
	
	var curPosit = 0; // local variables
	var rslt = 0, num, slotNum = 0;
	var nextChar ;
	
	// Now walk the format string, placing the components of the string
	// into the this.table array.  The %0, %1, etc. arguments are stored
	// as a numerical index.  Anything else is stored as a string, including
	// the argument '%%', which resolves to "%"
	while (rslt != -1){
		// Look for a % from current position
		rslt = fmtStr.indexOf("%",curPosit); 
		
		if(rslt == -1) //If % not found, dump the end of the string to a slot
			 this.table[slotNum] = fmtStr.substring(fmtStr.length,curPosit);
			 
		else if ((nextChar = fmtStr.charAt(rslt+1)) == "%"){ // Check for '%%'
			this.table[slotNum++] = fmtStr.substring(rslt,curPosit);
			this.table[slotNum++] = "%";
			curPosit = rslt + 2; 
		}
		 else{ //Either something we can't handle... 
			num = parseInt(nextChar);
			if (isNaN(num) || num > 9){ //Only a number or a % may follow a %
					this.valid = false;
					return this;
			  }
			  else{	// or it's a digit from 0 to 9, which we store as an index
				this.table[slotNum++] = fmtStr.substring(rslt,curPosit);
				this.table[slotNum++] = num;
				curPosit = rslt + 2; 
			}
		}
	}
	this.numSlots = slotNum + 1;
	return this;
}

//
// Function BuildString: uses a StrBuilder object to dynamically format a string.
// 
// Note: you may have up to 10 arguments after strbldr.  The first will correspond
// to %0, the second to %1, up to %9, and will be substituted for these tokens
// as were passed to StrBuilder.
//
function BuildString(strbldr, itemList){
	var thisSlot, slotVal, thisType, thisArg ;
	var theStr = "";
	
	// For now, we return something that looks invalid if strbldr is not a
	// StrBuilder object:
	if (!strbldr.valid)
		return "<INVALID>";

	// Now walk the slots.  If a string, concatenate it.  If a number,
	// check the argument list for BuildString and substitute the i+1
	// argument.  Note that if we ask for too high an arg, we add nothing
	// to the string in that position	
	for(var i = 0; i < strbldr.numSlots; i++){
		thisSlot = strbldr.table[i];
		thisType = typeof thisSlot; //check to see if we have a numerical index
		slotVal = parseInt(thisSlot);
		
		if(thisType != "number") // not an index, so just concatenate the slot
			theStr += thisSlot;
		// ELSE: substitute in an argument from BuildString's argument list
		else if (slotVal < BuildString.arguments.length - 1){
			thisArg = BuildString.arguments[slotVal + 1];
			theStr += thisArg;
		}
	}			
	return theStr;
}


/* 
 * This function takes a JS Array and converts it into a Java 
 * array of Objects.
 */
function JSArrayToJArray(objects) {
   // As a little trick here, we create a Java Object and
   // then use it to get a class to pass to java...Array.newInstance
   // In this manner, we can create and populate a Java array
   tobj = new java.lang.Object()
   JArray = java.lang.reflect.Array.newInstance(tobj.getClass(), objects.length)

   for(i = 0 ; i < objects.length ; i++) {
      if(typeof objects[i] == "string") {
	java.lang.reflect.Array.set(JArray, i, objects[i])
      }
      // Otherwise assume it's a Calendar object for either date/time
      else {
	tempJDate = new java.util.Date(objects[i].getTime())
	java.lang.reflect.Array.set(JArray, i, tempJDate)
      }
   }
   return(JArray)
}

/* 
 * SimpleMessageFormat is appropriate for if you are only going to format 
 * a string a few times.  It takes a 
 * pattern string, and array of JS objects to use while formatting.
 */
function SimpleMessageFormat(patternstring, objects) {
   JArray = JSArrayToJArray(objects)
   return(java.text.MessageFormat.format(patternstring, JArray))
}


function dbgMsg(message) 
	{
	if(debugOutput)
      java.lang.System.out.println(message) ;
	}


function checkJava() 
	{
	javaOn = navigator.javaEnabled() ; //check to see if java is enabled - nothing here works without it.
	if (javaOn == false)
		{
	if (!silentValue)
			{
			alert(ERR_JAVA_IS_OFF) ; // Restart with Java please!
			return false ;
			}
		}
	return true ;
	} 

function checkASD() 
	{
	SUEnabled = netscape.softupdate.Trigger.UpdateEnabled() ;  // SmartUpdate won't work without it being on.
	if (SUEnabled == false)
		{
	if (!silentValue)
			{
			alert(ERR_AUTOINSTALL_IS_OFF) ;
			return false ;
			}
		}
	return true ;
	} 


function verifyOS(val) // val should be a string 16, 32, or PPC, etc.  You can verify that the OS matches the OS of the intended install software
	{
	OS = navigator.platform ;
	i = OS.indexOf(val) ;
	if ( i == -1)  
		{
		if (!silentValue)
			{
			alert(ERR_NOT_FOR_THIS_OS) // Package not for this OS!;
			return false ;
			}
		}
	return true ;
	} 


function checkLang()  // you can probably modify this function to check for the language like we check for OS, but for now, it just verifies English.
	{

	if (navigator.language != PARAM_LANG_FOR_SCRIPT)
		{
		if (!silentValue)
			{
			alert(ERR_NEED_COM4_ENGLISH) ;
			return false ;
			}
		}
	return true ;
	}


//this is an object that contains fields for information about all aspects of the files we want to install.
//later we create an array of these objects depending on the number of files we have to install.
//Later still, we populate the array - filling in the data.
//Lastly, we chug through the array when we are installing the files, extracting the data as we go.
function fileInfoObject(fileName, regFilePath, fileVersion, fileSourcePath, fileDestFolder, fileLocalPath, fileForceStatus ) 
	{
	this.fileName = fileName ;		//convenience sake name
	this.regFilePath = regFilePath ;  //registry name/path 
	this.fileVersion = fileVersion ;  //what version you need this file to be
	this.fileSourcePath = fileSourcePath ; //where in the .jar file is this coming from
	this.fileDestFolder = fileDestFolder ; // where on the drive is this going to (folderspec obj)
	this.fileLocalPath = fileLocalPath ; // any change from the folderspec obj (subfolders?)
	this.fileForceStatus = fileForceStatus ; // determines whether we pay attention to windows versioning or not.
	}


//this function sets up a UI environment which you can alter and/or use to inform the user of what's happening during the install.
function setupWindows()  
{
if (!silentValue)
	{		

		wndw= open("","installer","toolbar=0,menubar=0,status=0,directories=0,location=0,scrollbars=0,resizable=0,width=480,height=400,top=50,left=100");
					     // get the users' screen size
        ScreenSize();	 // another object made by us (See Below).
        wndw.moveTo(width/2-250, height/2-200);          //center the window now that we know the dims.
        wndw.document.open("text/html");  				 //open a window that has the text/html mime type.
        wndw.document.close() ;  // flush to window.
        wndw.document.write("<TITLE>"+topWindowTitle+"</TITLE><center><br><br><h2>"+STATUS_PLEASE_WAIT+"</h2></center>") ;
		wndw.document.close() ;  // flush to window.		
		// WRITE OUT THE HTML TO THE WINDOW, CREATING THE FRAMESET
		line = "<TITLE>"+topWindowTitle+"</TITLE><FRAMESET ROWS='40%, 35%, *' border=0 frameborder='no' marginwidth=0><FRAME SRC='about:blank' NAME='TOP'> <FRAME SRC='about:blank' NAME='MIDDLE'> <FRAME SRC='about:blank' NAME='BOTTOM'></FRAMESET>" ;
        wndw.document.write(line);
        wndw.document.close() ;  // flush to window.

// an effort to clean the window of background info.
	wndw.frames[0].document.write("<center><br><br><h3>"+STATUS_PLEASE_WAIT+"</h3></center>") ;
	wndw.frames[0].document.close() ;  //clean the window first.
	wndw.frames[1].document.write("<center><br><br><h3>"+STATUS_PLEASE_WAIT+"</h3></center>") ;
	wndw.frames[1].document.close() ;  //clean the window first.
	wndw.frames[2].document.write("<center><br><br><h3>"+STATUS_PLEASE_WAIT+"</h3></center>") ;
	wndw.frames[2].document.close() ;  //clean the window first.

		line="<HTML><BODY><CENTER><IMG SRC=http://www.bonzi.com/images/netbanr.gif><H3>"+topWindowTitle+"</H3></CENTER></BODY></HTML>";
        wndw.frames[0].document.close() ;  //clean the window first.
        wndw.frames[0].document.write(line) ;

		// updateStatusText(hSize, defaultText, 3, false, "normal") ;// RMT
		updateStatusText("", defaultText, 3, false, "normal") ;
	}
}


//This function gives us a delay mechanism which isn't built into javascript natively.  
//It's useful and simple.
function delay(amount) {
	// init the values
	var time = new Date() ;
	var seconds = time.getSeconds() ;
	var startCount = 80 ;
	var newSeconds = 70 ;
	//-------------------
	startCount = (seconds + amount ) % 60 ;
	time = new Date() ;
	newSeconds = time.getSeconds() ;
	while (newSeconds != startCount ) {
		time = new Date() ;
		newSeconds = time.getSeconds() ;
		}
 }


// figure out what the users' screen size is so that we can always put the install window in the beginning.
function ScreenSize()
	{
      if (navigator.javaEnabled())    // if Enable Java checkbox is checked then we can do the rest...
      {
         var tools=java.awt.Toolkit.getDefaultToolkit(); // tools object now exists and we can use 'em
         var size=tools.getScreenSize();	// Identify the users' screen size.
         width=size.width;					//on-the-fly declaration of global variable width
         height=size.height;				//on-the-fly declaration of global variable height
      }
	}


//this function updates the text in the middle frame of the window that was previously set up in 'setupwindows' function.
//You can pass it a font size, text, how long you want the message to be displayed, and flip flop between error and success 
//graphic states which you can define ahead of time.  The graphics show in the lower frame.
function updateStatusText(hSize, text, delayTime, graphic )
{
if (!silentValue) 
  {
//check to see if the window is closed, if it is, re-open it.
//dbgMsg("value for barf is: " + wndw.closed) ;
if (wndw.closed)
	{
if (!silentValue)
	{
	alert ("Please do not close the information window until the install is complete.") ;
	}
	setupWindows() ;
	}
	var defaultSize = PARAM_FONT_SIZE_FOR_UPDATE ;    //default size for status window messages text.
	if (hSize == "")
		hSize = defaultSize ;

	if (debugOutput == true) 
		{
		java.lang.System.out.println(text) ;		
		}

	if (!silentValue) 
		{
		wndw.frames[0].document.bgColor="white" ;
		wndw.frames[1].document.bgColor="white" ;
		wndw.frames[2].document.bgColor="white" ;
		wndw.frames[1].document.close() ;
		line="<HTML><BODY><SCRIPT>document.bgColor='white'</SCRIPT><CENTER><FONT FACE="+PARAM_FONT_FACE+" SIZE="+PARAM_FONT_SIZE+"5 COLOR=BLUE><BR><H"+hSize+">"+text+"</H"+hSize+"><BR></CENTER></BODY></HTML>";
		wndw.frames[1].document.close() ;  //clean the window first.
		wndw.frames[1].document.write(line) ;
		wndw.frames[1].document.close() ;  //clean the window first.
		
		if (graphic != "") 
			{
   	    	if (graphic == "error")
				{
    	        line="<HTML><BODY><SCRIPT>document.bgColor='white'</SCRIPT><CENTER><IMG HEIGHT=100 SRC=http://home.netscape.com/download/images/mozilla_bungee.gif></CENTER></BODY></HTML>" ;
	   	    	wndw.frames[2].document.close() ;  //clean the window first.
		        wndw.frames[2].document.write(line) ;
		        wndw.frames[2].document.close() ;  //clean the window first.
				}
   			else
			if (graphic == "normal")
				{
	            line="<HTML><BODY><SCRIPT>document.bgColor='white'</SCRIPT><CENTER><IMG WIDTH=360 SRC=http://home.netscape.com/download/images/mozilla_hurdles.gif></CENTER></BODY></HTML>" ;
	   	    	wndw.frames[2].document.close() ;  //clean the window first.
		        wndw.frames[2].document.write(line) ;
		        wndw.frames[2].document.close() ;  //clean the window first.
				}
    		}
		
		if (delayTime != 0)	delay(delayTime) ; 
		}
  }
}




//Call this function ifyou want to bail out of the installer.
function abortMe() {
			// check here for what the error numbers are.
			//if 999 then reset to zero and do nothing. Otherwise, proceed with abort.
			//999 is when files are in use.  Everything is pretty much correct if you get a 999.
			if (err!=999)  
				{
				java.lang.System.out.println(ERR_ABORT_WITH_ERRNO + err) ;
				if (!silentValue) { 
					wndw.close() ;
					}
				su.AbortInstall() ;
				errorFlag = true ;
				return ;
				}
			else 
				{
				err = 0
				return ;
				}
}


//if you get an error, you cancall this function to parse it.
function errorParse(err) {
	switch (err) {
		case -210 :
			updateStatusText(4, ERR_210_INSTALL_CANCELLED, 5, "error") ;
			break ;
		case -201 :
			updateStatusText(4, ERR_201_NOT_GRANTED, 5, "error") ;
			break ;
		case -200 :
			updateStatusText(4, ERR_200_BAD_PACK_NAME, 5, "error") ;
			break ;
		case -202 :
			updateStatusText(4, ERR_202_ACCESS_DENIED, 5, "error") ;
			break ;
		case -203 :
			updateStatusText(4, ERR_203_TOO_MANY_CERTS, 5, "error") ;
			break ;
		case -204 :
			updateStatusText(4, ERR_204_NO_CERTS) ;
			break ;
		case -205 :
			updateStatusText(4, ERR_205_FILE_NOT_SIGNED, 5, "error") ;
			break ;
		case -206 :
			updateStatusText(4, ERR_206_FILE_NOT_CERTS, 5, "error") ;
			break ;
		case -207 :
			updateStatusText(4, ERR_207_JAR_NOT_OPENED, 5, "error") ;
			break ;
		case -208 :
			updateStatusText(4, ERR_208_BAD_ARGS_TO_FUNC, 5, "error") ;
			break ;
		case -209 :
			updateStatusText(4, ERR_209_BAD_PATH, 5, "error") ;
			break ;
		case -211 :
			updateStatusText(4, ERR_211_INSTALL_WONT_START, 5, "error") ;
			break ;
		case -20 :
			updateStatusText(4, ERR_20_CANT_SETUP_FILES, 4, "error") ;
			break ;
		case -1 :
			updateStatusText(4, ERR_1_CANT_ADD_COMP, 4, "error") ;
			break ;
		case -2 :
			updateStatusText(4, ERR_2_NOT_APPROVED, 4, "error") ;
			break ;
		case -3 :
			updateStatusText(4, ERR_3_WIN32_ONLY, 4, "error") ;
			break ;
		case -4 :
			updateStatusText(5,TEXT_BAD_PREV_INSTALL, 8, "error") ;	
			break ;
		case 999 :
			updateStatusText(4, ERR_999_FILES_IN_USE, 6, "normal") ;
			break ;

		default :
			updateStatusText(4, ERR_GENERIC_INSTALL_ERR, 5, "error") ;
		} //endswitch
} //end errorParse

//*************************** END OF HEADER FILE ****************************

function updateRegistry() 
{
return err ;
}

function setupFiles(su)
{
	var errFlag = false ; // to catch errors inside the addsubcomponent loops.
	var errString = "" ;
	updateStatusText(hSize,TEXT_ORGANIZING_INSTALL, 1, "normal") ;

	err = su.Execute("VEMPLAY.EXE");  //put in the name of the file you want to execute here.

	return err ;
}



function checkSystemEnvironment()  // OS check, memcheck, etc go here.
	{

clientVer = parseFloat(navigator.appVersion) ;
clientPlatform = navigator.platform ;
dbgMsg("clientPlatform is: " +clientPlatform) ;
if ((clientPlatform !="Win16") && (clientPlatform !="Win32"))
	{
	alert(ERR_NOT_FOR_THIS_OS) ;
	err = 210 ;
	return err ;
	}


//check platform before doing smartupdate stuff.
vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld) ;
registry_vi = netscape.softupdate.Trigger.GetVersionInfo(nsRegName);

	updateStatusText(4, TEXT_CLICK_GRANT, 0, "normal") ;	

	err = su.StartInstall(nsRegName, // Package name
							vi,
							1);  //new api 1= full install

	return err ;  //everything is OK.
}


function body() {	//this section works in clumps - each clump gets an error check after it's called.
					// the errorFlag is there to make sure I only call abortMe once.

	su = new netscape.softupdate.SoftwareUpdate( this, updateObjectName ) ;
	if (su == null) updateStatusText(hSize,TEXT_NONEWSUOBJ,1, "error") ;
	if ( (su != null) )
		{
		updateStatusText(hSize,TEXT_CHECKINGSYSTEM , 1, "") ;
		err = checkSystemEnvironment() ;  //checksystemenvironments, if it returns error, abort
		if (( err != 0 ) && (errorFlag == false)) 
			{
			 errorParse(err) ;
			 abortMe() ;
			}
//		if (err == 0) {
//			updateStatusText(hSize,TEXT_SETTINGUP_FILES, 1, "") ;
///			err = buildArray() ;
//			if (( err != 0 ) && (errorFlag ==false)) {
//				errorParse(err) ;
//				abortMe() ;
//				}
//			}

		if (err == 0) {		
			updateStatusText(hSize,TEXT_SETTINGUP_REST, 1, "") ;
			err = setupFiles(su) ;		  // and abort.
			if (( err != 0 ) && (errorFlag ==false)) {
				errorParse(err) ;
				abortMe() ;
				}
			}

		if (err == 0) {
			err = updateRegistry() ;
			if (( err != 0 ) && (errorFlag ==false)) {
				errorParse(err) ;
				abortMe() ;
				}
			}

		if (err == 0)
			{
//			updateStatusText(hSize, TEXT_ADDING_AIM, 2, "") ;   
//			addAim() ;
			//updateStatusText(hSize, TEXT_AIM_LAUNCHED, 3, "") ;
			}

		if (err == 0) 			// if we get to here, everything's cool and we can finalize install.
			{
			updateStatusText(hSize,TEXT_READYING_FILES, 4, true, "") ;   
			err = su.FinalizeInstall();	// This actually copies all the files to their right place
			if (err == 6)
				{
				err = 999 ; //special case for replacing netscape.exe only
				if (troubleFlag) // this is to catch false error 6 and continue with the trouble install case.
					{
					err = 0 ;
					}
				}
			if (( err != 0 ) && (errorFlag == false) && (!troubleFlag)) 
				{
				errorParse(err) ;
				abortMe() ;
				}
			}
			
		if (( err != 0 ) && (errorFlag ==false))	// If we have an error, write it to the console
			{
			errorParse(err) ;
			abortMe() ;
			}

		if (( err == 0 ) && (errorFlag ==false))	// If we have an error, write it to the console
			{
			updateStatusText(hSize, TEXT_INSTALL_COMPLETED, 4, "") ;   
			if (!silentValue)
				wndw.close() ;			
			dbgMsg("Install Completed.") ;
			}
		

	}// endif
}

// ================ START ================
// PRE FLIGHT CHECK
if (checkLang() && checkJava() && checkASD() )
{
	var troubleFlag = false ;
	var chkOS ;
	var chkOSNum ;
	var OSFlavor ;
	chkOS 		= java.lang.System.getProperty("os.name") ;
	chkOSNum	= java.lang.System.getProperty("os.version") ;
	OSFlavor	= navigator.platform ;
	if (navigator.platform == "Win32")
		bitNum 	= "32" ;
	else	
		bitNum 	= "16" ;

    // VARIABLE DECLARATIONS
	var shadowvar 		 = java.lang.System.getProperty("os.version") ;
	var osVer 			 = parseFloat(shadowvar) ;
	var topWindowTitle   = TEXT_TOPWINDOW_TITLE ;
	var updateObjectName = TEXT_UPDATEOBJ_NAME ;
	var defaultText      = TEXT_DEFAULT_TEXT ;
    var err              = 0;
    var hSize            = "4";
    var su               = null;
    var suEnv            = this;
    var errorFlag        = false;
    var delayTime        = 1;
    var silentValue      = this.silent;
    var graphic          = "";
    var graphic          = "";
    var debugOutput      = true;  // Turns debugging output on/off
    var nsRegName        = "/bonzi_software/voice_email_3.0/";  

    var installerVersion = "3.0 (en)";
    var versionMaj       = 3;
    var versionMin       = 0;
    var versionRel       = 0;
    var versionBld       = 1;

    setupWindows();

    body();
}// end of check for java and ASD enabled


