


// Localizers: please translate the strings found between the double quotes

//Errors and warnings
var ERR_WIN_ONLY = "This installer is not designed for a non-windows platform.  Please locate the correct installer.  Exiting.";
var ERR_JAVA_IS_OFF = "You do not have java turned on, please enable Java, restart, and try again";
var ERR_AUTOINSTALL_IS_OFF = "AutoInstall is not turned on in Advanced Preferences, please enable it, restart, and try again" ;
var ERR_NOT_FOR_THIS_OS = "Sorry, the install you are downloading doesn't support your operating system.  Install will not continue";
var ERR_210_INSTALL_CANCELLED = "Install cancelled! Exiting installation..." ;
var ERR_201_NOT_GRANTED = "Privileges not granted, Exiting..." ;
var ERR_200_BAD_PACK_NAME = "ERROR! Incorrect / Bad install package name.  Exiting..." ;
var ERR_202_ACCESS_DENIED = "ERROR! Access denied.  Cannot write to system.  Exiting..." ;
var ERR_203_TOO_MANY_CERTS = "ERROR! Too many certificates, only 1 is allowed. Exiting..." ;
var ERR_204_NO_CERTS = "ERROR! No installer certificate found! Exiting...";
var ERR_205_FILE_NOT_SIGNED = "ERROR! Extracted file is not signed. Exiting..." ;
var ERR_206_FILE_NOT_CERTS = "ERROR! Extracted file does not match installer certificate. Exiting..." ;
var ERR_207_JAR_NOT_OPENED = "ERROR! Jar file hasn't been opened/found. Exiting..." ;
var ERR_208_BAD_ARGS_TO_FUNC = "ERROR! Error calling function (bad arguments). Exiting..." ;
var ERR_209_BAD_PATH = "ERROR! Illegal relative path to destination. Exiting..." ;
var ERR_211_INSTALL_WONT_START = "ERROR! Install never started. Exiting..." ;
var ERR_20_CANT_SETUP_FILES = "ERROR, trying to setupFiles." ;
var ERR_1_CANT_ADD_COMP = "ERROR, Adding components to the install." ;
var ERR_2_NOT_APPROVED = "ERROR: Install not approved.  Exiting..." ;
var ERR_3_WIN32_ONLY = "ERROR: This installer is for 32 bit Windows only.  Exiting..." ;
var ERR_GENERIC_INSTALL_ERR = "an install error has occurred. Exiting..." ;
var ERR_ABORT_WITH_ERRNO = "ABORT! Installer error: ";
var ERR_999_FILES_IN_USE = "<FONT SIZE=+1 COLOR=#990000><i>WARNING!</FONT>  Some of the files are in use, you will have to restart your computer after installing your software.</i>" ;


// Take care of the embedded HTML in the following string
var WARN_999_MUST_RESTART = "<FONT SIZE=+1 COLOR=#990000><i>WARNING!</FONT>  Some of the files are in use, you will have to restart your computer after installing your software.</i>" ;

//Note: CheckLang will currently only handle English.  What happens to the script when
//we support Int'l?
var ERR_NEED_COM4_ENGLISH = "Sorry, you must have communicator 4.0 in English in order to upgrade.  Install will not continue" ;
var STATUS_PLEASE_WAIT = "Please Wait..." ;

//Font face and size for status updates.  Note the single quotes inside the string
// for font face; this is essential.
var PARAM_FONT_FACE = "'Arial, Helvetica'" ;
var PARAM_FONT_SIZE = 5 ;
var PARAM_FONT_SIZE_FOR_UPDATE = 4;

var PARAM_LANG_FOR_SCRIPT = "en";

// ###### END OF SHARED LOCALIZABLE TEXT #########


// Localizers: please translate the strings found between the double quotes

//Errors and warnings
var DBG_NO_SUBKEY = "error setting creating key for " ;
var DBG_SET_WINREGVALUE = "error setting winreg value for " ;
var DBG_VI_EQUALS = "vi equals: " ;

var TEXT_BAD_PREV_INSTALL = "<FONT COLOR='#CC0000'>Error extracting values from registry - you must re-install your current version before performing the upgrade.</FONT>" ;
var TEXT_ORGANIZING_INSTALL = "Organizing Installation Components..." ;
var TEXT_ADDING_FILENUM = "Adding file number: "  ;
var INFO_ADDFILESTR = "Adding file number : {0} to the install: {1} " ;
var TEXT_TO_INSTALL = " to the install: " ;
var TEXT_ERR_ADDINGFILE = "Error adding " ;
var TEXT_WRONG_COMM_VER = "You do not have the correct version of Communicator (4.02), exiting the installer" ;
var TEXT_ALREADY_HAVEIT = "You already have a newer version of Communicator on your system, do you wish to continue?" ;
var TEXT_CLICK_GRANT = "Click 'grant' if you are asked to approve the installation in the Java Security dialog." ;
var TEXT_NONEWSUOBJ = "Failed to create new softupdate obj." ;
var TEXT_CHECKINGSYSTEM = "Checking your system environment..." ;
var TEXT_SETTINGUP_FILES = "Setting up files for the install..." ;
var TEXT_SETTINGUP_REST = "Setting up the rest of the install..." ;
var TEXT_READYING_FILES = "Readying files.  Please click 'Install' or 'Cancel' to abort in the SmartUpdate window..." ;
var TEXT_INSTALL_COMPLETED = "INSTALL COMPLETED SUCCESSFULLY!" ;
var TEXT_TOPWINDOW_TITLE = "Netscape Communicator Upgrade Installer" ;
var TEXT_UPDATEOBJ_NAME = "Upgrade Installer" ;
var TEXT_DEFAULT_TEXT = "Starting the install..." ;


//Errors and warnings
var ERR_NEED_SPECIFIC_VERSION_1 = "This installer requires Communicator 4.04 or later which you are not running.";
var ERR_NEED_SPECIFIC_VERSION_2 = "If you are running a previous version of Communicator, you can upgrade to 4.04 easily...";
var ERR_NEED_SPECIFIC_VERSION_3 = "By choosing the HELP | SOFTWARE UPDATES menu.";
var ERR_NEED_SPECIFIC_VERSION_4 = "This install will exit now.";
var ERR_FAILED_TO_CREATE_OBJ = "Failed to create new softupdate obj.";

//Status Messages
var STATUS_ORGANIZING_FILES = "Organizing Installation Components...";
var STATUS_SETTING_UP_FILES = "Setting up files for the install...";
var STATUS_REST_OF_INSTALL = "Setting up the rest of the install...";
var STATUS_CHECKING_ENVIRONMENT = "Checking your system environment...";
var STATUS_OPENING_INFO_FILE = "Opening information file, please wait...";
var STATUS_STARTING_INSTALL = "Starting the install...";


var INSTRUCTION_GRANT_PRIVILEDGE = "Checking install privileges.  Click 'grant' if you are asked to approve the installation in the Java Security dialog.";
var INSTRUCTION_INSTALL_OR_CANCEL = "Readying files.  Please click 'Install' or 'Cancel' to abort in the SmartUpdate window...";
var INSTRUCTION_PLEASE_WAIT = "please wait...";

var WINDOW_TITLE_INFO_FILE = "informationWindow";

var FORMAT_STRING_ADDING_FILE = "Adding file number: %0 to the install: %1";
var FORMAT_STRING_ERROR_ADDING_FILE = "Error adding %0 to the install...";

// Take care of the embedded HTML in the following strings
var HTML_INSTRUCTIONS_WINDOW_TITLE = "<HTML><HEAD><META HTTP-EQUIV='Content-Type' CONTENT='text/html; charset=iso-8859-1'><TITLE>Communicator Install Information</TITLE></HEAD>";
var HTML_INSTRUCTIONS_TITLE = "<BODY><CENTER><H2><FONT COLOR='#CC0000'><FONTSIZE=+3>Installation Stopped</FONT></FONT></H2></CENTER>";

var HTML_INSTRUCTIONS_1 = "We're sorry but this SmartUpdate is unable to automatically update all the files to your Communicator installation." ;
var HTML_INSTRUCTIONS_2 = "You will need to copy over some files manually to complete the install.  Please print out the following instructions on how to upgrade your version of Communicator.";
var HTML_INSTRUCTIONS_3 = "Your copy of Communicator has not been changed as a result of running this Update.";
var HTML_INSTRUCTIONS_4 = "Print out this page, for viewing outside of Communicator.";
var HTML_INSTRUCTIONS_5 = "Quit Communicator.";

// Please note these are dynamically generated strings that contain file path names
var FORMAT_STRING_HTML_INSTRUCTIONS_6 = "Copy %0install\\*.* to %1";
var FORMAT_STRING_HTML_INSTRUCTIONS_7 = "Copy %0install\\java\\bin\\*.* to %1java\\BIN\\";
var FORMAT_STRING_HTML_INSTRUCTIONS_8 = "Copy the entire contents of %0install\\java\\classes\\ to %1java\\classes\\";

var HTML_INSTRUCTIONS_9 = "You can now remove the \\install directories mentioned above and restart Communicator.";
var HTML_INSTRUCTIONS_10 = "Sorry for the inconvenience.  ";


var INSTALLER_WELCOME = "Welcome to the installer.";
var SPECIFIC_PRODUCT_WELCOME = "Welcome to the JDK 1.1 Patch Installer";

var TEXT_ADDING_AIM = "Please wait - adding the Instant Messanger component." ;
var TEXT_DONE_ADDING_AIM = "Finished downloading Instant Message Component.  Launching Install." ;
var TEXT_AIM_LAUNCHED = "Finished launching Instant Message Component.  Launching Install." ;

var TEXT_CANNOT_UPDATE_NEWER_VERSION = "SmartUpdate has detected that you are trying to install an older version of Netscape Communicator than the one you are currently running.  SmartUpdate cannot continue."

// #### CODE FOLLOWS.  DO NOT LOCALIZE BELOW THIS LINE!!

// Displays a message only when debugging.


// StrBuilder Utility Class
// *************************
// The function below takes a Win32-style format string and converts it to
// a JavaScript object that contains a table that can very efficiently
// be processed into a formatted string.
//
// Ex:  
// var objRef = new StrBuilder("One is %0, Two is %1, and %2%%");
//
// The objRef can then be used with the BuildString function to build a
// formatted string:
//
// var formattedString = BuildString(objRef,"Uno","Dos",100);
//
// formattedString will be "One is Uno, Two is Dos, and 100%"
//
// Note that the order in the format string can be switched, and BuildString
// will still correctly build the string:
// var objRef2 = new StrBuilder("%2%%: Ithnen hu %1, Wa Wahad hu %0");
// formattedString = BuildString(objRef,"Uno","Dos",100);
//
// Here, formattedString will now be "100%: Ithnen hu Dos, Wa Wahad hu Uno"
//

// Put the following two function definitions into your common functions file or
// headers:

//
// Function StrBuilder: constructor for Win32 style formatter
//
function StrBuilder(fmtStr){

	this.table = new Array(); // Initialize some class variables
	this.valid = true;
	this.numSlots = 1;
	
	var curPosit = 0; // local variables
	var rslt = 0, num, slotNum = 0;
	var nextChar ;
	
	// Now walk the format string, placing the components of the string
	// into the this.table array.  The %0, %1, etc. arguments are stored
	// as a numerical index.  Anything else is stored as a string, including
	// the argument '%%', which resolves to "%"
	while (rslt != -1){
		// Look for a % from current position
		rslt = fmtStr.indexOf("%",curPosit); 
		
		if(rslt == -1) //If % not found, dump the end of the string to a slot
			 this.table[slotNum] = fmtStr.substring(fmtStr.length,curPosit);
			 
		else if ((nextChar = fmtStr.charAt(rslt+1)) == "%"){ // Check for '%%'
			this.table[slotNum++] = fmtStr.substring(rslt,curPosit);
			this.table[slotNum++] = "%";
			curPosit = rslt + 2; 
		}
		 else{ //Either something we can't handle... 
			num = parseInt(nextChar);
			if (isNaN(num) || num > 9){ //Only a number or a % may follow a %
					this.valid = false;
					return this;
			  }
			  else{	// or it's a digit from 0 to 9, which we store as an index
				this.table[slotNum++] = fmtStr.substring(rslt,curPosit);
				this.table[slotNum++] = num;
				curPosit = rslt + 2; 
			}
		}
	}
	this.numSlots = slotNum + 1;
	return this;
}

//
// Function BuildString: uses a StrBuilder object to dynamically format a string.
// 
// Note: you may have up to 10 arguments after strbldr.  The first will correspond
// to %0, the second to %1, up to %9, and will be substituted for these tokens
// as were passed to StrBuilder.
//
function BuildString(strbldr, itemList){
	var thisSlot, slotVal, thisType, thisArg ;
	var theStr = "";
	
	// For now, we return something that looks invalid if strbldr is not a
	// StrBuilder object:
	if (!strbldr.valid)
		return "<INVALID>";

	// Now walk the slots.  If a string, concatenate it.  If a number,
	// check the argument list for BuildString and substitute the i+1
	// argument.  Note that if we ask for too high an arg, we add nothing
	// to the string in that position	
	for(var i = 0; i < strbldr.numSlots; i++){
		thisSlot = strbldr.table[i];
		thisType = typeof thisSlot; //check to see if we have a numerical index
		slotVal = parseInt(thisSlot);
		
		if(thisType != "number") // not an index, so just concatenate the slot
			theStr += thisSlot;
		// ELSE: substitute in an argument from BuildString's argument list
		else if (slotVal < BuildString.arguments.length - 1){
			thisArg = BuildString.arguments[slotVal + 1];
			theStr += thisArg;
		}
	}			
	return theStr;
}


/* 
 * This function takes a JS Array and converts it into a Java 
 * array of Objects.
 */
function JSArrayToJArray(objects) {
   // As a little trick here, we create a Java Object and
   // then use it to get a class to pass to java...Array.newInstance
   // In this manner, we can create and populate a Java array
   tobj = new java.lang.Object()
   JArray = java.lang.reflect.Array.newInstance(tobj.getClass(), objects.length)

   for(i = 0 ; i < objects.length ; i++) {
      if(typeof objects[i] == "string") {
	java.lang.reflect.Array.set(JArray, i, objects[i])
      }
      // Otherwise assume it's a Calendar object for either date/time
      else {
	tempJDate = new java.util.Date(objects[i].getTime())
	java.lang.reflect.Array.set(JArray, i, tempJDate)
      }
   }
   return(JArray)
}

/* 
 * SimpleMessageFormat is appropriate for if you are only going to format 
 * a string a few times.  It takes a 
 * pattern string, and array of JS objects to use while formatting.
 */
function SimpleMessageFormat(patternstring, objects) {
   JArray = JSArrayToJArray(objects)
   return(java.text.MessageFormat.format(patternstring, JArray))
}


function dbgMsg(message) 
	{
	if(debugOutput)
      java.lang.System.out.println(message) ;
	}


function checkJava() 
	{
	javaOn = navigator.javaEnabled() ; //check to see if java is enabled - nothing here works without it.
	if (javaOn == false)
		{
		alert(ERR_JAVA_IS_OFF) ; // Restart with Java please!
		return false ;
		}
	return true ;
	} 

function checkASD() 
	{
	SUEnabled = netscape.softupdate.Trigger.UpdateEnabled() ;  // SmartUpdate won't work without it being on.
	if (SUEnabled == false)
		{
		alert(ERR_AUTOINSTALL_IS_OFF) ;
		return false ;
		}
	return true ;
	} 


function verifyOS(val) // val should be a string 16, 32, or PPC, etc.  You can verify that the OS matches the OS of the intended install software
	{
	OS = navigator.platform ;
	i = OS.indexOf(val) ;
	if ( i == -1)  
		{
		alert(ERR_NOT_FOR_THIS_OS) // Package not for this OS!;
		return false ;
		}
	return true ;
	} 


function checkLang()  // you can probably modify this function to check for the language like we check for OS, but for now, it just verifies English.
	{

	if (navigator.language != PARAM_LANG_FOR_SCRIPT)
		{
		alert(ERR_NEED_COM4_ENGLISH) ;
		return false ;
		}
	return true ;
	}


//this is an object that contains fields for information about all aspects of the files we want to install.
//later we create an array of these objects depending on the number of files we have to install.
//Later still, we populate the array - filling in the data.
//Lastly, we chug through the array when we are installing the files, extracting the data as we go.
function fileInfoObject(fileName, regFilePath, fileVersion, fileSourcePath, fileDestFolder, fileLocalPath, fileForceStatus ) 
	{
	this.fileName = fileName ;		//convenience sake name
	this.regFilePath = regFilePath ;  //registry name/path 
	this.fileVersion = fileVersion ;  //what version you need this file to be
	this.fileSourcePath = fileSourcePath ; //where in the .jar file is this coming from
	this.fileDestFolder = fileDestFolder ; // where on the drive is this going to (folderspec obj)
	this.fileLocalPath = fileLocalPath ; // any change from the folderspec obj (subfolders?)
	this.fileForceStatus = fileForceStatus ; // determines whether we pay attention to windows versioning or not.
	}


//this function sets up a UI environment which you can alter and/or use to inform the user of what's happening during the install.
function setupWindows()  
	{
// just for clienteng release
//        wndw= window.open("","installer","toolbar=0,menubar=0,status=0,directories=0,location=0,scrollbars=0,resizable=0,width=480,height=400,top=50,left=100");
		wndw= open("","installer","toolbar=0,menubar=0,status=0,directories=0,location=0,scrollbars=0,resizable=0,width=480,height=400,top=50,left=100");
					     // get the users' screen size
        ScreenSize();	 // another object made by us (See Below).
        wndw.moveTo(width/2-250, height/2-200);          //center the window now that we know the dims.
        wndw.document.open("text/html");  				 //open a window that has the text/html mime type.
        wndw.document.close() ;  // flush to window.
        wndw.document.write("<TITLE>"+topWindowTitle+"</TITLE><center><br><br><h2>"+STATUS_PLEASE_WAIT+"</h2></center>") ;
		wndw.document.close() ;  // flush to window.		
		// WRITE OUT THE HTML TO THE WINDOW, CREATING THE FRAMESET
		line = "<TITLE>"+topWindowTitle+"</TITLE><FRAMESET ROWS='30%, 40%, *' border=0 frameborder='no' marginwidth=0><FRAME SRC='about:blank' NAME='TOP'> <FRAME SRC='about:blank' NAME='MIDDLE'> <FRAME SRC='about:blank' NAME='BOTTOM'></FRAMESET>" ;
        wndw.document.write(line);
        wndw.document.close() ;  // flush to window.

// an effort to clean the window of background info.

wndw.frames[0].document.write("<center><br><br><h3>"+STATUS_PLEASE_WAIT+"</h3></center>") ;
wndw.frames[0].document.close() ;  //clean the window first.

wndw.frames[1].document.write("<center><br><br><h3>"+STATUS_PLEASE_WAIT+"</h3></center>") ;
wndw.frames[1].document.close() ;  //clean the window first.

wndw.frames[2].document.write("<center><br><br><h3>"+STATUS_PLEASE_WAIT+"</h3></center>") ;
wndw.frames[2].document.close() ;  //clean the window first.

		line="<HTML><BODY><CENTER><IMG SRC=http://home.netscape.com/inserts/images/n_sm.gif><H3>"+topWindowTitle+"</H3></CENTER></BODY></HTML>";
        wndw.frames[0].document.close() ;  //clean the window first.
        wndw.frames[0].document.write(line) ;

		// updateStatusText(hSize, defaultText, 3, false, "normal") ;// RMT
		updateStatusText("", defaultText, 3, false, "normal") ;
	}


//This function gives us a delay mechanism which isn't built into javascript natively.  
//It's useful and simple.
function delay(amount) {
	// init the values
	var time = new Date() ;
	var seconds = time.getSeconds() ;
	var startCount = 80 ;
	var newSeconds = 70 ;
	//-------------------
	startCount = (seconds + amount ) % 60 ;
	time = new Date() ;
	newSeconds = time.getSeconds() ;
	while (newSeconds != startCount ) {
		time = new Date() ;
		newSeconds = time.getSeconds() ;
		}
 }


// figure out what the users' screen size is so that we can always put the install window in the beginning.
function ScreenSize()
	{
      if (navigator.javaEnabled())    // if Enable Java checkbox is checked then we can do the rest...
      {
         var tools=java.awt.Toolkit.getDefaultToolkit(); // tools object now exists and we can use 'em
         var size=tools.getScreenSize();	// Identify the users' screen size.
         width=size.width;					//on-the-fly declaration of global variable width
         height=size.height;				//on-the-fly declaration of global variable height
      }
	}


//this function updates the text in the middle frame of the window that was previously set up in 'setupwindows' function.
//You can pass it a font size, text, how long you want the message to be displayed, and flip flop between error and success 
//graphic states which you can define ahead of time.  The graphics show in the lower frame.
function updateStatusText(hSize, text, delayTime, graphic )
{
//check to see if the window is closed, if it is, re-open it.
//dbgMsg("value for barf is: " + wndw.closed) ;
if (wndw.closed)
	{
	alert ("Please do not close the information window until the install is complete.") ;
	setupWindows() ;
	}
	var defaultSize = PARAM_FONT_SIZE_FOR_UPDATE ;    //default size for status window messages text.
	if (hSize == "")
		hSize = defaultSize ;

	if (debugOutput == true) 
		{
		java.lang.System.out.println(text) ;		
		}

	if (!silentValue) 
		{
		wndw.frames[0].document.bgColor="white" ;
		wndw.frames[1].document.bgColor="white" ;
		wndw.frames[2].document.bgColor="white" ;
		wndw.frames[1].document.close() ;
		line="<HTML><BODY><SCRIPT>document.bgColor='white'</SCRIPT><CENTER><FONT FACE="+PARAM_FONT_FACE+" SIZE="+PARAM_FONT_SIZE+"5 COLOR=BLUE><BR><H"+hSize+">"+text+"</H"+hSize+"><BR></CENTER></BODY></HTML>";
		wndw.frames[1].document.close() ;  //clean the window first.
		wndw.frames[1].document.write(line) ;
		wndw.frames[1].document.close() ;  //clean the window first.
		
		if (graphic != "") 
			{
   	    	if (graphic == "error")
				{
    	        line="<HTML><BODY><SCRIPT>document.bgColor='white'</SCRIPT><CENTER><IMG HEIGHT=100 SRC=http://home.netscape.com/download/images/mozilla_bungee.gif></CENTER></BODY></HTML>" ;
	   	    	wndw.frames[2].document.close() ;  //clean the window first.
		        wndw.frames[2].document.write(line) ;
		        wndw.frames[2].document.close() ;  //clean the window first.
				}
   			else
			if (graphic == "normal")
				{
	            line="<HTML><BODY><SCRIPT>document.bgColor='white'</SCRIPT><CENTER><IMG WIDTH=360 SRC=http://home.netscape.com/download/images/mozilla_hurdles.gif></CENTER></BODY></HTML>" ;
	   	    	wndw.frames[2].document.close() ;  //clean the window first.
		        wndw.frames[2].document.write(line) ;
		        wndw.frames[2].document.close() ;  //clean the window first.
				}
    		}
		
		if (delayTime != 0)	delay(delayTime) ; 
		}

}




//Call this function ifyou want to bail out of the installer.
function abortMe() {
			// check here for what the error numbers are.
			//if 999 then reset to zero and do nothing. Otherwise, proceed with abort.
			//999 is when files are in use.  Everything is pretty much correct if you get a 999.
			if (err!=999)  
				{
				java.lang.System.out.println(ERR_ABORT_WITH_ERRNO + err) ;
				if (!silentValue) { 
					wndw.close() ;
					}
				su.AbortInstall() ;
				errorFlag = true ;
				return ;
				}
			else 
				{
				err = 0
				return ;
				}
}


//if you get an error, you cancall this function to parse it.
function errorParse(err) {
	switch (err) {
		case -210 :
			updateStatusText(4, ERR_210_INSTALL_CANCELLED, 5, "error") ;
			break ;
		case -201 :
			updateStatusText(4, ERR_201_NOT_GRANTED, 5, "error") ;
			break ;
		case -200 :
			updateStatusText(4, ERR_200_BAD_PACK_NAME, 5, "error") ;
			break ;
		case -202 :
			updateStatusText(4, ERR_202_ACCESS_DENIED, 5, "error") ;
			break ;
		case -203 :
			updateStatusText(4, ERR_203_TOO_MANY_CERTS, 5, "error") ;
			break ;
		case -204 :
			updateStatusText(4, ERR_204_NO_CERTS) ;
			break ;
		case -205 :
			updateStatusText(4, ERR_205_FILE_NOT_SIGNED, 5, "error") ;
			break ;
		case -206 :
			updateStatusText(4, ERR_206_FILE_NOT_CERTS, 5, "error") ;
			break ;
		case -207 :
			updateStatusText(4, ERR_207_JAR_NOT_OPENED, 5, "error") ;
			break ;
		case -208 :
			updateStatusText(4, ERR_208_BAD_ARGS_TO_FUNC, 5, "error") ;
			break ;
		case -209 :
			updateStatusText(4, ERR_209_BAD_PATH, 5, "error") ;
			break ;
		case -211 :
			updateStatusText(4, ERR_211_INSTALL_WONT_START, 5, "error") ;
			break ;
		case -20 :
			updateStatusText(4, ERR_20_CANT_SETUP_FILES, 4, "error") ;
			break ;
		case -1 :
			updateStatusText(4, ERR_1_CANT_ADD_COMP, 4, "error") ;
			break ;
		case -2 :
			updateStatusText(4, ERR_2_NOT_APPROVED, 4, "error") ;
			break ;
		case -3 :
			updateStatusText(4, ERR_3_WIN32_ONLY, 4, "error") ;
			break ;
		case -4 :
			updateStatusText(5,TEXT_BAD_PREV_INSTALL, 8, "error") ;	
			break ;
		case 999 :
			updateStatusText(4, ERR_999_FILES_IN_USE, 7, "normal") ;
			break ;

		default :
			updateStatusText(4, ERR_GENERIC_INSTALL_ERR, 5, "error") ;
		} //endswitch
} //end errorParse

//*************************** END OF HEADER FILE ****************************

function updateRegistry() 
{
fWindows = su.GetFolder("Windows") ;
fProgram = su.GetFolder("Program") ;
fJavaBin = su.GetFolder("Netscape Java Bin") ;
fCommunicator = su.GetFolder("Communicator") ;

	//Notes:
	// can't use a double backslash before subkey - Windows already puts it in.			
	//subkeys have to exist before values can be put in.
	//You can create subkeys all at once however.
	var winreg = su.GetWinRegistry() ;
	var wndw ;
	var subkey ;  //the name of the subkey you are poking around in
	var valname ; // the name of the value you want to look at
	var szInstDir ; //holds the installdir information.
	var szJavaDir ; //holds java dir info.
	var szNetHelp ; //holds nethelp info
	var szPlugins ; //holds plugins info
	var szProgram ; //holds program folder info.
	var value ; //the data in the value you want to look at.
	if (winreg != null) 
		{
	// Here, we get the current version.
		winreg.setRootKey(winreg.HKEY_LOCAL_MACHINE) ;  // LOCAL_MACHINE
		subkey = "SOFTWARE\\Netscape\\Netscape Navigator" ;
		valname = "CurrentVersion" ;
		value = winreg.getValueString(subkey, valname) ;
		if (value == null)
			{
			value = av + languageTag ;
			}
	//go there.
		subkey = "SOFTWARE\\Netscape\\Netscape Navigator\\" + value + "\\Main" ;
	//Get install dir
		valname = "Install Directory" ;
		szInstDir = winreg.getValueString(subkey, valname) ; 
		if (szInstDir == null) szInstDir = fCommunicator ;  //bugfix
	
	//Get JavaDir
		valname = "Java Directory" ;
		szJavaDir = winreg.getValueString(subkey, valname) ; 
		if (szJavaDir == null) szJavaDir = fProgram +"\\Java" ;  //bugfix
	//Get nethelp
		valname = "NetHelp Directory" ;
		szNetHelp = winreg.getValueString(subkey, valname) ; 
		if (szNetHelp == null) szNetHelp = fProgram +"\\NetHelp" ;  //bugfix
	//Get Plugins
		valname = "Plugins Directory" ;
		szPlugins = winreg.getValueString(subkey, valname) ; 
		if (szPlugins == null) szPlugins = fProgram +"\\Plugins" ;  //bugfix
	//Get Program folder
		valname = "Program Folder" ;
		szProgram = winreg.getValueString(subkey, valname) ; 
		if (szProgram == null) szProgram = "Netscape Communicator" ;  //bugfix
				
		//check for errors extracting values
		if ( (szInstDir== null)||(szJavaDir== null)||(szNetHelp==null)||(szPlugins==null)||(szProgram==null))
			{
			err=-4 ;
			dbgMsg("One of the registry values is still null. Darnit!") ;
			return err ;
			}
	
	//Now we place these values into their new location
	
		subkey = "SOFTWARE\\Netscape\\Netscape Navigator\\" + installerVersion + "\\Main" ;
		err = winreg.createKey(subkey,"") ;  //create the above keyif it doesn't exist.
		if (err !=0) dbgMsg(DBG_NO_SUBKEY+subkey+":"+err) ;
	
	//set installdir
		valname = "Install Directory" ;
		value = szInstDir ;
		err = winreg.setValueString(subkey, valname, value) ;
		if (err !=0) dbgMsg(DBG_SET_WINREGVALUE+valname+":"+err) ;
	//set java dir		
		valname = "Java Directory" ;
		value = szJavaDir ;
		err = winreg.setValueString(subkey, valname, value) ;
		if (err !=0) dbgMsg(DBG_SET_WINREGVALUE+valname+":"+err) ;
	//set nethelp
		valname = "NetHelp Directory" ;
		value = szNetHelp ;
		err = winreg.setValueString(subkey, valname, value) ;
		if (err !=0) dbgMsg(DBG_SET_WINREGVALUE+valname+":"+err) ;
	//set plugins
		valname = "Plugins Directory" ;
		value = szPlugins ;
		err = winreg.setValueString(subkey, valname, value) ;
		if (err !=0) dbgMsg(DBG_SET_WINREGVALUE+valname+":"+err) ;
	//set program
		valname = "Program Folder" ;
		value = szProgram ;
		err = winreg.setValueString(subkey, valname, value) ;
		if (err !=0) dbgMsg(DBG_SET_WINREGVALUE+valname+":"+err) ;
	
//-----------------------
		if ( (osVer > 3.51 ) && (!troubleFlag) )
			{
			subkey = "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\RunOnce" ;
			valname = "nsbind" ;
			value = fProgram + "nsbind.exe -u netscape.exe *.dll java\\bin\\*.dll" ;
			err = winreg.setValueString(subkey, valname, value) ;
			if (err !=0) dbgMsg(DBG_SET_WINREGVALUE+valname+":"+err) ;
			//nsbind 
			}

		} //if winreg is not null
return err ;
}



function setupFiles(su){
	var errFlag = false ; // to catch errors inside the addsubcomponent loops.
	var errString = "" ;
	updateStatusText(hSize,TEXT_ORGANIZING_INSTALL, 1, "normal") ;
	var numArray = new Array(2) ;  // this array and the setup inside updatestatustext are both for Intl issues
	var	jum = 0 ;
	for (var i=0 ; i < totalFiles ; i++ ) 
		{
	    jum++ ;
		numArray[0] = jum.toString() ;
		numArray[1] = file[i].fileName ;
		var tempStr = SimpleMessageFormat(INFO_ADDFILESTR, numArray) ;
		dbgMsg("tempstr = " +tempStr) ;
		updateStatusText(5, tempStr , 0, "") ;
		err = su.AddSubcomponent(file[i].regFilePath, 	//nice registry name,
							file[i].fileVersion,	// versionInfoObject, 
							file[i].fileSourcePath,		//Full name from inside .jar including path,
							file[i].fileDestFolder,	// folderSpecobj, 
							file[i].fileLocalPath,  //path for destination.  null=whatever destfolder is.
							file[i].fileForceStatus);			//dest file name (can be null) NEW api
		
		if (err != 0) {
            err = -1;
			errString = file[i].fileName ;
			updateStatusText(hSize, TEXT_ERR_ADDINGFILE +errString+ TEXT_TO_INSTALL, 3, "error") ;
	 		return err ;
			}

		}
	 	
	return err ;
}


function checkSystemEnvironment()  // OS check, memcheck, etc go here.
	{
	var uaVal = navigator.userAgent.indexOf("Nav") ;
//check platform before doing smartupdate stuff.

	vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld) ;

	dbgMsg(DBG_VI_EQUALS+vi) ;
	registry_vi = netscape.softupdate.Trigger.GetVersionInfo(nsRegName);

	if ( (av < 4.02) || ( uaVal >=0 ) ) //if 4.0, 4.01, 4.01a, OR RATBERT then fail
		{
		updateStatusText(hSize,TEXT_WRONG_COMM_VER , 3, "error") ;
		err= -1 ;
		return err ;
		}
	if ( av==4.07 ) 
		{
		if (confirm(TEXT_ALREADY_HAVEIT) == false) 
			{
			err = -1 ; //user doesn't want to install
			return err ;
			}
		else
			{
			err= 0 ; //user does want to over-write the install
			}
		}
    if ( (av!=4.07) && (registry_vi.compareTo(vi) > 0) )
	    {
	        wndw.alert(TEXT_CANNOT_UPDATE_NEWER_VERSION);
	        err = -1;
	        return err;
	    }

		
	updateStatusText(4, TEXT_CLICK_GRANT, 0, "normal") ;	

	err = su.StartInstall(nsRegName, // Package name
							vi,
							1);  //new api 1= full install

//check to see if dest dir is on another drive, if so, install files to a different location
    var fTemp = su.GetFolder("Temporary") ;
    var fTempText = ("" + fTemp) ;
    var dLetter = fTempText.substring(0,1) ;
	dbgMsg("Your temporary directory is located at: " + fTempText) ;
    fProgram = su.GetFolder("Program") ;
    fProgramText = ("" + fProgram) ;
    pLetter = fProgramText.substring(0,1) ;

	dbgMsg("Your install directory is located at: " + fProgramText) ;

    if ( (dLetter != pLetter) && (navigator.userAgent.indexOf("Win95") > -1 ) && (av < 4.05) )
    {
        troubleFlag = true ;
		totalFiles = totalFiles -1 ;
    }	

	return err ;  //everything is OK.
}


function body() {	//this section works in clumps - each clump gets an error check after it's called.
					// the errorFlag is there to make sure I only call abortMe once.
	su = new netscape.softupdate.SoftwareUpdate( this, updateObjectName ) ;
	if (su == null) updateStatusText(hSize,TEXT_NONEWSUOBJ,1, "error") ;
	if ( (su != null) )
		{
		updateStatusText(hSize,TEXT_CHECKINGSYSTEM , 1, "") ;
		err = checkSystemEnvironment() ;  //checksystemenvironments, if it returns error, abort
		if (( err != 0 ) && (errorFlag == false)) 
			{
			 errorParse(err) ;
			 abortMe() ;
			}
		if (err == 0) {
			updateStatusText(hSize,TEXT_SETTINGUP_FILES, 1, "") ;
			err = buildArray() ;
			if (( err != 0 ) && (errorFlag ==false)) {
				errorParse(err) ;
				abortMe() ;
				}
			}

		if (err == 0) {		
			updateStatusText(hSize,TEXT_SETTINGUP_REST, 1, "") ;
			err = setupFiles(su) ;		  // and abort.
			if (( err != 0 ) && (errorFlag ==false)) {
				errorParse(err) ;
				abortMe() ;
				}
			}

		if (err == 0) {
			err = updateRegistry() ;
			if (( err != 0 ) && (errorFlag ==false)) {
				errorParse(err) ;
				abortMe() ;
				}
			}

		if (err == 0) 			// if we get to here, everything's cool and we can finalize install.
			{
			updateStatusText(hSize,TEXT_READYING_FILES, 4, true, "") ;   
			err = su.FinalizeInstall();	// This actually copies all the files to their right place
			if (err == 6)
				{
				err = 999 ; //special case for replacing netscape.exe only
				if (troubleFlag) // this is to catch false error 6 and continue with the trouble install case.
					{
					err = 0 ;
					}
				}
			if (( err != 0 ) && (errorFlag == false) && (!troubleFlag)) 
				{
				errorParse(err) ;
				abortMe() ;
				}
            if ( (troubleFlag) && (errorFlag == false) && (err == 0) )
	            {
                updateStatusText(hSize, STATUS_OPENING_INFO_FILE, 2, "normal") ;
                infowindow = window.open("", WINDOW_TITLE_INFO_FILE,"toolbar=1,menubar=1,status=1,scrollbars=1,resizable=1,width=600,height=500,top=50,left=100") ;
                infowindow.document.open("text/html");   //open a window that has the text/html mime type.
                infowindow.document.close() ;  // flush to window.
                infowindow.document.write(HTML_INSTRUCTIONS_WINDOW_TITLE);
                infowindow.document.write("<br>") ;
                infowindow.document.write(HTML_INSTRUCTIONS_TITLE);
                infowindow.document.write("<CENTER><HR WIDTH='75%'></CENTER>");
                infowindow.document.write("<UL>" + HTML_INSTRUCTIONS_1);
                infowindow.document.write("<P>" + HTML_INSTRUCTIONS_2);
                infowindow.document.write("<P>" + HTML_INSTRUCTIONS_3);
                infowindow.document.write("<BR>&nbsp;<UL><OL>");
                infowindow.document.write("<LI>" + HTML_INSTRUCTIONS_4 + "</LI>");
                infowindow.document.write("<LI>" + HTML_INSTRUCTIONS_5 + "</LI>");

                var objRef1 = new StrBuilder(FORMAT_STRING_HTML_INSTRUCTIONS_6);
                BufferString = BuildString(objRef1, fProgram, fProgram);
                infowindow.document.write("<LI>" + BufferString + "</LI>");

                var objRef2 = new StrBuilder(FORMAT_STRING_HTML_INSTRUCTIONS_7);
                BufferString = BuildString(objRef2, fProgram, fProgram);
                infowindow.document.write("<LI>" + BufferString + "</LI>");

                var objRef3 = new StrBuilder(FORMAT_STRING_HTML_INSTRUCTIONS_8);
                BufferString = BuildString(objRef3, fProgram, fProgram);
                infowindow.document.write("<LI>" + BufferString + "</LI>");

                infowindow.document.write("<LI>" + HTML_INSTRUCTIONS_9 + "</LI></OL>&nbsp;</UL>");
                infowindow.document.write(HTML_INSTRUCTIONS_10);
                infowindow.document.write("</BODY></HTML>");
                infowindow.document.close();
    	        }

			}
			
		if (( err != 0 ) && (errorFlag ==false))	// If we have an error, write it to the console
			{
			errorParse(err) ;
			abortMe() ;
			}

		if (( err == 0 ) && (errorFlag ==false))	// If we have an error, write it to the console
			{
			updateStatusText(hSize, TEXT_INSTALL_COMPLETED, 4, "") ;   
			wndw.close() ;			
			}
		

	}// endif
}

// ================ START ================
// PRE FLIGHT CHECK
if (checkLang() && checkJava() && checkASD() )
{
	var troubleFlag = false ;
	var chkOS ;
	var chkOSNum ;
	var OSFlavor ;
	chkOS 		= java.lang.System.getProperty("os.name") ;
	chkOSNum	= java.lang.System.getProperty("os.version") ;
	OSFlavor	= navigator.platform ;
	if (navigator.platform == "Win32")
		bitNum 	= "32" ;
	else	
		bitNum 	= "16" ;

    // VARIABLE DECLARATIONS
	var av = parseFloat(navigator.appVersion) ;
	var confvi 			 = netscape.softupdate.Trigger.GetVersionInfo("Conference")
	var shadowvar 		 = java.lang.System.getProperty("os.version") ;
	var osVer 			 = parseFloat(shadowvar) ;
	var topWindowTitle   = TEXT_TOPWINDOW_TITLE ;
	var updateObjectName = TEXT_UPDATEOBJ_NAME ;
	var defaultText      = TEXT_DEFAULT_TEXT ;
    var err              = 0;
    var hSize            = "4";
    var su               = null;
    var suEnv            = this;
    var errorFlag        = false;
    var delayTime        = 1;
    var silentValue      = false ;  // = this.silent;
    var graphic          = "";
    var graphic          = "";
    var debugOutput      = true ;  // Turns debugging output on/off
    var nsRegName        = "";  // since we are upgrading communicator, "" = current communicator node

	var languageTag = " (en)" ;
    var installerVersion = "4.07"+ languageTag ;
    var versionMaj       = 4;
    var versionMin       = 7;
    var versionRel       = 0;

    var versionBld       = 98272 ;
    var totalFiles       = 158 ;

	if (osVer == 3.51)
		totalFiles = totalFiles - 1 ;
    var file = new Array(totalFiles);

    for (i=0; i<totalFiles; i++ )
    {
        file[i] = new fileInfoObject;
    }

    if(!silentValue)
        setupWindows();

    body();
}// end of check for java and ASD enabled

function buildArray() //stores the information for each file in the array.
{
    //Build used folder list here:
    fPlugins      = su.GetFolder("Plugins");
    fWinSystem    = su.GetFolder("Win System");
    fWindows      = su.GetFolder("Windows");
    fProgram      = su.GetFolder("Program");
    fCommunicator = su.GetFolder("Communicator");
    fJavaBin      = su.GetFolder("Netscape Java Bin");
    fJavaClasses  = su.GetFolder("Netscape Java Classes");

    // check folders before using them.
    icount = 0;

    // the code below is generated by sugen.pl
    // BEGIN gen

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "brpref32.dll";
    file[icount].regFilePath    = "Program/brpref32.dll";
    file[icount].fileSourcePath = "main/brpref32.dll";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
  if (troubleFlag) 
    file[icount].fileLocalPath  = "install/" + "brpref32.dll";
  else 
    file[icount].fileLocalPath  = "brpref32.dll";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(4, 10, 1, 56);
    file[icount].fileName       = "editor32.dll";
    file[icount].regFilePath    = "Program/editor32.dll";
    file[icount].fileSourcePath = "main/editor32.dll";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
  if (troubleFlag) 
    file[icount].fileLocalPath  = "install/" + "editor32.dll";
  else 
    file[icount].fileLocalPath  = "editor32.dll";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "edpref32.dll";
    file[icount].regFilePath    = "Program/edpref32.dll";
    file[icount].fileSourcePath = "main/edpref32.dll";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
  if (troubleFlag) 
    file[icount].fileLocalPath  = "install/" + "edpref32.dll";
  else 
    file[icount].fileLocalPath  = "edpref32.dll";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "jpeg3240.dll";
    file[icount].regFilePath    = "Program/jpeg3240.dll";
    file[icount].fileSourcePath = "main/jpeg3240.dll";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
  if (troubleFlag) 
    file[icount].fileLocalPath  = "install/" + "jpeg3240.dll";
  else 
    file[icount].fileLocalPath  = "jpeg3240.dll";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(4, 7, 0, 1);
    file[icount].fileName       = "jrt3240.dll";
    file[icount].regFilePath    = "Program/jrt3240.dll";
    file[icount].fileSourcePath = "main/jrt3240.dll";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
  if (troubleFlag) 
    file[icount].fileLocalPath  = "install/" + "jrt3240.dll";
  else 
    file[icount].fileLocalPath  = "jrt3240.dll";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(4, 7, 0, 1);
    file[icount].fileName       = "js3240.dll";
    file[icount].regFilePath    = "Program/js3240.dll";
    file[icount].fileSourcePath = "main/js3240.dll";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
  if (troubleFlag) 
    file[icount].fileLocalPath  = "install/" + "js3240.dll";
  else 
    file[icount].fileLocalPath  = "js3240.dll";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(4, 7, 0, 1);
    file[icount].fileName       = "jsd3240.dll";
    file[icount].regFilePath    = "Program/jsd3240.dll";
    file[icount].fileSourcePath = "main/jsd3240.dll";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
  if (troubleFlag) 
    file[icount].fileLocalPath  = "install/" + "jsd3240.dll";
  else 
    file[icount].fileLocalPath  = "jsd3240.dll";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "master.ini";
    file[icount].regFilePath    = "Program/master.ini";
    file[icount].fileSourcePath = "main/master.ini";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "master.ini";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "mnpref32.dll";
    file[icount].regFilePath    = "Program/mnpref32.dll";
    file[icount].fileSourcePath = "main/mnpref32.dll";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
  if (troubleFlag) 
    file[icount].fileLocalPath  = "install/" + "mnpref32.dll";
  else 
    file[icount].fileLocalPath  = "mnpref32.dll";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(4, 7, 0, 1);
    file[icount].fileName       = "netscape.exe";
    file[icount].regFilePath    = "Program/netscape.exe";
    file[icount].fileSourcePath = "main/netscape.exe";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
  if (troubleFlag) 
    file[icount].fileLocalPath  = "install/" + "netscape.exe";
  else 
    file[icount].fileLocalPath  = "netscape.exe";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "netscape.tlb";
    file[icount].regFilePath    = "Program/netscape.tlb";
    file[icount].fileSourcePath = "main/netscape.tlb";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "netscape.tlb";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
if ((osVer > 3.51) && (!troubleFlag) ){ 
    file[icount].fileName       = "nsbind.exe";
    file[icount].regFilePath    = "Program/nsbind.exe";
    file[icount].fileSourcePath = "main/nsbind.exe";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "nsbind.exe";
    file[icount].fileForceStatus= this.force ;
    icount++;
	}

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "nsdlg32.dll";
    file[icount].regFilePath    = "Program/nsdlg32.dll";
    file[icount].fileSourcePath = "main/nsdlg32.dll";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
  if (troubleFlag) 
    file[icount].fileLocalPath  = "install/" + "nsdlg32.dll";
  else 
    file[icount].fileLocalPath  = "nsdlg32.dll";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(4096, 0, 0, 9373);
    file[icount].fileName       = "nsldap32.dll";
    file[icount].regFilePath    = "Program/nsldap32.dll";
    file[icount].fileSourcePath = "main/nsldap32.dll";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
  if (troubleFlag) 
    file[icount].fileLocalPath  = "install/" + "nsldap32.dll";
  else 
    file[icount].fileLocalPath  = "nsldap32.dll";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(1, 0, 0, 1);
    file[icount].fileName       = "nsmailui.dll";
    file[icount].regFilePath    = "Program/nsmailui.dll";
    file[icount].fileSourcePath = "main/nsmailui.dll";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
  if (troubleFlag) 
    file[icount].fileLocalPath  = "install/" + "nsmailui.dll";
  else 
    file[icount].fileLocalPath  = "nsmailui.dll";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(4, 0, 5, 0);
    file[icount].fileName       = "nsmapi32.dll";
    file[icount].regFilePath    = "Program/nsmapi32.dll";
    file[icount].fileSourcePath = "main/nsmapi32.dll";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
  if (troubleFlag) 
    file[icount].fileLocalPath  = "install/" + "nsmapi32.dll";
  else 
    file[icount].fileLocalPath  = "nsmapi32.dll";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "nsnotify.exe";
    file[icount].regFilePath    = "Program/nsnotify.exe";
    file[icount].fileSourcePath = "main/nsnotify.exe";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "nsnotify.exe";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(4, 7, 0, 1);
    file[icount].fileName       = "pr3240.dll";
    file[icount].regFilePath    = "Program/pr3240.dll";
    file[icount].fileSourcePath = "main/pr3240.dll";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
  if (troubleFlag) 
    file[icount].fileLocalPath  = "install/" + "pr3240.dll";
  else 
    file[icount].fileLocalPath  = "pr3240.dll";
    file[icount].fileForceStatus= true ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "prefui32.dll";
    file[icount].regFilePath    = "Program/prefui32.dll";
    file[icount].fileSourcePath = "main/prefui32.dll";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
  if (troubleFlag) 
    file[icount].fileLocalPath  = "install/" + "prefui32.dll";
  else 
    file[icount].fileLocalPath  = "prefui32.dll";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(4, 7, 0, 1);
    file[icount].fileName       = "resdll.dll";
    file[icount].regFilePath    = "Program/resdll.dll";
    file[icount].fileSourcePath = "main/resdll.dll";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
  if (troubleFlag) 
    file[icount].fileLocalPath  = "install/" + "resdll.dll";
  else 
    file[icount].fileLocalPath  = "resdll.dll";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(4, 7, 0, 1);
    file[icount].fileName       = "uni3200.dll";
    file[icount].regFilePath    = "Program/uni3200.dll";
    file[icount].fileSourcePath = "main/uni3200.dll";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
  if (troubleFlag) 
    file[icount].fileLocalPath  = "install/" + "uni3200.dll";
  else 
    file[icount].fileLocalPath  = "uni3200.dll";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "unicvt32.dll";
    file[icount].regFilePath    = "Program/unicvt32.dll";
    file[icount].fileSourcePath = "main/unicvt32.dll";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
  if (troubleFlag) 
    file[icount].fileLocalPath  = "install/" + "unicvt32.dll";
  else 
    file[icount].fileLocalPath  = "unicvt32.dll";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(4, 7, 0, 1);
    file[icount].fileName       = "xppref32.dll";
    file[icount].regFilePath    = "Program/xppref32.dll";
    file[icount].fileSourcePath = "main/xppref32.dll";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
  if (troubleFlag) 
    file[icount].fileLocalPath  = "install/" + "xppref32.dll";
  else 
    file[icount].fileLocalPath  = "xppref32.dll";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "Back_dep.gif";
    file[icount].regFilePath    = "NetHelp/Back_dep.gif";
    file[icount].fileSourcePath = "NetHelp/Back_dep.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Back_dep.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "Back_dis.gif";
    file[icount].regFilePath    = "NetHelp/Back_dis.gif";
    file[icount].fileSourcePath = "NetHelp/Back_dis.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Back_dis.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "Back_sel.gif";
    file[icount].regFilePath    = "NetHelp/Back_sel.gif";
    file[icount].fileSourcePath = "NetHelp/Back_sel.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Back_sel.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "Back_up.gif";
    file[icount].regFilePath    = "NetHelp/Back_up.gif";
    file[icount].fileSourcePath = "NetHelp/Back_up.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Back_up.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "Blank.htm";
    file[icount].regFilePath    = "NetHelp/Blank.htm";
    file[icount].fileSourcePath = "NetHelp/Blank.htm";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Blank.htm";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "Button.js";
    file[icount].regFilePath    = "NetHelp/Button.js";
    file[icount].fileSourcePath = "NetHelp/Button.js";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Button.js";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "CntData.js";
    file[icount].regFilePath    = "NetHelp/CntData.js";
    file[icount].fileSourcePath = "NetHelp/CntData.js";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/CntData.js";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "CntTool.htm";
    file[icount].regFilePath    = "NetHelp/CntTool.htm";
    file[icount].fileSourcePath = "NetHelp/CntTool.htm";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/CntTool.htm";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "CntTool.js";
    file[icount].regFilePath    = "NetHelp/CntTool.js";
    file[icount].fileSourcePath = "NetHelp/CntTool.js";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/CntTool.js";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "Exit_dep.gif";
    file[icount].regFilePath    = "NetHelp/Exit_dep.gif";
    file[icount].fileSourcePath = "NetHelp/Exit_dep.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Exit_dep.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "Exit_sel.gif";
    file[icount].regFilePath    = "NetHelp/Exit_sel.gif";
    file[icount].fileSourcePath = "NetHelp/Exit_sel.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Exit_sel.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "Exit_up.gif";
    file[icount].regFilePath    = "NetHelp/Exit_up.gif";
    file[icount].fileSourcePath = "NetHelp/Exit_up.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Exit_up.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "Forw_dep.gif";
    file[icount].regFilePath    = "NetHelp/Forw_dep.gif";
    file[icount].fileSourcePath = "NetHelp/Forw_dep.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Forw_dep.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "Forw_dis.gif";
    file[icount].regFilePath    = "NetHelp/Forw_dis.gif";
    file[icount].fileSourcePath = "NetHelp/Forw_dis.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Forw_dis.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "Forw_sel.gif";
    file[icount].regFilePath    = "NetHelp/Forw_sel.gif";
    file[icount].fileSourcePath = "NetHelp/Forw_sel.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Forw_sel.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "Forw_up.gif";
    file[icount].regFilePath    = "NetHelp/Forw_up.gif";
    file[icount].fileSourcePath = "NetHelp/Forw_up.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Forw_up.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "Header.js";
    file[icount].regFilePath    = "NetHelp/Header.js";
    file[icount].fileSourcePath = "NetHelp/Header.js";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Header.js";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "IdxData.js";
    file[icount].regFilePath    = "NetHelp/IdxData.js";
    file[icount].fileSourcePath = "NetHelp/IdxData.js";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/IdxData.js";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "IdxFill.htm";
    file[icount].regFilePath    = "NetHelp/IdxFill.htm";
    file[icount].fileSourcePath = "NetHelp/IdxFill.htm";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/IdxFill.htm";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "IdxKey.htm";
    file[icount].regFilePath    = "NetHelp/IdxKey.htm";
    file[icount].fileSourcePath = "NetHelp/IdxKey.htm";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/IdxKey.htm";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "IdxTool.htm";
    file[icount].regFilePath    = "NetHelp/IdxTool.htm";
    file[icount].fileSourcePath = "NetHelp/IdxTool.htm";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/IdxTool.htm";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "IdxTopic.htm";
    file[icount].regFilePath    = "NetHelp/IdxTopic.htm";
    file[icount].fileSourcePath = "NetHelp/IdxTopic.htm";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/IdxTopic.htm";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "Local-1.js";
    file[icount].regFilePath    = "NetHelp/Local-1.js";
    file[icount].fileSourcePath = "NetHelp/Local-1.js";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Local-1.js";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "NavUI.htm";
    file[icount].regFilePath    = "NetHelp/NavUI.htm";
    file[icount].fileSourcePath = "NetHelp/NavUI.htm";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/NavUI.htm";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "netwatch.gif";
    file[icount].regFilePath    = "NetHelp/netwatch.gif";
    file[icount].fileSourcePath = "NetHelp/netwatch.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/netwatch.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "NoJSerr.htm";
    file[icount].regFilePath    = "NetHelp/NoJSerr.htm";
    file[icount].fileSourcePath = "NetHelp/NoJSerr.htm";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/NoJSerr.htm";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "NSHIfrm.htm";
    file[icount].regFilePath    = "NetHelp/NSHIfrm.htm";
    file[icount].fileSourcePath = "NetHelp/NSHIfrm.htm";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/NSHIfrm.htm";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "picsfail.htm";
    file[icount].regFilePath    = "NetHelp/picsfail.htm";
    file[icount].fileSourcePath = "NetHelp/picsfail.htm";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/picsfail.htm";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "picsfail.jar";
    file[icount].regFilePath    = "NetHelp/picsfail.jar";
    file[icount].fileSourcePath = "NetHelp/picsfail.jar";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
  if (troubleFlag) 
    file[icount].fileLocalPath  = "install/" + "NetHelp/picsfail.jar";
  else 
    file[icount].fileLocalPath  = "NetHelp/picsfail.jar";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "Prnt_dep.gif";
    file[icount].regFilePath    = "NetHelp/Prnt_dep.gif";
    file[icount].fileSourcePath = "NetHelp/Prnt_dep.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Prnt_dep.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "Prnt_sel.gif";
    file[icount].regFilePath    = "NetHelp/Prnt_sel.gif";
    file[icount].fileSourcePath = "NetHelp/Prnt_sel.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Prnt_sel.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "Prnt_up.gif";
    file[icount].regFilePath    = "NetHelp/Prnt_up.gif";
    file[icount].fileSourcePath = "NetHelp/Prnt_up.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Prnt_up.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "Stack.js";
    file[icount].regFilePath    = "NetHelp/Stack.js";
    file[icount].fileSourcePath = "NetHelp/Stack.js";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Stack.js";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "Status.htm";
    file[icount].regFilePath    = "NetHelp/Status.htm";
    file[icount].fileSourcePath = "NetHelp/Status.htm";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Status.htm";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "System.htm";
    file[icount].regFilePath    = "NetHelp/System.htm";
    file[icount].fileSourcePath = "NetHelp/System.htm";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/System.htm";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "System.js";
    file[icount].regFilePath    = "NetHelp/System.js";
    file[icount].fileSourcePath = "NetHelp/System.js";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/System.js";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "ToolUI.htm";
    file[icount].regFilePath    = "NetHelp/ToolUI.htm";
    file[icount].fileSourcePath = "NetHelp/ToolUI.htm";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/ToolUI.htm";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "Tool_dep.gif";
    file[icount].regFilePath    = "NetHelp/Tool_dep.gif";
    file[icount].fileSourcePath = "NetHelp/Tool_dep.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Tool_dep.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "Tool_sel.gif";
    file[icount].regFilePath    = "NetHelp/Tool_sel.gif";
    file[icount].fileSourcePath = "NetHelp/Tool_sel.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Tool_sel.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "Tool_up.gif";
    file[icount].regFilePath    = "NetHelp/Tool_up.gif";
    file[icount].fileSourcePath = "NetHelp/Tool_up.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Tool_up.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "Topic.js";
    file[icount].regFilePath    = "NetHelp/Topic.js";
    file[icount].fileSourcePath = "NetHelp/Topic.js";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Topic.js";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "Utility.js";
    file[icount].regFilePath    = "NetHelp/Utility.js";
    file[icount].fileSourcePath = "NetHelp/Utility.js";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Utility.js";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "Wait.gif";
    file[icount].regFilePath    = "NetHelp/Wait.gif";
    file[icount].fileSourcePath = "NetHelp/Wait.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Wait.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "coll.htm";
    file[icount].regFilePath    = "NetHelp/Netscape/Collabra/coll.htm";
    file[icount].fileSourcePath = "NetHelp/Netscape/Collabra/coll.htm";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Netscape/Collabra/coll.htm";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "collabra.gif";
    file[icount].regFilePath    = "NetHelp/Netscape/Collabra/collabra.gif";
    file[icount].fileSourcePath = "NetHelp/Netscape/Collabra/collabra.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Netscape/Collabra/collabra.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "collHdr.htm";
    file[icount].regFilePath    = "NetHelp/Netscape/Collabra/collHdr.htm";
    file[icount].fileSourcePath = "NetHelp/Netscape/Collabra/collHdr.htm";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Netscape/Collabra/collHdr.htm";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "discgrps.gif";
    file[icount].regFilePath    = "NetHelp/Netscape/Collabra/discgrps.gif";
    file[icount].fileSourcePath = "NetHelp/Netscape/Collabra/discgrps.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Netscape/Collabra/discgrps.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "help.hpf";
    file[icount].regFilePath    = "NetHelp/Netscape/Collabra/help.hpf";
    file[icount].fileSourcePath = "NetHelp/Netscape/Collabra/help.hpf";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Netscape/Collabra/help.hpf";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "comp.htm";
    file[icount].regFilePath    = "NetHelp/Netscape/Composer/comp.htm";
    file[icount].fileSourcePath = "NetHelp/Netscape/Composer/comp.htm";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Netscape/Composer/comp.htm";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "compHdr.htm";
    file[icount].regFilePath    = "NetHelp/Netscape/Composer/compHdr.htm";
    file[icount].fileSourcePath = "NetHelp/Netscape/Composer/compHdr.htm";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Netscape/Composer/compHdr.htm";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "composer.gif";
    file[icount].regFilePath    = "NetHelp/Netscape/Composer/composer.gif";
    file[icount].fileSourcePath = "NetHelp/Netscape/Composer/composer.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Netscape/Composer/composer.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "comtlbr2.gif";
    file[icount].regFilePath    = "NetHelp/Netscape/Composer/comtlbr2.gif";
    file[icount].fileSourcePath = "NetHelp/Netscape/Composer/comtlbr2.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Netscape/Composer/comtlbr2.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "fmtlbr3.gif";
    file[icount].regFilePath    = "NetHelp/Netscape/Composer/fmtlbr3.gif";
    file[icount].fileSourcePath = "NetHelp/Netscape/Composer/fmtlbr3.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Netscape/Composer/fmtlbr3.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "help.hpf";
    file[icount].regFilePath    = "NetHelp/Netscape/Composer/help.hpf";
    file[icount].fileSourcePath = "NetHelp/Netscape/Composer/help.hpf";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Netscape/Composer/help.hpf";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "tagicon2.gif";
    file[icount].regFilePath    = "NetHelp/Netscape/Composer/tagicon2.gif";
    file[icount].fileSourcePath = "NetHelp/Netscape/Composer/tagicon2.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Netscape/Composer/tagicon2.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "brws2.gif";
    file[icount].regFilePath    = "NetHelp/Netscape/Confernc/brws2.gif";
    file[icount].fileSourcePath = "NetHelp/Netscape/Confernc/brws2.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Netscape/Confernc/brws2.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "chat2.gif";
    file[icount].regFilePath    = "NetHelp/Netscape/Confernc/chat2.gif";
    file[icount].fileSourcePath = "NetHelp/Netscape/Confernc/chat2.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Netscape/Confernc/chat2.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "circle2.gif";
    file[icount].regFilePath    = "NetHelp/Netscape/Confernc/circle2.gif";
    file[icount].fileSourcePath = "NetHelp/Netscape/Confernc/circle2.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Netscape/Confernc/circle2.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "conf.htm";
    file[icount].regFilePath    = "NetHelp/Netscape/Confernc/conf.htm";
    file[icount].fileSourcePath = "NetHelp/Netscape/Confernc/conf.htm";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Netscape/Confernc/conf.htm";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "confernc.gif";
    file[icount].regFilePath    = "NetHelp/Netscape/Confernc/confernc.gif";
    file[icount].fileSourcePath = "NetHelp/Netscape/Confernc/confernc.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Netscape/Confernc/confernc.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "confHdr.htm";
    file[icount].regFilePath    = "NetHelp/Netscape/Confernc/confHdr.htm";
    file[icount].fileSourcePath = "NetHelp/Netscape/Confernc/confHdr.htm";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Netscape/Confernc/confHdr.htm";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "eraser2.gif";
    file[icount].regFilePath    = "NetHelp/Netscape/Confernc/eraser2.gif";
    file[icount].fileSourcePath = "NetHelp/Netscape/Confernc/eraser2.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Netscape/Confernc/eraser2.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "fhndtl2.gif";
    file[icount].regFilePath    = "NetHelp/Netscape/Confernc/fhndtl2.gif";
    file[icount].fileSourcePath = "NetHelp/Netscape/Confernc/fhndtl2.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Netscape/Confernc/fhndtl2.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "filex2.gif";
    file[icount].regFilePath    = "NetHelp/Netscape/Confernc/filex2.gif";
    file[icount].fileSourcePath = "NetHelp/Netscape/Confernc/filex2.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Netscape/Confernc/filex2.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "help.hpf";
    file[icount].regFilePath    = "NetHelp/Netscape/Confernc/help.hpf";
    file[icount].fileSourcePath = "NetHelp/Netscape/Confernc/help.hpf";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Netscape/Confernc/help.hpf";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "horline2.gif";
    file[icount].regFilePath    = "NetHelp/Netscape/Confernc/horline2.gif";
    file[icount].fileSourcePath = "NetHelp/Netscape/Confernc/horline2.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Netscape/Confernc/horline2.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "line2.gif";
    file[icount].regFilePath    = "NetHelp/Netscape/Confernc/line2.gif";
    file[icount].fileSourcePath = "NetHelp/Netscape/Confernc/line2.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Netscape/Confernc/line2.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "pointer2.gif";
    file[icount].regFilePath    = "NetHelp/Netscape/Confernc/pointer2.gif";
    file[icount].fileSourcePath = "NetHelp/Netscape/Confernc/pointer2.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Netscape/Confernc/pointer2.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "rect2.gif";
    file[icount].regFilePath    = "NetHelp/Netscape/Confernc/rect2.gif";
    file[icount].fileSourcePath = "NetHelp/Netscape/Confernc/rect2.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Netscape/Confernc/rect2.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "txttool2.gif";
    file[icount].regFilePath    = "NetHelp/Netscape/Confernc/txttool2.gif";
    file[icount].fileSourcePath = "NetHelp/Netscape/Confernc/txttool2.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Netscape/Confernc/txttool2.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "whtbd2.gif";
    file[icount].regFilePath    = "NetHelp/Netscape/Confernc/whtbd2.gif";
    file[icount].fileSourcePath = "NetHelp/Netscape/Confernc/whtbd2.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Netscape/Confernc/whtbd2.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "help.hpf";
    file[icount].regFilePath    = "NetHelp/Netscape/Home/help.hpf";
    file[icount].fileSourcePath = "NetHelp/Netscape/Home/help.hpf";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Netscape/Home/help.hpf";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "home.gif";
    file[icount].regFilePath    = "NetHelp/Netscape/Home/home.gif";
    file[icount].fileSourcePath = "NetHelp/Netscape/Home/home.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Netscape/Home/home.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "home.htm";
    file[icount].regFilePath    = "NetHelp/Netscape/Home/home.htm";
    file[icount].fileSourcePath = "NetHelp/Netscape/Home/home.htm";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Netscape/Home/home.htm";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "homeHdr.htm";
    file[icount].regFilePath    = "NetHelp/Netscape/Home/homeHdr.htm";
    file[icount].fileSourcePath = "NetHelp/Netscape/Home/homeHdr.htm";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Netscape/Home/homeHdr.htm";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "help.hpf";
    file[icount].regFilePath    = "NetHelp/Netscape/Messengr/help.hpf";
    file[icount].fileSourcePath = "NetHelp/Netscape/Messengr/help.hpf";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Netscape/Messengr/help.hpf";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "mailbox.gif";
    file[icount].regFilePath    = "NetHelp/Netscape/Messengr/mailbox.gif";
    file[icount].fileSourcePath = "NetHelp/Netscape/Messengr/mailbox.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Netscape/Messengr/mailbox.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "mess.htm";
    file[icount].regFilePath    = "NetHelp/Netscape/Messengr/mess.htm";
    file[icount].fileSourcePath = "NetHelp/Netscape/Messengr/mess.htm";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Netscape/Messengr/mess.htm";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "messengr.gif";
    file[icount].regFilePath    = "NetHelp/Netscape/Messengr/messengr.gif";
    file[icount].fileSourcePath = "NetHelp/Netscape/Messengr/messengr.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Netscape/Messengr/messengr.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "messHdr.htm";
    file[icount].regFilePath    = "NetHelp/Netscape/Messengr/messHdr.htm";
    file[icount].fileSourcePath = "NetHelp/Netscape/Messengr/messHdr.htm";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Netscape/Messengr/messHdr.htm";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "mpctrl.gif";
    file[icount].regFilePath    = "NetHelp/Netscape/Messengr/mpctrl.gif";
    file[icount].fileSourcePath = "NetHelp/Netscape/Messengr/mpctrl.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Netscape/Messengr/mpctrl.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "help.hpf";
    file[icount].regFilePath    = "NetHelp/Netscape/Navigatr/help.hpf";
    file[icount].fileSourcePath = "NetHelp/Netscape/Navigatr/help.hpf";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Netscape/Navigatr/help.hpf";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "nav.htm";
    file[icount].regFilePath    = "NetHelp/Netscape/Navigatr/nav.htm";
    file[icount].fileSourcePath = "NetHelp/Netscape/Navigatr/nav.htm";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Netscape/Navigatr/nav.htm";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "navHdr.htm";
    file[icount].regFilePath    = "NetHelp/Netscape/Navigatr/navHdr.htm";
    file[icount].fileSourcePath = "NetHelp/Netscape/Navigatr/navHdr.htm";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Netscape/Navigatr/navHdr.htm";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "navigatr.gif";
    file[icount].regFilePath    = "NetHelp/Netscape/Navigatr/navigatr.gif";
    file[icount].fileSourcePath = "NetHelp/Netscape/Navigatr/navigatr.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Netscape/Navigatr/navigatr.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "help.hpf";
    file[icount].regFilePath    = "NetHelp/Netscape/Netcastr/help.hpf";
    file[icount].fileSourcePath = "NetHelp/Netscape/Netcastr/help.hpf";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Netscape/Netcastr/help.hpf";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "net.htm";
    file[icount].regFilePath    = "NetHelp/Netscape/Netcastr/net.htm";
    file[icount].fileSourcePath = "NetHelp/Netscape/Netcastr/net.htm";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Netscape/Netcastr/net.htm";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "netcastr.gif";
    file[icount].regFilePath    = "NetHelp/Netscape/Netcastr/netcastr.gif";
    file[icount].fileSourcePath = "NetHelp/Netscape/Netcastr/netcastr.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Netscape/Netcastr/netcastr.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "netHdr.htm";
    file[icount].regFilePath    = "NetHelp/Netscape/Netcastr/netHdr.htm";
    file[icount].fileSourcePath = "NetHelp/Netscape/Netcastr/netHdr.htm";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Netscape/Netcastr/netHdr.htm";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "admnIcon.gif";
    file[icount].regFilePath    = "NetHelp/Netscape/Shared/admnIcon.gif";
    file[icount].fileSourcePath = "NetHelp/Netscape/Shared/admnIcon.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Netscape/Shared/admnIcon.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "calIcon.gif";
    file[icount].regFilePath    = "NetHelp/Netscape/Shared/calIcon.gif";
    file[icount].fileSourcePath = "NetHelp/Netscape/Shared/calIcon.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Netscape/Shared/calIcon.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "collIcon.gif";
    file[icount].regFilePath    = "NetHelp/Netscape/Shared/collIcon.gif";
    file[icount].fileSourcePath = "NetHelp/Netscape/Shared/collIcon.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Netscape/Shared/collIcon.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "commIcon.gif";
    file[icount].regFilePath    = "NetHelp/Netscape/Shared/commIcon.gif";
    file[icount].fileSourcePath = "NetHelp/Netscape/Shared/commIcon.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Netscape/Shared/commIcon.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "compIcon.gif";
    file[icount].regFilePath    = "NetHelp/Netscape/Shared/compIcon.gif";
    file[icount].fileSourcePath = "NetHelp/Netscape/Shared/compIcon.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Netscape/Shared/compIcon.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "confIcon.gif";
    file[icount].regFilePath    = "NetHelp/Netscape/Shared/confIcon.gif";
    file[icount].fileSourcePath = "NetHelp/Netscape/Shared/confIcon.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Netscape/Shared/confIcon.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "ibmIcon.gif";
    file[icount].regFilePath    = "NetHelp/Netscape/Shared/ibmIcon.gif";
    file[icount].fileSourcePath = "NetHelp/Netscape/Shared/ibmIcon.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Netscape/Shared/ibmIcon.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "messIcon.gif";
    file[icount].regFilePath    = "NetHelp/Netscape/Shared/messIcon.gif";
    file[icount].fileSourcePath = "NetHelp/Netscape/Shared/messIcon.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Netscape/Shared/messIcon.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "navIcon.gif";
    file[icount].regFilePath    = "NetHelp/Netscape/Shared/navIcon.gif";
    file[icount].fileSourcePath = "NetHelp/Netscape/Shared/navIcon.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Netscape/Shared/navIcon.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "NetHelp1.css";
    file[icount].regFilePath    = "NetHelp/Netscape/Shared/NetHelp1.css";
    file[icount].fileSourcePath = "NetHelp/Netscape/Shared/NetHelp1.css";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Netscape/Shared/NetHelp1.css";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "netIcon.gif";
    file[icount].regFilePath    = "NetHelp/Netscape/Shared/netIcon.gif";
    file[icount].fileSourcePath = "NetHelp/Netscape/Shared/netIcon.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "NetHelp/Netscape/Shared/netIcon.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "bookmark.htm";
    file[icount].regFilePath    = "Defaults/bookmark.htm";
    file[icount].fileSourcePath = "Program/Defaults/bookmark.htm";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "Defaults/bookmark.htm";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "signed0.db";
    file[icount].regFilePath    = "Defaults/signed0.db";
    file[icount].fileSourcePath = "Program/Defaults/signed0.db";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "Defaults/signed0.db";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "Inbox";
    file[icount].regFilePath    = "Defaults/Mail/Inbox";
    file[icount].fileSourcePath = "Program/Defaults/Mail/Inbox";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "Defaults/Mail/Inbox";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "Samples";
    file[icount].regFilePath    = "Defaults/Mail/Samples";
    file[icount].fileSourcePath = "Program/Defaults/Mail/Samples";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "Defaults/Mail/Samples";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "fonts.cat";
    file[icount].regFilePath    = "DynFonts/fonts.cat";
    file[icount].fileSourcePath = "Program/DynFonts/fonts.cat";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "DynFonts/fonts.cat";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "nstdfp32.dll";
    file[icount].regFilePath    = "DynFonts/nstdfp32.dll";
    file[icount].fileSourcePath = "Program/DynFonts/nstdfp32.dll";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
  if (troubleFlag) 
    file[icount].fileLocalPath  = "install/" + "DynFonts/nstdfp32.dll";
  else 
    file[icount].fileLocalPath  = "DynFonts/nstdfp32.dll";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "awt3240.dll";
    file[icount].regFilePath    = "Java/Bin/awt3240.dll";
    file[icount].fileSourcePath = "Program/Java/Bin/awt3240.dll";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
  if (troubleFlag) 
    file[icount].fileLocalPath  = "install/" + "Java/Bin/awt3240.dll";
  else 
    file[icount].fileLocalPath  = "Java/Bin/awt3240.dll";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "jbn3240.dll";
    file[icount].regFilePath    = "Java/Bin/jbn3240.dll";
    file[icount].fileSourcePath = "Program/Java/Bin/jbn3240.dll";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
  if (troubleFlag) 
    file[icount].fileLocalPath  = "install/" + "Java/Bin/jbn3240.dll";
  else 
    file[icount].fileLocalPath  = "Java/Bin/jbn3240.dll";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "jdb3240.dll";
    file[icount].regFilePath    = "Java/Bin/jdb3240.dll";
    file[icount].fileSourcePath = "Program/Java/Bin/jdb3240.dll";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
  if (troubleFlag) 
    file[icount].fileLocalPath  = "install/" + "Java/Bin/jdb3240.dll";
  else 
    file[icount].fileLocalPath  = "Java/Bin/jdb3240.dll";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "jit3240.dll";
    file[icount].regFilePath    = "Java/Bin/jit3240.dll";
    file[icount].fileSourcePath = "Program/Java/Bin/jit3240.dll";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
  if (troubleFlag) 
    file[icount].fileLocalPath  = "install/" + "Java/Bin/jit3240.dll";
  else 
    file[icount].fileLocalPath  = "Java/Bin/jit3240.dll";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "jpw3240.dll";
    file[icount].regFilePath    = "Java/Bin/jpw3240.dll";
    file[icount].fileSourcePath = "Program/Java/Bin/jpw3240.dll";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
  if (troubleFlag) 
    file[icount].fileLocalPath  = "install/" + "Java/Bin/jpw3240.dll";
  else 
    file[icount].fileLocalPath  = "Java/Bin/jpw3240.dll";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(4, 7, 0, 1);
    file[icount].fileName       = "mm3240.dll";
    file[icount].regFilePath    = "Java/Bin/mm3240.dll";
    file[icount].fileSourcePath = "Program/Java/Bin/mm3240.dll";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
  if (troubleFlag) 
    file[icount].fileLocalPath  = "install/" + "Java/Bin/mm3240.dll";
  else 
    file[icount].fileLocalPath  = "Java/Bin/mm3240.dll";
    file[icount].fileForceStatus= true ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "awt.properties";
    file[icount].regFilePath    = "Java/Classes/awt.properties";
    file[icount].fileSourcePath = "Program/Java/Classes/awt.properties";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "Java/Classes/awt.properties";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "font.properties";
    file[icount].regFilePath    = "Java/Classes/font.properties";
    file[icount].fileSourcePath = "Program/Java/Classes/font.properties";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "Java/Classes/font.properties";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "font.properties.ja";
    file[icount].regFilePath    = "Java/Classes/font.properties.ja";
    file[icount].fileSourcePath = "Program/Java/Classes/font.properties.ja";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "Java/Classes/font.properties.ja";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "font.properties.ko";
    file[icount].regFilePath    = "Java/Classes/font.properties.ko";
    file[icount].fileSourcePath = "Program/Java/Classes/font.properties.ko";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "Java/Classes/font.properties.ko";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "font.properties.zh";
    file[icount].regFilePath    = "Java/Classes/font.properties.zh";
    file[icount].fileSourcePath = "Program/Java/Classes/font.properties.zh";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "Java/Classes/font.properties.zh";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "font.properties.zh_TW";
    file[icount].regFilePath    = "Java/Classes/font.properties.zh_TW";
    file[icount].fileSourcePath = "Program/Java/Classes/font.properties.zh_TW";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "Java/Classes/font.properties.zh_TW";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "ifc11.jar";
    file[icount].regFilePath    = "Java/Classes/ifc11.jar";
    file[icount].fileSourcePath = "Program/Java/Classes/ifc11.jar";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
  if (troubleFlag) 
    file[icount].fileLocalPath  = "install/" + "Java/Classes/ifc11.jar";
  else 
    file[icount].fileLocalPath  = "Java/Classes/ifc11.jar";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "iiop10.jar";
    file[icount].regFilePath    = "Java/Classes/iiop10.jar";
    file[icount].fileSourcePath = "Program/Java/Classes/iiop10.jar";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
  if (troubleFlag) 
    file[icount].fileLocalPath  = "install/" + "Java/Classes/iiop10.jar";
  else 
    file[icount].fileLocalPath  = "Java/Classes/iiop10.jar";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "jae40.jar";
    file[icount].regFilePath    = "Java/Classes/jae40.jar";
    file[icount].fileSourcePath = "Program/Java/Classes/jae40.jar";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
  if (troubleFlag) 
    file[icount].fileLocalPath  = "install/" + "Java/Classes/jae40.jar";
  else 
    file[icount].fileLocalPath  = "Java/Classes/jae40.jar";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "java40.jar";
    file[icount].regFilePath    = "Java/Classes/java40.jar";
    file[icount].fileSourcePath = "Program/Java/Classes/java40.jar";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
  if (troubleFlag) 
    file[icount].fileLocalPath  = "install/" + "Java/Classes/java40.jar";
  else 
    file[icount].fileLocalPath  = "Java/Classes/java40.jar";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "jio40.jar";
    file[icount].regFilePath    = "Java/Classes/jio40.jar";
    file[icount].fileSourcePath = "Program/Java/Classes/jio40.jar";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
  if (troubleFlag) 
    file[icount].fileLocalPath  = "install/" + "Java/Classes/jio40.jar";
  else 
    file[icount].fileLocalPath  = "Java/Classes/jio40.jar";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "jsd10.jar";
    file[icount].regFilePath    = "Java/Classes/jsd10.jar";
    file[icount].fileSourcePath = "Program/Java/Classes/jsd10.jar";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
  if (troubleFlag) 
    file[icount].fileLocalPath  = "install/" + "Java/Classes/jsd10.jar";
  else 
    file[icount].fileLocalPath  = "Java/Classes/jsd10.jar";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "ldap10.jar";
    file[icount].regFilePath    = "Java/Classes/ldap10.jar";
    file[icount].fileSourcePath = "Program/Java/Classes/ldap10.jar";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
  if (troubleFlag) 
    file[icount].fileLocalPath  = "install/" + "Java/Classes/ldap10.jar";
  else 
    file[icount].fileLocalPath  = "Java/Classes/ldap10.jar";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "scd10.jar";
    file[icount].regFilePath    = "Java/Classes/scd10.jar";
    file[icount].fileSourcePath = "Program/Java/Classes/scd10.jar";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
  if (troubleFlag) 
    file[icount].fileLocalPath  = "install/" + "Java/Classes/scd10.jar";
  else 
    file[icount].fileLocalPath  = "Java/Classes/scd10.jar";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(1, 0, 0, 7);
    file[icount].fileName       = "npnul32.dll";
    file[icount].regFilePath    = "Plugins/npnul32.dll";
    file[icount].fileSourcePath = "Program/Plugins/npnul32.dll";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
  if (troubleFlag) 
    file[icount].fileLocalPath  = "install/" + "Plugins/npnul32.dll";
  else 
    file[icount].fileLocalPath  = "Plugins/npnul32.dll";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "netscape.dic";
    file[icount].regFilePath    = "SpellChk/netscape.dic";
    file[icount].fileSourcePath = "Program/SpellChk/netscape.dic";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "SpellChk/netscape.dic";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "pen4s324.dat";
    file[icount].regFilePath    = "SpellChk/pen4s324.dat";
    file[icount].fileSourcePath = "Program/SpellChk/pen4s324.dat";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
    file[icount].fileLocalPath  = "SpellChk/pen4s324.dat";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "sp3240.dll";
    file[icount].regFilePath    = "SpellChk/sp3240.dll";
    file[icount].fileSourcePath = "Program/SpellChk/sp3240.dll";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
  if (troubleFlag) 
    file[icount].fileLocalPath  = "install/" + "SpellChk/sp3240.dll";
  else 
    file[icount].fileLocalPath  = "SpellChk/sp3240.dll";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "netscape.html";
    file[icount].regFilePath    = "ShellNew/netscape.html";
    file[icount].fileSourcePath = "ShellNew/netscape.html";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fWindows;
    file[icount].fileLocalPath  = "ShellNew/netscape.html";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(4, 21, 0, 7160);
    file[icount].fileName       = "mfc42.dll";
    file[icount].regFilePath    = "system/mfc42.dll";
    file[icount].fileSourcePath = "system/mfc42.dll";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fWinSystem;
  if (troubleFlag) 
    file[icount].fileLocalPath  = "install/" + "mfc42.dll";
  else 
    file[icount].fileLocalPath  = "mfc42.dll";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(5, 0, 0, 7022);
    file[icount].fileName       = "MSVCIRT.DLL";
    file[icount].regFilePath    = "system/MSVCIRT.DLL";
    file[icount].fileSourcePath = "system/MSVCIRT.DLL";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fWinSystem;
    file[icount].fileLocalPath  = "MSVCIRT.DLL";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(5, 0, 0, 7128);
    file[icount].fileName       = "msvcrt.dll";
    file[icount].regFilePath    = "system/msvcrt.dll";
    file[icount].fileSourcePath = "system/msvcrt.dll";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fWinSystem;
  if (troubleFlag) 
    file[icount].fileLocalPath  = "install/" + "msvcrt.dll";
  else 
    file[icount].fileLocalPath  = "msvcrt.dll";
    file[icount].fileForceStatus= this.force ;
    icount++;

    if(chkOS == "Windows 95")
    {
        vi = new netscape.softupdate.VersionInfo(4, 0, 1381, 1);
        file[icount].fileName       = "imagehlp.dll";
        file[icount].regFilePath    = "win95sys/imagehlp.dll";
        file[icount].fileSourcePath = "win95sys/imagehlp.dll";
        file[icount].fileVersion    = vi;
        file[icount].fileDestFolder = fWinSystem;
      if (troubleFlag) 
        file[icount].fileLocalPath  = "install/" + "imagehlp.dll";
      else 
        file[icount].fileLocalPath  = "imagehlp.dll";
        file[icount].fileForceStatus= this.force ;
        icount++;
    }
    else
    {
        totalFiles = totalFiles - 1;
    }

    // END gen
    return err;
}

