// Localizers: please translate the strings found between the double quotes

//Errors and warnings
var ERR_JAVA_IS_OFF = "You do not have java turned on, please enable Java, restart, and try again";
var ERR_AUTOINSTALL_IS_OFF = "AutoInstall is not turned on in Advanced Preferences, please enable it, restart, and try again" ;
var ERR_NOT_FOR_THIS_OS = "Sorry, the install you are downloading doesn't support your operating system.  Install will not continue";
var ERR_210_INSTALL_CANCELLED  = "Install cancelled!" ;
var ERR_201_NOT_GRANTED        = "Privileges not granted, Exiting..." ;
var ERR_200_BAD_PACK_NAME      = "Error! Incorrect/Bad install package name.  Exiting..." ;
var ERR_202_ACCESS_DENIED      = "Error! Access was not granted.  Exiting..." ;
var ERR_203_TOO_MANY_CERTS     = "Error! Too many certificates, only 1 is allowed. Exiting..." ;
var ERR_204_NO_CERTS           = "Error! No installer certificate found! Exiting...";
var ERR_205_FILE_NOT_SIGNED    = "Error! Extracted file is not signed. Exiting..." ;
var ERR_206_FILE_NOT_CERTS     = "Error! Extracted file does not match installer certificate. Exiting..." ;
var ERR_207_JAR_NOT_OPENED     = "Error! Jar file hasn't been opened/found. Exiting..." ;
var ERR_208_BAD_ARGS_TO_FUNC   = "Error! Error calling function (bad arguments). Exiting..." ;
var ERR_209_BAD_PATH           = "Error! Illegal relative path to destination. Exiting..." ;
var ERR_211_INSTALL_WONT_START = "Error! Install never started. Exiting..." ;
var ERR_20_CANT_SETUP_FILES    = "Error, trying to setupFiles." ;
var ERR_1_CANT_ADD_COMP        = "Error, Adding components to the install." ;
var ERR_2_NOT_APPROVED         = "Error: Install not approved.  Exiting..." ;
var ERR_3_WIN32_ONLY           = "Error: This installer is for 32 bit Windows only.  Exiting..." ;
var ERR_GENERIC_INSTALL_ERR    = "an install error has occurred. Exiting..." ;
var ERR_ABORT_WITH_ERRNO       = "Abort! Installer error: ";
var ERR_999_FILES_IN_USE       = "<FONT SIZE=+1 COLOR=#990000><i>WARNING!</FONT>  Some of the files are in use, you will have to restart your computer after installing your software.</i>" ;

//Note: CheckLang will currently only handle English.  What happens to the script when
//we support Int'l?
var ERR_NEED_COM4_ENGLISH = "Sorry, you must have Communicator 4.0 in English in order to update.  Install will not continue" ;
var STATUS_PLEASE_WAIT = "Please Wait..." ;

//Font face and size for status updates.  Note the single quotes inside the string
// for font face; this is essential.
var PARAM_FONT_FACE = "'Arial, Helvetica'" ;
var PARAM_FONT_SIZE = 5 ;
var PARAM_FONT_SIZE_FOR_UPDATE = 4;

var PARAM_LANG_FOR_SCRIPT = "en";

//Errors and warnings
var DBG_NO_SUBKEY = "error setting creating key for " ;
var DBG_SET_WINREGVALUE = "error setting winreg value for " ;
var DBG_VI_EQUALS = "vi equals: " ;

var TEXT_ORGANIZING_INSTALL = "Organizing Installation Components..." ;
var INFO_ADDFILESTR = "Processing file:<BR>({0}) {1}";
var TEXT_TO_INSTALL = " to the install: " ;
var TEXT_ERR_ADDINGFILE = "Error adding " ;
var TEXT_WRONG_COMM_VER = "You do not have the correct version of communicator (4.02), exiting the installer" ;
var TEXT_CLICK_GRANT = "Click 'grant' if you are asked to approve the installation in the Java Security dialog." ;
var TEXT_NONEWSUOBJ = "Failed to create new softupdate obj." ;
var TEXT_CHECKINGSYSTEM = "Checking your system environment..." ;
var TEXT_SETTINGUP_FILES = "Setting up files for the install..." ;
var TEXT_SETTINGUP_REST = "Setting up the rest of the install..." ;
var TEXT_INSTALLING_FILES = "Installing files, please wait..." ;
var TEXT_READYING_FILES = "When the 'Install' button in the SmartUpdate window is enabled, click 'Install' to install the update or click 'Cancel' to cancel the update." ;
var TEXT_INSTALL_COMPLETED = "Install completed successfully!" ;
var TEXT_DEFAULT_TEXT = "Starting the install..." ;

//Status Messages
var STATUS_OPENING_INFO_FILE = "Opening information file, please wait...";

var WINDOW_TITLE_INFO_FILE = "informationWindow";

// Take care of the embedded HTML in the following strings
var HTML_INSTRUCTIONS_WINDOW_TITLE = "<HTML><HEAD><META HTTP-EQUIV='Content-Type' CONTENT='text/html; charset=iso-8859-1'><TITLE>Navigator Install Information</TITLE></HEAD>";
var HTML_INSTRUCTIONS_TITLE = "<BODY><CENTER><H2><FONT COLOR='#CC0000'><FONTSIZE=+3>Installation Stopped</FONT></FONT></H2></CENTER>";

var HTML_INSTRUCTIONS_1 = "We're sorry but this SmartUpdate is unable to automatically update all the files to your Communicator installation." ;
var HTML_INSTRUCTIONS_2 = "You will need to copy over some files manually to complete the install.  Please print out the following instructions on how to update your version of Communicator.";
var HTML_INSTRUCTIONS_3 = "Your copy of Communicator has not been changed as a result of running this Update.";
var HTML_INSTRUCTIONS_4 = "Print out this page, for viewing outside of Communicator.";
var HTML_INSTRUCTIONS_5 = "Quit Communicator.";

// Please note these are dynamically generated strings that contain file path names
var FORMAT_STRING_HTML_INSTRUCTIONS_6 = "Copy %0install\\*.* to %1";
var FORMAT_STRING_HTML_INSTRUCTIONS_7 = "Copy %0install\\java\\bin\\*.* to %1java\\BIN\\";
var FORMAT_STRING_HTML_INSTRUCTIONS_8 = "Copy the entire contents of %0install\\java\\classes\\ to %1java\\classes\\";

var HTML_INSTRUCTIONS_9 = "You can now remove the \\install directories mentioned above and restart Communicator.";
var HTML_INSTRUCTIONS_10 = "Sorry for the inconvenience.  ";

var TEXT_ALREADY_HAVEIT  = "You already have a version of 4.5 on your system, do you wish to continue?";
var TEXT_TOPWINDOW_TITLE = "Macromedia Flash Update Installer";
var TEXT_UPDATEOBJ_NAME  = "Macromedia Flash";

var languageTag      = " (en)";
var installerVersion = "4.5 (en)";
var versionMaj       = 4;
var versionMin       = 50;
var versionRel       = 2;
var versionBld       = 98177;
var totalFiles       = 1;
var ua               = navigator.appVersion.substring(0, navigator.appVersion.indexOf(" "));
// #### CODE FOLLOWS.  DO NOT LOCALIZE BELOW THIS LINE!!

var av = parseFloat(navigator.appVersion) ;

// Displays a message only when debugging.

// StrBuilder Utility Class
// *************************
// The function below takes a Win32-style format string and converts it to
// a JavaScript object that contains a table that can very efficiently
// be processed into a formatted string.
//
// Ex:  
// var objRef = new StrBuilder("One is %0, Two is %1, and %2%%");
//
// The objRef can then be used with the BuildString function to build a
// formatted string:
//
// var formattedString = BuildString(objRef,"Uno","Dos",100);
//
// formattedString will be "One is Uno, Two is Dos, and 100%"
//
// Note that the order in the format string can be switched, and BuildString
// will still correctly build the string:
// var objRef2 = new StrBuilder("%2%%: Ithnen hu %1, Wa Wahad hu %0");
// formattedString = BuildString(objRef,"Uno","Dos",100);
//
// Here, formattedString will now be "100%: Ithnen hu Dos, Wa Wahad hu Uno"
//

// Put the following two function definitions into your common functions file or
// headers:

//
// Function StrBuilder: constructor for Win32 style formatter
//
function StrBuilder(fmtStr){

	this.table = new Array(); // Initialize some class variables
	this.valid = true;
	this.numSlots = 1;
	
	var curPosit = 0; // local variables
	var rslt = 0, num, slotNum = 0;
	var nextChar ;
	
	// Now walk the format string, placing the components of the string
	// into the this.table array.  The %0, %1, etc. arguments are stored
	// as a numerical index.  Anything else is stored as a string, including
	// the argument '%%', which resolves to "%"
	while (rslt != -1){
		// Look for a % from current position
		rslt = fmtStr.indexOf("%",curPosit); 
		
		if(rslt == -1) //If % not found, dump the end of the string to a slot
			 this.table[slotNum] = fmtStr.substring(fmtStr.length,curPosit);
			 
		else if ((nextChar = fmtStr.charAt(rslt+1)) == "%"){ // Check for '%%'
			this.table[slotNum++] = fmtStr.substring(rslt,curPosit);
			this.table[slotNum++] = "%";
			curPosit = rslt + 2; 
		}
		 else{ //Either something we can't handle... 
			num = parseInt(nextChar);
			if (isNaN(num) || num > 9){ //Only a number or a % may follow a %
					this.valid = false;
					return this;
			  }
			  else{	// or it's a digit from 0 to 9, which we store as an index
				this.table[slotNum++] = fmtStr.substring(rslt,curPosit);
				this.table[slotNum++] = num;
				curPosit = rslt + 2; 
			}
		}
	}
	this.numSlots = slotNum + 1;
	return this;
}

//
// Function BuildString: uses a StrBuilder object to dynamically format a string.
// 
// Note: you may have up to 10 arguments after strbldr.  The first will correspond
// to %0, the second to %1, up to %9, and will be substituted for these tokens
// as were passed to StrBuilder.
//
function BuildString(strbldr, itemList){
	var thisSlot, slotVal, thisType, thisArg ;
	var theStr = "";
	
	// For now, we return something that looks invalid if strbldr is not a
	// StrBuilder object:
	if (!strbldr.valid)
		return "<INVALID>";

	// Now walk the slots.  If a string, concatenate it.  If a number,
	// check the argument list for BuildString and substitute the i+1
	// argument.  Note that if we ask for too high an arg, we add nothing
	// to the string in that position	
	for(var i = 0; i < strbldr.numSlots; i++){
		thisSlot = strbldr.table[i];
		thisType = typeof thisSlot; //check to see if we have a numerical index
		slotVal = parseInt(thisSlot);
		
		if(thisType != "number") // not an index, so just concatenate the slot
			theStr += thisSlot;
		// ELSE: substitute in an argument from BuildString's argument list
		else if (slotVal < BuildString.arguments.length - 1){
			thisArg = BuildString.arguments[slotVal + 1];
			theStr += thisArg;
		}
	}			
	return theStr;
}

/* 
 * This function takes a JS Array and converts it into a Java 
 * array of Objects.
 */
function JSArrayToJArray(objects)
{
    // As a little trick here, we create a Java Object and
    // then use it to get a class to pass to java...Array.newInstance
    // In this manner, we can create and populate a Java array
    tobj   = new java.lang.Object()
    JArray = java.lang.reflect.Array.newInstance(tobj.getClass(), objects.length)

    for(i = 0 ; i < objects.length ; i++)
    {
        if(typeof objects[i] == "string")
        {
             java.lang.reflect.Array.set(JArray, i, objects[i])
        }
        // Otherwise assume it's a Calendar object for either date/time
        else
        {
             tempJDate = new java.util.Date(objects[i].getTime())
             java.lang.reflect.Array.set(JArray, i, tempJDate)
        }
    }
    return(JArray)
}

/* 
 * SimpleMessageFormat is appropriate for if you are only going to format 
 * a string a few times.  It takes a 
 * pattern string, and array of JS objects to use while formatting.
 */
function SimpleMessageFormat(patternstring, objects)
{
    JArray = JSArrayToJArray(objects)
    return(java.text.MessageFormat.format(patternstring, JArray))
}


function dbgMsg(message) 
	{
	if(debugOutput)
      java.lang.System.out.println(message) ;
	}


function checkJava() 
	{
	javaOn = navigator.javaEnabled() ; //check to see if java is enabled - nothing here works without it.
	if (javaOn == false)
		{
		alert(ERR_JAVA_IS_OFF) ; // Restart with Java please!
		return false ;
		}
	return true ;
	} 

function checkASD() 
	{
	SUEnabled = netscape.softupdate.Trigger.UpdateEnabled() ;  // SmartUpdate won't work without it being on.
	if (SUEnabled == false)
		{
		alert(ERR_AUTOINSTALL_IS_OFF) ;
		return false ;
		}
	return true ;
	} 


function verifyOS(val) // val should be a string 16, 32, or PPC, etc.  You can verify that the OS matches the OS of the intended install software
	{
	OS = navigator.platform ;
	i = OS.indexOf(val) ;
	if ( i == -1)  
		{
		alert(ERR_NOT_FOR_THIS_OS) // Package not for this OS!;
		return false ;
		}
	return true ;
	} 


function checkLang()  // you can probably modify this function to check for the language like we check for OS, but for now, it just verifies English.
	{

	if (navigator.language != PARAM_LANG_FOR_SCRIPT)
		{
		alert(ERR_NEED_COM4_ENGLISH) ;
		return false ;
		}
	return true ;
	}


//this is an object that contains fields for information about all aspects of the files we want to install.
//later we create an array of these objects depending on the number of files we have to install.
//Later still, we populate the array - filling in the data.
//Lastly, we chug through the array when we are installing the files, extracting the data as we go.
function fileInfoObject(fileName, regFilePath, fileVersion, fileSourcePath, fileDestFolder, fileLocalPath, fileForceStatus ) 
	{
	this.fileName = fileName ;		//convenience sake name
	this.regFilePath = regFilePath ;  //registry name/path 
	this.fileVersion = fileVersion ;  //what version you need this file to be
	this.fileSourcePath = fileSourcePath ; //where in the .jar file is this coming from
	this.fileDestFolder = fileDestFolder ; // where on the drive is this going to (folderspec obj)
	this.fileLocalPath = fileLocalPath ; // any change from the folderspec obj (subfolders?)
	this.fileForceStatus = fileForceStatus ; // determines whether we pay attention to windows versioning or not.
	}


//this function sets up a UI environment which you can alter and/or use to
//inform the user of what's happening during the install.
function setupWindows()  
{
    // just for clienteng release
    //        wndw= window.open("","installer","toolbar=0,menubar=0,status=0,directories=0,location=0,scrollbars=0,resizable=0,width=480,height=400,top=50,left=100");
    wndw= open("","installer","toolbar=0,menubar=0,status=0,directories=0,location=0,scrollbars=0,resizable=0,width=480,height=400,top=50,left=100");
                     // get the users' screen size
    ScreenSize();	 // another object made by us (See Below).
    wndw.moveTo(width/2-250, height/2-200);          //center the window now that we know the dims.
    wndw.document.open("text/html");  				 //open a window that has the text/html mime type.
    wndw.document.close() ;  // flush to window.
    wndw.document.write("<TITLE>"+topWindowTitle+"</TITLE><center><br><br><h2>"+STATUS_PLEASE_WAIT+"</h2></center>") ;
    wndw.document.close() ;  // flush to window.		

    // WRITE OUT THE HTML TO THE WINDOW, CREATING THE FRAMESET
    line = "<TITLE>"+topWindowTitle+"</TITLE><FRAMESET ROWS='30%, 40%, *' border=0 frameborder='no' marginwidth=0><FRAME SRC='about:blank' NAME='TOP'> <FRAME SRC='about:blank' NAME='MIDDLE'> <FRAME SRC='about:blank' NAME='BOTTOM'></FRAMESET>" ;
    wndw.document.write(line);
    wndw.document.close() ;  // flush to window.

    // an effort to clean the window of background info.
    wndw.frames[0].document.write("<center><br><br><h3>"+STATUS_PLEASE_WAIT+"</h3></center>") ;
    wndw.frames[0].document.close() ;  //clean the window first.

    wndw.frames[1].document.write("<center><br><br><h3>"+STATUS_PLEASE_WAIT+"</h3></center>") ;
    wndw.frames[1].document.close() ;  //clean the window first.

    wndw.frames[2].document.write("<center><br><br><h3>"+STATUS_PLEASE_WAIT+"</h3></center>") ;
    wndw.frames[2].document.close() ;  //clean the window first.

    line="<HTML><BODY><CENTER><IMG SRC=http://home.netscape.com/inserts/images/n_sm.gif><H3>"+topWindowTitle+"</H3></CENTER></BODY></HTML>";
    wndw.frames[0].document.close() ;  //clean the window first.
    wndw.frames[0].document.write(line) ;

    // updateStatusText(hSize, defaultText, 3, false, "normal") ;// RMT
    updateStatusText("", defaultText, 3, false, "normal") ;
}


//This function gives us a delay mechanism which isn't built into javascript natively.  
//It's useful and simple.
function delay(amount) {
	// init the values
	var time = new Date() ;
	var seconds = time.getSeconds() ;
	var startCount = 80 ;
	var newSeconds = 70 ;
	//-------------------
	startCount = (seconds + amount ) % 60 ;
	time = new Date() ;
	newSeconds = time.getSeconds() ;
	while (newSeconds != startCount ) {
		time = new Date() ;
		newSeconds = time.getSeconds() ;
		}
 }


// figure out what the users' screen size is so that we can always put the install window in the beginning.
function ScreenSize()
	{
      if (navigator.javaEnabled())    // if Enable Java checkbox is checked then we can do the rest...
      {
         var tools=java.awt.Toolkit.getDefaultToolkit(); // tools object now exists and we can use 'em
         var size=tools.getScreenSize();	// Identify the users' screen size.
         width=size.width;					//on-the-fly declaration of global variable width
         height=size.height;				//on-the-fly declaration of global variable height
      }
	}


//this function updates the text in the middle frame of the window that was previously set up in 'setupwindows' function.
//You can pass it a font size, text, how long you want the message to be displayed, and flip flop between error and success 
//graphic states which you can define ahead of time.  The graphics show in the lower frame.
function updateStatusText(hSize, text, delayTime, graphic )
{
	//check to see if the window is closed, if it is, re-open it.
	//dbgMsg("value for barf is: " + wndw.closed) ;
	if (wndw.closed)
	{
		alert ("Please do not close the information window until the install is complete.") ;
		setupWindows() ;
	}
	var defaultSize = PARAM_FONT_SIZE_FOR_UPDATE ;    //default size for status window messages text.
	if (hSize == "")
		hSize = defaultSize ;

	if (debugOutput == true) 
	{
		java.lang.System.out.println(text) ;		
	}

	if (!silentValue) 
	{
		wndw.frames[0].document.bgColor="white" ;
		wndw.frames[1].document.bgColor="white" ;
		wndw.frames[2].document.bgColor="white" ;
		wndw.frames[1].document.close() ;
		line="<HTML><BODY><SCRIPT>document.bgColor='white'</SCRIPT><CENTER><FONT FACE="+PARAM_FONT_FACE+" SIZE="+PARAM_FONT_SIZE+"5 COLOR=BLUE><BR><H"+hSize+">"+text+"</H"+hSize+"><BR></CENTER></BODY></HTML>";
		wndw.frames[1].document.close() ;  //clean the window first.
		wndw.frames[1].document.write(line) ;
		wndw.frames[1].document.close() ;  //clean the window first.
		
		if (graphic != "") 
		{
   	    	if (graphic == "error")
			{
    	        line="<HTML><BODY><SCRIPT>document.bgColor='white'</SCRIPT><CENTER><IMG HEIGHT=100 SRC=http://home.netscape.com/download/images/mozilla_bungee.gif></CENTER></BODY></HTML>" ;
	   	    	wndw.frames[2].document.close() ;  //clean the window first.
		        wndw.frames[2].document.write(line) ;
		        wndw.frames[2].document.close() ;  //clean the window first.
			}
   			else
			if (graphic == "normal")
			{
	            line="<HTML><BODY><SCRIPT>document.bgColor='white'</SCRIPT><CENTER><IMG WIDTH=360 SRC=http://home.netscape.com/download/images/mozilla_hurdles.gif></CENTER></BODY></HTML>" ;
	   	    	wndw.frames[2].document.close() ;  //clean the window first.
		        wndw.frames[2].document.write(line) ;
		        wndw.frames[2].document.close() ;  //clean the window first.
			}
   		}
		
		if (delayTime != 0)
			delay(delayTime) ; 
    }
}




//Call this function ifyou want to bail out of the installer.
function abortMe()
{
    // check here for what the error numbers are.
    // if 999 then reset to zero and do nothing. Otherwise, proceed with abort.
    // 999 is when files are in use.  Everything is pretty much correct if you get a 999.
    if (err!=999)  
    {
	    if(debugOutput)
        {
            java.lang.System.out.println(ERR_ABORT_WITH_ERRNO + err) ;
        }
        if (!silentValue)
        { 
            wndw.close() ;
        }
        su.AbortInstall() ;
        errorFlag = true ;
        return ;
    }
    else 
    {
        err = 0
        return ;
    }
}


//if you get an error, you cancall this function to parse it.
function errorParse(err) {
	switch (err) {
//		case -200 :
//			wndw.alert(err + ": " + ERR_200_BAD_PACK_NAME);
//			break ;
//		case -201 :
//			wndw.alert(err + ": " + ERR_201_NOT_GRANTED);
//			break ;
		case -202 :
			wndw.alert(err + ": " + ERR_202_ACCESS_DENIED);
			break ;
		case -203 :
			wndw.alert(err + ": " + ERR_203_TOO_MANY_CERTS);
			break ;
		case -204 :
			wndw.alert(err + ": " + ERR_204_NO_CERTS);
			break ;
		case -205 :
			wndw.alert(err + ": " + ERR_205_FILE_NOT_SIGNED);
			break ;
		case -206 :
			wndw.alert(err + ": " + ERR_206_FILE_NOT_CERTS);
			break ;
		case -207 :
			wndw.alert(err + ": " + ERR_207_JAR_NOT_OPENED);
			break ;
		case -208 :
			wndw.alert(err + ": " + ERR_208_BAD_ARGS_TO_FUNC);
			break ;
		case -209 :
			wndw.alert(err + ": " + ERR_209_BAD_PATH);
			break ;
		case -200 :
		case -201 :
		case -210 :
			updateStatusText(4, ERR_210_INSTALL_CANCELLED, 3, "error") ;
			break ;
		case -211 :
			wndw.alert(err + ": " + ERR_211_INSTALL_WONT_START);
			break ;
		case -20 :
			wndw.alert(err + ": " + ERR_20_CANT_SETUP_FILES);
			break ;
		case -1 :
			wndw.alert(err + ": " + ERR_1_CANT_ADD_COMP);
			break ;
		case -2 :
			wndw.alert(err + ": " + ERR_2_NOT_APPROVED);
			break ;
		case -3 :
			wndw.alert(err + ": " + ERR_3_WIN32_ONLY);
			break ;
		case -4 :
			wndw.alert(err + ": " + EXT_BAD_PREV_INSTALL);
			break ;
		case 999 :
			updateStatusText(4, ERR_999_FILES_IN_USE, 7, "normal") ;
			break ;

		default :
			wndw.alert(err + ": " + ERR_GENERIC_INSTALL_ERR);
		} //endswitch
} //end errorParse

function setupFiles(su)
{
    var errString = "" ;
    updateStatusText(hSize,TEXT_ORGANIZING_INSTALL, 1, "normal") ;
    var numArray = new Array(2) ;  // this array and the setup inside updatestatustext are both for Intl issues
    var	jum = 0 ;
    for(var i=0 ; i < totalFiles ; i++) 
    {
	    jum++ ;
		numArray[0] = jum.toString();
		numArray[1] = file[i].fileName;
		var tempStr = SimpleMessageFormat(INFO_ADDFILESTR, numArray) ;
		updateStatusText(5, tempStr , 0, "") ;
        err = su.AddSubcomponent(file[i].regFilePath,      // nice registry name,
                                 file[i].fileVersion,      // versionInfoObject, 
                                 file[i].fileSourcePath,   // Full name from inside .jar including path,
                                 file[i].fileDestFolder,   // folderSpecobj, 
                                 file[i].fileLocalPath,    // path for destination.  null=whatever destfolder is.
                                 file[i].fileForceStatus); // dest file name (can be null) NEW api
        if(err != 0)
        {
            errString = file[i].fileName ;
            updateStatusText(hSize, TEXT_ERR_ADDINGFILE +errString+ TEXT_TO_INSTALL, 0, "error") ;
            return err;
        }
		
    }
	return err ;
}

function checkSystemEnvironment()  // OS check, memcheck, etc go here.
{
	var uaVal = navigator.userAgent.indexOf("Nav") ;
    //check platform before doing smartupdate stuff.

	vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld) ;

	dbgMsg(DBG_VI_EQUALS+vi) ;
	registry_vi = netscape.softupdate.Trigger.GetVersionInfo(nsRegName);

	if ( (av < 4.02) || ( uaVal >=0 ) ) //if 4.0, 4.01, 4.01a, OR RATBERT then fail
		{
		updateStatusText(hSize,TEXT_WRONG_COMM_VER , 3, "error") ;
		err= -1 ;
		return err ;
		}
//	if ( av >= 4.09 )
//		{
//		if (confirm(TEXT_ALREADY_HAVEIT) == false) 
//			{
//			err = -1 ; //user doesn't want to install
//			return err ;
//			}
//		else
//			{
//			err= 0 ; //user does want to over-write the install
//			}
//		}
		
	updateStatusText(4, TEXT_CLICK_GRANT, 0, "normal") ;	

    statusDlgState = 1;
    if(av >= 4.09)
    {
        statusDlgState = 2;
    }
	err = su.StartInstall(nsRegName, vi, statusDlgState);


//check to see if dest dir is on another drive, if so, install files to a different location
    var fTemp = su.GetFolder("Temporary") ;
    var fTempText = ("" + fTemp) ;
    var dLetter = fTempText.substring(0,1) ;
	dbgMsg("Your temporary directory is located at: " + fTempText) ;
    fProgram = su.GetFolder("Program") ;
    fCommunicator = su.GetFolder("Communicator") ;
    fProgramText = ("" + fProgram) ;
    pLetter = fProgramText.substring(0,1) ;

	dbgMsg("Your install directory is located at: " + fProgramText) ;

    if ( (dLetter != pLetter) && (navigator.userAgent.indexOf("Win95") > -1 ) && (av < 4.05) )
    {
        troubleFlag = true ;
		totalFiles = totalFiles -1 ;
    }	

	return err ;  //everything is OK.
}


function body() {	//this section works in clumps - each clump gets an error check after it's called.
					// the errorFlag is there to make sure I only call abortMe once.

	su = new netscape.softupdate.SoftwareUpdate( this, updateObjectName ) ;
	if (su == null) updateStatusText(hSize,TEXT_NONEWSUOBJ,1, "error") ;
	if ( (su != null) )
		{
		updateStatusText(hSize,TEXT_CHECKINGSYSTEM , 1, "") ;
		err = checkSystemEnvironment() ;  //checksystemenvironments, if it returns error, abort
		if (( err != 0 ) && (errorFlag == false)) 
			{
			 errorParse(err) ;
			 abortMe() ;
			}
		if (err == 0) {
			updateStatusText(hSize,TEXT_SETTINGUP_FILES, 1, "") ;
			err = buildArray() ;
			if (( err != 0 ) && (errorFlag ==false)) {
				errorParse(err) ;
				abortMe() ;
				}
			}

		if (err == 0) {		
			updateStatusText(hSize,TEXT_SETTINGUP_REST, 1, "") ;
			err = setupFiles(su) ;		  // and abort.
			if (( err != 0 ) && (errorFlag ==false)) {
				errorParse(err) ;
				abortMe() ;
				}
			}

		if (err == 0) 			// if we get to here, everything's cool and we can finalize install.
			{
            if(av >= 4.09)
            {
			    updateStatusText(hSize,TEXT_INSTALLING_FILES, 4, true, "") ;   
            }
            else
            {
			    updateStatusText(hSize,TEXT_READYING_FILES, 4, true, "") ;   
            }

			err = su.FinalizeInstall();	// This actually copies all the files to their right place
			if (err == 6)
				{
				err = 999 ; //special case for replacing netscape.exe only
				if (troubleFlag) // this is to catch false error 6 and continue with the trouble install case.
					{
					err = 0 ;
					}
				}
			if (( err != 0 ) && (errorFlag == false) && (!troubleFlag)) 
				{
				errorParse(err) ;
				abortMe() ;
				}
            if ( (troubleFlag) && (errorFlag == false) && (err == 0) )
	            {
                updateStatusText(hSize, STATUS_OPENING_INFO_FILE, 2, "normal") ;
                infowindow = window.open("", WINDOW_TITLE_INFO_FILE,"toolbar=1,menubar=1,status=1,scrollbars=1,resizable=1,width=600,height=500,top=50,left=100") ;
                infowindow.document.open("text/html");   //open a window that has the text/html mime type.
                infowindow.document.close() ;  // flush to window.
                infowindow.document.write(HTML_INSTRUCTIONS_WINDOW_TITLE);
                infowindow.document.write("<br>") ;
                infowindow.document.write(HTML_INSTRUCTIONS_TITLE);
                infowindow.document.write("<CENTER><HR WIDTH='75%'></CENTER>");
                infowindow.document.write("<UL>" + HTML_INSTRUCTIONS_1);
                infowindow.document.write("<P>" + HTML_INSTRUCTIONS_2);
                infowindow.document.write("<P>" + HTML_INSTRUCTIONS_3);
                infowindow.document.write("<BR>&nbsp;<UL><OL>");
                infowindow.document.write("<LI>" + HTML_INSTRUCTIONS_4 + "</LI>");
                infowindow.document.write("<LI>" + HTML_INSTRUCTIONS_5 + "</LI>");

                var objRef1 = new StrBuilder(FORMAT_STRING_HTML_INSTRUCTIONS_6);
                BufferString = BuildString(objRef1, fProgram, fProgram);
                infowindow.document.write("<LI>" + BufferString + "</LI>");

                var objRef2 = new StrBuilder(FORMAT_STRING_HTML_INSTRUCTIONS_7);
                BufferString = BuildString(objRef2, fProgram, fProgram);
                infowindow.document.write("<LI>" + BufferString + "</LI>");

                var objRef3 = new StrBuilder(FORMAT_STRING_HTML_INSTRUCTIONS_8);
                BufferString = BuildString(objRef3, fProgram, fProgram);
                infowindow.document.write("<LI>" + BufferString + "</LI>");

                infowindow.document.write("<LI>" + HTML_INSTRUCTIONS_9 + "</LI></OL>&nbsp;</UL>");
                infowindow.document.write(HTML_INSTRUCTIONS_10);
                infowindow.document.write("</BODY></HTML>");
                infowindow.document.close();
    	        }

			}
			
		if (( err != 0 ) && (errorFlag ==false))	// If we have an error, write it to the console
			{
			errorParse(err) ;
			abortMe() ;
			}

		if (( err == 0 ) && (errorFlag ==false))	// If we have an error, write it to the console
			{
			updateStatusText(hSize, TEXT_INSTALL_COMPLETED, 4, "") ;   
			wndw.close() ;			
			}
		

	}// endif
}

// ================ START ================
// PRE FLIGHT CHECK
if (checkLang() && checkJava() && checkASD() )
{
	var troubleFlag = false ;
	var chkOS ;
	var chkOSNum ;
	var OSFlavor ;
	chkOS 		= java.lang.System.getProperty("os.name") ;
	chkOSNum	= java.lang.System.getProperty("os.version") ;
	OSFlavor	= navigator.platform ;
	if (navigator.platform == "Win32")
		bitNum 	= "32" ;
	else	
		bitNum 	= "16" ;

    // VARIABLE DECLARATIONS
	var netcastervi 	 = netscape.softupdate.Trigger.GetVersionInfo("Netcaster/netcast.htm")
	var confvi 			 = netscape.softupdate.Trigger.GetVersionInfo("Conference")
	var shadowvar 		 = java.lang.System.getProperty("os.version") ;
	var osVer 			 = parseFloat(shadowvar) ;
	var topWindowTitle   = TEXT_TOPWINDOW_TITLE ;
	var updateObjectName = TEXT_UPDATEOBJ_NAME ;
	var defaultText      = TEXT_DEFAULT_TEXT ;
    var err              = 0;
    var hSize            = "4";
    var su               = null;
    var suEnv            = this;
    var errorFlag        = false;
    var delayTime        = 1;
    var silentValue      = false ;  // = this.silent;
    var graphic          = "";
    var graphic          = "";
    var debugOutput      = false;  // Turns debugging output on/off
    var nsRegName        = "";  // since we are upgrading communicator, "" = current communicator node

    if(osVer == 3.51)
    {
        totalFiles = totalFiles - 1;
    }

    var file = new Array(totalFiles);

    for(i=0; i<totalFiles; i++ )
    {
        file[i] = new fileInfoObject;
    }

    if(!silentValue)
        setupWindows();

    body();
}// end of check for java and ASD enabled


function buildArray() //stores the information for each file in the array.
{
    //Build used folder list here:
    fPlugins      = su.GetFolder("Plugins");
    fWinSystem    = su.GetFolder("Win System");
    fMacExtension = su.GetFolder("Mac Extension");
    fWindows      = su.GetFolder("Windows");
    fProgram      = su.GetFolder("Program");
    fCommunicator = su.GetFolder("Communicator");
    fJavaBin      = su.GetFolder("Netscape Java Bin");
    fJavaClasses  = su.GetFolder("Netscape Java Classes");

    // check folders before using them.
    icount = 0;

    // the code below is generated by sugen.pl
    // BEGIN gen


    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "Shockwave Flash NP-PPC";
    file[icount].regFilePath    = "Plugins/Macromedia/Shockwave Flash/Shockwave Flash NP-PPC";
    file[icount].fileSourcePath = "Plug-ins/Shockwave Flash NP-PPC";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fCommunicator;
    file[icount].fileLocalPath  = "Plug-ins/Shockwave Flash NP-PPC";
    file[icount].fileForceStatus= this.force ;
    icount++;

    // END gen
    return err;
}

