                            b   	   	   k                                          Button.jsTEXTMOSS   @                  ddKm     /* ==================================================================
FILE:   Button.js
DESCR:  Button control for Netscape Help implementation.
NOTES:  May require routine(s) from Utility.js.
================================================================== */

var UP       = 0
var DOWN     = 1
var SELECTED = 2
var DISABLED = 3

// Disables the button bar without visibly disabling the buttons.
var bDisableBtnBar = false

// Bind events to event handler.
document.captureEvents( Event.MOUSEDOWN )
document.onmousedown = mouseDownEvt

function mouseDownEvt( evt )
{
   //alert( "mouseDownEvt()" )

   // Block right click events to block potentially destabilizing local menus.
   if ( evt.which == 3 ) {
      return false
   }

   // Block left mouse down when bar is disabled.
   else if ( bDisableBtnBar ) {
      return false
   }

   return true
}

/*
DESCR:   Button class.
PARAMS:  upImage        Image file for up state.
         downImage      Image file for down state.
         selectedImage  Image file for selected state.
         disabledImage  Image file for disabled state.
         command        Command to execute.
         bBlender       Specifies that the button should behave as a
                        blender-type button.
         label          Text to go next to button. Use "" for no label.
         toolTip        Mouse tip text. Use "" for no tool tip.
         bar            The buttonBar object.
RETURNS:
NOTES:
*/
function button( upImage, downImage, selectedImage, disabledImage, command,
                 bBlender, label, toolTip, bar )
{
   this.state = UP  // Default state.

   this.buttonNumber = bar.aButtons.length

   this.aImages = new Array( upImage, downImage, selectedImage, disabledImage )

   this.command  = command
   this.bBlender = bBlender
   this.bOn      = false
   this.label    = label
   this.toolTip  = toolTip
   this.bar      = bar

   this.mouseOverEvt = mouseOverEvt
   this.mouseOutEvt  = mouseOutEvt
   this.clickEvt     = clickEvt
   this.enable       = enable
   this.turnOff      = turnOff
   this.setState     = setState
}

   /*
   DESCR:   Enables and disables a button.
   PARAMS:  bEnable  Pass true for enable; false for disable.
   RETURNS: 
   NOTES:   
   */
   function enable( bEnable )
   {
      this.setState( bEnable ? UP : DISABLED )
   }

   /*
   DESCR:   Turns the button off if it is a blender button that is on.
   PARAMS:
   RETURNS: 
   NOTES:
   */
   function turnOff()
   {
      if ( this.bBlender && this.bOn ) {
         this.setState( UP )
      }
   }

   /*
   DESCR:   Assigns state and sets button image.
   PARAMS:  newState  State value for the button.
   RETURNS: 
   NOTES:   
   */
   function setState( newState )
   {
      this.state = newState
      if ( this.bBlender && this.state == UP ) this.bOn = false

      document.images[ this.buttonNumber ].src = this.aImages[ this.state ]
   }

   /*
   DESCR:   Mouse over event handler.
   PARAMS:  
   RETURNS: 
   NOTES:   
   */
   function mouseOverEvt()
   {
      if ( this.state == DISABLED ) return
      if ( this.bBlender && this.bOn ) return

      if ( this.state == UP ) {
         this.setState( SELECTED )
      }
   }

   /*
   DESCR:   Mouse out event handler.
   PARAMS:  
   RETURNS: 
   NOTES:   
   */
   function mouseOutEvt()
   {
      if ( this.state == DISABLED ) return
      if ( this.bBlender && this.bOn ) return

      this.setState( UP )
   }

   /*
   DESCR:   Mouse click event handler.
   PARAMS:  
   RETURNS: 
   NOTES:   
   */
   function clickEvt()
   {
      if ( this.state == DISABLED ) return
      if ( this.bBlender && this.bOn ) return

      this.setState( DOWN )

      // If this is a blender button, turn off the other blenders.
      if ( this.bBlender ) {
         for ( var i = 0; i < this.bar.aButtons.length; i++ ) {
            this.bar.aButtons[ i ].turnOff()
         }
         this.bOn = true
      }

      // Execute command.
      eval( this.command )
   }

// End class definition: button.

/*
DESCR:   Button bar class.
PARAMS:  bgColor     Background color for the bar.
         bLandscape  Pass true for landscape orientation, false for portrait.
         align       Button alignment. Pass "LEFT" or "RIGHT".
         width       Bar width in pixels or percentage.
         spacing     For landscape, this refers to additional pixels to right
                     of button image. Use "" for no extra space. For portrait,
                     this refers to the height of an additional row between
                     buttons. Use "" for no extra space.
         barName     Identifier representing the bar.
RETURNS: 
NOTES:
*/
function buttonBar( bgColor, bLandscape, align, width, spacing, barName )
{
   //top.trace( "buttonBar constructor()" )

   this.aButtons   = new Array()
   this.bgColor    = bgColor
   this.bLandscape = bLandscape
   this.align      = align
   this.width      = width
   this.spacing    = spacing
   this.barName    = barName

   this.addButton = addButton
   this.create    = create
}

   /*
   DESCR:   Adds a button to a bar.
   PARAMS:  button  The button object.
   RETURNS: 
   NOTES:   
   */
   function addButton( button )
   {
      this.aButtons[ this.aButtons.length ] = button
   }
   
   /*
   DESCR:   Writes the document.
   PARAMS:  
   RETURNS: 
   NOTES:   
   */
   function create()
   {
      if ( this.aButtons.length == 0 ) return false

      var html

      html  = "<HTML>"
      html  += "<HEAD>"
//      html += "<STYLE TYPE = 'text/javascript'>"
//      html += "classes.label.all.fontFamily = 'arial';"
//      html += "classes.label.all.fontSize = '12px';"
//      html += "classes.label.all.color = '#000066';"
//      html += "</STYLE>"
      html += "</HEAD>"

      html +=  "<BODY BGCOLOR = " + this.bgColor + ">"

      html += "<TABLE BORDER = 0 ALIGN = " + this.align + " WIDTH = " + this.width + ">"

      // For each button.
      html += "<TR>"
      for ( var i = 0; i < this.aButtons.length; i++ ) {
         html += "<TD ALIGN = 'center'>"
         html += "<A HREF = 'javascript:" + this.barName + ".aButtons[" + i + "].clickEvt()' "
         html += "ONMOUSEOVER = '" + this.barName + ".aButtons[" + i + "].mouseOverEvt()' "
         html += "ONMOUSEOUT = '" + this.barName + ".aButtons[" + i + "].mouseOutEvt()'>"
         html += "<IMG SRC = '" + this.aButtons[ i ].aImages[ this.aButtons[ i ].state ] + "' BORDER = 0 ALT = '" + this.aButtons[ i ].toolTip + "'>"
         html += "</A>"
         if ( this.spacing != "" ) {
            html += "<SPACER TYPE = 'block' WIDTH = " + this.spacing + ">"
         }
         html += "</TD>"

         if ( !this.bLandscape ) {

            // Add label cell and terminate row. Add spacer row.
            html += "<TD ALIGN = 'left'>"
            html += "<DIV CLASS = label>"
            html += this.aButtons[ i ].label 
            html += "</DIV>"
            html += "</TD>"
            html += "</TR>"
            if ( this.spacing != "" ) {
               html += "<TR><TD><SPACER TYPE = 'block' HEIGHT = " +
                       this.spacing + "></TD></TR>"
            }
         }
      }
 
      if ( this.bLandscape ) {
 
         // End row and fill next with labels.
         html += "</TR>"
         html += "<TR>"
         for ( var i = 0; i < this.aButtons.length; i++ ) {
            html += "<TD ALIGN = 'center'>"
            html += "<DIV CLASS = label>"
            html += this.aButtons[ i ].label
            html += "</DIV>"
            if ( this.spacing != "" ) {
               html += "<SPACER TYPE = 'block' WIDTH = " + this.spacing + ">"
            }
            html += "</TD>"
         }
         html += "</TR>"
      }

      html += "</TABLE></BODY></HTML>"

      with ( document ) {
         open()
         write( html )
         close()
      }

      return true
   }

// End class definition: buttonBar.



