/*
 * Copyright (c)  2000
 * SWsoft  company
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted 
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */

//--------------------------------------------------------------------
// MySQL OLE DB Provider 
// Functionality: minimum
// Release: 0.1
//
// @doc
//
// @module UTILPROP.H | CUtilProp object definitions
//
//
#ifndef _UTILPROP_H_
#define _UTILPROP_H_

//-----------  structs and #defines -------------------------------------------
#define DBPROP_SWSTTABLEOWNER	0xffL
extern const GUID DBPROPSET_BTRIEVE_ROWSET;
#define SWST_OWNER_MAX_LENGTH	MAXOWNERNAME

enum InternalSqlSupportVersions {
	ISS_WRONG = -1, ISS_SSQL = 0, ISS_NOVIKOV = 1, ISS_AVDONKIN = 2, ISS_MYSQL = 3
};


// @struct PROPSTRUCT  | simple table used to store property information. Used in 
// our read-only implementation of IDBProperties::GetPropertyInfo and IRowsetInfo::GetProperties
typedef struct _tagPROPSTRUCT
    {
    DBPROPID	dwPropertyID;
	DBPROPFLAGS dwFlags;
    VARTYPE     vtType;
    BOOL        boolVal;
    SLONG       longVal;
    PWSTR       pwstrVal;
    PWSTR		pwstrDescBuffer;
    } PROPSTRUCT;
								   
// flags for IDBProperties::GetPropertyInfo
#define FLAGS_ROWSETRO		(DBPROPFLAGS_ROWSET | DBPROPFLAGS_READ)
#define FLAGS_ROWSETWO		(DBPROPFLAGS_ROWSET | DBPROPFLAGS_WRITE)
#define FLAGS_ROWSETRW		(DBPROPFLAGS_ROWSET | DBPROPFLAGS_READ | DBPROPFLAGS_WRITE)

#define FLAGS_BTRIEVE_ROWSETRO		(DBPROPFLAGS_ROWSET | DBPROPFLAGS_READ)
#define FLAGS_BTRIEVE_ROWSETWO		(DBPROPFLAGS_ROWSET | DBPROPFLAGS_WRITE)
#define FLAGS_BTRIEVE_ROWSETRW		(DBPROPFLAGS_ROWSET | DBPROPFLAGS_READ | DBPROPFLAGS_WRITE)

#define FLAGS_DATASOURCEINFORO    (DBPROPFLAGS_DATASOURCEINFO | DBPROPFLAGS_READ)
#define FLAGS_DATASOURCEINFOWO    (DBPROPFLAGS_DATASOURCEINFO | DBPROPFLAGS_WRITE)
#define FLAGS_DATASOURCEINFORW    (DBPROPFLAGS_DATASOURCEINFO | DBPROPFLAGS_READ | DBPROPFLAGS_WRITE)

#define FLAGS_DATASOURCERO    (DBPROPFLAGS_DATASOURCE | DBPROPFLAGS_READ)
#define FLAGS_DATASOURCEWO    (DBPROPFLAGS_DATASOURCE | DBPROPFLAGS_WRITE)
#define FLAGS_DATASOURCERW    (DBPROPFLAGS_DATASOURCE | DBPROPFLAGS_READ | DBPROPFLAGS_WRITE)

#define FLAGS_SESSIONRO		(DBPROPFLAGS_SESSION | DBPROPFLAGS_READ)
#define FLAGS_SESSIONWO		(DBPROPFLAGS_SESSION | DBPROPFLAGS_WRITE)
#define FLAGS_SESSIONRW		(DBPROPFLAGS_SESSION | DBPROPFLAGS_READ | DBPROPFLAGS_WRITE)

#define FLAGS_DBINITRW		(DBPROPFLAGS_DBINIT | DBPROPFLAGS_READ | DBPROPFLAGS_WRITE)
#define FLAGS_DBINITRO		(DBPROPFLAGS_DBINIT | DBPROPFLAGS_READ)
#define FLAGS_DBINITWO		(DBPROPFLAGS_DBINIT | DBPROPFLAGS_WRITE)

#define FLAGS_INDEXRW		(DBPROPFLAGS_INDEX | DBPROPFLAGS_READ | DBPROPFLAGS_WRITE)
#define FLAGS_INDEXRO		(DBPROPFLAGS_INDEX | DBPROPFLAGS_READ)
#define FLAGS_INDEXWO		(DBPROPFLAGS_INDEX | DBPROPFLAGS_WRITE)

// Number of supported properties per property set
#define	NUMBER_OF_SUPPORTED_PROPERTY_SETS	7

#define	START_OF_SUPPORTED_ROWSET_PROPERTIES				0
#define START_OF_SUPPORTED_DATASOURCEINFO_PROPERTIES		(START_OF_SUPPORTED_ROWSET_PROPERTIES + NUMBER_OF_SUPPORTED_ROWSET_PROPERTIES)
#define START_OF_SUPPORTED_DBINIT_PROPERTIES				(START_OF_SUPPORTED_DATASOURCEINFO_PROPERTIES + NUMBER_OF_SUPPORTED_DATASOURCEINFO_PROPERTIES)
#define START_OF_SUPPORTED_DATASOURCE_PROPERTIES			(START_OF_SUPPORTED_DBINIT_PROPERTIES + NUMBER_OF_SUPPORTED_DBINIT_PROPERTIES)
#define START_OF_SUPPORTED_SESSION_PROPERTIES				(START_OF_SUPPORTED_DATASOURCE_PROPERTIES + NUMBER_OF_SUPPORTED_DATASOURCE_PROPERTIES)
#define START_OF_SUPPORTED_BTRIEVE_ROWSET_PROPERTIES		(START_OF_SUPPORTED_SESSION_PROPERTIES + NUMBER_OF_SUPPORTED_SESSION_PROPERTIES)
#define START_OF_SUPPORTED_INDEX_PROPERTIES					(START_OF_SUPPORTED_BTRIEVE_ROWSET_PROPERTIES + NUMBER_OF_SUPPORTED_BTRIEVE_ROWSET_PROPERTIES)

#define NUMBER_OF_SUPPORTED_DBINIT_PROPERTIES				18
#define	NUMBER_OF_SUPPORTED_DATASOURCEINFO_PROPERTIES		55
#define	NUMBER_OF_SUPPORTED_ROWSET_PROPERTIES				79
#define	NUMBER_OF_SUPPORTED_DATASOURCE_PROPERTIES			1
#define	NUMBER_OF_SUPPORTED_SESSION_PROPERTIES				1
#define	NUMBER_OF_SUPPORTED_BTRIEVE_ROWSET_PROPERTIES		1
#define	NUMBER_OF_SUPPORTED_INDEX_PROPERTIES				11

#define	NUMBER_OF_SUPPORTED_PROPERTIES							\
		(	NUMBER_OF_SUPPORTED_DBINIT_PROPERTIES +				\
			NUMBER_OF_SUPPORTED_DATASOURCEINFO_PROPERTIES +		\
			NUMBER_OF_SUPPORTED_ROWSET_PROPERTIES	+			\
			NUMBER_OF_SUPPORTED_DATASOURCE_PROPERTIES + 		\
			NUMBER_OF_SUPPORTED_SESSION_PROPERTIES	+			\
			NUMBER_OF_SUPPORTED_BTRIEVE_ROWSET_PROPERTIES +		\
			NUMBER_OF_SUPPORTED_INDEX_PROPERTIES				)

// description size
#define CCH_GETPROPERTYINFO_DESCRIP_BUFFER_SIZE 50
// username and passwords sizes
#define MAXPROVIDERSTRING 127
#define MAXAUTHSERVICE 30

// flags for Get and Set Properties
const DWORD		PROPSET_DSOINFO		= 0x0001;
const DWORD		PROPSET_INIT	= 0x0002;
const DWORD		PROPSET_SESSION	= 0x0004;
const DWORD		PROPSET_ROWSET	= 0x0008;
const DWORD		PROPSET_DATASOURCE = 0x0010;
const DWORD		PROPSET_INDEX	= 0x0020;

// Classes -------------------------------------------------------------------

class CDataSource;

//----------------------------------------------------------------------------
// @class CUtilProp | Containing class for all interfaces on the UtilProp 
// Object
//
class CUtilProp
{
	START_CLASS(); 

//	friend class CImpIRowsetLocate;
//	friend class CImpIRowsetScroll;
//	friend class CImpIRowsetFind;
//	friend class CImpIRowset;
//	friend class CImpIOpenRowset;
//	friend class CRowset;
//	friend class CSSql;
//	friend class CDataSource;
//	friend class CImpIColumnsInfo;
//	friend class CImpIRowsetChange;
	friend class CImpIDBInitialize;

	public:	
		//@cmember Gets index of entry for a given property in global property table
		PROPSTRUCT	m_rgproperties[NUMBER_OF_SUPPORTED_PROPERTIES];

        BOOL GetPropIndex
        	(
		       	DBPROPID	dwPropertyID,
			 	ULONG*		pulIndex
        	);

	protected: 
		WCHAR		m_wszFilePath[MAX_PATH];
 		WCHAR		m_wszSwstTableOwner[SWST_OWNER_MAX_LENGTH];
		WCHAR		m_wszPassword[MAXPASSWORD+1];
		WCHAR		m_wszUserID[MAXUSERNAME+1];
		WCHAR		m_wszServer[MAXSERVERNAME+1];
		WCHAR		m_wszProviderString[MAXPROVIDERSTRING+1];
		WCHAR		m_wszAuthService[MAXAUTHSERVICE+1];
		WCHAR		m_wszCurrentCatalog[MAXDATASOURCENAME+1];
		WCHAR		m_wszDataSourceName[MAXDATASOURCENAME+1+MYSQL_MAXDATASOURCENAME+1];
		CDataSource* m_pCDataSource;
        
	protected:
        //@cmember Loads fields of DBPROPINFO struct. Helper for GetPropertyInfo            
        BOOL LoadDBPROPINFO
            (
				PROPSTRUCT*		pPropStruct,
				DBPROPINFO*		pPropInfo
            );

        //@cmember Loads fields of DBPROP struct. Helper for GetProperties
        BOOL LoadDBPROP
            (
				PROPSTRUCT*	pPropStruct,
				DBPROP*		pPropSupport
            );

        //@cmember Checks to see if the value is valid. Helper for SetProperties
		HRESULT IsValidValue
			(
			DBPROP*		pDBProp
			);

		// @cmember Set datasource name (differs with path!)
		BOOL SetDataSourceName
			(
			CHAR*	pszDataSourceName,
			CHAR*   pszDataSourceInfo = NULL
			);

	private: // helper functions
		// Get calculated value
		PROPSTRUCT* loadDefaultPropValues( PROPSTRUCT* props );
		
		// Get calculated value
		PROPSTRUCT& getDefaultPropValue( ULONG ulPropIdx, PROPSTRUCT& prop );
		
		// Change some values in some specific cases
		void calcDefaultPropValue( PROPSTRUCT& prop );

	public: //@access public
		//@cmember Constructor		 
		 CUtilProp( CDataSource* pCDataSource = NULL, CUtilProp* pUtilProp = NULL );
		//@cmember Destructor
		~CUtilProp(void);

		static HRESULT CUtilProp::GetPropertiesArgChk
			(
			DWORD					dwBitMask,
			const ULONG				cPropertySets,
			const DBPROPIDSET		rgPropertySets[],
			ULONG*					pcProperties,
			DBPROPSET**				prgProperties
			);

		STDMETHODIMP GetProperties
		    (
				DWORD				dwBitMask,
			    ULONG				cPropertySets,
			    const DBPROPIDSET	rgPropertySets[],
			    ULONG*              pcProperties,
			    DBPROPSET**			prgProperties
		    );

		STDMETHODIMP GetPropertyInfo
		    (
				BOOL				fDSOInitialized,
			    ULONG				cPropertySets,		
			    const DBPROPIDSET	rgPropertySets[],	
				ULONG*				pcPropertyInfoSets,	
				DBPROPINFOSET**		prgPropertyInfoSets,
				WCHAR**				ppDescBuffer		
		    );

		static HRESULT	SetPropertiesArgChk
			(	const ULONG			cProperties, 
				const DBPROPSET		rgProperties[]
			);

		STDMETHODIMP SetProperties
			(
				DWORD				dwBitMask,
				ULONG				cProperties,
				DBPROPSET			rgProperties[]
			);

		// Get NULL symbol for CHARACTED fields
		char GetNullCharSymbol();

		// Treat string data (STRING, LSTRING, ZSTRING) as coded in OEM
		bool OEM2ANSI();

		// Disable bound directories
		bool NoBound();

		// Connected in MySQL mode?
		bool MySqlMode();

		// Version of internal sql support to be used
		InternalSqlSupportVersions InternalSqlSupport();

        // Determine if user wants more predictable configuration instead of speed up
        bool not_cache_files_opening();

		FINISH_CLASS(); 
};

typedef CUtilProp *PCUTILPROP;

#endif

