/*
 * Copyright (c)  2000
 * SWsoft  company
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted 
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */

//--------------------------------------------------------------------
// MySQL OLE DB Provider 
// Functionality: base
// Release: 1.5
//
// @doc
//
// @module DbInitUI.CPP | User interface for db connect
//
//

// Includes ------------------------------------------------------------------
#include "hfiles.h"
#include "headers.h"
#include "resource.h"
#include <commctrl.h>

///////////////////////////////////
///  Functions with user interface
///////////////////////////////////

// SelectFileDSN  ----------------------------------------------------------------
//
// @func Common dialog look-alike which allows you to select a file DSN.
//
// @rdesc BOOLEAN value indicates success or failure
//      @flag TRUE | Db path by file DSN was obtained
//      @flag FALSE | No Db path by file DSN was obtained
//
BOOL SelectFileDSN
    (
    HWND        hParent,      //@parm IN | Parent window Handle
    LPSTR       lpszDbName,   //@parm OUT | .DSN path
    LPSTR       lpszDDFPath,  //@parm OUT | DDF Directory buffer
	LPSTR		lpszDataPath, //@parm OUT  | Data Directory buffer
	BYTE	   *piDriverType  //@parm OUT  | Type of ODBC driver for P.SQL 2000
    )
{
	OPENFILENAME    ofn;

    // Fill default file name
	*lpszDbName = '\0';
	
	// Set up initialization structure
	ZeroMemory( &ofn, sizeof( OPENFILENAME ) );
	ofn.lStructSize = sizeof( OPENFILENAME );
	ofn.hwndOwner	= hParent;
	ofn.lpstrFilter	= "File Data Source Name (*.dsn)\0*.dsn\0\0";
	ofn.lpstrFile	= lpszDbName;
	ofn.nMaxFile	= MAXDDFPATH;
	ofn.lpstrTitle	= "Choose Desired File Data Source Name";
	ofn.lpstrDefExt = "dsn";
	ofn.Flags		= OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST | OFN_SHAREAWARE | OFN_HIDEREADONLY | OFN_NOLONGNAMES;
    
	// Show dialog
	if( !GetOpenFileName( &ofn ) )
		return FALSE;

	// Check if file DSN contains correct database information and get db path.
	return FALSE; // CheckFileDSN( lpszDbName, lpszDDFPath, lpszDataPath, piDriverType );
}

// SelectDDF  ----------------------------------------------------------------
//
// @func Common dialog look-alike which allows you to select a direcotry.
//
// @rdesc BOOLEAN value indicates success or failure
//      @flag TRUE | Directory was obtained
//      @flag FALSE | No Directory was obtained
//
BOOL SelectDDF
    (
    HWND        hParent,      //@parm IN | Parent window Handle
    LPSTR       lpszDDFPath,  //@parm OUT | DDF Directory buffer
	LPSTR		lpszDataPath //@parm OUT  | Data path buffer
    )
{
    BOOL ret;
	OPENFILENAME    ofn;

    // Fill default file name
	strcpy( lpszDDFPath, "file.ddf" );
	
	// Set up initialization structure
	ZeroMemory( &ofn, sizeof( OPENFILENAME ) );
	ofn.lStructSize = sizeof( OPENFILENAME );
	ofn.hwndOwner	= hParent;
	ofn.lpstrFilter	= "Data dictionary file (*.ddf)\0*.ddf\0\0";
	ofn.lpstrFile	= lpszDDFPath;
	ofn.nMaxFile	= MAXDDFPATH;
	ofn.lpstrTitle	= "Choose Desired Data Dictionary";
	ofn.lpstrDefExt = "ddf";
	ofn.Flags		= OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST | OFN_SHAREAWARE | OFN_HIDEREADONLY | OFN_NOLONGNAMES;
    
	ret = GetOpenFileName( &ofn );
	if( ret )
	{
		// Only directory is necessary
		lpszDDFPath[ ofn.nFileOffset-1 ] = '\0';
		strcpy0( lpszDataPath, lpszDDFPath, MAXDDFPATH );
	}

	return ret;
}

// CenterDialog --------------------------------------------------------------
//
// @func Center the dialog over the parent window.
//
// @rdesc NONE
//
void WINAPI CenterDialog
    (
    HWND hDlg                   //@parm IN | Window to Center
    )
{
	RECT  rcParent;         // Parent window client rect
    RECT  rcDlg;            // Dialog window rect
    int   nLeft, nTop;      // Top-left coordinates
    int   cWidth, cHeight;  // Width and height
    HWND  hwnd;

    // Get frame window client rect in screen coordinates
    if ((hwnd = GetParent( hDlg )) == NULL)
        {
        rcParent.top = rcParent.left = 0;
        rcParent.right = GetSystemMetrics( SM_CXFULLSCREEN );
        rcParent.bottom = GetSystemMetrics( SM_CYFULLSCREEN );
        }
    else
        GetWindowRect( hwnd, &rcParent );

    // Determine the top-left point for the dialog to be centered
    GetWindowRect( hDlg, &rcDlg );
    cWidth  = rcDlg.right - rcDlg.left;
    cHeight = rcDlg.bottom - rcDlg.top;
    nLeft   = rcParent.left +
        (((rcParent.right - rcParent.left) - cWidth) / 2);
    nTop    = rcParent.top +
        (((rcParent.bottom - rcParent.top) - cHeight) / 2);
    if (nLeft < 0)
        nLeft = 0;
    if (nTop < 0)
        nTop  = 0;

    // Place the dialog
    MoveWindow( hDlg, nLeft, nTop, cWidth, cHeight, TRUE );
    return;
}

BOOL CALLBACK DlgSelectDataSourceTypeProc (HWND hwnd, UINT uMsg,  WPARAM wParam, LPARAM lParam) 
{
   	// Set init Data Source on dialog initialization
	if( uMsg == WM_INITDIALOG )
	{
		SelectDataSourceTypeTag* pTag = (SelectDataSourceTypeTag*) lParam;
		if( *pTag->m_lpszInitDataSource )
			SetDlgItemText(hwnd, ID_CURRENTDATASOURCENAME, pTag->m_lpszInitDataSource );
		else
			SetDlgItemText(hwnd, ID_CURRENTDATASOURCENAME, "(No Initial Data Source)" );

		if( !pTag->m_bValid )
		{
			HWND hwndInitName = GetDlgItem(hwnd, ID_CURRENTDATASOURCENAME);
			long style = GetWindowLong( hwndInitName, GWL_STYLE);
			SetWindowLong(hwndInitName, GWL_STYLE, style | WS_DISABLED );
		}
	
		return TRUE; // Specific return value for WM_INITDIALOG
	}
	
	// Close dialog
	if( uMsg == WM_COMMAND )
	   EndDialog( hwnd, wParam );

    return FALSE;
}


BOOL CALLBACK DlgSelectDataSourceNameProc (HWND hwnd, UINT uMsg,  WPARAM wParam, LPARAM lParam) 
{
	// For data exchange
	static DSNINFO* g_pParam = NULL;

   	// Set init Data Source on dialog initialization
	if( uMsg == WM_INITDIALOG )
	{
		// Dialog Parameters
		DSNINFO* pParam = (DSNINFO*)lParam;
		
		// For data exchange
		if( g_pParam == NULL ) 
			g_pParam = pParam;
		else // Disable OK button. Then we cannot get WM_COMMAND from IDOK
		{
			HWND hwndOK = GetDlgItem(hwnd, IDOK);
			long style = GetWindowLong( hwndOK, GWL_STYLE );
			SetWindowLong(hwndOK, GWL_STYLE, style | WS_DISABLED );
		}
		
		// Handle of ListView
		HWND hListView = GetDlgItem( hwnd, IDC_DSNLIST );
		
		LVCOLUMN lvCol;
		RECT rect;
		EnumDatabase* pEnum = NULL;

		ZeroMemory( &lvCol, sizeof( lvCol ) );
		lvCol.mask = LVCF_TEXT | ( GetWindowRect( hListView, &rect ) ? LVCF_WIDTH : 0 );

		lvCol.pszText = "Name";
		lvCol.cx = ( rect.right - rect.left ) / 3 - 2;
		int ret = ListView_InsertColumn( hListView, 0, &lvCol );

		lvCol.pszText = "Dictionary Path";
		lvCol.cx = 2 * lvCol.cx;
		ListView_InsertColumn( hListView, 1, &lvCol );
		
		lvCol.pszText = "Data Path";
		lvCol.cx = 0;
		ListView_InsertColumn( hListView, 2, &lvCol );

		switch( pParam->m_type )
		{
		case DATASOURCE_NAMEDDB:
			SetWindowText( hwnd, "Select Named Pervasive Database" );
			pEnum = new EnumNamedDatabases;
			break;
		case DATASOURCE_USERDSN:
			SetWindowText( hwnd, "Select User Data Source Name" );
			pEnum = new EnumUserDSNs;
			break;
		case DATASOURCE_SYSTEMDSN:
			SetWindowText( hwnd, "Select System Data Source Name" );
			pEnum = new EnumSystemDSNs;
			break;
		default:
			assert( FALSE );
		}

		// Save authentificational information
		DSNINFO dsnInfo;
		strcpy0( dsnInfo.m_szServerName, g_pParam->m_szServerName, MAXSTR(dsnInfo.m_szServerName) );
		strcpy0( dsnInfo.m_szUser, g_pParam->m_szUser, MAXSTR(dsnInfo.m_szUser) );
		strcpy0( dsnInfo.m_szPassword, g_pParam->m_szPassword, MAXSTR(dsnInfo.m_szPassword) );
		
		if( !pEnum || FAILED( pEnum->Init( &dsnInfo ) ) ) // Failed on creation of enumerator
			return TRUE;  // Specific return value for WM_INITDIALOG

		// Adding lines to list box
		LVITEM lvItem;
		ZeroMemory( &lvItem, sizeof( lvItem ) );
		lvItem.mask = LVIF_TEXT;

		// Do while we can do
		while( SUCCEEDED( pEnum->Next( &dsnInfo ) ) )
		{
			++lvItem.iItem;
			lvItem.iSubItem = 0;
			lvItem.pszText = dsnInfo.m_szDataSource;
			lvItem.iItem = ListView_InsertItem( hListView, &lvItem );

			if( lvItem.iItem != -1 )
			{
				lvItem.pszText = dsnInfo.m_szDDFPath;
				lvItem.iSubItem = 1;
				ListView_SetItem( hListView, &lvItem );

				lvItem.pszText = dsnInfo.m_szDataPath;
				lvItem.iSubItem = 2;
				ListView_SetItem( hListView, &lvItem );
			}
		}

		// Completing
		pEnum->Done();
		delete pEnum;
		return TRUE; // Specific return value for WM_INITDIALOG
	}
	
	// Close dialog
	else if( uMsg == WM_COMMAND )
	{
		// Where to get data
		LVITEM lvItem;
		ZeroMemory( &lvItem, sizeof( lvItem ) );

		// Handle of ListView
		HWND hListView = GetDlgItem( hwnd, IDC_DSNLIST );

		// If OK then get selection
		if( wParam == IDOK && hListView != NULL )
		{
			lvItem.iItem = ListView_GetSelectionMark( hListView );
			if( lvItem.iItem != -1 )
			{
				lvItem.mask = LVIF_TEXT;
				lvItem.pszText = g_pParam->m_szDataSource;
				lvItem.cchTextMax = MAXDATASOURCENAME;
				if( !ListView_GetItem( hListView, &lvItem ) ) 
					wParam = IDC_BACK;  // Error

				lvItem.iSubItem = 1;
				lvItem.pszText = g_pParam->m_szDDFPath;
				lvItem.cchTextMax = MAXDDFPATH;
				if( !ListView_GetItem( hListView, &lvItem ) )
					wParam = IDC_BACK;  // Error

				lvItem.iSubItem = 2;
				lvItem.pszText = g_pParam->m_szDataPath;
				lvItem.cchTextMax = MAXDDFPATH;
				if( !ListView_GetItem( hListView, &lvItem ) )
					wParam = IDC_BACK;  // Error
			}
			else wParam = IDC_BACK;  // Error
		}

		// reset g_pParam
		g_pParam = NULL;
		
		// Close Dialog
		EndDialog( hwnd, wParam );
	}

    return FALSE;
}


// Select Data Source Type
DATASOURCE_TYPE SelectDataSourceType( HWND hWnd, char* lpsInitDataSource, BOOL bValid )
{
	switch( DialogBoxParam(g_hInstance, MAKEINTRESOURCE(IDD_DATASOURCE_TYPES), hWnd, 
		DlgSelectDataSourceTypeProc, 
		(LPARAM) &SelectDataSourceTypeTag( lpsInitDataSource, bValid ) ) )
	{
		case ID_CURRENTDATASOURCENAME: return DATASOURCE_SAME;					// No changes (useful if we are always asked)
		case ID_BTRIEVEDATADICTIONARY: return DATASOURCE_DDF;					// Data dictionary
		case ID_NAMEDDATABASE: return DATASOURCE_NAMEDDB;				// Named  db
		case ID_FILEDATASOURCENAME: return DATASOURCE_FILEDSN;				// File Data Source Name
		case ID_USERATASOURCENAME: return DATASOURCE_USERDSN;				// User Data Source Name
		case ID_SYSTEMDATASOURCENAME: return DATASOURCE_SYSTEMDSN;			// System Data Source Name
		default: return DATASOURCE_NONE;
	}
}


// Select Data Source Name
BOOL SelectDataSourceName( HWND hWnd, char* lpsDataSource, char* lpsDDFPath, char* lpsDataPath, DATASOURCE_TYPE type )
{
	// Initialize dialogue paramenters
	DSNINFO param;
	param.m_type = type;
	
	// Run dialog user to select data source name
	switch( DialogBoxParam(g_hInstance, MAKEINTRESOURCE(IDD_DSNDIALOG), hWnd, DlgSelectDataSourceNameProc, (LPARAM)&param ) )
	{
	case IDOK:
		// Save data source name if necessary
		if( lpsDataSource )
			strcpy0( lpsDataSource, param.m_szDataSource, MAXDATASOURCENAME );
		
		// Save database (ddf) path if necessary
		if( lpsDDFPath )
			strcpy0( lpsDDFPath, param.m_szDDFPath, MAXDDFPATH );
		
		// Save database (data) path if necessary
		if( lpsDataPath )
			strcpy0( lpsDataPath, param.m_szDataPath, MAXDDFPATH );
		return TRUE;
	
	case IDC_BACK:	// Go to list of enumerators
		return BACK;
	
	default: 	// Cancelled
		return FALSE;
	}
}

